/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRImageLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRResultSetDataSource
implements JRDataSource {
    private static final Log log = LogFactory.getLog(JRResultSetDataSource.class);
    public static final String PROPERTY_FIELD_COLUMN_NAME = "net.sf.jasperreports.sql.field.column.name";
    public static final String PROPERTY_FIELD_COLUMN_LABEL = "net.sf.jasperreports.sql.field.column.label";
    public static final String PROPERTY_FIELD_COLUMN_INDEX = "net.sf.jasperreports.sql.field.column.index";
    public static final String INDEXED_COLUMN_PREFIX = "COLUMN_";
    private static final int INDEXED_COLUMN_PREFIX_LENGTH = "COLUMN_".length();
    public static final String EXCEPTION_MESSAGE_KEY_RESULT_SET_CLOB_VALUE_READ_FAILURE = "data.result.set.clob.value.read.failure";
    public static final String EXCEPTION_MESSAGE_KEY_RESULT_SET_COLUMN_INDEX_OUT_OF_RANGE = "data.result.set.column.index.out.of.range";
    public static final String EXCEPTION_MESSAGE_KEY_RESULT_SET_FIELD_VALUE_NOT_RETRIEVED = "data.result.set.field.value.not.retrieved";
    public static final String EXCEPTION_MESSAGE_KEY_RESULT_SET_METADATA_NOT_RETRIEVED = "data.result.set.metadata.not.retrieved";
    public static final String EXCEPTION_MESSAGE_KEY_RESULT_SET_UNKNOWN_COLUMN_NAME = "data.result.set.unknown.column.name";
    public static final String EXCEPTION_MESSAGE_KEY_RESULT_SET_UNKNOWN_COLUMN_LABEL = "data.result.set.unknown.column.label";
    public static final String EXCEPTION_MESSAGE_KEY_RESULT_SET_NEXT_RECORD_NOT_RETRIEVED = "data.result.set.next.record.not.retrieved";
    private JasperReportsContext jasperReportsContext;
    private ResultSet resultSet;
    private Map<String, Integer> columnIndexMap = new HashMap<String, Integer>();
    private TimeZone timeZone;
    private boolean timeZoneOverride;
    private TimeZone reportTimeZone;
    private Map<JRField, Calendar> fieldCalendars = new HashMap<JRField, Calendar>();

    public JRResultSetDataSource(JasperReportsContext jasperReportsContext, ResultSet resultSet) {
        this.jasperReportsContext = jasperReportsContext;
        this.resultSet = resultSet;
    }

    public JRResultSetDataSource(ResultSet resultSet) {
        this(DefaultJasperReportsContext.getInstance(), resultSet);
    }

    @Override
    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.resultSet != null) {
            try {
                hasNext = this.resultSet.next();
            }
            catch (SQLException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_NEXT_RECORD_NOT_RETRIEVED, null, e);
            }
        }
        return hasNext;
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        Object objValue;
        block40: {
            objValue = null;
            if (field != null && this.resultSet != null) {
                Integer columnIndex = this.getColumnIndex(field);
                Class<?> clazz = field.getValueClass();
                try {
                    if (clazz.equals(Boolean.class)) {
                        objValue = this.resultSet.getBoolean(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(Byte.class)) {
                        objValue = this.resultSet.getByte(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(java.util.Date.class) || clazz.equals(Date.class)) {
                        objValue = this.readDate(columnIndex, field);
                        break block40;
                    }
                    if (clazz.equals(Timestamp.class)) {
                        objValue = this.readTimestamp(columnIndex, field);
                        break block40;
                    }
                    if (clazz.equals(Time.class)) {
                        objValue = this.readTime(columnIndex, field);
                        break block40;
                    }
                    if (clazz.equals(Double.class)) {
                        objValue = this.resultSet.getDouble(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(Float.class)) {
                        objValue = Float.valueOf(this.resultSet.getFloat(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(Integer.class)) {
                        objValue = this.resultSet.getInt(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(InputStream.class)) {
                        byte[] bytes = this.readBytes(columnIndex);
                        objValue = bytes == null ? null : new ByteArrayInputStream(bytes);
                        break block40;
                    }
                    if (clazz.equals(Long.class)) {
                        objValue = this.resultSet.getLong(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(Short.class)) {
                        objValue = this.resultSet.getShort(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(BigDecimal.class)) {
                        objValue = this.resultSet.getBigDecimal(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block40;
                    }
                    if (clazz.equals(String.class)) {
                        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                }
                                objValue = this.clobToString(clob);
                                break;
                            }
                            default: {
                                objValue = this.resultSet.getString(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block40;
                    }
                    if (clazz.equals(Clob.class)) {
                        objValue = this.resultSet.getClob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else if (clazz.equals(Reader.class)) {
                        Reader reader = null;
                        long size = -1L;
                        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) break;
                                reader = clob.getCharacterStream();
                                size = clob.length();
                                break;
                            }
                            default: {
                                reader = this.resultSet.getCharacterStream(columnIndex);
                                if (!this.resultSet.wasNull()) break;
                                reader = null;
                            }
                        }
                        objValue = reader == null ? null : this.getArrayReader(reader, size);
                    } else if (clazz.equals(Blob.class)) {
                        objValue = this.resultSet.getBlob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else {
                        byte[] bytes;
                        objValue = clazz.equals(Image.class) ? ((bytes = this.readBytes(columnIndex)) == null ? null : JRImageLoader.getInstance(this.jasperReportsContext).loadAwtImageFromBytes(bytes)) : (clazz.equals(byte[].class) ? (Object)this.readBytes(columnIndex) : this.resultSet.getObject(columnIndex));
                    }
                }
                catch (Exception e) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_FIELD_VALUE_NOT_RETRIEVED, new Object[]{field.getName(), clazz.getName()}, e);
                }
            }
        }
        return objValue;
    }

    protected Object readDate(Integer columnIndex, JRField field) throws SQLException {
        Date objValue;
        Calendar calendar = this.getFieldCalendar(field);
        Date date = objValue = calendar == null ? this.resultSet.getDate(columnIndex) : this.resultSet.getDate(columnIndex, calendar);
        if (this.resultSet.wasNull()) {
            objValue = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("date field " + field.getName() + " is " + (objValue == null ? "null" : objValue + " (" + objValue.getTime() + ")"));
        }
        return objValue;
    }

    protected Object readTimestamp(Integer columnIndex, JRField field) throws SQLException {
        Timestamp objValue;
        Calendar calendar = this.getFieldCalendar(field);
        Timestamp timestamp = objValue = calendar == null ? this.resultSet.getTimestamp(columnIndex) : this.resultSet.getTimestamp(columnIndex, calendar);
        if (this.resultSet.wasNull()) {
            objValue = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("timestamp field " + field.getName() + " is " + (objValue == null ? "null" : objValue + " (" + objValue.getTime() + ")"));
        }
        return objValue;
    }

    protected Object readTime(Integer columnIndex, JRField field) throws SQLException {
        Time objValue;
        Calendar calendar = this.getFieldCalendar(field);
        Time time = objValue = calendar == null ? this.resultSet.getTime(columnIndex) : this.resultSet.getTime(columnIndex, calendar);
        if (this.resultSet.wasNull()) {
            objValue = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("time field " + field.getName() + " is " + (objValue == null ? "null" : objValue + " (" + objValue.getTime() + ")"));
        }
        return objValue;
    }

    private Integer getColumnIndex(JRField field) throws JRException {
        String fieldName = field.getName();
        Integer columnIndex = this.columnIndexMap.get(fieldName);
        if (columnIndex == null) {
            try {
                columnIndex = this.searchColumnByName(field);
                if (columnIndex == null) {
                    columnIndex = this.searchColumnByLabel(field);
                }
                if (columnIndex == null) {
                    columnIndex = this.searchColumnByIndex(field);
                }
                if (columnIndex == null) {
                    columnIndex = this.searchColumnByName(fieldName);
                }
                if (columnIndex == null) {
                    columnIndex = this.searchColumnByLabel(fieldName);
                }
                if (columnIndex == null && fieldName.startsWith(INDEXED_COLUMN_PREFIX)) {
                    columnIndex = this.searchColumnByIndex(fieldName.substring(INDEXED_COLUMN_PREFIX_LENGTH));
                }
                if (columnIndex == null) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_UNKNOWN_COLUMN_NAME, new Object[]{fieldName});
                }
            }
            catch (SQLException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_METADATA_NOT_RETRIEVED, null, e);
            }
            if (log.isDebugEnabled()) {
                try {
                    ResultSetMetaData metaData = this.resultSet.getMetaData();
                    log.debug("field " + fieldName + " has type " + metaData.getColumnType(columnIndex) + "/" + metaData.getColumnTypeName(columnIndex) + ", class " + metaData.getColumnClassName(columnIndex));
                }
                catch (SQLException e) {
                    log.debug("failed to read result set metadata", e);
                }
            }
            this.columnIndexMap.put(fieldName, columnIndex);
        }
        return columnIndex;
    }

    protected Integer searchColumnByName(JRField field) throws SQLException, JRException {
        String name;
        if (field.hasProperties() && (name = field.getPropertiesMap().getProperty(PROPERTY_FIELD_COLUMN_NAME)) != null) {
            Integer columnIndex = this.searchColumnByName(name);
            if (columnIndex == null) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_UNKNOWN_COLUMN_NAME, new Object[]{name});
            }
            return columnIndex;
        }
        return null;
    }

    protected Integer searchColumnByName(String name) throws SQLException {
        Integer columnIndex = null;
        ResultSetMetaData metadata = this.resultSet.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnName = metadata.getColumnName(i);
            if (!name.equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        return columnIndex;
    }

    protected Integer searchColumnByLabel(JRField field) throws SQLException, JRException {
        String label;
        if (field.hasProperties() && (label = field.getPropertiesMap().getProperty(PROPERTY_FIELD_COLUMN_LABEL)) != null) {
            Integer columnIndex = this.searchColumnByLabel(label);
            if (columnIndex == null) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_UNKNOWN_COLUMN_LABEL, new Object[]{label});
            }
            return columnIndex;
        }
        return null;
    }

    protected Integer searchColumnByLabel(String label) throws SQLException {
        Integer columnIndex = null;
        ResultSetMetaData metadata = this.resultSet.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnLabel = metadata.getColumnLabel(i);
            if (columnLabel == null || !label.equalsIgnoreCase(columnLabel)) continue;
            columnIndex = i;
            break;
        }
        return columnIndex;
    }

    protected Integer searchColumnByIndex(JRField field) throws SQLException, JRException {
        String index;
        if (field.hasProperties() && (index = field.getPropertiesMap().getProperty(PROPERTY_FIELD_COLUMN_INDEX)) != null) {
            return this.searchColumnByIndex(index);
        }
        return null;
    }

    protected Integer searchColumnByIndex(String index) throws SQLException, JRException {
        Integer columnIndex = Integer.valueOf(index);
        if (columnIndex <= 0 || columnIndex > this.resultSet.getMetaData().getColumnCount()) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_COLUMN_INDEX_OUT_OF_RANGE, new Object[]{columnIndex});
        }
        return columnIndex;
    }

    protected String clobToString(Clob clob) throws JRException {
        try {
            int bufSize = 8192;
            char[] buf = new char[bufSize];
            BufferedReader reader = new BufferedReader(clob.getCharacterStream(), bufSize);
            StringBuilder str = new StringBuilder((int)clob.length());
            int read = reader.read(buf);
            while (read > 0) {
                str.append(buf, 0, read);
                read = reader.read(buf);
            }
            return str.toString();
        }
        catch (SQLException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_CLOB_VALUE_READ_FAILURE, null, e);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_RESULT_SET_CLOB_VALUE_READ_FAILURE, null, e);
        }
    }

    protected CharArrayReader getArrayReader(Reader reader, long size) throws IOException {
        char[] buf = new char[8192];
        CharArrayWriter bufWriter = new CharArrayWriter(size > 0L ? (int)size : 8192);
        BufferedReader bufReader = new BufferedReader(reader, 8192);
        int read = bufReader.read(buf);
        while (read > 0) {
            bufWriter.write(buf, 0, read);
            read = bufReader.read(buf);
        }
        bufWriter.flush();
        return new CharArrayReader(bufWriter.toCharArray());
    }

    protected byte[] readBytes(Integer columnIndex) throws SQLException, IOException {
        InputStream is = null;
        long size = -1L;
        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
        switch (columnType) {
            case 2004: {
                Blob blob = this.resultSet.getBlob(columnIndex);
                if (this.resultSet.wasNull()) break;
                is = blob.getBinaryStream();
                size = blob.length();
                break;
            }
            default: {
                is = this.resultSet.getBinaryStream(columnIndex);
                if (!this.resultSet.wasNull()) break;
                is = null;
            }
        }
        byte[] bytes = null;
        if (is != null) {
            bytes = this.readBytes(is, size);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(InputStream is, long size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size > 0L ? (int)size : 1000);
        byte[] bytes = new byte[1000];
        int ln = 0;
        try {
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    public void setTimeZone(TimeZone timeZone, boolean override) {
        this.timeZone = timeZone;
        this.timeZoneOverride = override;
    }

    public void setReportTimeZone(TimeZone reportTimeZone) {
        this.reportTimeZone = reportTimeZone;
    }

    protected Calendar getFieldCalendar(JRField field) {
        if (this.fieldCalendars.containsKey(field)) {
            return this.fieldCalendars.get(field);
        }
        Calendar calendar = this.createFieldCalendar(field);
        this.fieldCalendars.put(field, calendar);
        if (log.isDebugEnabled()) {
            log.debug("calendar for field " + field.getName() + " is " + calendar);
        }
        return calendar;
    }

    protected Calendar createFieldCalendar(JRField field) {
        TimeZone tz;
        if (this.timeZoneOverride) {
            tz = this.timeZone;
        } else if (field.hasProperties() && field.getPropertiesMap().containsProperty("net.sf.jasperreports.jdbc.time.zone")) {
            String timezoneId = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(field, "net.sf.jasperreports.jdbc.time.zone");
            tz = this.resolveTimeZone(timezoneId);
        } else {
            tz = this.timeZone;
        }
        Calendar cal = tz == null ? null : Calendar.getInstance(tz);
        return cal;
    }

    protected TimeZone resolveTimeZone(String timezoneId) {
        TimeZone tz = timezoneId == null || timezoneId.length() == 0 ? null : (timezoneId.equals("REPORT_TIME_ZONE") ? this.reportTimeZone : TimeZone.getTimeZone(timezoneId));
        return tz;
    }
}

