/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.WrappingImageMapRenderable;
import net.sf.jasperreports.engine.util.WrappingRenderable;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.WrappingDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.WrappingDeprecatedRenderable;
import net.sf.jasperreports.renderers.WrappingRenderToImageDataRenderer;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenderableUtil {
    private static final Log log = LogFactory.getLog(RenderableUtil.class);
    public static final String EXCEPTION_MESSAGE_KEY_IMAGE_ERROR = "engine.renderable.util.image.error";
    private JasperReportsContext jasperReportsContext;

    private RenderableUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static RenderableUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new RenderableUtil(jasperReportsContext);
    }

    public Renderable getRenderable(byte[] imageData) {
        return new JRImageRenderer(imageData);
    }

    public Renderable getRenderable(String imageLocation) throws JRException {
        return this.getRenderable(imageLocation, OnErrorTypeEnum.ERROR, true);
    }

    public Renderable getRenderable(String imageLocation, OnErrorTypeEnum onErrorType) throws JRException {
        return this.getRenderable(imageLocation, onErrorType, true);
    }

    public Renderable getRenderable(String imageLocation, OnErrorTypeEnum onErrorType, boolean isLazy) throws JRException {
        Renderable result;
        block4: {
            if (imageLocation == null) {
                return null;
            }
            if (isLazy) {
                return new JRImageRenderer(imageLocation);
            }
            try {
                byte[] data = RepositoryUtil.getInstance(this.jasperReportsContext).getBytesFromLocation(imageLocation);
                result = new JRImageRenderer(data);
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block4;
                log.debug("handled image error with type " + onErrorType + " for location " + imageLocation, e);
            }
        }
        return result;
    }

    public Renderable getRenderable(Image img, OnErrorTypeEnum onErrorType) throws JRException {
        ColorModel colorModel;
        ImageTypeEnum type = ImageTypeEnum.JPEG;
        if (img instanceof RenderedImage && (colorModel = ((RenderedImage)((Object)img)).getColorModel()).hasAlpha() && colorModel.getTransparency() != 1) {
            type = ImageTypeEnum.PNG;
        }
        return this.getRenderable(img, type, onErrorType);
    }

    public Renderable getRenderable(Image image, ImageTypeEnum imageType, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRImageLoader.getInstance(this.jasperReportsContext).loadBytesFromAwtImage(image, imageType));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug("handled image error with type " + onErrorType, e);
            }
        }
        return result;
    }

    public Renderable getRenderable(InputStream is, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRLoader.loadBytes(is));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug("handled image error with type " + onErrorType, e);
            }
        }
        return result;
    }

    public Renderable getRenderable(URL url, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRLoader.loadBytes(url));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug("handled image error with type " + onErrorType + " for URL " + url, e);
            }
        }
        return result;
    }

    public Renderable getRenderable(File file, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRLoader.loadBytes(file));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug("handled image error with type " + onErrorType + " for file " + file, e);
            }
        }
        return result;
    }

    public Renderable getOnErrorRendererForDimension(Renderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                renderer.getDimension(this.jasperReportsContext);
                result = renderer;
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug("handled image error with type " + onErrorType, e);
            }
        }
        return result;
    }

    public net.sf.jasperreports.renderers.Renderable getOnErrorRendererForDimension(RenderersCache renderersCache, net.sf.jasperreports.renderers.Renderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        net.sf.jasperreports.renderers.Renderable result;
        block3: {
            result = null;
            DimensionRenderable dimensionRenderer = renderersCache.getDimensionRenderable(renderer);
            if (dimensionRenderer != null) {
                try {
                    dimensionRenderer.getDimension(this.jasperReportsContext);
                    result = (net.sf.jasperreports.renderers.Renderable)((Object)dimensionRenderer);
                }
                catch (Exception e) {
                    result = this.handleImageError(e, onErrorType);
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("handled image error with type " + onErrorType, e);
                }
            }
        }
        return result;
    }

    public Renderable getOnErrorRendererForImageData(Renderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                renderer.getImageData(this.jasperReportsContext);
                result = renderer;
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug("handled image error with type " + onErrorType, e);
            }
        }
        return result;
    }

    public Renderable handleImageError(Exception error, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable errorRenderable;
        if (error instanceof JRException) {
            errorRenderable = this.getOnErrorRenderer(onErrorType, (JRException)error);
        } else if (error instanceof JRRuntimeException) {
            errorRenderable = this.getOnErrorRenderer(onErrorType, (JRRuntimeException)error);
        } else {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (log.isDebugEnabled()) {
                log.debug("got unexpected image exception of type " + error.getClass().getName(), error);
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_IMAGE_ERROR, null, error);
        }
        return errorRenderable;
    }

    public Renderable getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRException e) throws JRException {
        JRImageRenderer renderer = null;
        switch (onErrorType) {
            case ICON: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/image-16.png");
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public Renderable getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRRuntimeException e) throws JRRuntimeException {
        JRImageRenderer renderer = null;
        switch (onErrorType) {
            case ICON: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/image-16.png");
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public static Renderable getWrappingRenderable(JRRenderable deprecatedRenderer) {
        Renderable renderable = null;
        if (deprecatedRenderer != null) {
            Renderable renderable2 = renderable = deprecatedRenderer instanceof Renderable ? (Renderable)deprecatedRenderer : null;
            if (renderable == null) {
                renderable = new WrappingRenderable(deprecatedRenderer);
            }
        }
        return renderable;
    }

    public static Renderable getWrappingRenderable(JRImageMapRenderer deprecatedRenderer) {
        Renderable renderable = null;
        if (deprecatedRenderer != null) {
            Renderable renderable2 = renderable = deprecatedRenderer instanceof Renderable ? (Renderable)((Object)deprecatedRenderer) : null;
            if (renderable == null) {
                renderable = new WrappingImageMapRenderable(deprecatedRenderer);
            }
        }
        return renderable;
    }

    public static Renderable getWrappingRenderable(net.sf.jasperreports.renderers.Renderable renderable) {
        Renderable deprecatedRenderable = null;
        if (renderable != null) {
            Renderable renderable2 = deprecatedRenderable = renderable instanceof Renderable ? (Renderable)renderable : null;
            if (deprecatedRenderable == null) {
                DimensionRenderable dimensionRenderable;
                Graphics2DRenderable grxRenderable = null;
                DataRenderable dataRenderable = null;
                DimensionRenderable dimensionRenderable2 = dimensionRenderable = renderable instanceof DimensionRenderable ? (DimensionRenderable)((Object)renderable) : null;
                if (renderable instanceof Graphics2DRenderable) {
                    if (renderable instanceof DataRenderable) {
                        grxRenderable = (Graphics2DRenderable)((Object)renderable);
                        dataRenderable = (DataRenderable)((Object)renderable);
                    } else {
                        grxRenderable = (Graphics2DRenderable)((Object)renderable);
                        dataRenderable = new WrappingRenderToImageDataRenderer(grxRenderable, dimensionRenderable, null);
                    }
                } else if (renderable instanceof DataRenderable) {
                    dataRenderable = (DataRenderable)((Object)renderable);
                    grxRenderable = new WrappingDataToGraphics2DRenderer((DataRenderable)((Object)renderable));
                } else {
                    throw new JRRuntimeException("engine.renderable.must.implement.interface", new Object[]{renderable.getClass().getName(), DataRenderable.class.getName() + " or " + Graphics2DRenderable.class.getName()});
                }
                if (dimensionRenderable == null) {
                    dimensionRenderable = renderable instanceof DimensionRenderable ? (DimensionRenderable)((Object)grxRenderable) : null;
                }
                deprecatedRenderable = new WrappingDeprecatedRenderable(renderable.getId(), grxRenderable, dataRenderable, dimensionRenderable);
            }
        }
        return deprecatedRenderable;
    }
}

