/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfStructureElement;
import net.sf.jasperreports.export.pdf.PdfStructureEntry;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfStructure;

public class ClassicStructureEntry
implements PdfStructureEntry {
    private ClassicPdfStructure pdfStructure;
    private PdfStructureElement element;

    public ClassicStructureEntry(ClassicPdfStructure pdfStructure, PdfStructureElement element) {
        this.pdfStructure = pdfStructure;
        this.element = element;
    }

    public PdfStructureElement getElement() {
        return this.element;
    }

    @Override
    public void putString(String name, String value) {
        this.element.put(this.pdfStructure.pdfName(name), new PdfString(value));
    }

    @Override
    public void putArray(String name) {
        this.element.put(this.pdfStructure.pdfName(name), new PdfArray());
    }

    @Override
    public void setSpan(int colSpan, int rowSpan) {
        PdfArray a = new PdfArray();
        PdfDictionary dict = new PdfDictionary();
        if (colSpan > 1) {
            dict.put(this.pdfStructure.pdfName("ColSpan"), new PdfNumber(colSpan));
        }
        if (rowSpan > 1) {
            dict.put(this.pdfStructure.pdfName("RowSpan"), new PdfNumber(rowSpan));
        }
        dict.put(PdfName.O, PdfName.TABLE);
        a.add(dict);
        this.element.put(PdfName.A, a);
    }
}

