/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.toolbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.ad.process.ISvrProcessPrecondition;
import org.adempiere.ad.services.IDeveloperModeBL;
import org.adempiere.util.Check;
import org.adempiere.util.Services;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class AProcessActionModel {
    private static final String ACTION_Name = "Process";
    private final CLogger logger = CLogger.getCLogger(this.getClass());
    private static final Map<Integer, List<Integer>> staticRegisteredProcesses = new HashMap<Integer, List<Integer>>();

    public String getActionName() {
        return ACTION_Name;
    }

    public List<MProcess> fetchProcesses(Properties ctx, GridTab gridTab) {
        List<MProcess> emptyList = Collections.unmodifiableList(new ArrayList());
        if (gridTab == null) {
            return emptyList;
        }
        List gridFieldProcess = Arrays.stream(gridTab.getFields()).filter(field -> field.getAD_Process_ID() > 0 && field.isDisplayed()).collect(Collectors.toList());
        MRole role = MRole.getDefault((Properties)ctx, (boolean)false);
        Check.assumeNotNull((Object)role, (String)"No role found for {0}", (Object[])new Object[]{ctx});
        List<MProcess> list = this.fetchProcessesForTab(ctx, gridTab);
        Iterator<MProcess> it = list.iterator();
        while (it.hasNext()) {
            MProcess process = it.next();
            Optional<GridField> maybeGridFieldProcess = gridFieldProcess.stream().filter(field -> field.getAD_Process_ID() == process.getAD_Process_ID()).findFirst();
            boolean isDisplay = maybeGridFieldProcess.map(gridField -> gridField.isDisplayed(true)).orElse(true);
            if (!isDisplay) {
                it.remove();
                continue;
            }
            Boolean accessRW = role.checkProcessAccess(process.getAD_Process_ID());
            if (accessRW == null) {
                this.logger.log(Level.FINE, "Removing process {0} because user has no access at all to it", (Object)process);
                it.remove();
                continue;
            }
            if (!accessRW.booleanValue()) {
                this.logger.log(Level.FINE, "Removing process {0} because user has only readonly access to it", (Object)process);
                it.remove();
                continue;
            }
            if (this.isPreconditionApplicable(process, gridTab)) continue;
            this.logger.log(Level.FINE, "Removing process {0} because preconditions were not met", (Object)process);
            it.remove();
        }
        return list;
    }

    public String getDisplayName(MProcess process) {
        Object name = process.get_Translation("Name");
        IDeveloperModeBL developerModeBL = (IDeveloperModeBL)Services.get(IDeveloperModeBL.class);
        if (developerModeBL != null && developerModeBL.isEnabled()) {
            name = (String)name + "/" + process.getValue();
        }
        return name;
    }

    public String getDescription(MProcess process) {
        Object description = process.get_Translation("Description");
        IDeveloperModeBL developerModeBL = (IDeveloperModeBL)Services.get(IDeveloperModeBL.class);
        if (developerModeBL != null && developerModeBL.isEnabled()) {
            description = description == null ? "" : (String)description + "\n - ";
            description = (String)description + "Classname:" + process.getClassname() + ", ID=" + process.getAD_Process_ID();
        }
        return description;
    }

    private boolean isPreconditionApplicable(MProcess process, GridTab gridTab) {
        Class<?> processClass;
        if (Check.isEmpty((String)process.getClassname(), (boolean)true)) {
            return true;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            processClass = classLoader.loadClass(process.getClassname());
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        if (!ISvrProcessPrecondition.class.isAssignableFrom(processClass)) {
            return true;
        }
        try {
            ISvrProcessPrecondition svrProcessPrecondit = processClass.asSubclass(ISvrProcessPrecondition.class).newInstance();
            return svrProcessPrecondit.isPreconditionApplicable(gridTab);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private List<MProcess> fetchProcessesForTab(Properties ctx, GridTab gridTab) {
        int adClientId = Env.getAD_Client_ID((Properties)ctx);
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(gridTab.getAD_Table_ID());
        params.add(adClientId);
        params.add(adClientId);
        String whereClause = "EXISTS (  SELECT 1  FROM AD_Table_Process tp  WHERE tp.IsActive='Y'    AND tp.AD_Table_ID=?    AND tp.AD_Process_ID=AD_Process.AD_Process_ID    AND (      (tp.IsShowForAllClients='N' AND EXISTS (         SELECT 1         FROM AD_Table_Process_Client tpc         WHERE tpc.IsActive='Y'           AND tpc.AD_Process_ID=tp.AD_Process_ID           AND tpc.AD_Client_ID=?           AND NVL(tpc.IsExclude,'N')='N'      ))      OR      (tp.IsShowForAllClients='Y' AND NOT EXISTS (         SELECT 1         FROM AD_Table_Process_Client tpc2         WHERE tpc2.IsActive='Y'           AND tpc2.AD_Process_ID=tp.AD_Process_ID           AND tpc2.AD_Client_ID=?           AND NVL(tpc2.IsExclude,'N')='Y'      ))    ))";
        return new Query(ctx, "AD_Process", "EXISTS (  SELECT 1  FROM AD_Table_Process tp  WHERE tp.IsActive='Y'    AND tp.AD_Table_ID=?    AND tp.AD_Process_ID=AD_Process.AD_Process_ID    AND (      (tp.IsShowForAllClients='N' AND EXISTS (         SELECT 1         FROM AD_Table_Process_Client tpc         WHERE tpc.IsActive='Y'           AND tpc.AD_Process_ID=tp.AD_Process_ID           AND tpc.AD_Client_ID=?           AND NVL(tpc.IsExclude,'N')='N'      ))      OR      (tp.IsShowForAllClients='Y' AND NOT EXISTS (         SELECT 1         FROM AD_Table_Process_Client tpc2         WHERE tpc2.IsActive='Y'           AND tpc2.AD_Process_ID=tp.AD_Process_ID           AND tpc2.AD_Client_ID=?           AND NVL(tpc2.IsExclude,'N')='Y'      ))    ))", Trx.TRXNAME_None).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Name").list(MProcess.class);
    }

    public static void registerProcess(int adTableId, int adProcessId) {
        Check.assume((adTableId > 0 ? 1 : 0) != 0, (String)"adTableId > 0", (Object[])new Object[0]);
        Check.assume((adProcessId > 0 ? 1 : 0) != 0, (String)"adProcessId > 0", (Object[])new Object[0]);
        List<Integer> processIds = staticRegisteredProcesses.get(adTableId);
        if (processIds == null) {
            processIds = new ArrayList<Integer>();
            staticRegisteredProcesses.put(adTableId, processIds);
        }
        if (!processIds.contains(adProcessId)) {
            processIds.add(adProcessId);
        }
    }
}

