/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class EKModelAddDesignToInvoiceLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelAddDesignToInvoiceLine.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        System.out.println("===> modelChange ejecutado");
        if (!(po instanceof MInvoiceLine) || type != 1) {
            return null;
        }
        MInvoiceLine iLine = (MInvoiceLine)po;
        System.out.println("Factura L\u00ednea ID: " + iLine.get_ID());
        int C_OrderLine_ID = iLine.getC_OrderLine_ID();
        if (C_OrderLine_ID <= 0) {
            System.out.println("No tiene l\u00ednea de pedido asociada");
            return null;
        }
        MOrderLine oLine = new MOrderLine(iLine.getCtx(), C_OrderLine_ID, iLine.get_TrxName());
        MOrder order = oLine.getParent();
        MDocType docType = new MDocType(iLine.getCtx(), order.getC_DocTypeTarget_ID(), iLine.get_TrxName());
        System.out.println("DocBaseType: " + docType.getDocBaseType());
        if (!"SOO".equals(docType.getDocBaseType())) {
            System.out.println("No es pedido de venta");
            return null;
        }
        int M_Product_ID = oLine.getM_Product_ID();
        if (M_Product_ID <= 0) {
            System.out.println("No tiene producto");
            return null;
        }
        MProduct product = new MProduct(iLine.getCtx(), M_Product_ID, iLine.get_TrxName());
        Integer designID = (Integer)oLine.get_Value("AJC_Designs_ID");
        System.out.println("AJC_Designs_ID desde l\u00ednea de pedido: " + designID);
        if (designID == null || designID <= 0) {
            System.out.println("No tiene dise\u00f1o asociado");
            return null;
        }
        PO design = MTable.get((Properties)iLine.getCtx(), (String)"AJC_Designs").getPO(designID.intValue(), iLine.get_TrxName());
        if (design == null) {
            System.out.println("No encontr\u00f3 el dise\u00f1o");
            return null;
        }
        String designName = (String)design.get_Value("Name");
        System.out.println("Nombre del dise\u00f1o: " + designName);
        String desigcodigo = (String)design.get_Value("Value");
        if (designName == null || designName.trim().isEmpty()) {
            System.out.println("El nombre del dise\u00f1o est\u00e1 vac\u00edo");
            return null;
        }
        if (desigcodigo == null || desigcodigo.trim().isEmpty()) {
            System.out.println("El codigo del dise\u00f1o est\u00e1 vac\u00edo");
            return null;
        }
        String originalDesc = iLine.getDescription() != null ? iLine.getDescription() : "";
        String newDesc = originalDesc + " Dise\u00f1o: [ " + desigcodigo + " " + designName + "]";
        iLine.setDescription(newDesc.trim());
        System.out.println("Descripci\u00f3n actualizada: " + newDesc);
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

