/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class EKModelAdjustmentAmt
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelAdjustmentAmt.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        BigDecimal finalTotal;
        log.info(po.get_TableName() + " Type: " + type);
        if ((type == 2 || type == 1) && po instanceof MOrderLine) {
            MOrderLine ol = (MOrderLine)po;
            if (ol.getC_Order().isSOTrx()) {
                return null;
            }
            BigDecimal qtyEntered = ol.getQtyEntered();
            BigDecimal actualPrice = ol.getPriceActual();
            BigDecimal lineNetAmt = actualPrice.multiply(qtyEntered);
            BigDecimal adjAmt = (BigDecimal)ol.get_Value("AJ_AdjustmentAmt");
            if (adjAmt == null) {
                adjAmt = Env.ZERO;
            }
            finalTotal = lineNetAmt.add(adjAmt);
            ol.setLineNetAmt(finalTotal.setScale(ol.getPrecision(), RoundingMode.HALF_UP));
        }
        if ((type == 2 || type == 1) && po instanceof MInvoiceLine) {
            MInvoiceLine il = (MInvoiceLine)po;
            BigDecimal qtyEntered = il.getQtyEntered();
            BigDecimal actualPrice = il.getPriceActual();
            BigDecimal lineNetAmt = actualPrice.multiply(qtyEntered);
            BigDecimal adjAmt = (BigDecimal)il.get_Value("AJ_AdjustmentAmt");
            if (adjAmt == null || adjAmt.compareTo(Env.ZERO) == 0) {
                if (il.getC_OrderLine_ID() > 0 && type == 1) {
                    MOrderLine ol = new MOrderLine(po.getCtx(), il.getC_OrderLine_ID(), po.get_TrxName());
                    adjAmt = (BigDecimal)ol.get_Value("AJ_AdjustmentAmt");
                    il.set_CustomColumn("AJ_AdjustmentAmt", (Object)adjAmt);
                } else {
                    adjAmt = Env.ZERO;
                }
            }
            finalTotal = lineNetAmt.add(adjAmt).setScale(il.getPrecision(), RoundingMode.HALF_UP);
            il.setLineNetAmt(finalTotal);
            if (!il.is_ValueChanged("TaxAmt")) {
                il.setTaxAmt();
            } else if (!il.isTaxIncluded()) {
                il.setLineTotalAmt(finalTotal.add(il.getTaxAmt()));
            } else {
                il.setLineTotalAmt(finalTotal);
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

