/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClient;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelGLToBankStmtValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelGLToBankStmtValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("GL_Journal", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (!(po instanceof MJournal) || timing != 9) {
            return null;
        }
        MJournal journal = (MJournal)po;
        if ("Y".equals(journal.get_ValueAsString("IsECBGenerated"))) {
            return null;
        }
        try {
            boolean msg = this.generateECB(journal);
            if (msg) {
                journal.set_ValueOfColumn("IsECBGenerated", "Y");
                journal.saveEx();
            }
        }
        catch (Exception e) {
            log.saveError("Error", e);
            return "No se pudo generar el/los ECB: " + e.getMessage();
        }
        return null;
    }

    private boolean generateECB(MJournal journal) {
        String trxName = journal.get_TrxName();
        Properties ctx = journal.getCtx();
        String descBase = journal.getDescription() != null && !journal.getDescription().trim().isEmpty() ? journal.getDescription() : "Diario " + journal.getDocumentNo();
        LinkedHashMap<Integer, List> byBank = new LinkedHashMap<Integer, List>();
        for (MJournalLine jl : journal.getLines(false)) {
            int bankID = DB.getSQLValue((String)trxName, (String)"SELECT C_BankAccount_ID FROM C_ElementValue WHERE C_ElementValue_ID=?", (int)jl.getAccount_ID());
            if (bankID <= 0) continue;
            byBank.computeIfAbsent(bankID, k -> new ArrayList()).add(jl);
        }
        if (byBank.isEmpty()) {
            log.warning("El asiento no contiene cuentas bancarias; no se genera ECB");
            return false;
        }
        boolean seInsertoAlgo = false;
        for (Map.Entry entry : byBank.entrySet()) {
            int bankID = (Integer)entry.getKey();
            List lines = (List)entry.getValue();
            MBankStatement ecb = (MBankStatement)new Query(ctx, "C_BankStatement", "C_BankAccount_ID=? AND AD_Org_ID=? AND DocStatus='DR' AND IsActive='Y'", trxName).setParameters(new Object[]{bankID, journal.getAD_Org_ID()}).setOrderBy("C_BankStatement_ID DESC").first();
            if (ecb == null) {
                ecb = new MBankStatement(ctx, 0, trxName);
                ecb.setAD_Org_ID(journal.getAD_Org_ID());
                ecb.setC_BankAccount_ID(bankID);
                ecb.setStatementDate(journal.getDateAcct());
                String hdrDesc = "Creado desde AC " + journal.getDocumentNo() + " (GL_Journal_ID=" + journal.get_ID() + ")";
                ecb.setDescription(hdrDesc);
                ecb.saveEx();
            } else {
                log.info("Usando ECB existente en borrador: " + ecb.getDocumentNo() + " (ID=" + ecb.get_ID() + ")");
                String extraDesc = " Nuevo AC " + journal.getDocumentNo() + " (GL_Journal_ID=" + journal.get_ID() + ")";
                String nuevaDescripcion = (ecb.getDescription() != null ? ecb.getDescription() : "") + extraDesc;
                ecb.setDescription(nuevaDescripcion);
                ecb.saveEx();
            }
            int lineNo = DB.getSQLValue((String)trxName, (String)"SELECT COALESCE(MAX(Line),0)+10 FROM C_BankStatementLine WHERE C_BankStatement_ID=?", (int)ecb.get_ID());
            int defaultChargeID = MSysConfig.getIntValue((String)"EK_BANK_FROM_GLJournal", (int)0, (int)journal.getAD_Client_ID());
            for (MJournalLine jl : lines) {
                MBankStatementLine sl = new MBankStatementLine(ecb);
                sl.setLine(lineNo);
                sl.setDescription((String)(jl.getDescription() != null && !jl.getDescription().trim().isEmpty() ? jl.getDescription() : descBase));
                BigDecimal amt = jl.getAmtAcctDr().subtract(jl.getAmtAcctCr());
                sl.setStmtAmt(amt);
                if (defaultChargeID > 0) {
                    sl.setC_Charge_ID(defaultChargeID);
                }
                sl.set_ValueOfColumn("GL_JournalLine_ID", (Object)jl.get_ID());
                jl.set_ValueOfColumn("C_BankStatement_ID", (Object)ecb.get_ID());
                jl.saveEx();
                sl.saveEx();
                lineNo += 10;
                seInsertoAlgo = true;
            }
        }
        return seInsertoAlgo;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

