/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class EKModelManualPricePL1000469
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelManualPricePL1000469.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        if (!(po instanceof MOrderLine)) {
            return null;
        }
        MOrderLine line = (MOrderLine)po;
        if (type != 1 && type != 2) {
            return null;
        }
        MOrder order = line.getParent();
        if (order == null || order.get_ID() <= 0) {
            return null;
        }
        if (order.getM_PriceList_ID() != 1000469) {
            return null;
        }
        BigDecimal pa = line.getPriceActual();
        if (pa == null) {
            pa = Env.ZERO;
        }
        line.setPriceList(pa);
        line.setDiscount(Env.ZERO);
        line.setLineNetAmt();
        log.warning("PL=1000469: PriceList/Limit/Discount fijados a manual. PA=" + String.valueOf(pa));
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

