/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelMovementValidator
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelMovementValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Movement", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        if (!(po instanceof MMovement)) {
            return null;
        }
        MMovement mov = (MMovement)po;
        if (timing == 7 && this.isValidationEnabled("ValidMovStock", po) && this.ValidMovStock(mov) != null) {
            error = (String)error + this.ValidMovStock(mov);
        }
        return error == "" ? null : error;
    }

    public String ValidMovStock(MMovement mov) {
        String trxName = mov.get_TrxName();
        try {
            MMovementLine[] lines = mov.getLines(false);
            if (lines == null || lines.length == 0) {
                return null;
            }
            LinkedHashMap<Key, BigDecimal> demand = new LinkedHashMap<Key, BigDecimal>();
            for (MMovementLine l : lines) {
                BigDecimal qty;
                if (l.getM_Product_ID() <= 0 || l.getM_Locator_ID() <= 0 || (qty = l.getMovementQty()) == null || qty.signum() == 0) continue;
                BigDecimal consume = qty.abs();
                Key k = new Key(l.getM_Product_ID(), l.getM_Locator_ID(), l.getM_AttributeSetInstance_ID());
                demand.merge(k, consume, BigDecimal::add);
            }
            if (demand.isEmpty()) {
                return null;
            }
            for (Map.Entry entry : demand.entrySet()) {
                Key k = (Key)entry.getKey();
                BigDecimal toConsume = (BigDecimal)entry.getValue();
                BigDecimal onHand = this.getQtyOnHandInLocator(k.M_Product_ID, k.M_Locator_ID, k.M_ASI_ID);
                if (onHand == null) {
                    onHand = Env.ZERO;
                }
                if (onHand.compareTo(toConsume) >= 0) continue;
                MProduct prod = MProduct.get(mov.getCtx(), k.M_Product_ID);
                MLocator loc = new MLocator(mov.getCtx(), k.M_Locator_ID, trxName);
                String msg = "No es posible completar el Movimiento porque quedar\u00eda stock negativo en el origen.\nProducto: " + prod.getValue() + " - " + prod.getName() + "\nLocator origen: " + (String)(loc != null ? loc.getValue() : "ID:" + k.M_Locator_ID) + "\nDisponible en origen: " + onHand.stripTrailingZeros().toPlainString() + "\nRequerido para mover: " + toConsume.stripTrailingZeros().toPlainString();
                return msg;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error validando stock: " + ex.getMessage();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal getQtyOnHandInLocator(int M_Product_ID, int M_Locator_ID, int M_ASI_ID) {
        StringBuilder sql = new StringBuilder().append("SELECT COALESCE(SUM(s.QtyOnHand),0) ").append("FROM M_Storage s ").append("WHERE s.M_Product_ID=? AND s.M_Locator_ID=? ");
        if (M_ASI_ID > 0) {
            sql.append("AND s.M_AttributeSetInstance_ID=? ");
        }
        try (CPreparedStatement ps = DB.prepareStatement((String)sql.toString(), null);){
            int i = 1;
            ps.setInt(i++, M_Product_ID);
            ps.setInt(i++, M_Locator_ID);
            if (M_ASI_ID > 0) {
                ps.setInt(i++, M_ASI_ID);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Env.ZERO;
                BigDecimal bigDecimal = rs.getBigDecimal(1);
                return bigDecimal;
            }
        }
        catch (Exception e) {
            log.warning("getQtyOnHandInLocator error: " + e.getMessage());
        }
        return Env.ZERO;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    private static final class Key {
        final int M_Product_ID;
        final int M_Locator_ID;
        final int M_ASI_ID;

        Key(int p, int l, int a) {
            this.M_Product_ID = p;
            this.M_Locator_ID = l;
            this.M_ASI_ID = a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return this.M_Product_ID == k.M_Product_ID && this.M_Locator_ID == k.M_Locator_ID && this.M_ASI_ID == k.M_ASI_ID;
        }

        public int hashCode() {
            return Objects.hash(this.M_Product_ID, this.M_Locator_ID, this.M_ASI_ID);
        }
    }
}

