/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class EKModelRutValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelRutValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(po.get_TableName() + " Type: " + type);
        if ((type == 2 || type == 1) && po instanceof MBPartner) {
            MBPartner bp = (MBPartner)po;
            if (bp.getC_BP_Group().getValue().contains("Extranjero") || bp.getC_BP_Group().getValue().contains("Prospecto")) {
                return null;
            }
            String rut = bp.getValue();
            if (this.isValidRUT(rut) != null) {
                return "El RUT ingresado no es valido: " + this.isValidRUT(rut) + ".";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    private String isValidRUT(String rut) {
        if (rut == null || !rut.contains("-")) {
            return "RUT debe llevar guion (-)";
        }
        if (rut == null || rut.contains(".")) {
            return "RUT no debe llevar puntos";
        }
        if (rut == null || rut.contains(" ")) {
            return "RUT no debe llevar espacios";
        }
        if (rut == null || rut.contains("k")) {
            return "RUT debe terminar con K may\u00fascula";
        }
        String[] parts = rut.split("-");
        if (parts.length != 2) {
            return "RUT sin digito verificador";
        }
        String numberPart = parts[0].replaceAll("\\.", "");
        String dv = parts[1].toUpperCase();
        try {
            int number = Integer.parseInt(numberPart);
            char expectedDV = this.calculateDV(number);
            if (dv.charAt(0) == expectedDV) {
                return null;
            }
            return "DV no coincide";
        }
        catch (NumberFormatException e) {
            return e.toString();
        }
    }

    private char calculateDV(int rutNumber) {
        int m = 0;
        int s = 1;
        while (rutNumber != 0) {
            s = (s + rutNumber % 10 * (9 - m++ % 6)) % 11;
            rutNumber /= 10;
        }
        return (char)(s != 0 ? s + 47 : 75);
    }
}

