/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.ajah.model.EKModelRutValidator;
import org.compiere.model.MBankStatement;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelValidBankStatement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelRutValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_BankStatement", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 && po instanceof MBankStatement) {
            MBankStatement bs = (MBankStatement)po;
            this.alreadyHaveBankStatement(bs);
        }
        return null;
    }

    private void alreadyHaveBankStatement(MBankStatement bs) {
        String sql = "SELECT MAX(C_BankStatement_ID) FROM C_BankStatement WHERE DocStatus='DR' AND C_BankAccount_ID=?";
        int alreadyBankStatement_id = DB.getSQLValue((String)bs.get_TrxName(), (String)sql, (int)bs.getC_BankAccount_ID());
        if (alreadyBankStatement_id > 0) {
            bs = new MBankStatement(bs.getCtx(), alreadyBankStatement_id, bs.get_TrxName());
            throw new AdempiereException("Ya existe Estado de Cuenta " + bs.getDocumentNo() + " en borrador para esta cuenta bancaria.");
        }
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

