/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelValidInOut
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidInOut.class);

    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        engine.addModelChange("M_InOut", (ModelValidator)this);
        engine.addModelChange("M_InOutLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInOut io;
        Object error = "";
        if (type == 4 && po instanceof MInOut && (io = (MInOut)po).isSOTrx() && this.isValidationEnabled("dteDocumentTypeSet", po) && this.dteDocumentTypeSet(io) != null) {
            error = (String)error + this.dteDocumentTypeSet(io);
        }
        if (po instanceof MInOutLine && (type == 1 || type == 2)) {
            MInOutLine line = (MInOutLine)po;
            if (this.isValidationEnabled("ValidASILote", po) && this.ValidASILote(line, po) != null) {
                error = (String)error + this.ValidASILote(line, po);
            }
        }
        return error == "" ? null : error;
    }

    private String dteDocumentTypeSet(MInOut io) {
        if (io.getC_Order_ID() <= 0) {
            return null;
        }
        MOrder nv = new MOrder(io.getCtx(), io.getC_Order_ID(), io.get_TrxName());
        if (nv.getC_BPartner_Location_ID() != nv.getBill_Location_ID()) {
            MDocType dt = MDocType.get((Properties)io.getCtx(), (int)nv.getC_DocType_ID());
            int newDt_id = dt.get_ValueAsInt("C_DocTypeShipmentDTE_ID");
            if (newDt_id > 0) {
                io.setC_DocType_ID(dt.get_ValueAsInt("C_DocTypeShipmentDTE_ID"));
                io.saveEx();
            } else {
                return "Tipo de Documento DTE para la Entrega no seteado (C_DocTypeShipmentDTE_ID=null).";
            }
        }
        return null;
    }

    public String ValidASILote(MInOutLine line, PO po) {
        int asiId = line.getM_AttributeSetInstance_ID();
        if (asiId <= 0) {
            return null;
        }
        MAttributeSetInstance asi = new MAttributeSetInstance(po.getCtx(), asiId, po.get_TrxName());
        String lot = asi.getLot();
        if (lot == null || lot.trim().isEmpty()) {
            return null;
        }
        int adClientId = line.getAD_Client_ID();
        int productId = line.getM_Product_ID();
        int exists = DB.getSQLValue((String)po.get_TrxName(), (String)"SELECT 1 FROM M_AttributeSetInstance asi WHERE asi.AD_Client_ID=?   AND UPPER(asi.Lot)=UPPER(?)   AND asi.M_AttributeSetInstance_ID<>?   AND EXISTS (       SELECT 1       FROM M_Storage s       WHERE s.M_AttributeSetInstance_ID = asi.M_AttributeSetInstance_ID         AND s.M_Product_ID = ?   )", (Object[])new Object[]{adClientId, lot.trim(), asiId, productId});
        if (exists > 0) {
            return "No se puede usar el lote '" + lot + "' porque ya existe para este producto.";
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MInOut io;
        Object error = "";
        if (timing == 7 && po instanceof MInOut && (io = (MInOut)po).isSOTrx()) {
            if (this.isValidationEnabled("movementDateOnComplete", po) && this.movementDateOnComplete(io) != null) {
                error = (String)error + this.movementDateOnComplete(io);
            }
            if (this.isValidationEnabled("ValidInOutStock", po) && this.ValidInOutStock(io, timing) != null) {
                error = (String)error + this.ValidInOutStock(io, timing);
            }
            if (this.isValidationEnabled("ShipmentQtyValidator", po) && this.ShipmentQtyValidator(io) != null) {
                error = (String)error + this.ShipmentQtyValidator(io);
            }
            if (this.isValidationEnabled("ShipmentInvoicePeriodValidator", po) && this.ShipmentInvoicePeriodValidator(io, po) != null) {
                error = (String)error + this.ShipmentInvoicePeriodValidator(io, po);
            }
        }
        return error == "" ? null : error;
    }

    private String ShipmentInvoicePeriodValidator(MInOut io, PO po) {
        boolean mismoMes;
        if (!"C-".equals(io.getMovementType())) {
            return null;
        }
        String trxName = po.get_TrxName();
        int invoiceId = DB.getSQLValue((String)trxName, (String)"SELECT DISTINCT il.C_Invoice_ID FROM C_InvoiceLine il JOIN M_InOutLine iol ON il.M_InOutLine_ID = iol.M_InOutLine_ID WHERE iol.M_InOut_ID = ?", (int)io.getM_InOut_ID());
        if (invoiceId <= 0) {
            return null;
        }
        MInvoice inv = new MInvoice(io.getCtx(), invoiceId, trxName);
        if (!inv.isSOTrx()) {
            return null;
        }
        Timestamp dateAcctInv = inv.getDateAcct();
        Timestamp dateAcctIO = io.getDateAcct();
        if (dateAcctInv == null || dateAcctIO == null) {
            return null;
        }
        Calendar cInv = Calendar.getInstance();
        cInv.setTime(dateAcctInv);
        Calendar cIO = Calendar.getInstance();
        cIO.setTime(dateAcctIO);
        boolean bl = mismoMes = cInv.get(1) == cIO.get(1) && cInv.get(2) == cIO.get(2);
        if (!mismoMes) {
            return "No se puede completar la Gu\u00eda de Entrega.\n\nLa fecha contable de la Gu\u00eda (" + String.valueOf(dateAcctIO) + ") debe estar en el mismo per\u00edodo que la factura de origen (" + String.valueOf(dateAcctInv) + ").";
        }
        return null;
    }

    private String ShipmentQtyValidator(MInOut io) {
        MInOutLine[] lines;
        Properties ctx = io.getCtx();
        String trxName = io.get_TrxName();
        if (io.isReversal()) {
            return null;
        }
        if (!io.isSOTrx()) {
            return null;
        }
        if (!"C-".equals(io.getMovementType())) {
            return null;
        }
        for (MInOutLine line : lines = io.getLines(false)) {
            BigDecimal thisDeliveryAbs;
            BigDecimal alreadyDeliveredAbs;
            BigDecimal totalDelivered;
            BigDecimal alreadyDelivered;
            int orderLineId = line.getC_OrderLine_ID();
            if (orderLineId <= 0) continue;
            MOrderLine oLine = new MOrderLine(ctx, orderLineId, trxName);
            BigDecimal qtyOrdered = oLine.getQtyOrdered();
            if (qtyOrdered == null) {
                qtyOrdered = BigDecimal.ZERO;
            }
            if ((alreadyDelivered = DB.getSQLValueBD((String)trxName, (String)"SELECT COALESCE(SUM(l.MovementQty), 0) FROM M_InOutLine l INNER JOIN M_InOut i ON (i.M_InOut_ID = l.M_InOut_ID) WHERE l.C_OrderLine_ID=?   AND i.DocStatus IN ('CO','CL')   AND i.M_InOut_ID <> ?", (Object[])new Object[]{orderLineId, io.getM_InOut_ID()})) == null) {
                alreadyDelivered = BigDecimal.ZERO;
            }
            if ((totalDelivered = (alreadyDeliveredAbs = alreadyDelivered.abs()).add(thisDeliveryAbs = line.getMovementQty() == null ? BigDecimal.ZERO : line.getMovementQty().abs())).compareTo(qtyOrdered) <= 0) continue;
            String product = line.getM_Product() != null ? line.getM_Product().getValue() + " - " + line.getM_Product().getName() : "(sin producto)";
            String msg = "No se puede entregar m\u00e1s cantidad que la Nota de Venta.\nProducto: " + product + "\nCantidad Pedida: " + String.valueOf(qtyOrdered) + "\nYa Entregado (otras entregas): " + String.valueOf(alreadyDeliveredAbs) + "\nEsta Entrega: " + String.valueOf(thisDeliveryAbs) + "\nTotal Entregado: " + String.valueOf(totalDelivered);
            return msg;
        }
        return null;
    }

    private String movementDateOnComplete(MInOut io) {
        io.setMovementDate(new Timestamp(System.currentTimeMillis()));
        io.setDateAcct(new Timestamp(System.currentTimeMillis()));
        if (!io.save()) {
            return "Error al tratar guardar:" + io.getProcessMsg();
        }
        return null;
    }

    public String ValidInOutStock(MInOut io, int timing) {
        String trxName = io.get_TrxName();
        MDocType dt = MDocType.get((Properties)io.getCtx(), (int)io.getC_DocType_ID());
        if (dt == null || !"MMS".equals(dt.getDocBaseType())) {
            return null;
        }
        if (io.isReversal()) {
            return null;
        }
        if (this.isFromWROrder(io)) {
            return null;
        }
        Timestamp movementDate = io.getMovementDate();
        if (movementDate == null) {
            movementDate = new Timestamp(System.currentTimeMillis());
        }
        try {
            MInOutLine[] lines = io.getLines();
            if (lines == null || lines.length == 0) {
                return null;
            }
            for (MInOutLine l : lines) {
                BigDecimal qty;
                MProduct prodCheck;
                if (l.getM_Product_ID() <= 0 || l.getM_Locator_ID() <= 0 || "S".equals((prodCheck = MProduct.get(io.getCtx(), l.getM_Product_ID())).getProductType()) || (qty = l.getQtyEntered()) == null || qty.signum() == 0) continue;
                BigDecimal consume = qty.abs();
                int productId = l.getM_Product_ID();
                int locatorId = l.getM_Locator_ID();
                int asiId = l.getM_AttributeSetInstance_ID();
                BigDecimal onHand = this.getQtyOnHandInLocator(productId, asiId, locatorId, movementDate);
                if (onHand == null) {
                    onHand = Env.ZERO;
                }
                if (onHand.compareTo(consume) >= 0) continue;
                MProduct prod = MProduct.get(io.getCtx(), productId);
                MLocator loc = new MLocator(io.getCtx(), locatorId, trxName);
                return "No se puede completar la Entrega porque quedar\u00eda stock negativo.\nProducto: " + prod.getValue() + " - " + prod.getName() + "\nLocator: " + (String)(loc != null ? loc.getValue() : "ID=" + locatorId) + "\nStock disponible: " + String.valueOf(onHand) + "\nRequerido: " + String.valueOf(consume);
            }
            return null;
        }
        catch (Exception ex) {
            return "Error validando stock en M_InOut: " + ex.getMessage();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal getQtyOnHandInLocator(int M_Product_ID, int M_ASI_ID, int M_Locator_ID, Timestamp movementDate) {
        StringBuilder sql = new StringBuilder().append("SELECT COALESCE(SUM(s.QtyOnHand),0) ").append("FROM M_Storage s ").append("LEFT JOIN M_AttributeSetInstance asi ").append("  ON (s.M_AttributeSetInstance_ID = asi.M_AttributeSetInstance_ID) ").append("WHERE s.M_Product_ID=? ").append("  AND s.M_Locator_ID=? ");
        if (M_ASI_ID > 0) {
            sql.append("  AND s.M_AttributeSetInstance_ID=? ");
        }
        sql.append("  AND (asi.GuaranteeDate IS NULL OR asi.GuaranteeDate >= ?) ");
        try (CPreparedStatement ps = DB.prepareStatement((String)sql.toString(), null);){
            int i = 1;
            ps.setInt(i++, M_Product_ID);
            ps.setInt(i++, M_Locator_ID);
            if (M_ASI_ID > 0) {
                ps.setInt(i++, M_ASI_ID);
            }
            ps.setTimestamp(i++, movementDate);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Env.ZERO;
                BigDecimal bigDecimal = rs.getBigDecimal(1);
                return bigDecimal;
            }
        }
        catch (Exception e) {
            log.warning("getQtyOnHandInLocator error: " + e.getMessage());
        }
        return Env.ZERO;
    }

    private boolean isFromWROrder(MInOut io) {
        String trx = io.get_TrxName();
        if (io.getC_Order_ID() > 0) {
            String sqlHdr = "SELECT CASE          WHEN o.IsSOTrx='Y'           AND dt.DocBaseType='SOO'           AND COALESCE(dt.DocSubTypeSO,'')='WR'          THEN 1 ELSE 0 END FROM C_Order o JOIN C_DocType dt ON dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID) WHERE o.C_Order_ID=?";
            return DB.getSQLValueEx((String)trx, (String)"SELECT CASE          WHEN o.IsSOTrx='Y'           AND dt.DocBaseType='SOO'           AND COALESCE(dt.DocSubTypeSO,'')='WR'          THEN 1 ELSE 0 END FROM C_Order o JOIN C_DocType dt ON dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID) WHERE o.C_Order_ID=?", (Object[])new Object[]{io.getC_Order_ID()}) == 1;
        }
        String sqlLines = "SELECT 1 FROM M_InOutLine iol JOIN C_OrderLine ol ON (ol.C_OrderLine_ID = iol.C_OrderLine_ID) JOIN C_Order o      ON (o.C_Order_ID = ol.C_Order_ID) JOIN C_DocType dt   ON (dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID)) WHERE iol.M_InOut_ID=?   AND o.IsSOTrx='Y'   AND dt.DocBaseType='SOO'   AND COALESCE(dt.DocSubTypeSO,'')='WR' LIMIT 1";
        return DB.getSQLValueEx((String)trx, (String)"SELECT 1 FROM M_InOutLine iol JOIN C_OrderLine ol ON (ol.C_OrderLine_ID = iol.C_OrderLine_ID) JOIN C_Order o      ON (o.C_Order_ID = ol.C_Order_ID) JOIN C_DocType dt   ON (dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID)) WHERE iol.M_InOut_ID=?   AND o.IsSOTrx='Y'   AND dt.DocBaseType='SOO'   AND COALESCE(dt.DocSubTypeSO,'')='WR' LIMIT 1", (Object[])new Object[]{io.getM_InOut_ID()}) == 1;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

