/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class EKModelValidInvoice
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidInvoice.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        if (timing == 7 && po instanceof MInvoice) {
            MInvoice inv = (MInvoice)po;
            MDocType dt = new MDocType(po.getCtx(), inv.getC_DocType_ID(), po.get_TrxName());
            if (inv.isSOTrx()) {
                if (this.isValidationEnabled("qtyLineZero", po) && this.qtyLineZero(inv) != null) {
                    error = this.qtyLineZero(inv);
                }
                if (this.isValidationEnabled("wrongAffectsLines", po) && this.wrongAffectsLines(inv, dt) != null) {
                    error = (String)error + this.wrongAffectsLines(inv, dt);
                }
                if (this.isValidationEnabled("wrongExemptLines", po) && this.wrongExemptLines(inv, dt) != null) {
                    error = (String)error + this.wrongExemptLines(inv, dt);
                }
                if (this.isValidationEnabled("validCurrency", po) && this.validCurrency(inv) != null) {
                    error = (String)error + this.validCurrency(inv);
                }
                if (this.isValidationEnabled("validPOReferenceChar", po) && this.validPOReferenceChar(inv) != null) {
                    error = this.validPOReferenceChar(inv);
                }
                if (this.isValidationEnabled("dateAcctOnComplete", po)) {
                    this.dateAcctOnComplete(inv);
                }
            } else {
                if (this.wrongAffectsLines(inv, dt) != null && this.wrongAffectsLines(inv, dt) != null) {
                    error = (String)error + this.wrongAffectsLines(inv, dt);
                }
                this.PaymentRuleAcctCom(inv);
            }
        }
        return error == "" ? null : error;
    }

    public String qtyLineZero(MInvoice inv) {
        MInvoiceLine[] lines;
        for (MInvoiceLine line : lines = inv.getLines()) {
            if (line.getM_Product_ID() <= 0 && line.getC_Charge_ID() <= 0) continue;
            String codeRef = inv.get_ValueAsString("AJ_CodRef");
            if (line.getQtyEntered().compareTo(Env.ZERO) > 0 || codeRef.equals("2")) continue;
            return "L\u00ednea " + line.getLine() + " no puede tener cantidad 0. \n";
        }
        return null;
    }

    public String wrongAffectsLines(MInvoice inv, MDocType dt) {
        boolean taxExempt = dt.get_ValueAsBoolean("IsTaxExempt");
        if (taxExempt) {
            MInvoiceLine[] lines;
            for (MInvoiceLine line : lines = inv.getLines()) {
                if (line.getC_Tax().isTaxExempt()) continue;
                return "L\u00ednea " + line.getLine() + " no puede ser afecta en documento exento. \n";
            }
        }
        return null;
    }

    public String wrongExemptLines(MInvoice inv, MDocType dt) {
        boolean taxExempt = dt.get_ValueAsBoolean("IsTaxExempt");
        if (!taxExempt) {
            MInvoiceLine[] lines;
            for (MInvoiceLine line : lines = inv.getLines()) {
                if (!line.getC_Tax().isTaxExempt()) continue;
                return "L\u00ednea " + line.getLine() + " no puede ser exenta en documento afecto. \n";
            }
        }
        return null;
    }

    public String validCurrency(MInvoice inv) {
        if (inv.getC_Currency_ID() != 228 && inv.getC_Currency_ID() != 100) {
            return "El documento no se puede completar con moneda " + inv.getC_Currency().getISO_Code() + ". \n";
        }
        return null;
    }

    public String validPOReferenceChar(MInvoice inv) {
        if (inv.getPOReference() == null) {
            return null;
        }
        if (inv.getPOReference().contains("/")) {
            return "El Documento Ref no puede llevar el caracter /";
        }
        return null;
    }

    public void dateAcctOnComplete(MInvoice inv) {
        if (inv.getC_Order() != null && inv.getC_Order().getC_DocType().getDocSubTypeSO() != null && (inv.getC_Order().getC_DocType().getDocSubTypeSO().equals("WR") || inv.getC_Order().getC_DocType().getDocSubTypeSO().equals("WI"))) {
            return;
        }
        if (inv.getC_DocType() != null && inv.getC_DocType().getName().toLowerCase().contains("boleta")) {
            return;
        }
        Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
        LocalDate localDate = currentTimestamp.toLocalDateTime().toLocalDate();
        Timestamp dateOnlyTimestamp = Timestamp.valueOf(localDate.atStartOfDay());
        inv.setDateAcct(dateOnlyTimestamp);
        inv.save();
    }

    public void PaymentRuleAcctCom(MInvoice inv) {
        MOrderLine oLine;
        MOrder order;
        MInvoiceLine line;
        MInvoiceLine[] lines;
        if (!inv.isSOTrx() && (lines = inv.getLines()).length > 0 && (line = lines[0]).getC_OrderLine_ID() > 0 && (order = (oLine = new MOrderLine(inv.getCtx(), line.getC_OrderLine_ID(), inv.get_TrxName())).getParent()) != null && order.getPaymentRule() != null) {
            inv.setPaymentRule(order.getPaymentRule());
            inv.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            inv.saveEx();
        }
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

