/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.ajah.model.EKModelAdjustmentAmt;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class EKModelValidKitRaptor
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelAdjustmentAmt.class);

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 7 && po instanceof MOrder) {
            MOrder ov = (MOrder)po;
            if (!ov.isSOTrx()) {
                return null;
            }
            int n = 0;
            MOrderLine[] lines = ov.getLines();
            MOrderLine[] mOrderLineArray = lines;
            int n2 = mOrderLineArray.length;
            if (n < n2) {
                MOrderLine line = mOrderLineArray[n];
                if (!line.getM_Product().getM_Product_Category().getName().toUpperCase().startsWith("KIT")) {
                    return null;
                }
                if (line.get_ValueAsInt("M_ProductionBatch_ID") > 0) {
                    return this.validProduction(line, line.get_ValueAsInt("M_ProductionBatch_ID"));
                }
                if (line.get_ValueAsInt("M_Inventory_ID") > 0) {
                    return this.validInventory(line, line.get_ValueAsInt("M_Inventory_ID"));
                }
                return "El producto " + line.getM_Product().getName() + " no tiene produccion ni consumo asociado.";
            }
        }
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String validProduction(MOrderLine line, int op_id) {
        MProduction pt = (MProduction)new Query(line.getCtx(), "M_Production", "M_ProductionBatch_ID=?", line.get_TrxName()).setParameters(new Object[]{op_id}).first();
        MProductionLine[] pLines = pt.getLines();
        BigDecimal productCost = Env.ZERO;
        BigDecimal totalCost = Env.ZERO;
        int marginCost = 0;
        for (MProductionLine pLine : pLines) {
            if (pLine.isEndProduct()) continue;
            MCost pCost = (MCost)new Query(line.getCtx(), "M_Cost", "M_Product_ID=?", line.get_TrxName()).setParameters(new Object[]{pLine.getM_Product_ID()}).first();
            productCost = pCost.getCurrentCostPrice();
            productCost = productCost.multiply(pLine.getMovementQty().abs());
            marginCost = MSysConfig.getIntValue((String)"MARGEN_VENTAS_RAPTOR", (int)30);
            productCost = productCost.multiply(new BigDecimal(marginCost)).divide(new BigDecimal(100));
            totalCost = totalCost.add(productCost);
        }
        if (totalCost.compareTo(Env.ZERO) <= 0) {
            return "El costo de la produccion no puede ser 0";
        }
        if (totalCost.compareTo(line.getLineNetAmt()) > 0) {
            return "El costo de la produccion no puede ser mayor a la del producto en venta  (" + String.valueOf(totalCost.toBigInteger()) + ">" + String.valueOf(line.getLineNetAmt()) + ").";
        }
        return null;
    }

    public String validInventory(MOrderLine line, int inv_id) {
        MInventory inv = MInventory.get(line.getCtx(), inv_id);
        MInventoryLine[] iLines = inv.getLines(true);
        BigDecimal productCost = Env.ZERO;
        BigDecimal totalCost = Env.ZERO;
        int marginCost = 0;
        for (MInventoryLine iLine : iLines) {
            MCost pCost = (MCost)new Query(line.getCtx(), "M_Cost", "M_Product_ID=?", line.get_TrxName()).setParameters(new Object[]{iLine.getM_Product_ID()}).first();
            productCost = pCost.getCurrentCostPrice();
            productCost = productCost.multiply(iLine.getMovementQty().abs());
            marginCost = MSysConfig.getIntValue((String)"MARGEN_VENTAS_RAPTOR", (int)30);
            productCost = productCost.multiply(new BigDecimal(marginCost)).divide(new BigDecimal(100));
            totalCost = totalCost.add(productCost);
        }
        if (totalCost.compareTo(Env.ZERO) <= 0) {
            return "El costo del consumo no puede ser 0";
        }
        if (totalCost.compareTo(line.getLineNetAmt()) > 0) {
            return "El costo del consumo no puede ser mayor a la del producto en venta (" + String.valueOf(totalCost.toBigInteger()) + ">" + String.valueOf(line.getLineNetAmt()) + ").";
        }
        return null;
    }
}

