/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class EKModelValidLogisASI
extends AbstractValidatingEKModel
implements ModelValidator {
    private static final CLogger log = CLogger.getCLogger(EKModelValidLogisASI.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        engine.addDocValidate("M_Inventory", (ModelValidator)this);
        engine.addDocValidate("M_Movement", (ModelValidator)this);
        engine.addDocValidate("M_Production", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) {
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing != 7) {
            return null;
        }
        if (!this.isValidationEnabled("doDocValidate", po)) {
            return null;
        }
        try {
            String err = this.doDocValidate(po);
            return Util.isEmpty((String)err, (boolean)true) ? null : err;
        }
        catch (Exception ex) {
            log.severe("ASI validation error: " + ex.getMessage());
            return "Error validando Atributos: " + ex.getMessage();
        }
    }

    private String doDocValidate(PO po) throws Exception {
        if (po instanceof MInOut) {
            if (!this.isValidationEnabled("validateInOut", po)) {
                return null;
            }
            MInOut io = (MInOut)po;
            if (this.isValidationEnabled("skipPOS_WR", (PO)io) && io.isSOTrx() && this.isFromWROrder(io)) {
                log.fine("Skip ASI validation on MInOut because source Sales Order DocSubTypeSO=WR");
                return null;
            }
            return this.validateInOut(io);
        }
        if (po instanceof MInventory) {
            if (!this.isValidationEnabled("validateInventory", po)) {
                return null;
            }
            return this.validateInventory((MInventory)po);
        }
        if (po instanceof MMovement) {
            if (!this.isValidationEnabled("validateMovement", po)) {
                return null;
            }
            return this.validateMovement((MMovement)po);
        }
        if (po instanceof MProduction) {
            if (!this.isValidationEnabled("validateProduction", po)) {
                return null;
            }
            return this.validateProduction((MProduction)po);
        }
        return null;
    }

    private String validateInOut(MInOut io) throws Exception {
        ArrayList<String> issues = new ArrayList<String>();
        for (MInOutLine line : io.getLines(true)) {
            int attributeSetId;
            int productId = line.getM_Product_ID();
            if (productId <= 0 || (attributeSetId = this.getProductAttributeSetId(productId, io.get_TrxName())) <= 0) continue;
            int asiId = line.getM_AttributeSetInstance_ID();
            this.checkASIComplete(io.getCtx(), productId, attributeSetId, asiId, issues, io.get_TrxName(), "Entrega/Recepci\u00f3n", line.getLine());
        }
        return this.aggregateIssues(issues);
    }

    private String validateInventory(MInventory inv) throws Exception {
        ArrayList<String> issues = new ArrayList<String>();
        MDocType dt = MDocType.get((Properties)inv.getCtx(), (int)inv.getC_DocType_ID());
        String dtName = dt != null && dt.getName() != null ? dt.getName().toUpperCase() : "";
        boolean isInventoryDoc = dtName.contains("INVENTARIO");
        for (MInventoryLine line : inv.getLines(true)) {
            BigDecimal qtyCount;
            int attributeSetId;
            int productId = line.getM_Product_ID();
            if (productId <= 0 || (attributeSetId = this.getProductAttributeSetId(productId, inv.get_TrxName())) <= 0 || isInventoryDoc && ((qtyCount = line.getQtyCount()) == null || qtyCount.signum() == 0)) continue;
            int asiId = line.getM_AttributeSetInstance_ID();
            this.checkASIComplete(inv.getCtx(), productId, attributeSetId, asiId, issues, inv.get_TrxName(), "Inventario/Consumo", line.getLine());
        }
        return this.aggregateIssues(issues);
    }

    private String validateMovement(MMovement mv) throws Exception {
        ArrayList<String> issues = new ArrayList<String>();
        for (MMovementLine line : mv.getLines(true)) {
            int attributeSetId;
            int productId = line.getM_Product_ID();
            if (productId <= 0 || (attributeSetId = this.getProductAttributeSetId(productId, mv.get_TrxName())) <= 0) continue;
            int asiFromId = line.getM_AttributeSetInstance_ID();
            this.checkASIComplete(mv.getCtx(), productId, attributeSetId, asiFromId, issues, mv.get_TrxName(), "Movimiento (Origen)", line.getLine());
            if (!this.isValidationEnabled("requireMovementDestASI", (PO)mv)) continue;
            int asiToId = this.getSafe(line, "M_AttributeSetInstanceTo_ID");
            this.checkASIComplete(mv.getCtx(), productId, attributeSetId, asiToId, issues, mv.get_TrxName(), "Movimiento (Destino)", line.getLine());
        }
        return this.aggregateIssues(issues);
    }

    private String validateProduction(MProduction prd) throws Exception {
        ArrayList<String> issues = new ArrayList<String>();
        for (MProductionLine line : prd.getLines()) {
            int attributeSetId;
            int productId;
            if (!this.isEndProductLine(line) || (productId = line.getM_Product_ID()) <= 0 || (attributeSetId = this.getProductAttributeSetId(productId, prd.get_TrxName())) <= 0) continue;
            int asiId = line.getM_AttributeSetInstance_ID();
            this.checkASIComplete(prd.getCtx(), productId, attributeSetId, asiId, issues, prd.get_TrxName(), "Producci\u00f3n (Producto Final)", line.getLine());
        }
        return this.aggregateIssues(issues);
    }

    private void checkASIComplete(Properties ctx, int productId, int attributeSetId, int asiId, List<String> issues, String trxName, String docLabel, int lineNo) throws Exception {
        String productName = this.getProductName(productId, trxName);
        if (asiId <= 0) {
            issues.add(EKModelValidLogisASI.msg(docLabel, lineNo, productName, "FALTA seleccionar Lote/Serie (ASI no ingresado)"));
            return;
        }
        AttributeSetFlags flags = this.getAttributeSetFlags(attributeSetId, trxName);
        if (flags.requiresLot && Util.isEmpty((String)this.getASIField(asiId, "Lot", trxName), (boolean)true)) {
            issues.add(EKModelValidLogisASI.msg(docLabel, lineNo, productName, "Falta Lote"));
        }
        if (flags.requiresSerNo && Util.isEmpty((String)this.getASIField(asiId, "SerNo", trxName), (boolean)true)) {
            issues.add(EKModelValidLogisASI.msg(docLabel, lineNo, productName, "Falta N\u00b0 de Serie"));
        }
        if (flags.requiresGuaranteeDate && this.getASIDate(asiId, "GuaranteeDate", trxName) == null) {
            issues.add(EKModelValidLogisASI.msg(docLabel, lineNo, productName, "Falta Fecha de Garant\u00eda"));
        }
        List<MandatoryAttr> mandatoryAttrs = this.getMandatoryAttributes(attributeSetId, trxName);
        for (MandatoryAttr ma : mandatoryAttrs) {
            if (this.hasAttrInstance(asiId, ma.attributeId, trxName)) continue;
            issues.add(EKModelValidLogisASI.msg(docLabel, lineNo, productName, "Falta atributo obligatorio: " + ma.name));
        }
    }

    private String aggregateIssues(List<String> issues) {
        if (issues.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("No es posible completar. Debe ingresar ASI completo en las l\u00edneas:\n");
        for (String i : issues) {
            sb.append(" - ").append(i).append("\n");
        }
        return sb.toString();
    }

    private static String msg(String doc, int line, String prod, String detail) {
        return doc + " | L\u00ednea " + line + " | Producto: " + prod + " \u2192 " + detail;
    }

    private int getProductAttributeSetId(int productId, String trxName) {
        String sql = "SELECT M_AttributeSet_ID FROM M_Product WHERE M_Product_ID=?";
        return DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{productId});
    }

    private String getProductName(int productId, String trxName) {
        String sql = "SELECT Name FROM M_Product WHERE M_Product_ID=?";
        String v = DB.getSQLValueStringEx((String)trxName, (String)sql, (Object[])new Object[]{productId});
        return v != null ? v : "M_Product_ID=" + productId;
    }

    private AttributeSetFlags getAttributeSetFlags(int attributeSetId, String trxName) {
        AttributeSetFlags f = new AttributeSetFlags();
        String sql = "SELECT COALESCE(IsLot,'N'), COALESCE(IsSerNo,'N'), COALESCE(IsGuaranteeDate,'N') FROM M_AttributeSet WHERE M_AttributeSet_ID=?";
        try (CPreparedStatement ps = DB.prepareStatement((String)sql, (String)trxName);){
            ps.setInt(1, attributeSetId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    f.requiresLot = "Y".equalsIgnoreCase(rs.getString(1));
                    f.requiresSerNo = "Y".equalsIgnoreCase(rs.getString(2));
                    f.requiresGuaranteeDate = "Y".equalsIgnoreCase(rs.getString(3));
                }
            }
        }
        catch (Exception e) {
            log.severe("Error leyendo M_AttributeSet: " + e.getMessage());
        }
        return f;
    }

    private String getASIField(int asiId, String column, String trxName) {
        String sql = "SELECT " + column + " FROM M_AttributeSetInstance WHERE M_AttributeSetInstance_ID=?";
        return DB.getSQLValueStringEx((String)trxName, (String)sql, (Object[])new Object[]{asiId});
    }

    private Timestamp getASIDate(int asiId, String column, String trxName) {
        String sql = "SELECT " + column + " FROM M_AttributeSetInstance WHERE M_AttributeSetInstance_ID=?";
        return DB.getSQLValueTSEx((String)trxName, (String)sql, (Object[])new Object[]{asiId});
    }

    private List<MandatoryAttr> getMandatoryAttributes(int attributeSetId, String trxName) {
        ArrayList<MandatoryAttr> list = new ArrayList<MandatoryAttr>();
        String sql = "SELECT au.M_Attribute_ID, a.Name FROM M_AttributeUse au JOIN M_Attribute a ON (a.M_Attribute_ID=au.M_Attribute_ID) WHERE au.M_AttributeSet_ID=? AND a.IsMandatory='Y' AND au.IsActive='Y'";
        try (CPreparedStatement ps = DB.prepareStatement((String)sql, (String)trxName);){
            ps.setInt(1, attributeSetId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    MandatoryAttr m = new MandatoryAttr();
                    m.attributeId = rs.getInt(1);
                    m.name = rs.getString(2);
                    list.add(m);
                }
            }
        }
        catch (Exception e) {
            log.severe("Error leyendo atributos obligatorios: " + e.getMessage());
        }
        return list;
    }

    private boolean hasAttrInstance(int asiId, int attributeId, String trxName) {
        String sql = "SELECT COUNT(*) FROM M_AttributeInstance WHERE M_AttributeSetInstance_ID=? AND M_Attribute_ID=?";
        BigDecimal cnt = DB.getSQLValueBDEx((String)trxName, (String)sql, (Object[])new Object[]{asiId, attributeId});
        return cnt != null && cnt.signum() > 0;
    }

    private boolean isFromWROrder(MInOut io) {
        String trx = io.get_TrxName();
        if (io.getC_Order_ID() > 0) {
            String sqlHdr = "SELECT CASE          WHEN o.IsSOTrx='Y'           AND dt.DocBaseType='SOO'           AND COALESCE(dt.DocSubTypeSO,'')='WR'          THEN 1 ELSE 0 END FROM C_Order o JOIN C_DocType dt ON dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID) WHERE o.C_Order_ID=?";
            return DB.getSQLValueEx((String)trx, (String)"SELECT CASE          WHEN o.IsSOTrx='Y'           AND dt.DocBaseType='SOO'           AND COALESCE(dt.DocSubTypeSO,'')='WR'          THEN 1 ELSE 0 END FROM C_Order o JOIN C_DocType dt ON dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID) WHERE o.C_Order_ID=?", (Object[])new Object[]{io.getC_Order_ID()}) == 1;
        }
        String sqlLines = "SELECT 1 FROM M_InOutLine iol JOIN C_OrderLine ol ON (ol.C_OrderLine_ID = iol.C_OrderLine_ID) JOIN C_Order o      ON (o.C_Order_ID = ol.C_Order_ID) JOIN C_DocType dt   ON (dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID)) WHERE iol.M_InOut_ID=?   AND o.IsSOTrx='Y'   AND dt.DocBaseType='SOO'   AND COALESCE(dt.DocSubTypeSO,'')='WR' LIMIT 1";
        return DB.getSQLValueEx((String)trx, (String)"SELECT 1 FROM M_InOutLine iol JOIN C_OrderLine ol ON (ol.C_OrderLine_ID = iol.C_OrderLine_ID) JOIN C_Order o      ON (o.C_Order_ID = ol.C_Order_ID) JOIN C_DocType dt   ON (dt.C_DocType_ID = COALESCE(o.C_DocTypeTarget_ID, o.C_DocType_ID)) WHERE iol.M_InOut_ID=?   AND o.IsSOTrx='Y'   AND dt.DocBaseType='SOO'   AND COALESCE(dt.DocSubTypeSO,'')='WR' LIMIT 1", (Object[])new Object[]{io.getM_InOut_ID()}) == 1;
    }

    private boolean isEndProductLine(MProductionLine line) {
        try {
            return line.isEndProduct();
        }
        catch (Throwable throwable) {
            try {
                int idx = line.get_ColumnIndex("IsEndProduct");
                if (idx >= 0) {
                    return line.get_ValueAsBoolean("IsEndProduct");
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return false;
        }
    }

    private int getSafe(Object bean, String field) {
        try {
            String getter = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
            Object val = bean.getClass().getMethod(getter, new Class[0]).invoke(bean, new Object[0]);
            if (val instanceof Integer) {
                return (Integer)val;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    private static class AttributeSetFlags {
        boolean requiresLot;
        boolean requiresSerNo;
        boolean requiresGuaranteeDate;

        private AttributeSetFlags() {
        }
    }

    private static class MandatoryAttr {
        int attributeId;
        String name;

        private MandatoryAttr() {
        }
    }
}

