/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelValidOrderline
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidOrderline.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        Object error = "";
        MOrderLine line = (MOrderLine)po;
        if ((type == 1 || type == 2) && po instanceof MOrderLine && this.isValidationEnabled("NVOrderLineValidator", po) && this.NVOrderLineValidator(line) != null) {
            error = (String)error + this.NVOrderLineValidator(line);
        }
        if ((type == 4 || type == 5) && this.isValidationEnabled("setOrderLineCommission", po)) {
            this.setOrderLineCommission(line, type);
        }
        return error == "" ? null : error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOrderLineCommission(MOrderLine ol, int type) {
        boolean recalc;
        boolean bl = recalc = type == 4 || ol.is_ValueChanged("M_Product_ID") || ol.is_ValueChanged("PriceActual") || ol.is_ValueChanged("QtyOrdered") || ol.is_ValueChanged("LineNetAmt");
        if (!recalc) {
            return;
        }
        String q = "SELECT comision_pct, comision_monto_total FROM adempiere.ajc_commission_from_orderline(?)";
        CPreparedStatement ps = null;
        ResultSet rs = null;
        BigDecimal pct = Env.ZERO;
        BigDecimal amt = Env.ZERO;
        try {
            ps = DB.prepareStatement((String)"SELECT comision_pct, comision_monto_total FROM adempiere.ajc_commission_from_orderline(?)", (String)ol.get_TrxName());
            ps.setInt(1, ol.getC_OrderLine_ID());
            rs = ps.executeQuery();
            if (rs.next()) {
                if (rs.getBigDecimal(1) != null) {
                    pct = rs.getBigDecimal(1);
                }
                if (rs.getBigDecimal(2) != null) {
                    amt = rs.getBigDecimal(2);
                }
            }
            DB.close((ResultSet)rs, (Statement)ps);
        }
        catch (Exception e) {
            log.warning("Order commission query failed: " + e.getMessage());
        }
        finally {
            DB.close(rs, (Statement)ps);
        }
        DB.executeUpdateEx((String)"UPDATE C_OrderLine SET aj_percentagefrom=?, comision=? WHERE C_OrderLine_ID=?", (Object[])new Object[]{pct, amt, ol.getC_OrderLine_ID()}, (String)ol.get_TrxName());
        ol.set_ValueOfColumn("aj_percentagefrom", pct);
        ol.set_ValueOfColumn("comision", amt);
    }

    public String NVOrderLineValidator(MOrderLine line) {
        MProduct prod;
        if (!line.getParent().isSOTrx()) {
            return null;
        }
        if (line.getM_Product_ID() > 0 && (prod = (MProduct)line.getM_Product()).isInstanceAttribute() && line.getM_AttributeSetInstance_ID() <= 0) {
            return "El producto '" + prod.getName() + "' requiere un conjunto de atributos. Asigne uno antes de guardar.";
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        MOrder order = (MOrder)po;
        if (timing == 7 && this.isValidationEnabled("OrderLinechargeValidator", po) && this.OrderLinechargeValidator(order) != null) {
            error = (String)error + this.OrderLinechargeValidator(order);
        }
        return error == "" ? null : error;
    }

    public String OrderLinechargeValidator(MOrder order) {
        for (MOrderLine line : order.getLines()) {
            if (line.getC_Charge_ID() <= 0) continue;
            BigDecimal qtyOrdered = line.getQtyOrdered();
            line.setQtyDelivered(qtyOrdered);
            line.setQtyReserved(BigDecimal.ZERO);
            line.saveEx();
        }
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

