/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.util.ProcessUtil;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MProcess;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelValidPayment
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidPayment.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addModelChange("C_PaymentAllocate", (ModelValidator)this);
        engine.addModelChange("AJF_PaymentAllocation", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        Object error = "";
        if (po instanceof MPaymentAllocate && (type == 5 || type == 4 || type == 6)) {
            MPaymentAllocate pAll = (MPaymentAllocate)po;
            MPayment pay = new MPayment(pAll.getCtx(), pAll.getC_Payment_ID(), pAll.get_TrxName());
            if (this.isValidationEnabled("fillPaymentsFieldsInvAll", po) && this.fillPaymentsFieldsInvAll(pay) != null) {
                error = (String)error + this.fillPaymentsFieldsInvAll(pay);
            }
        }
        if (po.get_TableName().equals("AJF_PaymentAllocation") && (type == 5 || type == 4 || type == 6)) {
            MPayment pay = new MPayment(po.getCtx(), (Integer)po.get_Value("C_Payment_ID"), po.get_TrxName());
            if (this.isValidationEnabled("fillPaymentsFieldsPayAll", po) && this.fillPaymentsFieldsPayAll(pay, po) != null) {
                error = (String)error + String.valueOf(this.fillPaymentsFieldsPayAll(pay, po));
            }
        }
        return error == "" ? null : error;
    }

    private String fillPaymentsFieldsInvAll(MPayment pay) {
        try {
            String sql = "";
            sql = "SELECT COALESCE(SUM(Amount),0) FROM C_PaymentAllocate WHERE C_Payment_ID=?";
            BigDecimal payAmt = DB.getSQLValueBD((String)pay.get_TrxName(), (String)sql, (int)pay.getC_Payment_ID());
            sql = "SELECT COALESCE(SUM(DiscountAmt),0) FROM C_PaymentAllocate WHERE C_Payment_ID=?";
            BigDecimal discountAmt = DB.getSQLValueBD((String)pay.get_TrxName(), (String)sql, (int)pay.getC_Payment_ID());
            sql = "SELECT COALESCE(SUM(OverUnderAmt),0) FROM C_PaymentAllocate WHERE C_Payment_ID=?";
            BigDecimal overUnderAmt = DB.getSQLValueBD((String)pay.get_TrxName(), (String)sql, (int)pay.getC_Payment_ID());
            pay.setPayAmt(payAmt);
            pay.setDiscountAmt(discountAmt);
            pay.setOverUnderAmt(overUnderAmt);
            pay.saveEx();
        }
        catch (Exception e) {
            return "Error al asociar pago:" + String.valueOf(e);
        }
        return null;
    }

    private Object fillPaymentsFieldsPayAll(MPayment pay, PO po) {
        MPayment pRef = null;
        if (po.get_ValueAsInt("Ref_Payment_ID") >= 0 && ((BigDecimal)(pRef = new MPayment(po.getCtx(), po.get_ValueAsInt("Ref_Payment_ID"), po.get_TrxName())).get_Value("OpenAmt")).compareTo((BigDecimal)po.get_Value("Amt")) < 0) {
            return "El monto no puede ser mayor al saldo abierto del pago.(Monto abierto:" + String.valueOf(pRef.get_Value("OpenAmt")) + ")";
        }
        try {
            String sql = "";
            sql = "SELECT COALESCE(SUM(Amt),0) FROM AJF_PaymentAllocation WHERE C_Payment_ID=?";
            BigDecimal payAmt = DB.getSQLValueBD((String)pay.get_TrxName(), (String)sql, (int)pay.getC_Payment_ID());
            pay.setPayAmt(payAmt);
            if (pay.save()) {
                pRef.setRef_Payment_ID(pay.getC_Payment_ID());
            }
        }
        catch (Exception e) {
            return "Error al asociar pago:" + String.valueOf(e);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        if (po instanceof MPayment) {
            MPayment pay = (MPayment)po;
            MDocType dt = new MDocType(po.getCtx(), pay.getC_DocType_ID(), po.get_TrxName());
            if (timing == 10) {
                if (this.isValidationEnabled("updateInvoicePayCheck", po) && this.updateInvoicePayCheck(pay) != null) {
                    error = (String)error + this.updateInvoicePayCheck(pay);
                }
                if (this.isValidationEnabled("deleteAllocations", po) && this.deleteAllocations(pay) != null) {
                    error = (String)error + this.deleteAllocations(pay);
                }
                if (this.isValidationEnabled("updatePaymentOpenAmt", po) && this.updatePaymentOpenAmt(pay, timing) != null) {
                    error = (String)error + String.valueOf(this.updatePaymentOpenAmt(pay, timing));
                }
            }
            if (timing == 9 && this.isValidationEnabled("updatePaymentOpenAmt", po) && this.updatePaymentOpenAmt(pay, timing) != null) {
                error = (String)error + String.valueOf(this.updatePaymentOpenAmt(pay, timing));
            }
            if (timing == 7 && this.isValidationEnabled("sendBoletaGDExpress", po) && this.sendBoletaGDExpress(pay) != null) {
                error = (String)error + this.sendBoletaGDExpress(pay);
            }
        }
        return error == "" ? null : error;
    }

    private String sendBoletaGDExpress(MPayment pay) {
        int invoiceId = pay.getC_Invoice_ID();
        if (invoiceId <= 0) {
            return null;
        }
        if (!pay.getC_Invoice().isSOTrx()) {
            return null;
        }
        MDocType dt = MDocType.get((Properties)pay.getCtx(), (int)pay.getC_Invoice().getC_DocTypeTarget_ID());
        String sii = DB.getSQLValueString((String)pay.get_TrxName(), (String)"SELECT EK_SIICode FROM C_DocType WHERE C_DocType_ID=?", (int)dt.getC_DocType_ID());
        if (sii == null || sii.isEmpty()) {
            pay.addDescription("|ERROR: " + dt.getName() + " N\u00b0" + pay.getC_Invoice().getDocumentNo() + " sin codigo tributario de documento");
            return null;
        }
        if (!"39".equals(sii)) {
            return null;
        }
        if (!"CO".equals(pay.getC_Invoice().getDocStatus())) {
            pay.addDescription("|ERROR: " + dt.getName() + " N\u00b0" + pay.getC_Invoice().getDocumentNo() + " no est\u00e1 completo.");
            return null;
        }
        MProcess proc = MProcess.get((Properties)pay.getCtx(), (int)2000039);
        if (proc == null) {
            pay.addDescription("|ERROR: Proceso 2000039 no existe.");
            return null;
        }
        String cls = proc.getClassname();
        if (cls == null || cls.trim().isEmpty()) {
            pay.addDescription("|ERROR: Proceso sin ClassName.");
            return null;
        }
        ProcessInfo pi = new ProcessInfo(proc.getName(), proc.getAD_Process_ID());
        pi.setClassName(cls);
        pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)pay.getCtx()));
        pi.setAD_User_ID(Env.getAD_User_ID((Properties)pay.getCtx()));
        pi.setTable_ID(MInvoice.Table_ID);
        pi.setRecord_ID(invoiceId);
        pi.setManagedTransaction(false);
        try {
            boolean ok = ProcessUtil.startJavaProcess((Properties)pay.getCtx(), (ProcessInfo)pi, null, (boolean)false);
            if (ok) {
                pay.addDescription("|" + pi.getSummary());
            } else {
                pay.addDescription("|ERROR: " + pi.getSummary());
            }
        }
        catch (Exception e) {
            pay.addDescription("|ERROR: " + pi.getSummary());
            return null;
        }
        return null;
    }

    private String updateInvoicePayCheck(MPayment payment) {
        if (payment == null) {
            return "El pago no puede ser nulo.";
        }
        String sql = "SELECT DISTINCT al.C_Invoice_ID FROM C_AllocationLine al INNER JOIN C_AllocationHdr ah ON al.C_AllocationHdr_ID = ah.C_AllocationHdr_ID WHERE al.C_Payment_ID = ?";
        ArrayList<Integer> invoiceIds = new ArrayList<Integer>();
        try (CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)payment.get_TrxName());){
            pstmt.setInt(1, payment.getC_Payment_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int invoiceId = rs.getInt("C_Invoice_ID");
                if (invoiceId <= 0) continue;
                invoiceIds.add(invoiceId);
            }
        }
        catch (Exception e) {
            return "Error al obtener las facturas asociadas al pago ==>" + String.valueOf(e);
        }
        for (Integer invoiceId : invoiceIds) {
            DB.executeUpdate((String)"UPDATE C_Invoice SET IsPaid='N' where C_Invoice_ID=?", (int)invoiceId, (String)payment.get_TrxName());
        }
        return null;
    }

    private String deleteAllocations(MPayment pay) {
        String sql = "SELECT MAX(al.C_AllocationHdr_ID) FROM C_AllocationLine al WHERE al.C_Payment_ID = ?";
        int allocationHdr = DB.getSQLValue((String)pay.get_TrxName(), (String)sql, (int)pay.getC_Payment_ID());
        try {
            DB.executeUpdate((String)"DELETE FROM C_AllocationLine WHERE C_AllocationHDR_ID=?;", (int)allocationHdr, (String)pay.get_TrxName());
            DB.executeUpdate((String)"DELETE FROM C_AllocationHDR WHERE C_AllocationHDR_ID=?;", (int)allocationHdr, (String)pay.get_TrxName());
        }
        catch (Exception e) {
            return "Error al eliminar asignacion ==>" + String.valueOf(e);
        }
        return null;
    }

    private Object updatePaymentOpenAmt(MPayment pay, int timing) {
        String sql = "SELECT Ref_Payment_ID,Amt FROM AJF_PaymentAllocation WHERE C_Payment_ID = ?";
        CPreparedStatement ps = DB.prepareStatement((String)sql, (String)pay.get_TrxName());
        try {
            ps.setInt(1, pay.getC_Payment_ID());
            ResultSet rs = ps.executeQuery();
            BigDecimal openAmt = null;
            while (rs.next()) {
                MPayment rPay = new MPayment(pay.getCtx(), rs.getInt("Ref_Payment_ID"), pay.get_TrxName());
                openAmt = (BigDecimal)rPay.get_Value("OpenAmt");
                if (timing == 9) {
                    openAmt = openAmt.subtract(rs.getBigDecimal("Amt"));
                } else if (timing == 10) {
                    openAmt = openAmt.add(rs.getBigDecimal("Amt"));
                }
                rPay.set_CustomColumn("OpenAmt", openAmt);
                rPay.saveEx();
            }
        }
        catch (SQLException e) {
            return "Error al tratar de actualizar el OpenAmt:" + e.getMessage();
        }
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

