/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelValidInvoiceNC
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelValidInvoiceNC.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        Object error = "";
        if (!(po instanceof MInvoiceLine)) {
            return null;
        }
        MInvoiceLine il = (MInvoiceLine)po;
        MInvoice inv = new MInvoice(il.getCtx(), il.getC_Invoice_ID(), il.get_TrxName());
        if (type == 2) {
            if (this.isValidationEnabled("ValidLineProduct", po) && this.ValidLineProduct(il, inv) != null) {
                error = (String)error + this.ValidLineProduct(il, inv);
            }
            if (this.isValidationEnabled("ValidLineQty", po) && this.ValidLineQty(il, inv) != null) {
                error = (String)error + this.ValidLineQty(il, inv);
            }
            if (this.isValidationEnabled("ValidLinePrice", po) && this.ValidLinePrice(il, inv) != null) {
                error = (String)error + this.ValidLinePrice(il, inv);
            }
        }
        return error == "" ? null : error;
    }

    public String ValidLineProduct(MInvoiceLine il, MInvoice inv) {
        int CodRef = inv.get_ValueAsInt("AJ_CodRef");
        if (CodRef == 2) {
            return null;
        }
        if (!this.isSalesCreditMemo(inv)) {
            return null;
        }
        int srcInvoiceId = this.getSourceInvoiceId(inv);
        if (srcInvoiceId <= 0) {
            return null;
        }
        int productId = il.getM_Product_ID();
        if (productId <= 0) {
            return "La l\u00ednea no tiene producto.";
        }
        if (!this.existsProductInInvoice(srcInvoiceId, productId, il.get_TrxName())) {
            return "El producto de la l\u00ednea no existe en la factura de referencia.";
        }
        return null;
    }

    public String ValidLineQty(MInvoiceLine il, MInvoice inv) {
        BigDecimal cnQty;
        int CodRef = inv.get_ValueAsInt("AJ_CodRef");
        if (CodRef == 2) {
            return null;
        }
        if (!this.isSalesCreditMemo(inv)) {
            return null;
        }
        int srcInvoiceId = this.getSourceInvoiceId(inv);
        if (srcInvoiceId <= 0) {
            return null;
        }
        int productId = il.getM_Product_ID();
        BigDecimal srcTotalQty = this.getTotalQtyForProduct(srcInvoiceId, productId, il.get_TrxName());
        BigDecimal bigDecimal = cnQty = il.getQtyEntered() != null ? il.getQtyEntered().abs() : Env.ZERO;
        if (cnQty.compareTo(srcTotalQty) > 0) {
            return "La cantidad de la l\u00ednea de la NC (" + String.valueOf(cnQty) + ") supera la cantidad de la factura (" + String.valueOf(srcTotalQty) + ").";
        }
        return null;
    }

    public String ValidLinePrice(MInvoiceLine il, MInvoice inv) {
        BigDecimal cnPrice;
        int CodRef = inv.get_ValueAsInt("AJ_CodRef");
        if (CodRef == 2) {
            return null;
        }
        if (!this.isSalesCreditMemo(inv)) {
            return null;
        }
        int srcInvoiceId = this.getSourceInvoiceId(inv);
        if (srcInvoiceId <= 0) {
            return null;
        }
        int productId = il.getM_Product_ID();
        BigDecimal srcMaxPrice = this.getMaxPriceForProduct(srcInvoiceId, productId, il.get_TrxName());
        BigDecimal bigDecimal = cnPrice = il.getPriceActual() != null ? il.getPriceActual() : Env.ZERO;
        if (cnPrice.compareTo(srcMaxPrice) > 0) {
            return "El precio de una l\u00ednea de la NC (" + String.valueOf(cnPrice) + ") supera el precio de la factura (" + String.valueOf(srcMaxPrice) + ").";
        }
        return null;
    }

    private boolean isSalesCreditMemo(MInvoice inv) {
        int dtId;
        int n = dtId = inv.getC_DocTypeTarget_ID() > 0 ? inv.getC_DocTypeTarget_ID() : inv.getC_DocType_ID();
        if (dtId <= 0) {
            return false;
        }
        MDocType dt = MDocType.get((Properties)inv.getCtx(), (int)dtId);
        return inv.isSOTrx() && dt != null && "ARC".equals(dt.getDocBaseType());
    }

    private int getSourceInvoiceId(MInvoice inv) {
        int ref = 0;
        try {
            int aj = inv.get_ValueAsInt("AJ_RefDoc_ID");
            if (aj > 0) {
                return aj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ref > 0) {
            return ref;
        }
        return 0;
    }

    private boolean existsProductInInvoice(int invoiceId, int productId, String trx) {
        int cnt = DB.getSQLValue((String)trx, (String)"SELECT COUNT(*) FROM C_InvoiceLine WHERE C_Invoice_ID=? AND M_Product_ID=?", (int)invoiceId, (int)productId);
        return cnt > 0;
    }

    private BigDecimal getMaxPriceForProduct(int invoiceId, int productId, String trx) {
        BigDecimal v = DB.getSQLValueBD((String)trx, (String)"SELECT COALESCE(MAX(PriceActual),0) FROM C_InvoiceLine WHERE C_Invoice_ID=? AND M_Product_ID=?", (Object[])new Object[]{invoiceId, productId});
        return v != null ? v : Env.ZERO;
    }

    private BigDecimal getTotalQtyForProduct(int invoiceId, int productId, String trx) {
        BigDecimal v = DB.getSQLValueBD((String)trx, (String)"SELECT COALESCE(SUM(QtyEntered),0) FROM C_InvoiceLine WHERE C_Invoice_ID=? AND M_Product_ID=?", (Object[])new Object[]{invoiceId, productId});
        return v != null ? v.abs() : Env.ZERO;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        if (!(po instanceof MInvoice)) {
            return null;
        }
        MInvoice inv = (MInvoice)po;
        MDocType dt = new MDocType(po.getCtx(), inv.getC_DocType_ID(), po.get_TrxName());
        if (timing == 7 && this.isSalesCreditMemo(inv)) {
            MInvoiceLine[] lines;
            for (MInvoiceLine il : lines = inv.getLines(false)) {
                if (this.isValidationEnabled("ValidLineProduct", po) && this.ValidLineProduct(il, inv) != null) {
                    error = (String)error + this.ValidLineProduct(il, inv);
                }
                if (this.isValidationEnabled("ValidLineQty", po) && this.ValidLineQty(il, inv) != null) {
                    error = (String)error + this.ValidLineQty(il, inv);
                }
                if (!this.isValidationEnabled("ValidLinePrice", po) || this.ValidLinePrice(il, inv) == null) continue;
                error = (String)error + this.ValidLinePrice(il, inv);
            }
        }
        if (timing == 9 && this.isValidationEnabled("InvoiceReturn", po) && this.InvoiceReturn(inv, dt) != null) {
            error = (String)error + this.InvoiceReturn(inv, dt);
        }
        return error == "" ? null : error;
    }

    public String InvoiceReturn(MInvoice inv, MDocType dt) {
        try {
            MDocType dtReal = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID() > 0 ? inv.getC_DocTypeTarget_ID() : inv.getC_DocType_ID(), inv.get_TrxName());
            if (!inv.isSOTrx() || !"ARC".equals(dtReal.getDocBaseType())) {
                return null;
            }
            String targetName = "Nota De Cr\u00e9dito Devoluci\u00f3n";
            int retNcDocTypeId = this.findDocTypeByName("Nota De Cr\u00e9dito Devoluci\u00f3n", inv.getAD_Org_ID(), inv.getCtx(), inv.get_TrxName(), inv.getAD_Client_ID());
            if (retNcDocTypeId <= 0) {
                throw new AdempiereException("No existe el Tipo de Documento 'Nota De Cr\u00e9dito Devoluci\u00f3n'");
            }
            if (dtReal.getC_DocType_ID() != retNcDocTypeId) {
                return null;
            }
            String refMark = "NC-RET:" + inv.getDocumentNo();
            int exists = DB.getSQLValue((String)inv.get_TrxName(), (String)"SELECT COUNT(*) FROM M_InOut WHERE AD_Client_ID=? AND Description LIKE ?", (int)inv.getAD_Client_ID(), (String)("%" + refMark + "%"));
            if (exists > 0) {
                return null;
            }
            int M_Warehouse_ID = this.getWarehouseIdFromRelatedOrder(inv);
            if (M_Warehouse_ID <= 0) {
                M_Warehouse_ID = DB.getSQLValue((String)inv.get_TrxName(), (String)"SELECT M_Warehouse_ID FROM M_Warehouse WHERE AD_Org_ID=? AND IsActive='Y' ORDER BY IsDefault DESC", (int)inv.getAD_Org_ID());
            }
            if (M_Warehouse_ID <= 0) {
                throw new AdempiereException("No se pudo determinar el Almac\u00e9n para la devoluci\u00f3n.");
            }
            MInOut io = new MInOut(inv, 0, null, M_Warehouse_ID);
            io.set_TrxName(inv.get_TrxName());
            io.setIsSOTrx(true);
            io.setMovementType("C+");
            Timestamp when = inv.getDateAcct() != null ? inv.getDateAcct() : new Timestamp(System.currentTimeMillis());
            io.setMovementDate(when);
            io.setDateAcct(when);
            int inoutDT = this.findCustomerReturnDocType(inv.getCtx(), inv.getAD_Client_ID(), inv.getAD_Org_ID(), inv.get_TrxName());
            if (inoutDT <= 0) {
                throw new AdempiereException("No se pudo encontrar el Tipo de Documento 'Devoluci\u00f3n de materiales'.");
            }
            io.setC_DocType_ID(inoutDT);
            String baseDesc = io.getDescription() == null ? "" : io.getDescription() + " ";
            io.setDescription(baseDesc + "Devoluci\u00f3n por Nota de Cr\u00e9dito " + inv.getDocumentNo() + " " + refMark);
            io.saveEx();
            for (MInvoiceLine il : inv.getLines(false)) {
                int locatorId;
                BigDecimal qty;
                if (il.getM_Product_ID() == 0 || (qty = il.getQtyEntered()) == null || qty.signum() == 0) continue;
                BigDecimal qtyToReceive = qty.abs();
                MInOutLine iol = new MInOutLine(io);
                iol.setAD_Org_ID(io.getAD_Org_ID());
                iol.setM_Product_ID(il.getM_Product_ID());
                iol.setC_UOM_ID(il.getC_UOM_ID());
                if (il.getM_AttributeSetInstance_ID() > 0) {
                    iol.setM_AttributeSetInstance_ID(il.getM_AttributeSetInstance_ID());
                }
                if ((locatorId = this.getLocatorForHeaderWarehouse(il, M_Warehouse_ID, inv.get_TrxName())) <= 0) {
                    throw new AdempiereException("No se encontr\u00f3 un Locator para la devoluci\u00f3n en la bodega seleccionada.");
                }
                iol.setM_Locator_ID(locatorId);
                iol.setQty(qtyToReceive);
                iol.setMovementQty(qtyToReceive);
                if (il.getC_OrderLine_ID() > 0) {
                    iol.setC_OrderLine_ID(il.getC_OrderLine_ID());
                }
                if (il.getM_InOutLine_ID() > 0) {
                    iol.setRef_InOutLine_ID(il.getM_InOutLine_ID());
                }
                iol.saveEx();
                il.setM_InOutLine_ID(iol.getM_InOutLine_ID());
                il.saveEx();
            }
            if (!io.processIt("CO")) {
                throw new AdempiereException("No se pudo completar el Ingreso por Devoluci\u00f3n: " + io.getProcessMsg());
            }
            io.saveEx();
            this.recalcOrderQtyInvoicedFromInvoices(inv);
            return null;
        }
        catch (Exception e) {
            log.severe("Error creando devoluci\u00f3n por NC: " + e.getMessage());
            return e.getMessage();
        }
    }

    private int findDocTypeByName(String name, int adOrgId, Properties ctx, String trxName, int adClientId) {
        String normalized = name.toUpperCase().replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00dc", "U");
        String where = "AD_Client_ID=? AND IsActive='Y' AND translate(upper(Name), '\u00c1\u00c9\u00cd\u00d3\u00da\u00dc', 'AEIOUU') LIKE ? AND (AD_Org_ID=? OR AD_Org_ID=0)";
        String likeParam = normalized + "%";
        Integer id = new Query(ctx, "C_DocType", where, trxName).setParameters(new Object[]{adClientId, likeParam, adOrgId}).setOrderBy("AD_Org_ID DESC").firstId();
        return id == null ? 0 : id;
    }

    private int findCustomerReturnDocType(Properties ctx, int adClientId, int adOrgId, String trxName) {
        Integer id = DB.getSQLValueEx((String)trxName, (String)"SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND IsActive='Y' AND DocBaseType='MMR' AND Name ILIKE '%devolucion%' AND (AD_Org_ID=? OR AD_Org_ID=0) ORDER BY AD_Org_ID DESC, IsDefault DESC", (Object[])new Object[]{adClientId, adOrgId});
        if (id != null && id > 0) {
            return id;
        }
        return id != null ? id : 0;
    }

    private int getWarehouseIdFromRelatedOrder(MInvoice inv) {
        MOrder o;
        if (inv.getC_Order_ID() > 0 && (o = (MOrder)inv.getC_Order()) != null && o.getM_Warehouse_ID() > 0) {
            return o.getM_Warehouse_ID();
        }
        for (MInvoiceLine il : inv.getLines()) {
            MOrderLine ol;
            if (il.getC_OrderLine_ID() <= 0 || (ol = (MOrderLine)il.getC_OrderLine()) == null || ol.getM_Warehouse_ID() <= 0) continue;
            return ol.getM_Warehouse_ID();
        }
        return DB.getSQLValue(null, (String)"SELECT COALESCE(MAX(M_Warehouse_ID),0) FROM M_Warehouse WHERE AD_Org_ID=?", (int)inv.getAD_Org_ID());
    }

    private int getLocatorForHeaderWarehouse(MInvoiceLine il, int headerWarehouseId, String trxName) {
        int loc;
        Integer whOL;
        int loc2;
        if (il.getM_InOutLine_ID() > 0 && this.isLocatorInWarehouse(loc2 = DB.getSQLValue((String)trxName, (String)"SELECT M_Locator_ID FROM M_InOutLine WHERE M_InOutLine_ID=?", (int)il.getM_InOutLine_ID()), headerWarehouseId, trxName)) {
            return loc2;
        }
        if (il.getC_OrderLine_ID() > 0 && (whOL = this.getWarehouseFromOrderLine(il.getC_OrderLine_ID(), trxName)) != null && whOL > 0 && (loc = this.getDefaultLocator(headerWarehouseId, trxName)) > 0) {
            return loc;
        }
        int defLoc = this.getDefaultLocator(headerWarehouseId, trxName);
        return defLoc;
    }

    private boolean isLocatorInWarehouse(int locatorId, int warehouseId, String trxName) {
        if (locatorId <= 0) {
            return false;
        }
        Integer wh = DB.getSQLValueEx((String)trxName, (String)"SELECT M_Warehouse_ID FROM M_Locator WHERE M_Locator_ID=?", (Object[])new Object[]{locatorId});
        return wh != null && wh == warehouseId;
    }

    private int getDefaultLocator(int warehouseId, String trxName) {
        int loc = DB.getSQLValue((String)trxName, (String)"SELECT M_Locator_ID FROM M_Locator WHERE M_Warehouse_ID=? AND IsDefault='Y' ORDER BY M_Locator_ID", (int)warehouseId);
        if (loc > 0) {
            return loc;
        }
        loc = DB.getSQLValue((String)trxName, (String)"SELECT M_Locator_ID FROM M_Locator WHERE M_Warehouse_ID=? ORDER BY M_Locator_ID", (int)warehouseId);
        return loc > 0 ? loc : 0;
    }

    private Integer getWarehouseFromOrderLine(int orderLineId, String trxName) {
        if (orderLineId <= 0) {
            return null;
        }
        return DB.getSQLValueEx((String)trxName, (String)"SELECT M_Warehouse_ID FROM C_OrderLine WHERE C_OrderLine_ID=?", (Object[])new Object[]{orderLineId});
    }

    private void recalcOrderQtyInvoicedFromInvoices(MInvoice inv) {
        String trxName = inv.get_TrxName();
        for (MInvoiceLine il : inv.getLines(false)) {
            int orderLineId = il.getC_OrderLine_ID();
            if (orderLineId <= 0) continue;
            BigDecimal totalInvoiced = DB.getSQLValueBD((String)trxName, (String)"SELECT COALESCE(SUM(       CASE WHEN dt.DocBaseType = 'ARC'             THEN -ABS(il.QtyInvoiced)             ELSE  ABS(il.QtyInvoiced)        END   ), 0) FROM C_InvoiceLine il JOIN C_Invoice i ON (il.C_Invoice_ID = i.C_Invoice_ID) JOIN C_DocType dt ON (i.C_DocType_ID = dt.C_DocType_ID) WHERE il.C_OrderLine_ID = ? AND i.DocStatus NOT IN ('VO','RE') AND dt.DocBaseType IN ('ARI','ARC')", (int)orderLineId);
            if (totalInvoiced == null) {
                totalInvoiced = Env.ZERO;
            }
            MOrderLine oLine = new MOrderLine(inv.getCtx(), orderLineId, trxName);
            oLine.setQtyInvoiced(totalInvoiced);
            oLine.saveEx();
        }
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

