/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ValidateVAR00Commission
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ValidateVAR00Commission.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.log(Level.INFO, "ValidateVAR00Commission inicializado para cliente: " + this.m_AD_Client_ID);
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        if (!(po instanceof MOrderLine)) {
            return null;
        }
        if (type != 1 && type != 2) {
            return null;
        }
        MOrderLine line = (MOrderLine)po;
        if (line.getM_Product_ID() <= 0) {
            return null;
        }
        MOrder order = new MOrder(line.getCtx(), line.getC_Order_ID(), line.get_TrxName());
        if (!order.isSOTrx()) {
            return null;
        }
        MProduct product = MProduct.get(line.getCtx(), line.getM_Product_ID());
        if (product == null) {
            return null;
        }
        String value = product.getValue();
        log.info("Producto en l\u00ednea: " + value);
        if (!"VAR00".equalsIgnoreCase(value)) {
            return null;
        }
        BigDecimal porcentaje = (BigDecimal)line.get_Value("AJ_PercentageFrom");
        log.info("AJ_PercentageFrom = " + String.valueOf(porcentaje));
        if (porcentaje == null || porcentaje.compareTo(BigDecimal.ZERO) == 0) {
            return "No se puede guardar la l\u00ednea.\nEl producto requiere un % de comisi\u00f3n mayor a 0.";
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

