/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model.utils.fintoc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.ajah.model.utils.fintoc.FintocAccount;
import org.ajah.model.utils.fintoc.FintocBalance;
import org.ajah.model.utils.fintoc.FintocHolderAccount;
import org.ajah.model.utils.fintoc.FintocInstitution;
import org.ajah.model.utils.fintoc.FintocLink;
import org.ajah.model.utils.fintoc.FintocMovement;

public class FintocModel {
    private static final Logger log = Logger.getLogger(FintocModel.class.getName());
    private final String token;
    private final String apiKey;
    private final HttpClient httpClient;
    private int itemPerPage;

    public FintocModel(String token, String apiKey) {
        this.token = token;
        this.apiKey = apiKey;
        this.httpClient = HttpClient.newHttpClient();
        this.itemPerPage = 30;
    }

    public List<FintocLink> getLinks() {
        JsonArray links = this.fetchJsonArray("https://api.fintoc.com/v1/links/" + this.token);
        if (links == null) {
            log.warning("No se encontraron enlaces para el token proporcionado.");
            return List.of();
        }
        ArrayList<FintocLink> linkList = new ArrayList<FintocLink>();
        for (JsonElement link : links) {
            if (link != null && link.isJsonObject()) {
                linkList.add(this.parseFintocLink(link.getAsJsonObject()));
                continue;
            }
            log.warning("Elemento de enlace inv\u00e1lido o nulo: " + String.valueOf(link));
        }
        return linkList;
    }

    public List<FintocAccount> getAccounts() {
        JsonArray accounts = this.fetchJsonArray("https://api.fintoc.com/v1/accounts/?link_token=" + this.token);
        if (accounts == null) {
            log.warning("No se encontraron cuentas para el token proporcionado.");
            return List.of();
        }
        ArrayList<FintocAccount> accountList = new ArrayList<FintocAccount>();
        for (JsonElement account : accounts) {
            if (account != null && account.isJsonObject()) {
                accountList.add(this.parseFintocAccount(account.getAsJsonObject()));
                continue;
            }
            log.warning("Elemento de cuenta inv\u00e1lido o nulo: " + String.valueOf(account));
        }
        return accountList;
    }

    public List<FintocMovement> getMovements(String accountId) {
        JsonArray movements = this.fetchJsonArray("https://api.fintoc.com/v1/accounts/" + accountId + "/movements?link_token=" + this.token + "&per_page=" + this.itemPerPage);
        if (movements == null) {
            log.warning("No se encontraron movimientos para la cuenta ID: " + accountId);
            return List.of();
        }
        ArrayList<FintocMovement> movementList = new ArrayList<FintocMovement>();
        for (JsonElement movement : movements) {
            if (movement != null && movement.isJsonObject()) {
                movementList.add(this.parseFintocMovement(movement.getAsJsonObject()));
                continue;
            }
            log.warning("Elemento de movimiento inv\u00e1lido o nulo: " + String.valueOf(movement));
        }
        return movementList;
    }

    private JsonArray fetchJsonArray(String url) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("accept", "application/json").header("Authorization", this.apiKey).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return this.parseJsonArray(response.body());
        }
        catch (Exception e) {
            log.severe("Error al obtener datos de la API: " + e.getMessage());
            return null;
        }
    }

    private JsonArray parseJsonArray(String jsonString) {
        try {
            JsonStreamParser parser = new JsonStreamParser(jsonString);
            if (parser.hasNext()) {
                JsonElement element = parser.next();
                if (element.isJsonArray()) {
                    return element.getAsJsonArray();
                }
                if (element.isJsonObject()) {
                    JsonArray jsonArray = new JsonArray();
                    jsonArray.add((JsonElement)element.getAsJsonObject());
                    return jsonArray;
                }
            }
        }
        catch (Exception e) {
            log.severe("Error al parsear JSON a JsonArray: " + e.getMessage());
        }
        return null;
    }

    private FintocLink parseFintocLink(JsonObject linkObj) {
        FintocLink link = new FintocLink();
        link.setId(this.getOptionalString(linkObj, "id"));
        link.setObject(this.getOptionalString(linkObj, "object"));
        link.setUsername(this.getOptionalString(linkObj, "username"));
        link.setHolderId(this.getOptionalString(linkObj, "holder_id"));
        link.setLinkToken(this.getOptionalString(linkObj, "link_token"));
        link.setMode(this.getOptionalString(linkObj, "mode"));
        link.setActive(linkObj.has("active") && linkObj.get("active").getAsBoolean());
        link.setStatus(this.getOptionalString(linkObj, "status"));
        link.setHolderType(this.getOptionalString(linkObj, "holder_type"));
        link.setCreatedAt(this.getOptionalDate(linkObj, "created_at"));
        if (linkObj.has("institution")) {
            link.setInstitution(this.parseFintocInstitution(linkObj.getAsJsonObject("institution")));
        }
        if (linkObj.has("accounts") && linkObj.get("accounts").isJsonArray()) {
            JsonArray accountsArray = linkObj.getAsJsonArray("accounts");
            ArrayList<FintocAccount> accounts = new ArrayList<FintocAccount>();
            for (JsonElement account : accountsArray) {
                if (!account.isJsonObject()) continue;
                accounts.add(this.parseFintocAccount(account.getAsJsonObject()));
            }
            link.setAccounts(accounts);
        }
        return link;
    }

    private FintocAccount parseFintocAccount(JsonObject accountObj) {
        FintocAccount account = new FintocAccount();
        account.setId(this.getOptionalString(accountObj, "id"));
        account.setObject(this.getOptionalString(accountObj, "object"));
        account.setName(this.getOptionalString(accountObj, "name"));
        account.setOfficialName(this.getOptionalString(accountObj, "official_name"));
        account.setNumber(this.getOptionalString(accountObj, "number"));
        account.setHolderId(this.getOptionalString(accountObj, "holder_id"));
        account.setHolderName(this.getOptionalString(accountObj, "holder_name"));
        account.setType(this.getOptionalString(accountObj, "type"));
        account.setCurrency(this.getOptionalString(accountObj, "currency"));
        account.setRefreshedAt(this.getOptionalDate(accountObj, "refreshed_at"));
        if (accountObj.has("balance")) {
            JsonObject balanceObj = accountObj.getAsJsonObject("balance");
            FintocBalance balance = new FintocBalance(balanceObj.get("available").getAsDouble(), balanceObj.get("current").getAsDouble(), this.getOptionalDouble(balanceObj, "limit"));
            account.setBalance(balance);
        }
        return account;
    }

    private FintocMovement parseFintocMovement(JsonObject movementObj) {
        FintocMovement movement = new FintocMovement();
        movement.setId(this.getOptionalString(movementObj, "id"));
        movement.setAmount(movementObj.get("amount").getAsDouble());
        movement.setPostDate(this.getOptionalDate(movementObj, "post_date"));
        movement.setTransactionDate(this.getOptionalDate(movementObj, "transaction_date"));
        movement.setDescription(this.getOptionalString(movementObj, "description"));
        movement.setCurrency(this.getOptionalString(movementObj, "currency"));
        movement.setReferenceId(this.getOptionalString(movementObj, "reference_id"));
        movement.setType(this.getOptionalString(movementObj, "type"));
        movement.setPending(movementObj.get("pending").getAsBoolean());
        movement.setComment(this.getOptionalString(movementObj, "comment"));
        if (!movementObj.get("recipient_account").isJsonNull()) {
            movement.setHolderAccount(this.parseFintocHolderAccount(movementObj.getAsJsonObject("recipient_account")));
        } else if (!movementObj.get("sender_account").isJsonNull()) {
            movement.setHolderAccount(this.parseFintocHolderAccount(movementObj.getAsJsonObject("sender_account")));
        }
        return movement;
    }

    private FintocInstitution parseFintocInstitution(JsonObject institutionObj) {
        if (institutionObj == null || institutionObj.isJsonNull()) {
            log.warning("El objeto instituci\u00f3n es nulo o inv\u00e1lido.");
            return null;
        }
        FintocInstitution institution = new FintocInstitution();
        institution.setId(this.getOptionalString(institutionObj, "id"));
        institution.setName(this.getOptionalString(institutionObj, "name"));
        institution.setCountry(this.getOptionalString(institutionObj, "country"));
        return institution;
    }

    private FintocHolderAccount parseFintocHolderAccount(JsonObject holderObj) {
        if (holderObj == null || holderObj.isJsonNull()) {
            log.warning("El objeto instituci\u00f3n es nulo o inv\u00e1lido.");
            return null;
        }
        FintocHolderAccount holder = new FintocHolderAccount();
        holder.setHolderId(this.getOptionalString(holderObj, "holder_id"));
        holder.setHolderName(this.getOptionalString(holderObj, "holder_name"));
        holder.setNumber(this.getOptionalString(holderObj, "number"));
        if (holderObj.has("institution") && !holderObj.get("institution").isJsonNull()) {
            holder.setInstitution(this.parseFintocInstitution(holderObj.getAsJsonObject("institution")));
        }
        return holder;
    }

    private String getOptionalString(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() ? obj.get(key).getAsString() : null;
    }

    private LocalDateTime getOptionalDate(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() ? LocalDateTime.parse(obj.get(key).getAsString(), DateTimeFormatter.ISO_DATE_TIME) : null;
    }

    private Double getOptionalDouble(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() ? Double.valueOf(obj.get(key).getAsDouble()) : null;
    }

    public int getItemPerPage() {
        return this.itemPerPage;
    }

    public void setItemPerPage(int itemPerPage) {
        this.itemPerPage = itemPerPage;
    }
}

