/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model.utils.shopify;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public class ShopifyGraphQLOrdersSample {
    private static final String SHOP_DOMAIN = "purisnacks-cl.myshopify.com";
    private static final String API_VERSION = "2025-07";
    private static final String ACCESS_TOKEN = "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";

    public static void main(String[] args) throws Exception {
        String graphQLQuery = "query ListOrders($first:Int!, $cursor:String) {  orders(first: $first, after: $cursor, sortKey: CREATED_AT, reverse: true) {    edges{      cursor      node{        id name createdAt displayFinancialStatus currencyCode         totalPriceSet{shopMoney{amount currencyCode}}         customer{id displayName email}         shippingLines(first:10){          edges{            node{              title               originalPriceSet{shopMoney{amount currencyCode}}               discountedPriceSet{shopMoney{amount currencyCode}}             }          }        }        lineItems(first:100){          edges{            node{              quantity               originalUnitPriceSet{shopMoney{amount currencyCode}}               sku variant{sku} product{id title} name             }          }        }        discountCode         totalDiscountsSet{shopMoney{amount currencyCode}}        transactions{paymentId}      }    }    pageInfo { hasNextPage endCursor }  }}";
        String variablesJson = "{\"first\":50}";
        String jsonBody = "{\"query\":" + ShopifyGraphQLOrdersSample.quote(graphQLQuery) + ",\"variables\":" + variablesJson + "}";
        String url = "https://purisnacks-cl.myshopify.com/admin/api/2025-07/graphql.json";
        HttpClient http = HttpClient.newHttpClient();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").header("X-Shopify-Access-Token", ACCESS_TOKEN).POST(HttpRequest.BodyPublishers.ofString(jsonBody, StandardCharsets.UTF_8)).build();
        HttpResponse<String> res = http.send(req, HttpResponse.BodyHandlers.ofString());
        System.out.println(res.body());
    }

    private static String quote(String s) {
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + "\"";
    }
}

