/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;

public class CreditNoteFromInvoice {
    private static final CLogger log = CLogger.getCLogger(CreditNoteFromInvoice.class);

    public static MInvoice createCreditNoteWithLines(Properties ctx, MInvoice inv, String refCod, String reasonRef, boolean p_ReturnMaterial, String trxName, int adClientId, List<SelectedLine> selectedLines) throws Exception {
        if (inv == null || inv.get_ID() <= 0) {
            throw new AdempiereException("La factura origen no existe");
        }
        if (!"CO".equals(inv.getDocStatus())) {
            throw new AdempiereException("Documento debe estar completo para crear NC");
        }
        int docTypeId = CreditNoteFromInvoice.findDocTypeForNC(ctx, p_ReturnMaterial, adClientId, inv.getAD_Org_ID(), trxName);
        if (docTypeId <= 0) {
            if (p_ReturnMaterial) {
                throw new AdempiereException("No existe Tipo de Documento 'Nota de Cr\u00e9dito Devoluci\u00f3n'");
            }
            throw new AdempiereException("No existe Tipo de Documento 'Nota de Credito'");
        }
        Timestamp hoy = new Timestamp(System.currentTimeMillis());
        if ("2".equals(refCod)) {
            MInvoiceLine[] copied;
            MInvoice nc = MInvoice.copyFrom(inv, hoy, hoy, docTypeId, inv.isSOTrx(), false, false, trxName, true);
            nc.setPOReference(null);
            nc.setC_Order_ID(0);
            nc.set_CustomColumn("AJ_RefDoc_ID", inv.getC_Invoice_ID());
            nc.set_CustomColumn("AJ_CodRef", refCod);
            nc.set_CustomColumn("AJ_ReasonRef", reasonRef);
            nc.set_CustomColumn("AJ_PDFGDE", null);
            nc.set_CustomColumn("EK_DescriptionFEL", null);
            nc.saveEx();
            for (MInvoiceLine mInvoiceLine : copied = nc.getLines(true)) {
                mInvoiceLine.deleteEx(true);
            }
            int chargeID = MSysConfig.getIntValue((String)"EK_CORRECTION_TEXT", (int)0, (int)adClientId);
            if (chargeID <= 0) {
                throw new AdempiereException("No est\u00e1 configurado EK_CORRECTION_TEXT");
            }
            MInvoiceLine newLine = new MInvoiceLine(nc);
            newLine.setM_Product_ID(0);
            newLine.setC_OrderLine_ID(0);
            newLine.setM_InOutLine_ID(0);
            newLine.setM_AttributeSetInstance_ID(0);
            newLine.setC_Charge_ID(chargeID);
            BigDecimal precio = BigDecimal.ONE;
            newLine.setPriceActual(precio);
            newLine.setPriceEntered(precio);
            newLine.setQty(BigDecimal.ONE);
            newLine.setLineNetAmt(precio);
            newLine.saveEx();
            for (MInvoiceLine line : nc.getLines(true)) {
                if (line.getC_Charge_ID() == chargeID) continue;
                line.deleteEx(true);
            }
            inv.set_CustomColumn("AJ_RefDoc_ID", nc.getC_Invoice_ID());
            inv.saveEx();
            return nc;
        }
        MInvoice nc = MInvoice.copyFrom(inv, hoy, hoy, docTypeId, inv.isSOTrx(), false, false, trxName, true);
        for (MInvoiceLine line : nc.getLines(true)) {
            line.deleteEx(true);
        }
        nc.setPOReference(null);
        nc.setC_Order_ID(0);
        nc.set_CustomColumn("AJ_RefDoc_ID", inv.getC_Invoice_ID());
        nc.set_CustomColumn("AJ_CodRef", refCod);
        nc.set_CustomColumn("AJ_ReasonRef", reasonRef);
        nc.set_CustomColumn("AJ_PDFGDE", null);
        nc.set_CustomColumn("EK_DescriptionFEL", null);
        nc.saveEx();
        if (selectedLines == null) {
            for (MInvoiceLine src : inv.getLines(false)) {
                CreditNoteFromInvoice.copyLineWithASI(src, nc, src.getQtyInvoiced(), src.getPriceActual());
            }
        } else {
            for (SelectedLine sl : selectedLines) {
                if (sl.getQty() == null || sl.getQty().signum() == 0) continue;
                MInvoiceLine src = new MInvoiceLine(ctx, sl.getC_InvoiceLine_ID(), trxName);
                BigDecimal qty = sl.getQty() != null ? sl.getQty() : src.getQtyInvoiced();
                BigDecimal bigDecimal = sl.getPrice() != null ? sl.getPrice() : src.getPriceActual();
                MInvoiceLine nl = new MInvoiceLine(nc);
                PO.copyValues((PO)src, (PO)nl);
                nl.setC_Invoice_ID(nc.getC_Invoice_ID());
                nl.setInvoice(nc);
                nl.setM_InOutLine_ID(0);
                nl.setProcessed(false);
                nl.setQtyInvoiced(qty);
                nl.setQtyEntered(qty);
                nl.setPriceActual(bigDecimal);
                nl.setPriceEntered(bigDecimal);
                nl.setLineNetAmt(bigDecimal.multiply(qty));
                int asiId = src.getM_AttributeSetInstance_ID();
                if (asiId <= 0 && src.getM_InOutLine_ID() > 0) {
                    MInOutLine iol = new MInOutLine(src.getCtx(), src.getM_InOutLine_ID(), src.get_TrxName());
                    asiId = iol.getM_AttributeSetInstance_ID();
                }
                if (asiId > 0) {
                    nl.setM_AttributeSetInstance_ID(asiId);
                }
                nl.saveEx();
                System.out.println("   -> LINEA NC CREADA: NCLineID=" + nl.getC_InvoiceLine_ID());
            }
        }
        inv.set_CustomColumn("AJ_RefDoc_ID", nc.getC_Invoice_ID());
        inv.saveEx();
        return nc;
    }

    private static void copyLineWithASI(MInvoiceLine src, MInvoice nc, BigDecimal qty, BigDecimal price) {
        MInvoiceLine nl = new MInvoiceLine(nc);
        PO.copyValues((PO)src, (PO)nl);
        nl.setC_Invoice_ID(nc.getC_Invoice_ID());
        nl.setInvoice(nc);
        nl.setM_InOutLine_ID(0);
        nl.setProcessed(false);
        if (qty == null) {
            qty = src.getQtyInvoiced();
        }
        if (price == null) {
            price = src.getPriceActual();
        }
        nl.setQtyInvoiced(qty);
        nl.setQtyEntered(qty);
        nl.setPriceActual(price);
        nl.setPriceEntered(price);
        nl.setLineNetAmt(price.multiply(qty));
        int asiId = src.getM_AttributeSetInstance_ID();
        if (asiId <= 0 && src.getM_InOutLine_ID() > 0) {
            MInOutLine iol = new MInOutLine(src.getCtx(), src.getM_InOutLine_ID(), src.get_TrxName());
            asiId = iol.getM_AttributeSetInstance_ID();
        }
        if (asiId > 0) {
            nl.setM_AttributeSetInstance_ID(asiId);
        }
        nl.saveEx();
    }

    private static int findDocTypeForNC(Properties ctx, boolean isReturnMaterial, int adClientId, int adOrgId, String trxName) {
        String baseName = "NOTA DE CREDITO";
        Object where = "AD_Client_ID=? AND IsActive='Y' AND translate(upper(Name), '\u00c1\u00c9\u00cd\u00d3\u00da\u00dc', 'AEIOUU') LIKE ? AND (AD_Org_ID=? OR AD_Org_ID=0)";
        where = isReturnMaterial ? (String)where + " AND translate(upper(Name), '\u00c1\u00c9\u00cd\u00d3\u00da\u00dc', 'AEIOUU') LIKE '%DEVOLUCION%'" : (String)where + " AND translate(upper(Name), '\u00c1\u00c9\u00cd\u00d3\u00da\u00dc', 'AEIOUU') NOT LIKE '%DEVOLUCION%'";
        String likeParam = baseName;
        Integer id = new Query(ctx, "C_DocType", (String)where, trxName).setParameters(new Object[]{adClientId, likeParam + "%", adOrgId}).setOrderBy("AD_Org_ID DESC").firstId();
        return id == null ? 0 : id;
    }

    public static class SelectedLine {
        private int C_InvoiceLine_ID;
        private BigDecimal qty;
        private BigDecimal price;

        public SelectedLine(int id, BigDecimal qty, BigDecimal price) {
            this.C_InvoiceLine_ID = id;
            this.qty = qty;
            this.price = price;
        }

        public int getC_InvoiceLine_ID() {
            return this.C_InvoiceLine_ID;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public BigDecimal getPrice() {
            return this.price;
        }
    }
}

