/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import java.util.regex.Matcher;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MProject;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessAddAdvanceRetention
extends SvrProcess {
    private static final CLogger log = CLogger.getCLogger(EKProcessAddAdvanceRetention.class);
    private boolean p_OnlyRefreshDescription = false;
    private static final String KEY_DEVOLUCION_ANTICIPO = "devolucion anticipo";
    private static final String KEY_RETENCION_DESCUENTO = "retenci\u00f3n descuento";
    private static final String AUTO_FLAG = "[PROYECTO]";
    private static final String EP_BEGIN = "\n/*Resumen*/\n";
    private static final String EP_END = "\n/*Fin del Resumen*/\n";
    private static final String NAME_OVERRIDE_COL = "AJ_NameOverride";
    private static final String NAME_OVERRIDE_VALUE = "EP";
    private int p_C_Invoice_ID = 0;

    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        ProcessInfoParameter[] params = this.getParameter();
        if (params != null) {
            for (ProcessInfoParameter p : params) {
                Object v;
                if (p == null || p.getParameterName() == null || !"OnlyRefreshDescription".equalsIgnoreCase(p.getParameterName()) || (v = p.getParameter()) == null) continue;
                this.p_OnlyRefreshDescription = v instanceof Boolean ? (Boolean)v : "Y".equalsIgnoreCase(v.toString()) || "true".equalsIgnoreCase(v.toString());
            }
        }
    }

    protected String doIt() throws Exception {
        MInvoiceLine[] invLines;
        if (this.p_C_Invoice_ID <= 0) {
            return "No hay factura seleccionada.";
        }
        MInvoice inv = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, this.get_TrxName());
        if (inv.getC_Invoice_ID() <= 0) {
            return "Factura no encontrada: " + this.p_C_Invoice_ID;
        }
        if (this.p_OnlyRefreshDescription) {
            int updated = this.setNameOverrideForAllLines(inv.getC_Invoice_ID(), NAME_OVERRIDE_VALUE);
            String sqlDesc = "SELECT descripcion FROM AJC_invoice_ep_summary(?)";
            String newDesc = DB.getSQLValueStringEx((String)this.get_TrxName(), (String)"SELECT descripcion FROM AJC_invoice_ep_summary(?)", (Object[])new Object[]{inv.getC_Invoice_ID()});
            if (newDesc != null && !newDesc.trim().isEmpty()) {
                this.upsertEpSummary(inv, newDesc);
                log.info("Descripci\u00f3n refrescada (OnlyRefreshDescription=Y) usando delimitadores.");
            } else {
                log.info("AJC_invoice_ep_summary() no devolvi\u00f3 descripci\u00f3n (NULL/empty). Se mantiene la existente.");
            }
            inv.saveEx();
            return "Actualizada SIN recalcular cargos";
        }
        int C_Order_ID = inv.getC_Order_ID();
        if (C_Order_ID <= 0) {
            return "La factura no est\u00e1 asociada a una orden (C_Order_ID).";
        }
        MOrder ord = new MOrder(this.getCtx(), C_Order_ID, this.get_TrxName());
        if (ord.get_ID() <= 0) {
            return "Orden no encontrada: " + C_Order_ID;
        }
        int C_Project_ID = ord.getC_Project_ID();
        if (C_Project_ID <= 0) {
            return "La orden no tiene proyecto (C_Project_ID). No se generan cargos.";
        }
        int precision = inv.getPrecision();
        int adClientId = inv.getAD_Client_ID();
        int chargeAdvanceId = this.findChargeIdByKeyword(this.getCtx(), adClientId, KEY_DEVOLUCION_ANTICIPO);
        int chargeRetentionId = this.findChargeIdByKeyword(this.getCtx(), adClientId, KEY_RETENCION_DESCUENTO);
        if (chargeAdvanceId <= 0) {
            return "No se encontr\u00f3 C_Charge para 'devolucion anticipo'.";
        }
        if (chargeRetentionId <= 0) {
            return "No se encontr\u00f3 C_Charge para 'retenci\u00f3n descuento'.";
        }
        this.deletePreviousAutoLines(inv.getC_Invoice_ID());
        int created = 0;
        MProject project = new MProject(this.getCtx(), C_Project_ID, this.get_TrxName());
        String projectName = project.getName();
        for (MInvoiceLine il : invLines = inv.getLines(false)) {
            BigDecimal retAmt;
            BigDecimal advAmt;
            boolean hasAnyPct;
            BigDecimal baseInInvCur;
            if (!il.isActive() || il.getC_Charge_ID() > 0 || (baseInInvCur = il.getLineNetAmt()) == null || baseInInvCur.signum() <= 0) continue;
            int projectLineId = 0;
            int mProductId = il.getM_Product_ID();
            if (mProductId > 0) {
                projectLineId = this.findProjectLineIdByProduct(C_Project_ID, mProductId);
            }
            if (projectLineId <= 0) continue;
            BigDecimal pctAdv = this.getPctAdvanceFromProjectLine(projectLineId);
            BigDecimal pctRet = this.getPctRetentionFromProjectLine(projectLineId);
            boolean bl = hasAnyPct = pctAdv != null && pctAdv.signum() > 0 || pctRet != null && pctRet.signum() > 0;
            if (!hasAnyPct) continue;
            if (pctAdv != null && pctAdv.signum() > 0 && (advAmt = EKProcessAddAdvanceRetention.pct(baseInInvCur, pctAdv, precision)).signum() > 0) {
                this.createChargeLine(inv, chargeAdvanceId, advAmt.negate(), "Devoluci\u00f3n Anticipo [PROYECTO] [Producto=" + il.getName() + ", Proyecto=" + projectName + "]");
                ++created;
            }
            if (pctRet == null || pctRet.signum() <= 0 || (retAmt = EKProcessAddAdvanceRetention.pct(baseInInvCur, pctRet, precision)).signum() <= 0) continue;
            this.createChargeLine(inv, chargeRetentionId, retAmt.negate(), "Retenci\u00f3n [PROYECTO] [Producto=" + il.getName() + ", Proyecto=" + projectName + "]");
            ++created;
        }
        int updated = this.setNameOverrideForAllLines(inv.getC_Invoice_ID(), NAME_OVERRIDE_VALUE);
        log.info("Sobreescribe Glosa actualizado a Estado de Pago  en l\u00edneas: " + updated);
        String sqlDesc = "SELECT descripcion FROM AJC_invoice_ep_summary(?)";
        String desc = DB.getSQLValueStringEx((String)this.get_TrxName(), (String)"SELECT descripcion FROM AJC_invoice_ep_summary(?)", (Object[])new Object[]{inv.getC_Invoice_ID()});
        if (desc != null && !desc.isEmpty()) {
            this.upsertEpSummary(inv, desc);
        } else {
            log.info("Funcion AJC_invoice_ep_summary() no devolvi\u00f3 descripci\u00f3n");
        }
        inv.saveEx();
        return "Cargos generados desde l\u00edneas de la factura: " + created + " | L\u00edneas con Sobreescribe Glosa = Estado de Pago: " + updated;
    }

    private int findChargeIdByKeyword(Properties ctx, int adClientId, String keyword) {
        Integer id = this.queryChargeId(adClientId, keyword);
        if (id != null && id > 0) {
            return id;
        }
        id = this.queryChargeId(0, keyword);
        return id != null ? id : 0;
    }

    private Integer queryChargeId(int adClientId, String keyword) {
        String like = "%" + keyword.toLowerCase() + "%";
        String sql = "SELECT c_charge_id FROM c_charge WHERE isactive='Y' AND ad_client_id=?   AND ( lower(COALESCE(description,'')) LIKE ?      OR lower(COALESCE(name,''))        LIKE ? ) ORDER BY c_charge_id ASC LIMIT 1";
        return DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT c_charge_id FROM c_charge WHERE isactive='Y' AND ad_client_id=?   AND ( lower(COALESCE(description,'')) LIKE ?      OR lower(COALESCE(name,''))        LIKE ? ) ORDER BY c_charge_id ASC LIMIT 1", (Object[])new Object[]{adClientId, like, like});
    }

    private void deletePreviousAutoLines(int C_Invoice_ID) {
        String sql = "DELETE FROM C_InvoiceLine WHERE C_Invoice_ID=?   AND COALESCE(Description,'') LIKE ?";
        int del = DB.executeUpdateEx((String)"DELETE FROM C_InvoiceLine WHERE C_Invoice_ID=?   AND COALESCE(Description,'') LIKE ?", (Object[])new Object[]{C_Invoice_ID, "%[PROYECTO]%"}, (String)this.get_TrxName());
        log.info("L\u00edneas AUTO eliminadas: " + del);
    }

    private void createChargeLine(MInvoice inv, int cChargeId, BigDecimal amountNeg, String description) {
        if (amountNeg == null || amountNeg.signum() == 0) {
            return;
        }
        MInvoiceLine il = new MInvoiceLine(inv);
        il.setC_Charge_ID(cChargeId);
        il.setQty(Env.ONE);
        il.setPrice(amountNeg);
        il.setPriceEntered(amountNeg);
        il.setPriceActual(amountNeg);
        il.setLine(this.getNextLineNo(inv.getC_Invoice_ID()));
        il.setDescription(description);
        if (inv.getC_Project_ID() > 0) {
            il.setC_Project_ID(inv.getC_Project_ID());
        }
        try {
            il.set_ValueOfColumn(NAME_OVERRIDE_COL, (Object)NAME_OVERRIDE_VALUE);
        }
        catch (Exception ignore) {
            log.warning("Columna AJ_NameOverride no existe en MInvoiceLine (set en creaci\u00f3n).");
        }
        il.saveEx();
    }

    private void upsertEpSummary(MInvoice inv, String newDesc) {
        if (newDesc == null || newDesc.trim().isEmpty()) {
            return;
        }
        String old = inv.getDescription();
        if (old == null) {
            old = "";
        }
        String safeNew = newDesc.trim();
        String replacement = EP_BEGIN + safeNew + EP_END;
        String pattern = "(?s)\\Q\n/*Resumen*/\n\\E.*?\\Q\n/*Fin del Resumen*/\n\\E";
        if (old.contains(EP_BEGIN)) {
            String updated = old.replaceAll(pattern, Matcher.quoteReplacement(replacement));
            inv.setDescription(updated);
        } else {
            String base = old.trim();
            String combined = (String)(base.isEmpty() ? "" : base + "\n") + replacement;
            inv.setDescription(combined);
        }
    }

    private int getNextLineNo(int C_Invoice_ID) {
        String sql = "SELECT COALESCE(MAX(Line),0) + 10 FROM C_InvoiceLine WHERE C_Invoice_ID=?";
        Integer next = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COALESCE(MAX(Line),0) + 10 FROM C_InvoiceLine WHERE C_Invoice_ID=?", (Object[])new Object[]{C_Invoice_ID});
        return next != null ? next : 10;
    }

    private static BigDecimal pct(BigDecimal base, BigDecimal pct, int precision) {
        if (base == null || pct == null || pct.signum() == 0) {
            return Env.ZERO;
        }
        BigDecimal rate = pct.divide(new BigDecimal("100"), Math.max(precision + 4, 6), RoundingMode.HALF_UP);
        return base.multiply(rate).setScale(precision, RoundingMode.HALF_UP);
    }

    private int setNameOverrideForAllLines(int C_Invoice_ID, String value) {
        String sql = "UPDATE C_InvoiceLine    SET AJ_NameOverride = ?  WHERE C_Invoice_ID = ? AND IsActive = 'Y'";
        try {
            return DB.executeUpdateEx((String)"UPDATE C_InvoiceLine    SET AJ_NameOverride = ?  WHERE C_Invoice_ID = ? AND IsActive = 'Y'", (Object[])new Object[]{value, C_Invoice_ID}, (String)this.get_TrxName());
        }
        catch (Exception e) {
            log.warning("No se pudo actualizar AJ_NameOverride para todas las l\u00edneas: " + e.getMessage());
            return 0;
        }
    }

    private int findProjectLineIdByProduct(int C_Project_ID, int M_Product_ID) {
        String sql = "SELECT C_ProjectLine_ID FROM C_ProjectLine WHERE IsActive='Y' AND C_Project_ID=? AND M_Product_ID=? ORDER BY C_ProjectLine_ID ASC LIMIT 1";
        Integer id = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT C_ProjectLine_ID FROM C_ProjectLine WHERE IsActive='Y' AND C_Project_ID=? AND M_Product_ID=? ORDER BY C_ProjectLine_ID ASC LIMIT 1", (Object[])new Object[]{C_Project_ID, M_Product_ID});
        return id != null ? id : 0;
    }

    private BigDecimal getPctAdvanceFromProjectLine(int C_ProjectLine_ID) {
        String sql = "SELECT COALESCE(AJ_PctAdvance,0) FROM C_ProjectLine WHERE C_ProjectLine_ID=?";
        BigDecimal v = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)"SELECT COALESCE(AJ_PctAdvance,0) FROM C_ProjectLine WHERE C_ProjectLine_ID=?", (Object[])new Object[]{C_ProjectLine_ID});
        return v != null ? v : Env.ZERO;
    }

    private BigDecimal getPctRetentionFromProjectLine(int C_ProjectLine_ID) {
        String sql = "SELECT COALESCE(AJ_PctRetention,0) FROM C_ProjectLine WHERE C_ProjectLine_ID=?";
        BigDecimal v = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)"SELECT COALESCE(AJ_PctRetention,0) FROM C_ProjectLine WHERE C_ProjectLine_ID=?", (Object[])new Object[]{C_ProjectLine_ID});
        return v != null ? v : Env.ZERO;
    }
}

