/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.json.JSONArray;
import org.json.JSONObject;

public class EKProcessBulkWebhookByUrls
extends SvrProcess {
    private String p_PLVListCsv;
    private String p_PayloadJson;
    private Integer p_TimeoutMs = 20000;
    private BigDecimal p_MarginPct = null;
    private static final String SC_WH_URL = "WEBHOOK_FORWARD_URL";
    private static final String SC_WH_TOKEN = "WEBHOOK_FORWARD_TOKEN";

    protected void prepare() {
    }

    protected String doIt() throws Exception {
        JSONObject webhookResp;
        JSONArray output;
        this.p_PLVListCsv = "1000519,1000518,1000517";
        this.p_PayloadJson = "[\r\n  {\r\n    \"codigo_producto\": \"ARM-92735\",\r\n    \"nombre\": \"My Way Le Parfum V90Ml\",\r\n    \"urls\": [\r\n      \"https://www.falabella.com/falabella-cl/product/50200233/Perfume-Mujer-My-Way-Parfum-90Ml-Giorgio-Armani/50200233\",\r\n      \"https://www.paris.cl/perfume-my-way-le-parfum-90-ml-231714999.html\",\r\n    ]\r\n  },\r\n  {\r\n    \"codigo_producto\": \"CHE-99469\",\r\n    \"nombre\": \"212 Heroes For Her Edp 80 Ml\",\r\n    \"urls\": [\r\n      \"https://www.falabella.com/falabella-cl/product/50044656/Perfume-Mujer-212-Heroes-Edp-80Ml-Carolina-Herrera/50044656\",\r\n      \"https://www.paris.cl/perfume-212-heroes-for-her-edp-80-ml-517179999.html\",\r\n    ]\r\n  },\r\n\t{\r\n    \"codigo_producto\": \"ARM-92735\",\r\n    \"nombre\": \"My Way Le Parfum V90Ml\",\r\n    \"urls\": [\r\n      \"https://www.falabella.com/falabella-cl/product/50268626/Perfume-Mujer-Divine-EDP-50-Ml-Jean-Paul-Gaultier/50268626\",\r\n      \"https://www.paris.cl/perfume-gaultier-divine-edp-mujer-50-ml-218382999.html\",\r\n    ]\r\n  }\r\n]\r\n";
        if (this.isEmpty(this.p_PLVListCsv)) {
            return "Falta PLV_List (IDs separados por coma).";
        }
        if (this.isEmpty(this.p_PayloadJson)) {
            return "Falta PayloadJson (array con productos y urls).";
        }
        List<Integer> plvIds = this.parseIntCsv(this.p_PLVListCsv);
        if (plvIds.isEmpty()) {
            return "PLV_List inv\u00e1lido.";
        }
        JSONArray inputArr = new JSONArray(this.p_PayloadJson);
        Map<String, String> urlToProductCode = this.buildUrlToCodeMap(inputArr);
        int AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
        int AD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx());
        String urlToCall = MSysConfig.getValue((String)SC_WH_URL, null, (int)AD_Client_ID, (int)AD_Org_ID);
        Object authToken = MSysConfig.getValue((String)SC_WH_TOKEN, null, (int)AD_Client_ID, (int)AD_Org_ID);
        if (this.isEmpty(urlToCall)) {
            return "SysConfig WEBHOOK_FORWARD_URL vac\u00edo.";
        }
        if (this.isEmpty((String)authToken)) {
            return "SysConfig WEBHOOK_FORWARD_TOKEN vac\u00edo.";
        }
        if (!((String)authToken).toLowerCase().startsWith("bearer ")) {
            authToken = "Bearer " + ((String)authToken).trim();
        }
        if ((output = (webhookResp = this.postJsonArray(urlToCall, inputArr, this.p_TimeoutMs, (String)authToken)).optJSONArray("output")) == null) {
            if (webhookResp.has("0")) {
                output = new JSONArray().put((Object)webhookResp);
            } else {
                return "Respuesta del webhook no contiene 'output'. Resp=" + String.valueOf(webhookResp);
            }
        }
        StringBuilder report = new StringBuilder();
        int ok = 0;
        int err = 0;
        for (Integer plvId : plvIds) {
            MPriceListVersion plv = new MPriceListVersion(this.getCtx(), plvId.intValue(), this.get_TrxName());
            if (plv.get_ID() <= 0) {
                report.append("PLV no encontrada: ").append(plvId).append("\n");
                ++err;
                continue;
            }
            MPriceList pl = new MPriceList(this.getCtx(), plv.getM_PriceList_ID(), this.get_TrxName());
            if (pl.get_ID() <= 0) {
                report.append("Lista no encontrada para PLV=").append(plvId).append("\n");
                ++err;
                continue;
            }
            String listName = pl.getName() != null ? pl.getName().toLowerCase() : "";
            String domainFilter = null;
            if (listName.contains("Ventas falabella")) {
                domainFilter = "falabella.com";
            } else if (listName.contains("Ventas paris")) {
                domainFilter = "paris.cl";
            } else {
                report.append("Lista ").append(listName).append(" sin dominio asociado, se omite.\n");
                continue;
            }
            report.append("\n===> Procesando lista: ").append(listName).append(" (filtro: ").append(domainFilter).append(")\n");
            int precision = this.getCurrencyPrecision(pl.getC_Currency_ID());
            if (precision < 0) {
                precision = 2;
            }
            Map<String, BigDecimal> filteredPrices = this.computeBestPricesByDomain(output, urlToProductCode, domainFilter);
            for (Map.Entry<String, BigDecimal> e : filteredPrices.entrySet()) {
                BigDecimal priceStd;
                String productCode = e.getKey();
                BigDecimal priceList = priceStd = e.getValue().setScale(precision, RoundingMode.HALF_UP);
                if (this.p_MarginPct != null) {
                    BigDecimal factor = BigDecimal.ONE.add(this.p_MarginPct.movePointLeft(2));
                    priceList = priceStd.multiply(factor).setScale(precision, RoundingMode.HALF_UP);
                }
                try {
                    Integer M_Product_ID = this.getProductIdByValue(productCode);
                    if (M_Product_ID == null) {
                        report.append("Producto no encontrado (Value): ").append(productCode).append(" [PLV ").append(plvId).append("]\n");
                        ++err;
                        continue;
                    }
                    MProductPrice pp = this.getOrCreateProductPrice(plvId, M_Product_ID);
                    pp.setPriceStd(priceStd);
                    pp.setPriceList(priceList);
                    if (pp.getM_ProductPrice_ID() == 0 || pp.getPriceLimit() == null) {
                        pp.setPriceLimit(priceStd);
                    }
                    if (!pp.save()) {
                        report.append("No se pudo guardar precio para ").append(productCode).append(" [PLV ").append(plvId).append("]\n");
                        ++err;
                        continue;
                    }
                    ++ok;
                    report.append("OK ").append(productCode).append(" @PLV ").append(plvId).append(" -> PriceStd=").append(priceStd).append(", PriceList=").append(priceList).append("\n");
                }
                catch (Exception ex) {
                    ++err;
                    report.append("ERROR ").append(productCode).append(" @PLV ").append(plvId).append(": ").append(ex.getMessage()).append("\n");
                }
            }
        }
        report.append("\nResumen: OK=").append(ok).append(", Error=").append(err);
        return report.toString();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private List<Integer> parseIntCsv(String csv) {
        if (this.isEmpty(csv)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String part : csv.split(",")) {
            String t = part.trim();
            if (t.isEmpty()) continue;
            try {
                out.add(Integer.parseInt(t));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return out;
    }

    private Map<String, String> buildUrlToCodeMap(JSONArray inputArr) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < inputArr.length(); ++i) {
            JSONObject obj = inputArr.getJSONObject(i);
            String code = obj.optString("codigo_producto", null);
            JSONArray urls = obj.optJSONArray("urls");
            if (code == null || urls == null) continue;
            for (int j = 0; j < urls.length(); ++j) {
                String u = urls.optString(j, null);
                if (u == null || u.trim().isEmpty()) continue;
                map.put(u.trim(), code);
            }
        }
        return map;
    }

    private boolean gtZero(BigDecimal n) {
        return n != null && n.compareTo(BigDecimal.ZERO) > 0;
    }

    private BigDecimal getNum(JSONObject o, String key) {
        if (!o.has(key)) {
            return null;
        }
        Object v = o.get(key);
        if (v == null) {
            return null;
        }
        if (v instanceof Number) {
            return new BigDecimal(((Number)v).toString());
        }
        String s = v.toString().replace("CLP", "").replace("$", "").replace(".", "").replace(",", "").trim();
        if (s.isEmpty()) {
            return null;
        }
        try {
            return new BigDecimal(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer getProductIdByValue(String value) {
        String sql = "SELECT M_Product_ID FROM M_Product WHERE AD_Client_ID=? AND Value=? AND IsActive='Y'";
        return DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)Env.getAD_Client_ID((Properties)this.getCtx()), (String)value);
    }

    private int getCurrencyPrecision(int C_Currency_ID) {
        String sql = "SELECT StdPrecision FROM C_Currency WHERE C_Currency_ID=?";
        return DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)C_Currency_ID);
    }

    private MProductPrice getOrCreateProductPrice(int M_PriceList_Version_ID, int M_Product_ID) {
        MProductPrice pp = (MProductPrice)new Query(this.getCtx(), "M_ProductPrice", "M_PriceList_Version_ID=? AND M_Product_ID=?", this.get_TrxName()).setParameters(new Object[]{M_PriceList_Version_ID, M_Product_ID}).first();
        if (pp == null) {
            pp = new MProductPrice(this.getCtx(), 0, this.get_TrxName());
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            pp.setM_Product_ID(M_Product_ID);
        }
        return pp;
    }

    private JSONObject postJsonArray(String url, JSONArray bodyArr, int timeoutMs, String authToken) throws IOException {
        String trimmed;
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setRequestMethod("POST");
        con.setConnectTimeout(timeoutMs);
        con.setReadTimeout(timeoutMs);
        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        con.setRequestProperty("Authorization", authToken);
        con.setDoOutput(true);
        try (OutputStream os = con.getOutputStream();){
            os.write(bodyArr.toString().getBytes(StandardCharsets.UTF_8));
        }
        int status = con.getResponseCode();
        String resp = this.readAll(status >= 400 ? con.getErrorStream() : con.getInputStream());
        if (resp == null || resp.trim().isEmpty()) {
            resp = "{}";
        }
        if ((trimmed = resp.trim()).startsWith("{")) {
            return new JSONObject(trimmed);
        }
        JSONArray arr = new JSONArray(trimmed);
        JSONObject wrap = new JSONObject();
        wrap.put("output", (Object)arr);
        return wrap;
    }

    private Map<String, BigDecimal> computeBestPricesByDomain(JSONArray output, Map<String, String> urlToProductCode, String domainFilter) {
        HashMap<String, BigDecimal> best = new HashMap<String, BigDecimal>();
        for (int i = 0; i < output.length(); ++i) {
            JSONObject it = output.getJSONObject(i);
            String url = it.optString("url", null);
            if (url == null || !url.contains(domainFilter)) continue;
            String productCode = null;
            productCode = urlToProductCode.containsKey(url) ? urlToProductCode.get(url) : it.optString("codigo", null);
            if (productCode == null || productCode.trim().isEmpty()) continue;
            productCode = productCode.trim();
            BigDecimal special = this.getNum(it, "precio_especial");
            BigDecimal offer = this.getNum(it, "precio_oferta");
            BigDecimal normal = this.getNum(it, "precio");
            BigDecimal candidate = null;
            if (this.gtZero(special)) {
                candidate = special;
            } else if (this.gtZero(offer)) {
                candidate = offer;
            } else if (this.gtZero(normal)) {
                candidate = normal;
            }
            if (!this.gtZero(candidate) || best.containsKey(productCode) && candidate.compareTo((BigDecimal)best.get(productCode)) >= 0) continue;
            best.put(productCode, candidate);
        }
        return best;
    }

    private String readAll(InputStream is) {
        String string;
        if (is == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String ln;
            StringBuilder sb = new StringBuilder();
            while ((ln = br.readLine()) != null) {
                sb.append(ln);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        br.close();
        return string;
    }
}

