/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.json.JSONArray;
import org.json.JSONObject;

public class EKProcessCentralBankIndicators
extends SvrProcess {
    private int p_C_Currency_ID = 0;
    private Timestamp p_DateTrx;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DateTrx")) {
                this.p_DateTrx = (Timestamp)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        Object resultado = "";
        if (this.p_C_Currency_ID == 0) {
            List<String> monedas = List.of("CUF", "USD", "EUR");
            for (String moneda : monedas) {
                String monedaConvertida;
                if (moneda.equals("CUF")) {
                    monedaConvertida = "uf";
                } else if (moneda.equals("USD")) {
                    monedaConvertida = "dolar";
                } else if (moneda.equals("EUR")) {
                    monedaConvertida = "euro";
                } else {
                    return "No hay tasa de conversion para la moneda " + moneda;
                }
                this.log.config("Obteniendo conversion de " + monedaConvertida + " para la fecha = " + String.valueOf(this.p_DateTrx) + "...");
                if (this.getCurrency_ID_ByCode(moneda) > 0) {
                    resultado = (String)resultado + "||" + this.createConversion(monedaConvertida, this.getCurrency_ID_ByCode(moneda));
                    Thread.sleep(1000L);
                    continue;
                }
                resultado = (String)resultado + "|| Moneda " + moneda + " no encontrada en Adempiere";
            }
        } else {
            try {
                String moneda = DB.getSQLValueString((String)this.get_TrxName(), (String)("SELECT iso_code FROM c_currency WHERE c_currency_id=" + this.p_C_Currency_ID), (Object[])new Object[0]);
                this.log.config("fecha = " + String.valueOf(this.p_DateTrx));
                if (moneda.equals("CUF")) {
                    moneda = "uf";
                } else if (moneda.equals("USD")) {
                    moneda = "dolar";
                } else if (moneda.equals("EUR")) {
                    moneda = "euro";
                } else {
                    return "No hay tasa de conversion para la moneda " + moneda;
                }
                resultado = this.createConversion(moneda, this.p_C_Currency_ID);
            }
            catch (Exception e) {
                throw new AdempiereException("DB Error:" + String.valueOf(e));
            }
        }
        return resultado;
    }

    private String createConversion(String moneda, int c_currency_id) {
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");
        JSONArray jsonarr = new JSONArray();
        JSONObject json = new JSONObject();
        int i = 0;
        while (jsonarr.isEmpty()) {
            LocalDateTime localDateTime = this.p_DateTrx.toLocalDateTime();
            LocalDateTime newLocalDateTime = localDateTime.minusDays(i);
            Timestamp newDateTrx = Timestamp.valueOf(newLocalDateTime);
            String date_s = format.format(newDateTrx);
            String website = "https://mindicador.cl/api/" + moneda + "/" + date_s;
            String jsonText = this.fetchJSONWithRetries(website, 5000, 3);
            if (jsonText == null) {
                return "Error al obtener la tasa de conversi\u00f3n desde " + website;
            }
            json = new JSONObject(jsonText);
            jsonarr = json.getJSONArray("serie");
            ++i;
        }
        String valor = jsonarr.getJSONObject(0).get("valor").toString();
        try {
            MConversionRate mm = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
            mm.setC_Currency_ID(c_currency_id);
            mm.setC_Currency_ID_To(228);
            mm.setC_ConversionType_ID(114);
            mm.setValidFrom(this.p_DateTrx);
            mm.setValidTo(this.p_DateTrx);
            mm.setAD_Org_ID(0);
            mm.setMultiplyRate(new BigDecimal(valor));
            if (mm.save()) {
                return "Se obtiene conversion de " + moneda;
            }
        }
        catch (Exception e) {
            return "Error al guardar conversion: " + String.valueOf(e);
        }
        return "Error al obtener conversion de " + moneda;
    }

    private int getCurrency_ID_ByCode(String moneda) {
        try {
            String sql = "SELECT max(c_currency_id) FROM c_currency WHERE iso_code='" + moneda + "'";
            int c_currency_id = DB.getSQLValue((String)this.get_TrxName(), (String)sql);
            return c_currency_id;
        }
        catch (Exception e) {
            throw new AdempiereException("DB Error:" + String.valueOf(e));
        }
    }

    private String fetchJSONWithRetries(String urlString, int timeoutMillis, int maxRetries) {
        int attempts = 0;
        while (attempts < maxRetries) {
            String string;
            ++attempts;
            URL url = new URL(urlString);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setConnectTimeout(timeoutMillis);
            con.setReadTimeout(timeoutMillis);
            BufferedReader rd = new BufferedReader(new InputStreamReader(con.getInputStream()));
            try {
                int counter;
                StringBuilder sb = new StringBuilder();
                while ((counter = rd.read()) != -1) {
                    sb.append((char)counter);
                }
                string = sb.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rd.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Attempt " + attempts + " failed: " + e.getMessage());
                    if (attempts < maxRetries) continue;
                    return null;
                }
            }
            rd.close();
            return string;
        }
        return null;
    }
}

