/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class EKProcessCloneDocActionAccess
extends SvrProcess {
    private int p_Dest_AD_Client_ID = 0;
    private boolean p_DeleteExisting = true;
    private int m_Src_Role_ID = 0;
    private int m_Src_Client_ID = 0;
    private int m_Dest_Role_ID = 0;

    protected void prepare() {
        for (ProcessInfoParameter p : this.getParameter()) {
            if (p == null || p.getParameterName() == null) continue;
            String name = p.getParameterName();
            if ("AD_client_ID_Target".equalsIgnoreCase(name)) {
                this.p_Dest_AD_Client_ID = p.getParameterAsInt();
                continue;
            }
            this.log.warning("Par\u00e1metro desconocido: " + name);
        }
        this.m_Src_Role_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String trxName = this.get_TrxName();
        Properties ctx = this.getCtx();
        if (this.m_Src_Role_ID <= 0) {
            throw new AdempiereUserError("No se pudo determinar el AD_Role_ID origen.");
        }
        if (this.p_Dest_AD_Client_ID <= 0) {
            throw new AdempiereUserError("Debe indicar el AD_Client_ID destino.");
        }
        MRole Src = new MRole(ctx, this.m_Src_Role_ID, trxName);
        this.m_Src_Client_ID = Src.getAD_Client_ID();
        if (this.m_Src_Client_ID <= 0) {
            throw new AdempiereUserError("No existe el rol origen" + this.m_Src_Role_ID);
        }
        String srcdes = Src.getDescription();
        if (srcdes == null) {
            throw new AdempiereUserError("El rol origen no tiene Description");
        }
        String sqlFindDestRole = "SELECT AD_Role_ID FROM AD_Role WHERE AD_Client_ID = ?   AND UPPER(COALESCE(Description,'')) = UPPER(?) ORDER BY AD_Role_ID";
        try (CPreparedStatement ps = DB.prepareStatement((String)sqlFindDestRole, (String)trxName);){
            ps.setInt(1, this.p_Dest_AD_Client_ID);
            ps.setString(2, srcdes.trim());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    throw new AdempiereUserError("No se encontr\u00f3 rol destino con Description='" + srcdes + "' en AD_Client_ID=" + this.p_Dest_AD_Client_ID);
                }
                this.m_Dest_Role_ID = rs.getInt(1);
                if (rs.next()) {
                    throw new AdempiereUserError("Existen m\u00faltiples roles con Description='" + srcdes + "' en AD_Client_ID=" + this.p_Dest_AD_Client_ID + ". Asegure unicidad de la descripci\u00f3n.");
                }
            }
        }
        if (this.m_Dest_Role_ID == 0) {
            throw new AdempiereUserError("El rol destino es system.");
        }
        if (this.m_Dest_Role_ID == this.m_Src_Role_ID) {
            throw new AdempiereUserError("El rol origen y destino no pueden ser el mismo");
        }
        int deleted = 0;
        if (this.p_DeleteExisting) {
            deleted = DB.executeUpdate((String)"DELETE FROM AD_Document_Action_Access WHERE AD_Role_ID = ?", (Object[])new Object[]{this.m_Dest_Role_ID}, (boolean)false, (String)trxName);
            this.addLog("Eliminados " + deleted + " accesos previos del rol destino.");
        }
        String insertSQL = "INSERT INTO AD_Document_Action_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,  C_DocType_ID, AD_Role_ID, AD_Ref_List_ID, uuid) SELECT  ?, 0, 'Y', now(), ?, now(), ?,  dt_dst.C_DocType_ID, ?, adaa.AD_Ref_List_ID, NULL FROM AD_Document_Action_Access adaa JOIN C_DocType dt_src ON (dt_src.C_DocType_ID = adaa.C_DocType_ID) JOIN C_DocType dt_dst ON (dt_dst.AD_Client_ID = ?)                     AND (dt_dst.Name = dt_src.Name)                     AND (dt_dst.DocBaseType = dt_src.DocBaseType) WHERE adaa.AD_Role_ID = ?   AND dt_src.AD_Client_ID = ? ";
        int inserted = DB.executeUpdate((String)insertSQL, (Object[])new Object[]{this.p_Dest_AD_Client_ID, this.getAD_User_ID(), this.getAD_User_ID(), this.m_Dest_Role_ID, this.p_Dest_AD_Client_ID, this.m_Src_Role_ID, this.m_Src_Client_ID}, (boolean)false, (String)trxName);
        String tmpTable = "tmp_missing_doctypes_" + System.currentTimeMillis();
        String createTmp = "CREATE TEMP TABLE " + tmpTable + " ON COMMIT DROP AS SELECT DISTINCT dt_src.Name, dt_src.DocBaseType FROM AD_Document_Action_Access adaa JOIN C_DocType dt_src ON (dt_src.C_DocType_ID = adaa.C_DocType_ID) LEFT JOIN C_DocType dt_dst   ON (dt_dst.AD_Client_ID = ?)  AND (dt_dst.Name = dt_src.Name)  AND (dt_dst.DocBaseType = dt_src.DocBaseType) WHERE adaa.AD_Role_ID = ?   AND dt_src.AD_Client_ID = ?   AND dt_dst.C_DocType_ID IS NULL";
        DB.executeUpdate((String)createTmp, (Object[])new Object[]{this.p_Dest_AD_Client_ID, this.m_Src_Role_ID, this.m_Src_Client_ID}, (boolean)false, (String)trxName);
        int missing = DB.getSQLValue((String)trxName, (String)("SELECT COUNT(*) FROM " + tmpTable));
        StringBuilder detail = new StringBuilder();
        if (missing > 0) {
            String q = "SELECT Name, DocBaseType FROM " + tmpTable + " ORDER BY Name";
            try (CPreparedStatement ps = DB.prepareStatement((String)q, (String)trxName);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString(1);
                    String dbt = rs.getString(2);
                    detail.append(" - ").append(name).append(" (DocBaseType=").append(dbt).append(")\n");
                }
            }
        }
        String msg = "Clonado de AD_Document_Action_Access completado.\nOrigen: AD_Role_ID=" + this.m_Src_Role_ID + " (AD_Client_ID=" + this.m_Src_Client_ID + ")\nDestino: AD_Role_ID=" + this.m_Dest_Role_ID + " (AD_Client_ID=" + this.p_Dest_AD_Client_ID + ")\nInsertados: " + inserted + (String)(this.p_DeleteExisting ? ", Eliminados previos: " + deleted : "") + "\n" + (String)(missing > 0 ? "Faltantes (" + missing + "):\n" + String.valueOf(detail) : "Sin faltantes por Name/DocBaseType.");
        return msg;
    }
}

