/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class EKProcessCloneRoleAccess
extends SvrProcess {
    private int p_RoleSource_ID = 0;
    private int p_ClientTarget_ID = 0;
    private int roleTarget_ID;
    private String trxName;
    private int userId;
    private int srcClientId;
    private int dstClientId;
    private boolean dashboardTableExists;
    private int delWin;
    private int insWin;
    private int delProc;
    private int insProc;
    private int delForm;
    private int insForm;
    private int delBrowse;
    private int insBrowse;
    private int delWf;
    private int insWf;
    private int delDash;
    private int insDash;

    protected void prepare() {
        this.trxName = this.get_TrxName();
        this.userId = this.getAD_User_ID();
        this.p_RoleSource_ID = this.getRecord_ID();
        for (ProcessInfoParameter p : this.getParameter()) {
            if (p == null || p.getParameterName() == null) continue;
            String name = p.getParameterName();
            if ("AD_Role_ID_Source".equalsIgnoreCase(name)) {
                int val = p.getParameterAsInt();
                if (val <= 0) continue;
                this.p_RoleSource_ID = val;
                continue;
            }
            if ("AD_client_ID_Target".equalsIgnoreCase(name)) {
                this.p_ClientTarget_ID = p.getParameterAsInt();
                continue;
            }
            this.log.warning("Par\u00e1metro desconocido: " + name);
        }
    }

    protected String doIt() throws Exception {
        Properties ctx = this.getCtx();
        MRole src = new MRole(ctx, this.p_RoleSource_ID, this.trxName);
        if (src.get_ID() <= 0) {
            throw new AdempiereUserError("Rol ORIGEN no existe: " + this.p_RoleSource_ID);
        }
        this.srcClientId = src.getAD_Client_ID();
        String srcdes = src.getDescription();
        if (srcdes == null) {
            throw new AdempiereUserError("El rol origen no tiene Description");
        }
        this.roleTarget_ID = this.resolveRoleIdByClientAndQuery(this.p_ClientTarget_ID, srcdes);
        if (this.roleTarget_ID == 0) {
            throw new AdempiereUserError("El rol destino es system.");
        }
        if (this.p_RoleSource_ID == this.roleTarget_ID) {
            throw new AdempiereUserError("El rol origen y destino no pueden ser el mismo.");
        }
        MRole dst = new MRole(ctx, this.roleTarget_ID, this.trxName);
        if (dst.get_ID() <= 0) {
            throw new AdempiereUserError("Rol DESTINO no existe: " + this.roleTarget_ID);
        }
        this.dstClientId = dst.getAD_Client_ID();
        this.dashboardTableExists = this.checkDashboardTable();
        this.cloneWindowAccess();
        this.cloneProcessAccess();
        this.cloneFormAccess();
        this.cloneBrowseAccess();
        this.cloneWorkflowAccess();
        if (this.dashboardTableExists) {
            this.cloneDashboardAccess();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Clonado de accesos completado.\n").append("Roles: ").append(this.p_RoleSource_ID).append(" \u2192 ").append(this.roleTarget_ID).append("  | Clients: ").append(this.srcClientId).append(" \u2192 ").append(this.dstClientId).append("\n").append("AD_Window_Access:   DELETE=").append(this.delWin).append(", INSERT=").append(this.insWin).append("\n").append("AD_Process_Access:  DELETE=").append(this.delProc).append(", INSERT=").append(this.insProc).append("\n").append("AD_Form_Access:     DELETE=").append(this.delForm).append(", INSERT=").append(this.insForm).append("\n").append("AD_Browse_Access:   DELETE=").append(this.delBrowse).append(", INSERT=").append(this.insBrowse).append("\n").append("AD_Workflow_Access: DELETE=").append(this.delWf).append(", INSERT=").append(this.insWf);
        if (this.dashboardTableExists) {
            sb.append("\nAD_Dashboard_Access: DELETE=").append(this.delDash).append(", INSERT=").append(this.insDash);
        } else {
            sb.append("\nAD_Dashboard_Access: (tabla no existe)");
        }
        return sb.toString();
    }

    private int resolveRoleIdByClientAndQuery(int clientId, String query) {
        String like = "%" + query.trim() + "%";
        String sql = "SELECT AD_Role_ID, Name FROM AD_Role WHERE AD_Client_ID=? AND (Name ILIKE ? OR COALESCE(Description,'') ILIKE ?) ORDER BY IsActive DESC, Name ";
        CPreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<String> names = new ArrayList<String>();
        try {
            ps = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            int i = 1;
            ps.setInt(i++, clientId);
            ps.setString(i++, like);
            ps.setString(i++, like);
            rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getInt(1));
                names.add(rs.getString(2));
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Error buscando rol por cliente: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)ps);
                rs = null;
                ps = null;
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)ps);
        rs = null;
        ps = null;
        return (Integer)ids.get(0);
    }

    private void cloneWindowAccess() {
        this.delWin = DB.executeUpdate((String)"DELETE FROM AD_Window_Access WHERE AD_Role_ID=?", (Object[])new Object[]{this.roleTarget_ID}, (boolean)false, (String)this.trxName);
        String sql = "INSERT INTO AD_Window_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, AD_Window_ID, IsReadWrite) SELECT ?, 0, 'Y', now(), ?, now(), ?, ?, awa.AD_Window_ID, awa.IsReadWrite FROM AD_Window_Access awa WHERE awa.AD_Role_ID=?";
        this.insWin = DB.executeUpdate((String)sql, (Object[])new Object[]{this.dstClientId, this.userId, this.userId, this.roleTarget_ID, this.p_RoleSource_ID}, (boolean)false, (String)this.trxName);
    }

    private void cloneProcessAccess() {
        this.delProc = DB.executeUpdate((String)"DELETE FROM AD_Process_Access WHERE AD_Role_ID=?", (Object[])new Object[]{this.roleTarget_ID}, (boolean)false, (String)this.trxName);
        String sql = "INSERT INTO AD_Process_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, AD_Process_ID, IsReadWrite) SELECT ?, 0, 'Y', now(), ?, now(), ?, ?, apa.AD_Process_ID, apa.IsReadWrite FROM AD_Process_Access apa WHERE apa.AD_Role_ID=?";
        this.insProc = DB.executeUpdate((String)sql, (Object[])new Object[]{this.dstClientId, this.userId, this.userId, this.roleTarget_ID, this.p_RoleSource_ID}, (boolean)false, (String)this.trxName);
    }

    private void cloneFormAccess() {
        this.delForm = DB.executeUpdate((String)"DELETE FROM AD_Form_Access WHERE AD_Role_ID=?", (Object[])new Object[]{this.roleTarget_ID}, (boolean)false, (String)this.trxName);
        String sqlWithRW = "INSERT INTO AD_Form_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, AD_Form_ID, IsReadWrite) SELECT ?, 0, 'Y', now(), ?, now(), ?, ?, afa.AD_Form_ID, COALESCE(afa.IsReadWrite,'Y') FROM AD_Form_Access afa WHERE afa.AD_Role_ID=?";
        try {
            this.insForm = DB.executeUpdate((String)sqlWithRW, (Object[])new Object[]{this.dstClientId, this.userId, this.userId, this.roleTarget_ID, this.p_RoleSource_ID}, (boolean)false, (String)this.trxName);
        }
        catch (Exception ex) {
            String sqlNoRW = "INSERT INTO AD_Form_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, AD_Form_ID) SELECT ?, 0, 'Y', now(), ?, now(), ?, ?, afa.AD_Form_ID FROM AD_Form_Access afa WHERE afa.AD_Role_ID=?";
            this.insForm = DB.executeUpdate((String)sqlNoRW, (Object[])new Object[]{this.dstClientId, this.userId, this.userId, this.roleTarget_ID, this.p_RoleSource_ID}, (boolean)false, (String)this.trxName);
        }
    }

    private void cloneBrowseAccess() {
        this.delBrowse = DB.executeUpdate((String)"DELETE FROM AD_Browse_Access WHERE AD_Role_ID=?", (Object[])new Object[]{this.roleTarget_ID}, (boolean)false, (String)this.trxName);
        String sql = "INSERT INTO AD_Browse_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, AD_Browse_ID, IsReadWrite) SELECT ?, 0, 'Y', now(), ?, now(), ?, ?, aba.AD_Browse_ID, COALESCE(aba.IsReadWrite,'Y') FROM AD_Browse_Access aba WHERE aba.AD_Role_ID=?";
        this.insBrowse = DB.executeUpdate((String)sql, (Object[])new Object[]{this.dstClientId, this.userId, this.userId, this.roleTarget_ID, this.p_RoleSource_ID}, (boolean)false, (String)this.trxName);
    }

    private void cloneWorkflowAccess() {
        this.delWf = DB.executeUpdate((String)"DELETE FROM AD_Workflow_Access WHERE AD_Role_ID=?", (Object[])new Object[]{this.roleTarget_ID}, (boolean)false, (String)this.trxName);
        String sql = "INSERT INTO AD_Workflow_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, AD_Workflow_ID) SELECT ?, 0, 'Y', now(), ?, now(), ?, ?, awa.AD_Workflow_ID FROM AD_Workflow_Access awa WHERE awa.AD_Role_ID=?";
        this.insWf = DB.executeUpdate((String)sql, (Object[])new Object[]{this.dstClientId, this.userId, this.userId, this.roleTarget_ID, this.p_RoleSource_ID}, (boolean)false, (String)this.trxName);
    }

    private void cloneDashboardAccess() {
        this.delDash = DB.executeUpdate((String)"DELETE FROM AD_Dashboard_Access WHERE AD_Role_ID=?", (Object[])new Object[]{this.roleTarget_ID}, (boolean)false, (String)this.trxName);
        String sql = "INSERT INTO AD_Dashboard_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, PA_DashboardContent_ID) SELECT ?, 0, 'Y', now(), ?, now(), ?, ?, ada.PA_DashboardContent_ID FROM AD_Dashboard_Access ada WHERE ada.AD_Role_ID=?";
        this.insDash = DB.executeUpdate((String)sql, (Object[])new Object[]{this.dstClientId, this.userId, this.userId, this.roleTarget_ID, this.p_RoleSource_ID}, (boolean)false, (String)this.trxName);
    }

    private boolean checkDashboardTable() {
        String sql = "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = current_schema() AND LOWER(table_name) = 'ad_dashboard_access'";
        int cnt = DB.getSQLValue((String)this.trxName, (String)sql);
        return cnt > 0;
    }
}

