/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessCreateAdvanceInvoiceFromProject
extends SvrProcess {
    private String p_ChargeKey = "Anticipo contrato";
    private String ARI_TARGET_NAME = "Factura Venta Afecta";
    private int p_C_Order_ID = 0;

    protected void prepare() {
        this.p_C_Order_ID = this.getRecord_ID();
        for (ProcessInfoParameter p : this.getParameter()) {
            String name = p.getParameterName();
            if (!"ChargeKey".equalsIgnoreCase(name) || p.getParameter() == null) continue;
            this.p_ChargeKey = String.valueOf(p.getParameter()).trim();
        }
    }

    protected String doIt() throws Exception {
        String trxName;
        if (this.p_C_Order_ID <= 0) {
            return "No hay C_Order_ID en contexto.";
        }
        Properties ctx = this.getCtx();
        MOrder order = new MOrder(ctx, this.p_C_Order_ID, trxName = this.get_TrxName());
        if (order.get_ID() <= 0) {
            return "No se encontr\u00f3 la orden.";
        }
        if (!order.isSOTrx()) {
            return "La orden no es de venta";
        }
        int C_Project_ID = order.getC_Project_ID();
        if (C_Project_ID <= 0) {
            return "La orden no est\u00e1 asociada a un proyecto.";
        }
        MProject project = new MProject(ctx, C_Project_ID, trxName);
        if (project.get_ID() <= 0) {
            return "No se encontr\u00f3 el proyecto vinculado.";
        }
        int adClientId = order.getAD_Client_ID();
        int C_Charge_ID = this.findChargeIdByKeyword(this.getCtx(), adClientId, this.p_ChargeKey);
        if (C_Charge_ID <= 0) {
            return "No se encontr\u00f3 C_Charge con  '" + this.p_ChargeKey + "'.";
        }
        if (this.existsClosedAdvanceInvoiceWithAllLines(order, C_Project_ID, C_Charge_ID)) {
            return "Ya existe una factura de anticipo finalizada y todas las l\u00edneas est\u00e1n facturadas. No se crea otra.";
        }
        boolean createdHeader = false;
        MInvoice invoice = this.findExistingAdvanceInvoice(order);
        if (invoice == null) {
            invoice = this.createAdvanceInvoiceHeader(order, C_Project_ID);
            createdHeader = true;
        }
        this.ensureBPartnerLocation(invoice, order, trxName);
        MPriceList pl = new MPriceList(ctx, order.getM_PriceList_ID(), trxName);
        int precision = pl.getPricePrecision();
        String sql = "SELECT pl.C_ProjectLine_ID, pl.M_Product_ID,        COALESCE(pl.PlannedAmt,0) AS PlannedAmt,        COALESCE(pl.AJ_PctAdvance,0) AS PctAdv FROM C_ProjectLine pl WHERE pl.C_Project_ID = ? ORDER BY pl.C_ProjectLine_ID";
        int addedLines = 0;
        BigDecimal totalAdded = BigDecimal.ZERO;
        try (CPreparedStatement ps = DB.prepareStatement((String)sql, (String)trxName);){
            ps.setInt(1, C_Project_ID);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String prodName;
                    int C_ProjectLine_ID = rs.getInt("C_ProjectLine_ID");
                    int M_Product_ID = rs.getInt("M_Product_ID");
                    BigDecimal plannedAmt = rs.getBigDecimal("PlannedAmt");
                    BigDecimal pctAdv = rs.getBigDecimal("PctAdv");
                    if (plannedAmt == null) {
                        plannedAmt = BigDecimal.ZERO;
                    }
                    if (pctAdv == null) {
                        pctAdv = BigDecimal.ZERO;
                    }
                    if (pctAdv.signum() <= 0 || plannedAmt.signum() <= 0) continue;
                    if (this.existsAdvanceLine(order.getC_Order_ID(), C_ProjectLine_ID, C_Charge_ID)) {
                        this.log.info("Salta PL=" + C_ProjectLine_ID + " (ya existe l\u00ednea de anticipo)");
                        continue;
                    }
                    BigDecimal amt = plannedAmt.multiply(pctAdv).divide(new BigDecimal("100"), precision, RoundingMode.HALF_UP).abs();
                    MInvoiceLine il = new MInvoiceLine(invoice);
                    il.setC_Charge_ID(C_Charge_ID);
                    il.setQty(Env.ONE);
                    il.setPriceEntered(amt);
                    il.setPriceActual(amt);
                    il.setC_Project_ID(C_Project_ID);
                    try {
                        il.set_ValueOfColumn("C_ProjectLine_ID", (Object)C_ProjectLine_ID);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String desc = prodName = M_Product_ID > 0 ? new MProduct(ctx, M_Product_ID, trxName).getName() : "Producto N/D";
                    il.setDescription(desc);
                    il.setLineNetAmt();
                    il.saveEx();
                    ++addedLines;
                    totalAdded = totalAdded.add(amt);
                }
            }
        }
        if (addedLines == 0 && createdHeader) {
            invoice.delete(true);
            return "No hay l\u00edneas de anticipo faltantes. (Nada que crear)";
        }
        invoice.setDescription(this.appendDesc(invoice.getDescription(), "Factura de anticipo por proyecto: " + project.getValue() + " - " + project.getName()));
        invoice.saveEx();
        if (addedLines > 0) {
            return "Factura de anticipo " + (createdHeader ? "CREADA" : "ACTUALIZADA") + " -> " + invoice.getDocumentNo() + " | L\u00edneas a\u00f1adidas: " + addedLines + " | Monto agregado (sin impuestos): " + totalAdded.toPlainString();
        }
        return "No hay l\u00edneas faltantes: la factura de anticipo ya tiene todas las l\u00edneas. DocNo=" + invoice.getDocumentNo();
    }

    private MInvoice findExistingAdvanceInvoice(MOrder order) {
        String poRef = this.buildAdvancePORef(order);
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE IsActive='Y' AND IsSOTrx='Y'   AND C_Order_ID=? AND POReference=?   AND DocStatus IN ('DR','IP') ORDER BY C_Invoice_ID DESC LIMIT 1";
        int invId = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)order.getC_Order_ID(), (String)poRef);
        if (invId > 0) {
            return new MInvoice(this.getCtx(), invId, this.get_TrxName());
        }
        return null;
    }

    private boolean existsClosedAdvanceInvoiceWithAllLines(MOrder order, int C_Project_ID, int C_Charge_ID) {
        String poRef = this.buildAdvancePORef(order);
        String sqlHasClosed = "SELECT 1 FROM C_Invoice WHERE IsActive='Y' AND IsSOTrx='Y'   AND C_Order_ID=? AND POReference=?   AND DocStatus IN ('CO','CL','RE') LIMIT 1";
        int hasClosed = DB.getSQLValue((String)this.get_TrxName(), (String)sqlHasClosed, (int)order.getC_Order_ID(), (String)poRef);
        if (hasClosed != 1) {
            return false;
        }
        String sqlMissing = "SELECT COUNT(*) FROM C_ProjectLine pl WHERE pl.C_Project_ID=?   AND COALESCE(pl.AJ_PctAdvance,0) > 0   AND COALESCE(pl.PlannedAmt,0)    > 0   AND NOT EXISTS (         SELECT 1         FROM C_Invoice i         JOIN C_InvoiceLine il ON (il.C_Invoice_ID=i.C_Invoice_ID)         WHERE i.IsActive='Y' AND i.IsSOTrx='Y'           AND i.C_Order_ID=?           AND i.DocStatus IN ('DR','IP','CO','CL','RE')           AND il.C_Charge_ID=?           AND COALESCE(CAST(il.C_ProjectLine_ID AS INTEGER),0)=pl.C_ProjectLine_ID   )";
        int missing = DB.getSQLValue((String)this.get_TrxName(), (String)sqlMissing, (Object[])new Object[]{C_Project_ID, order.getC_Order_ID(), C_Charge_ID});
        return missing == 0;
    }

    private MInvoice createAdvanceInvoiceHeader(MOrder order, int C_Project_ID) {
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        invoice.setClientOrg(order.getAD_Client_ID(), order.getAD_Org_ID());
        invoice.setIsSOTrx(true);
        invoice.setC_BPartner_ID(order.getC_BPartner_ID());
        invoice.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        invoice.setAD_User_ID(order.getAD_User_ID());
        invoice.setSalesRep_ID(order.getSalesRep_ID());
        int dtTargetId = this.findDocTypeIdByName(order.getAD_Client_ID(), this.ARI_TARGET_NAME);
        if (dtTargetId > 0) {
            invoice.setC_DocTypeTarget_ID(dtTargetId);
        }
        invoice.setDateInvoiced(order.getDateOrdered());
        invoice.setDateAcct(order.getDateAcct());
        invoice.setM_PriceList_ID(order.getM_PriceList_ID());
        invoice.setC_Currency_ID(order.getC_Currency_ID());
        invoice.setC_Project_ID(C_Project_ID);
        invoice.setC_Order_ID(order.getC_Order_ID());
        invoice.setPOReference(this.buildAdvancePORef(order));
        invoice.saveEx();
        return invoice;
    }

    private void ensureBPartnerLocation(MInvoice invoice, MOrder order, String trxName) {
        if (invoice.getC_BPartner_Location_ID() > 0) {
            return;
        }
        int bpLoc = DB.getSQLValue((String)trxName, (String)"SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_BPartner_ID=? AND IsActive='Y' ORDER BY IsBillTo DESC, IsShipTo DESC, Created ASC LIMIT 1", (int)order.getC_BPartner_ID());
        if (bpLoc > 0) {
            invoice.setC_BPartner_Location_ID(bpLoc);
            invoice.saveEx();
        }
    }

    private String buildAdvancePORef(MOrder order) {
        Object docno = order.getDocumentNo() != null ? order.getDocumentNo() : "ORD-" + order.getC_Order_ID();
        return "ADV-" + (String)docno;
    }

    private boolean existsAdvanceLine(int C_Order_ID, int C_ProjectLine_ID, int C_Charge_ID) {
        String sql = "SELECT 1 FROM C_InvoiceLine il JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE i.IsActive='Y' AND i.IsSOTrx='Y'   AND i.C_Order_ID=?   AND il.C_Charge_ID=?   AND COALESCE(CAST(il.C_ProjectLine_ID AS INTEGER),0)=?   AND i.DocStatus IN ('DR','IP','CO','CL','RE') LIMIT 1";
        int one = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT 1 FROM C_InvoiceLine il JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE i.IsActive='Y' AND i.IsSOTrx='Y'   AND i.C_Order_ID=?   AND il.C_Charge_ID=?   AND COALESCE(CAST(il.C_ProjectLine_ID AS INTEGER),0)=?   AND i.DocStatus IN ('DR','IP','CO','CL','RE') LIMIT 1", (Object[])new Object[]{C_Order_ID, C_Charge_ID, C_ProjectLine_ID});
        return one == 1;
    }

    private int findChargeIdByKeyword(Properties ctx, int adClientId, String keyword) {
        Integer id = this.queryChargeId(adClientId, keyword);
        if (id != null && id > 0) {
            return id;
        }
        id = this.queryChargeId(0, keyword);
        return id != null ? id : 0;
    }

    private Integer queryChargeId(int adClientId, String keyword) {
        String like = "%" + keyword.toLowerCase() + "%";
        String sql = "SELECT c_charge_id FROM c_charge WHERE isactive='Y' AND ad_client_id=?   AND ( lower(COALESCE(description,'')) LIKE ?      OR lower(COALESCE(name,''))        LIKE ? ) ORDER BY c_charge_id ASC LIMIT 1";
        return DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT c_charge_id FROM c_charge WHERE isactive='Y' AND ad_client_id=?   AND ( lower(COALESCE(description,'')) LIKE ?      OR lower(COALESCE(name,''))        LIKE ? ) ORDER BY c_charge_id ASC LIMIT 1", (Object[])new Object[]{adClientId, like, like});
    }

    private int findDocTypeIdByName(int adClientId, String name) {
        String sql = "SELECT dt.C_DocType_ID FROM C_DocType dt WHERE dt.IsActive='Y'   AND dt.AD_Client_ID IN (?,0)   AND LOWER(dt.Name) = LOWER(?) ORDER BY dt.C_DocType_ID ASC LIMIT 1";
        return DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT dt.C_DocType_ID FROM C_DocType dt WHERE dt.IsActive='Y'   AND dt.AD_Client_ID IN (?,0)   AND LOWER(dt.Name) = LOWER(?) ORDER BY dt.C_DocType_ID ASC LIMIT 1", (int)adClientId, (String)name);
    }

    private String appendDesc(String base, String extra) {
        if (base == null || base.trim().isEmpty()) {
            return extra;
        }
        return base + " | " + extra;
    }
}

