/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.manufacturing.model.MPPProductBOMLine;

public class EKProcessCreateProductionMovement
extends SvrProcess {
    private boolean p_AutoComplete = false;
    private Properties ctx;
    private String trxName;
    private int p_M_Movement_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para;
        this.ctx = this.getCtx();
        this.trxName = this.get_TrxName();
        this.p_M_Movement_ID = this.getRecord_ID();
        for (ProcessInfoParameter p : para = this.getParameter()) {
            String name = p.getParameterName();
            if (name == null || !name.equalsIgnoreCase("AutoComplete")) continue;
            this.p_AutoComplete = "Y".equals(p.getParameter());
        }
    }

    protected String doIt() throws Exception {
        if (this.p_M_Movement_ID <= 0) {
            throw new AdempiereUserError("No hay registro de Movimiento.");
        }
        MMovement mov = new MMovement(this.ctx, this.p_M_Movement_ID, this.trxName);
        if (mov.get_ID() <= 0) {
            throw new AdempiereUserError("Movimiento no encontrado.");
        }
        if (!"CO".equals(mov.getDocStatus())) {
            throw new AdempiereUserError("El Movimiento debe estar COMPLETO para generar producci\u00f3n. ");
        }
        int prodDocTypeId = this.findProductionDocTypeId(mov);
        if (prodDocTypeId <= 0) {
            throw new AdempiereUserError("No se pudo resolver el Tipo de Documento de Producci\u00f3n (desempaque).");
        }
        List lines = new Query(this.ctx, "M_MovementLine", "M_Movement_ID=?", this.trxName).setParameters(new Object[]{this.p_M_Movement_ID}).setOrderBy("Line").list();
        if (lines.isEmpty()) {
            return "No hay l\u00edneas en el movimiento.";
        }
        int created = 0;
        int skippedNoBOM = 0;
        int skippedNoDest = 0;
        int skippedZeroQty = 0;
        int skippedNoUnpackBOM = 0;
        int skippedAlreadyLinked = 0;
        ArrayList<CallSite> noUnpackDetails = new ArrayList<CallSite>();
        Timestamp movementDate = mov.getMovementDate() != null ? mov.getMovementDate() : new Timestamp(System.currentTimeMillis());
        for (MMovementLine ml : lines) {
            BigDecimal qty;
            Integer existingProdId = (Integer)ml.get_Value("M_Production_ID");
            if (existingProdId != null && existingProdId > 0) {
                ++skippedAlreadyLinked;
                continue;
            }
            if (ml.getM_Product_ID() <= 0) continue;
            if (ml.getM_LocatorTo_ID() <= 0) {
                ++skippedNoDest;
                continue;
            }
            BigDecimal bigDecimal = qty = ml.getMovementQty() != null ? ml.getMovementQty() : Env.ZERO;
            if (qty.signum() == 0) {
                ++skippedZeroQty;
                continue;
            }
            MProduct parent = MProduct.get(this.ctx, ml.getM_Product_ID());
            boolean hasAny = this.hasAnyBom(mov.getAD_Client_ID(), parent.getM_Product_ID(), this.trxName);
            int ppBOM_ID = this.getUnpackBomId(mov.getAD_Client_ID(), parent.getM_Product_ID(), this.trxName);
            if (ppBOM_ID <= 0) {
                if (hasAny) {
                    ++skippedNoUnpackBOM;
                    noUnpackDetails.add((CallSite)((Object)(parent.getValue() + " - " + parent.getName())));
                    continue;
                }
                ++skippedNoBOM;
                continue;
            }
            List bomLines = new Query(this.ctx, "PP_Product_BOMLine", "PP_Product_BOM_ID=?", this.trxName).setParameters(new Object[]{ppBOM_ID}).list();
            if (bomLines.isEmpty()) {
                ++skippedNoBOM;
                continue;
            }
            MProduction prod = new MProduction(this.ctx, 0, this.trxName);
            prod.setAD_Org_ID(mov.getAD_Org_ID());
            prod.setC_DocType_ID(prodDocTypeId);
            prod.setM_Product_ID(parent.getM_Product_ID());
            prod.set_ValueOfColumn("pp_product_bom_id", ppBOM_ID);
            prod.setM_Locator_ID(ml.getM_LocatorTo_ID());
            prod.set_ValueOfColumn("PackOutQty", qty);
            prod.setMovementDate(movementDate);
            prod.setDescription(this.buildProdDescription(mov, ml, parent));
            prod.setIsCreated(true);
            prod.saveEx();
            ml.set_ValueOfColumn("M_Production_ID", (Object)prod.getM_Production_ID());
            ml.saveEx();
            MProductionLine plParent = new MProductionLine(this.ctx, 0, this.trxName);
            plParent.setAD_Org_ID(prod.getAD_Org_ID());
            plParent.setM_Production_ID(prod.getM_Production_ID());
            plParent.setM_Product_ID(parent.getM_Product_ID());
            plParent.setM_Locator_ID(ml.getM_LocatorTo_ID());
            plParent.setMovementQty(qty.negate());
            plParent.setDescription("Consumo del padre ");
            plParent.saveEx();
            for (MPPProductBOMLine bl : bomLines) {
                if (bl.getM_Product_ID() <= 0) continue;
                BigDecimal bomQty = bl.getQty() != null ? bl.getQty() : Env.ONE;
                BigDecimal compQty = bomQty.multiply(qty);
                MProductionLine plComp = new MProductionLine(this.ctx, 0, this.trxName);
                plComp.setAD_Org_ID(prod.getAD_Org_ID());
                plComp.setM_Production_ID(prod.getM_Production_ID());
                plComp.setM_Product_ID(bl.getM_Product_ID());
                plComp.setM_Locator_ID(ml.getM_LocatorTo_ID());
                plComp.setMovementQty(compQty);
                plComp.setDescription("Ingreso componente ");
                plComp.saveEx();
            }
            if (!prod.processIt("PR")) {
                throw new AdempiereUserError("No se pudo preparar Producci\u00f3n " + prod.getDocumentNo() + " - " + prod.getProcessMsg());
            }
            prod.saveEx();
            int srcAsiId = this.resolveASIFromMovementLine(ml);
            List linesAfter = new Query(this.ctx, "M_ProductionLine", "M_Production_ID=?", this.trxName).setParameters(new Object[]{prod.getM_Production_ID()}).setOrderBy("Line").list();
            int targetSetIdParent = parent.getM_AttributeSet_ID();
            if (targetSetIdParent > 0) {
                int newAsiParent = this.createNewASIFromSource(this.ctx, targetSetIdParent, srcAsiId, prod.getAD_Org_ID(), this.trxName);
                for (MProductionLine l : linesAfter) {
                    if (l.getM_Product_ID() != parent.getM_Product_ID() || l.getMovementQty().signum() >= 0) continue;
                    l.setM_AttributeSetInstance_ID(newAsiParent);
                    l.set_CustomColumn("AJ_AttributeSetInstance_ID", newAsiParent);
                    l.saveEx();
                    break;
                }
            }
            for (MProductionLine l : linesAfter) {
                int compSetId;
                if (l.getM_Product_ID() == parent.getM_Product_ID() || l.getMovementQty().signum() <= 0 || (compSetId = MProduct.get(this.ctx, l.getM_Product_ID()).getM_AttributeSet_ID()) <= 0) continue;
                int compAsi = this.createNewASIFromSource(this.ctx, compSetId, srcAsiId, prod.getAD_Org_ID(), this.trxName);
                l.setM_AttributeSetInstance_ID(compAsi);
                l.set_CustomColumn("AJ_AttributeSetInstance_ID", compAsi);
                l.saveEx();
            }
            if (this.p_AutoComplete) {
                prod.setDocAction("CO");
                if (!prod.processIt("CO")) {
                    throw new AdempiereUserError("No se pudo completar Producci\u00f3n " + prod.getDocumentNo() + " - " + prod.getProcessMsg());
                }
                prod.saveEx();
            }
            ++created;
        }
        StringBuilder msg = new StringBuilder("Producciones creadas: ").append(created);
        if (skippedAlreadyLinked > 0) {
            msg.append(" | L\u00edneas ya vinculadas a producci\u00f3n: ").append(skippedAlreadyLinked);
        }
        if (skippedNoDest > 0) {
            msg.append(" | L\u00edneas sin destino: ").append(skippedNoDest);
        }
        if (skippedZeroQty > 0) {
            msg.append(" | L\u00edneas con qty=0: ").append(skippedZeroQty);
        }
        if (skippedNoBOM > 0) {
            msg.append(" | Productos sin LdM: ").append(skippedNoBOM);
        }
        if (skippedNoUnpackBOM > 0) {
            msg.append(" | Productos sin LdM para 'desempaque': ").append(skippedNoUnpackBOM);
            int max = Math.min(10, noUnpackDetails.size());
            if (max > 0) {
                msg.append(" -> ").append(String.join((CharSequence)", ", noUnpackDetails.subList(0, max)));
                if (noUnpackDetails.size() > max) {
                    msg.append(" (+").append(noUnpackDetails.size() - max).append(" m\u00e1s)");
                }
            }
        }
        return msg.toString();
    }

    private int findProductionDocTypeId(MMovement mov) {
        Integer id = new Query(this.ctx, "C_DocType", "AD_Client_ID IN (0, ?) AND (Name ILIKE ? OR Description ILIKE ?)", this.trxName).setParameters(new Object[]{mov.getAD_Client_ID(), "%desempaque%", "%desempaque%"}).setOrderBy("AD_Client_ID DESC, IsDefault DESC").firstId();
        if (id != null && id > 0) {
            return id;
        }
        return id;
    }

    private boolean hasAnyBom(int adClientId, int productId, String trxName) {
        String sql = "SELECT 1 FROM pp_product_bom WHERE IsActive='Y'   AND m_product_id=?   AND AD_Client_ID IN (0, ?) ";
        int exists = DB.getSQLValue((String)trxName, (String)"SELECT 1 FROM pp_product_bom WHERE IsActive='Y'   AND m_product_id=?   AND AD_Client_ID IN (0, ?) ", (int)productId, (int)adClientId);
        return exists == 1;
    }

    private int getUnpackBomId(int adClientId, int productId, String trxName) {
        String sql = "SELECT pp_product_bom_id FROM pp_product_bom WHERE IsActive='Y'   AND m_product_id = ?   AND DocumentNo ILIKE ?    AND AD_Client_ID IN (0, ?) ORDER BY AD_Client_ID DESC, Updated DESC, pp_product_bom_id DESC ";
        return DB.getSQLValue((String)trxName, (String)"SELECT pp_product_bom_id FROM pp_product_bom WHERE IsActive='Y'   AND m_product_id = ?   AND DocumentNo ILIKE ?    AND AD_Client_ID IN (0, ?) ORDER BY AD_Client_ID DESC, Updated DESC, pp_product_bom_id DESC ", (Object[])new Object[]{productId, "%desempaque%", adClientId});
    }

    private int resolveASIFromMovementLine(MMovementLine ml) {
        int asiId = ml.getM_AttributeSetInstanceTo_ID();
        if (asiId > 0) {
            return asiId;
        }
        asiId = ml.getM_AttributeSetInstance_ID();
        if (asiId > 0) {
            return asiId;
        }
        String sql = "SELECT t.M_AttributeSetInstance_ID FROM M_Transaction t WHERE t.M_MovementLine_ID = ? ORDER BY t.Created DESC";
        int tAsi = DB.getSQLValue((String)this.trxName, (String)sql, (int)ml.getM_MovementLine_ID());
        return tAsi > 0 ? tAsi : 0;
    }

    private int createNewASIFromSource(Properties ctx, int targetSetId, int srcAsiId, int adOrgId, String trxName) {
        String lot = null;
        String serNo = null;
        String descr = null;
        Timestamp gdate = null;
        if (srcAsiId > 0) {
            MAttributeSetInstance src = new MAttributeSetInstance(ctx, srcAsiId, trxName);
            lot = src.getLot();
            gdate = src.getGuaranteeDate();
            serNo = src.getSerNo();
            descr = src.getDescription();
        }
        MAttributeSetInstance dst = new MAttributeSetInstance(ctx, 0, trxName);
        dst.setAD_Org_ID(adOrgId);
        dst.setM_AttributeSet_ID(targetSetId);
        if (lot != null) {
            dst.setLot(lot);
        }
        if (gdate != null) {
            dst.setGuaranteeDate(gdate);
        }
        if (serNo != null) {
            dst.setSerNo(serNo);
        }
        if (descr != null) {
            dst.setDescription(descr);
        }
        dst.saveEx();
        return dst.getM_AttributeSetInstance_ID();
    }

    private String buildProdDescription(MMovement mov, MMovementLine ml, MProduct parent) {
        StringBuilder sb = new StringBuilder();
        sb.append("Desempaque auto desde Movimiento ").append(mov.getDocumentNo() == null ? Integer.valueOf(mov.get_ID()) : mov.getDocumentNo()).append(" / L\u00ednea ").append(ml.getLine()).append(" / Producto ").append(parent.getValue()).append(" - ").append(parent.getName());
        return sb.toString();
    }
}

