/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class EKProcessCreditNoteFromInvoice
extends SvrProcess {
    private int p_C_Invoice_ID = 0;
    private String refCod;
    private String reasonRef;
    private boolean p_ReturnMaterial = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String pname = para[i].getParameterName();
            if ("AJ_CodRef".equals(pname)) {
                this.refCod = (String)para[i].getParameter();
                continue;
            }
            if ("AJ_ReasonRef".equals(pname)) {
                this.reasonRef = (String)para[i].getParameter();
                continue;
            }
            if ("EK_ReturnMaterial".equals(pname)) {
                Object v = para[i].getParameter();
                this.p_ReturnMaterial = "Y".equalsIgnoreCase(String.valueOf(v));
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + pname);
        }
        this.p_C_Invoice_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, this.get_TrxName());
        if (!inv.getDocStatus().equals("CO")) {
            return "Documento debe estar completo para crear NC";
        }
        int docTypeId = this.findDocTypeForNC(this.p_ReturnMaterial, inv.getAD_Client_ID(), inv.getAD_Org_ID());
        if (docTypeId <= 0) {
            if (this.p_ReturnMaterial) {
                throw new AdempiereException("No existe Tipo de Documento 'Nota de Cr\u00e9dito Devoluci\u00f3n'");
            }
            throw new AdempiereException("No existe Tipo de Documento 'Nota de Credito'");
        }
        Date date = new Date();
        Timestamp hoy = new Timestamp(date.getTime());
        boolean copyLines = !"2".equals(this.refCod);
        MInvoice nc = MInvoice.copyFrom(inv, hoy, hoy, docTypeId, inv.isSOTrx(), copyLines, false, this.get_TrxName(), true);
        if (!"2".equals(this.refCod)) {
            EKProcessCreditNoteFromInvoice.fixCopiedLinesASI(inv, nc);
            nc.saveEx();
        }
        nc.setPOReference(null);
        nc.setC_Order_ID(0);
        nc.set_CustomColumn("AJ_RefDoc_ID", inv.getC_Invoice_ID());
        nc.set_CustomColumn("AJ_CodRef", this.refCod);
        nc.set_CustomColumn("AJ_ReasonRef", this.reasonRef);
        nc.set_CustomColumn("AJ_PDFGDE", null);
        nc.set_CustomColumn("EK_DescriptionFEL", null);
        nc.saveEx();
        inv.set_CustomColumn("AJ_RefDoc_ID", nc.getC_Invoice_ID());
        inv.saveEx();
        if ("2".equals(this.refCod)) {
            for (MInvoiceLine line : nc.getLines()) {
                line.deleteEx(true);
            }
            int chargeID = MSysConfig.getIntValue((String)"EK_CORRECTION_TEXT", (int)0, (int)this.getAD_Client_ID());
            if (chargeID <= 0) {
                throw new IllegalStateException("No est\u00e1 configurado el par\u00e1metro EK_CORRECTION_TEXT");
            }
            MInvoiceLine newLine = new MInvoiceLine(nc);
            newLine.setC_Charge_ID(chargeID);
            BigDecimal precio = BigDecimal.ONE;
            newLine.setPriceActual(precio);
            newLine.setPriceEntered(precio);
            newLine.setQty(BigDecimal.ONE);
            newLine.setLineNetAmt(precio);
            newLine.saveEx();
        }
        inv.set_CustomColumn("AJ_RefDoc_ID", nc.getC_Invoice_ID());
        inv.saveEx();
        return "Se genera Nota de Cr\u00e9dito N\u00b0" + nc.getDocumentNo();
    }

    private int findDocTypeForNC(boolean isReturnMaterial, int adClientId, int adOrgId) {
        String baseName = "NOTA DE CREDITO";
        Object where = "AD_Client_ID=? AND IsActive='Y' AND translate(upper(Name), '\u00c1\u00c9\u00cd\u00d3\u00da\u00dc', 'AEIOUU') LIKE ? AND (AD_Org_ID=? OR AD_Org_ID=0)";
        where = isReturnMaterial ? (String)where + " AND translate(upper(Name), '\u00c1\u00c9\u00cd\u00d3\u00da\u00dc', 'AEIOUU') LIKE '%DEVOLUCION%'" : (String)where + " AND translate(upper(Name), '\u00c1\u00c9\u00cd\u00d3\u00da\u00dc', 'AEIOUU') NOT LIKE '%DEVOLUCION%'";
        String likeParam = baseName;
        Integer id = new Query(this.getCtx(), "C_DocType", (String)where, this.get_TrxName()).setParameters(new Object[]{adClientId, likeParam + "%", adOrgId}).setOrderBy("AD_Org_ID DESC").firstId();
        return id == null ? 0 : id;
    }

    private static void fixCopiedLinesASI(MInvoice invSrc, MInvoice invNC) {
        HashMap<Integer, MInvoiceLine> srcByLine = new HashMap<Integer, MInvoiceLine>();
        for (MInvoiceLine l : invSrc.getLines(false)) {
            srcByLine.put(l.getLine(), l);
        }
        for (MInvoiceLine ncLine : invNC.getLines(false)) {
            MInvoiceLine srcLine;
            if (ncLine.getM_Product_ID() <= 0 || ncLine.getM_AttributeSetInstance_ID() > 0 || (srcLine = (MInvoiceLine)srcByLine.get(ncLine.getLine())) == null) continue;
            int asiId = srcLine.getM_AttributeSetInstance_ID();
            if (asiId <= 0 && srcLine.getM_InOutLine_ID() > 0) {
                MInOutLine iol = new MInOutLine(invSrc.getCtx(), srcLine.getM_InOutLine_ID(), invSrc.get_TrxName());
                asiId = iol.getM_AttributeSetInstance_ID();
            }
            if (asiId <= 0) continue;
            ncLine.setM_AttributeSetInstance_ID(asiId);
            ncLine.saveEx();
        }
    }
}

