/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class EKProcessCurrencyConvertion
extends SvrProcess {
    private BigDecimal p_rate;
    private int p_C_Invoice_ID;
    private int p_M_PriceList_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("Rate")) {
                this.p_rate = para[i].getParameterAsBigDecimal();
                continue;
            }
            if (name.equals("M_PriceList_ID")) {
                this.p_M_PriceList_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_Invoice_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInvoiceLine[] lines;
        MInvoice inv = MInvoice.get(this.getCtx(), this.p_C_Invoice_ID);
        if (inv.getC_Currency_ID() == 228) {
            return null;
        }
        if (this.p_rate.compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("No se puede colocar tasa de conversion menor o igual a 0");
        }
        inv.setTotalLines(inv.getTotalLines().multiply(this.p_rate));
        inv.setGrandTotal(inv.getGrandTotal().multiply(this.p_rate));
        inv.setC_Currency_ID(228);
        inv.setM_PriceList_ID(this.p_M_PriceList_ID);
        inv.saveEx();
        for (MInvoiceLine line : lines = inv.getLines()) {
            line.setPriceEntered(line.getPriceEntered().multiply(this.p_rate));
            line.setPriceLimit(line.getPriceLimit().multiply(this.p_rate));
            line.setPriceList(line.getPriceList().multiply(this.p_rate));
            line.setPriceActual(line.getPriceActual().multiply(this.p_rate));
            line.setLineTotalAmt(line.getLineTotalAmt().multiply(this.p_rate));
            line.setTaxAmt(line.getTaxAmt().multiply(this.p_rate));
            line.setLineNetAmt(line.getLineNetAmt().multiply(this.p_rate));
            line.saveEx();
        }
        return "Procesado";
    }
}

