/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import DocumentoDTE.SiiDte.CampoStringA;
import DocumentoDTE.SiiDte.CdgItem;
import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.Detalle;
import DocumentoDTE.SiiDte.DocPersonalizadoA;
import DocumentoDTE.SiiDte.Documento;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.Encabezado;
import DocumentoDTE.SiiDte.IdDoc;
import DocumentoDTE.SiiDte.IdDoc_IndTraslado;
import DocumentoDTE.SiiDte.IdDoc_TipoDespacho;
import DocumentoDTE.SiiDte.ImpresionA;
import DocumentoDTE.SiiDte.PersonalizadosA;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.Referencia;
import DocumentoDTE.SiiDte.Referencia_CodRef;
import DocumentoDTE.SiiDte.Totales;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import com.liquid_technologies.ltxmllib12.exceptions.LtException;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.Servicio;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class EKProcessGDExpressDTEInOut
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_Inout_ID = 0;
    public String urlPdf = "";
    private String apiURL = "";
    private String apiAuth = "";
    private String ambiente;

    protected void prepare() {
        this.p_M_Inout_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInOut ship = new MInOut(this.m_ctx, this.p_M_Inout_ID, this.get_TrxName());
        MOrg org = new MOrg(this.getCtx(), ship.getAD_Org_ID(), this.get_TrxName());
        String msg = "";
        this.apiURL = MSysConfig.getValue((String)"DTEBoxServer", (String)"http://200.6.96.14/api/Core.svc/Core");
        this.apiAuth = MSysConfig.getValue((String)"DTEBoxPass", (String)"a497c198-a553-4ad0-8576-3cd227dc2f57");
        this.ambiente = org.get_ValueAsString("AJ_DTEBoxEnvironment");
        msg = this.CreateXML(ship);
        return msg;
    }

    public String CreateXML(MInOut inOut) {
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            DTEDefType dte = new DTEDefType();
            dte.setDTE_Choice(new DTE_Choice());
            MOrg org = MOrg.get((Properties)inOut.getCtx(), (int)inOut.getAD_Org_ID());
            MDocType docType = new MDocType(inOut.getCtx(), inOut.getC_DocType_ID(), inOut.get_TrxName());
            dte.getDTE_Choice().setDocumento(new Documento());
            Documento doc = dte.getDTE_Choice().getDocumento();
            doc.setEncabezado(new Encabezado());
            IdDoc idDoc = new IdDoc();
            if (docType.get_ValueAsString("EK_SIICode").compareTo("33") == 0) {
                idDoc.setTipoDTE(DTEType.n33);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("34") == 0) {
                idDoc.setTipoDTE(DTEType.n34);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("56") == 0) {
                idDoc.setTipoDTE(DTEType.n56);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("61") == 0) {
                idDoc.setTipoDTE(DTEType.n61);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("52") == 0) {
                idDoc.setTipoDTE(DTEType.n52);
            } else {
                throw new AdempiereException("Codigo SII no presente en tipo de documento");
            }
            idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(inOut.getDocumentNo())));
            idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(inOut.getMovementDate())));
            idDoc.setTipoDespacho(IdDoc_TipoDespacho.n2);
            String IndTrl = null;
            try {
                IndTrl = inOut.get_ValueAsString("AJ_TransferType");
            }
            catch (Exception e) {
                IndTrl = "01";
            }
            if (IndTrl == null || IndTrl == "" || IndTrl == " ") {
                IndTrl = "01";
            }
            if (IndTrl.compareTo("01") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n1);
            } else if (IndTrl.compareTo("02") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n2);
            } else if (IndTrl.compareTo("03") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n3);
            } else if (IndTrl.compareTo("04") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n4);
            } else if (IndTrl.compareTo("05") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n5);
            } else if (IndTrl.compareTo("06") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n6);
            } else if (IndTrl.compareTo("07") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n7);
            } else if (IndTrl.compareTo("08") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n8);
            } else if (IndTrl.compareTo("09") == 0) {
                idDoc.setIndTraslado(IdDoc_IndTraslado.n9);
            }
            doc.getEncabezado().setIdDoc(idDoc);
            Emisor emisor = new Emisor();
            emisor.setRUTEmisor((String)org.get_Value("EK_Value"));
            String nameRzn = org.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = org.getName();
            }
            emisor.setRznSoc(nameRzn);
            String giroEmisStr = (String)org.get_Value("EK_BusinessType");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            emisor.setGiroEmis(giroEmisStr);
            emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("EK_EconomicActivityCode"))));
            emisor.setDirOrigen((String)org.get_Value("EK_Address"));
            emisor.setCmnaOrigen((String)org.get_Value("EK_Commune"));
            emisor.setCiudadOrigen((String)org.get_Value("EK_City"));
            if (inOut.getSalesRep_ID() > 0) {
                emisor.setCdgVendedor(inOut.getSalesRep().getName());
            }
            doc.getEncabezado().setEmisor(emisor);
            MBPartner BP = new MBPartner(inOut.getCtx(), inOut.getC_BPartner_ID(), inOut.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(inOut.getCtx(), inOut.getC_BPartner_Location_ID(), inOut.get_TrxName());
            Receptor receptor = new Receptor();
            receptor.setRUTRecep(BP.getValue());
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptor.setRznSocRecep(RznSocRecepStr);
            String dirRecepStr = bloc.get_ValueAsString("Address1");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setDirRecep(dirRecepStr);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(inOut.getCtx(), bloc.get_ValueAsInt("C_City_ID"), inOut.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            String ciudadTxt = CmnaRecepStr;
            receptor.setCmnaRecep(CmnaRecepStr);
            int regionId = bloc.get_ValueAsInt("C_Region_ID");
            if (regionId == 1000002) {
                ciudadTxt = "Santiago";
            }
            receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
            receptor.setGiroRecep((String)BP.get_Value("EK_BusinessType"));
            String strContacto = bloc.get_ValueAsString("Phone");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setContacto(strContacto);
            doc.getEncabezado().setReceptor(receptor);
            BigDecimal amountGrandT = Env.ZERO;
            BigDecimal priceT = Env.ZERO;
            BigDecimal taxAmt = Env.ZERO;
            BigDecimal taxIVAAmt = Env.ZERO;
            BigDecimal taxIVAAmtAcu = Env.ZERO;
            BigDecimal taxExeAmtAcu = Env.ZERO;
            BigDecimal taxNetoAmtAcu = Env.ZERO;
            if (inOut.getC_Order_ID() > 0) {
                boolean taxIncluided = inOut.getC_Order().getM_PriceList().isTaxIncluded();
                MInOutLine[] iLines2 = inOut.getLines();
                for (int a = 0; a < iLines2.length; ++a) {
                    priceT = Env.ZERO;
                    taxAmt = Env.ZERO;
                    taxIVAAmt = Env.ZERO;
                    MInOutLine iLine = iLines2[a];
                    priceT = iLine.getC_OrderLine().getPriceEntered();
                    BigDecimal qtyO = iLine.getQtyEntered();
                    priceT = priceT.multiply(qtyO);
                    if (!taxIncluided) {
                        if (iLine.getC_OrderLine().getC_Tax_ID() > 0) {
                            if (iLine.getC_OrderLine().getC_Tax().getRate().compareTo(Env.ZERO) > 0) {
                                taxAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                                taxAmt = taxAmt.divide(Env.ONEHUNDRED);
                            }
                            if (iLine.getC_OrderLine().getC_Tax().isTaxExempt()) {
                                taxExeAmtAcu = taxExeAmtAcu.add(priceT);
                            }
                            if (iLine.getC_OrderLine().getC_Tax().getName().toUpperCase().contains("IVA") && iLine.getC_OrderLine().getC_Tax().getRate().compareTo(new BigDecimal("19.0")) == 0) {
                                taxIVAAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                                taxIVAAmt = taxIVAAmt.divide(Env.ONEHUNDRED);
                            }
                            taxNetoAmtAcu = taxNetoAmtAcu.add(priceT);
                        }
                    } else {
                        taxIVAAmt = priceT.multiply(new BigDecimal(0.19)).divide(new BigDecimal(1.19), 2, RoundingMode.HALF_UP).setScale(0, RoundingMode.HALF_UP);
                        taxNetoAmtAcu = taxNetoAmtAcu.add(priceT).subtract(taxIVAAmt);
                    }
                    amountGrandT = amountGrandT.add(priceT.add(taxAmt));
                    taxIVAAmtAcu = taxIVAAmtAcu.add(taxIVAAmt);
                }
            }
            if (taxNetoAmtAcu.compareTo(amountGrandT.subtract(taxIVAAmtAcu)) != 0) {
                taxNetoAmtAcu = amountGrandT.subtract(taxIVAAmtAcu);
            }
            Totales totales = new Totales();
            totales.setMntTotal(amountGrandT.toBigInteger());
            totales.setMntNeto(taxNetoAmtAcu.toBigInteger());
            totales.setMntExe(taxExeAmtAcu.toBigInteger());
            if (taxNetoAmtAcu.signum() > 0) {
                totales.setTasaIVA(BigDecimal.valueOf(19L));
            }
            BigDecimal ivaamt = Env.ZERO;
            totales.setIVA(taxIVAAmtAcu.toBigInteger());
            doc.getEncabezado().setTotales(totales);
            MInOutLine[] iLines = inOut.getLines(false);
            int lineInvoice = 0;
            boolean lineDiscount = false;
            for (int i = 0; i < iLines.length; ++i) {
                String refList;
                MInOutLine iLine = iLines[i];
                if (iLine.getM_Product_ID() == 0 && iLine.getC_Charge_ID() == 0) continue;
                ++lineInvoice;
                Detalle det = new Detalle();
                CdgItem cdgItem = new CdgItem();
                cdgItem.setTpoCodigo("INT1");
                cdgItem.setVlrCodigo(iLine.getProduct().getValue());
                det.getCdgItem().add(cdgItem);
                det.setNroLinDet(BigInteger.valueOf(lineInvoice));
                String pname = "";
                if (iLine.getProduct() == null) continue;
                pname = iLine.getProduct().getName();
                if (pname == null || pname.length() < 1) {
                    pname = iLine.getC_Charge().getName();
                }
                if ((refList = MRefList.getListName((Properties)this.m_ctx, (int)2000008, (String)iLine.get_ValueAsString("AJ_NameOverride"))).length() > 0) {
                    pname = refList;
                }
                pname = pname.replace("'", "");
                pname = pname.replace("\"", "");
                det.setNmbItem(pname);
                det.setQtyItem(iLine.getMovementQty());
                boolean taxIncluided = iLine.getC_OrderLine().getC_Order().getM_PriceList().isTaxIncluded();
                BigDecimal mtoItem = Env.ZERO;
                BigDecimal prcRefMnt = Env.ZERO;
                BigDecimal qtyMovement = iLine.getQtyEntered();
                if (iLine.getC_OrderLine_ID() > 0) {
                    if (!taxIncluided) {
                        prcRefMnt = iLine.getC_OrderLine().getPriceEntered();
                        mtoItem = this.roundToFourDecimal(prcRefMnt.multiply(qtyMovement));
                    } else {
                        MTax tax = MTax.get((Properties)this.getCtx(), (int)iLine.getC_OrderLine().getC_Tax_ID());
                        prcRefMnt = iLine.getC_OrderLine().getPriceEntered();
                        BigDecimal taxItemAmt = tax.calculateTax(prcRefMnt, true, iLine.getC_OrderLine().getC_Order().getC_Currency().getStdPrecision());
                        prcRefMnt = prcRefMnt.subtract(taxItemAmt);
                        mtoItem = this.roundToFourDecimal(prcRefMnt.multiply(qtyMovement));
                    }
                }
                det.setPrcItem(this.roundToFourDecimal(prcRefMnt));
                det.setMontoItem(mtoItem.setScale(0, 4).toBigInteger());
                if (iLine.getDescription() != null && iLine.getDescription() != "" && inOut.getC_DocType().getDocBaseType().compareTo("ARC") != 0) {
                    det.setDscItem(iLine.getDescription() == null ? " " : iLine.getDescription());
                }
                String unmdItemStr = "";
                unmdItemStr = iLine.getM_Product_ID() > 0 ? iLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                if (unmdItemStr == null) {
                    unmdItemStr = "UN";
                }
                det.setUnmdItem(unmdItemStr);
                doc.getDetalle().add(det);
            }
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (inOut.getPOReference() != null && inOut.getPOReference().length() > 1 && inOut.getC_DocType().getDocBaseType().compareTo("ARC") != 0 && inOut.getPOReference().compareTo(".") != 0) {
                tiporeferencia = "801";
                folioreferencia = inOut.getPOReference();
                fechareferencia = inOut.getDateOrdered() != null ? this.ConverDateToString(inOut.getDateOrdered()) : this.ConverDateToString(inOut.getMovementDate());
                tipo_Ref = 2;
            }
            int indice = 0;
            if (tipo_Ref > 0) {
                ++indice;
                Referencia reference = new Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(indice));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    reference.setCodRef(Referencia_CodRef.n1);
                    String razonRefTxt = inOut.get_ValueAsString("AJ_ReasonRef");
                    if (razonRefTxt != null && razonRefTxt.trim().length() > 1) {
                        reference.setRazonRef(razonRefTxt);
                    }
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if (inOut.getC_Order_ID() > 0) {
                MOrder refdoc = new MOrder(inOut.getCtx(), inOut.getC_Order_ID(), inOut.get_TrxName());
                tiporeferencia = "802";
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getDateOrdered());
                tipo_Ref = 4;
                ++indice;
                Referencia reference = new Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(indice));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    reference.setCodRef(Referencia_CodRef.n1);
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            PersonalizadosA personalizados = new PersonalizadosA();
            dte.setPersonalizados(personalizados);
            if (inOut.getDescription() != null) {
                personalizados.setDocPersonalizado(new DocPersonalizadoA());
                CampoStringA campoString = new CampoStringA();
                campoString.setName("Notas");
                campoString.setPrimitiveValue(inOut.getDescription());
                personalizados.getDocPersonalizado().getCampoString().add(campoString);
            }
            ImpresionA impresion = new ImpresionA();
            personalizados.getDocPersonalizado().setImpresion(impresion);
            if (inOut.getSalesRep_ID() > 0) {
                impresion.setPersonalizado_02(inOut.getSalesRep().getC_BPartner().getName() == null ? inOut.getSalesRep().getName() : inOut.getSalesRep().getC_BPartner().getName());
            }
            String fechaResolucion = "2014-08-22";
            int numeroResolucion = 80;
            int tipoPdf417 = 1;
            Servicio servicio = new Servicio(this.apiURL, this.apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, this.ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            dte.toXml();
            this.log.config("dte " + dte.toXml());
            this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
                error = "DTE Enviado con Exito";
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
            inOut.set_CustomColumn("AJ_DescriptionGDE", error);
            inOut.saveEx(inOut.get_TrxName());
        }
        catch (Exception e) {
            this.log.config(e.toString());
            error = e.toString();
        }
        return "Procesado " + error + " - " + ted + " - " + pdf417;
    }

    public String ConverDateToString(Timestamp fecha) {
        Object dateReturn = "";
        this.log.config("month" + fecha.getMonth() + "1");
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }

    private BigDecimal roundToFourDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        BigDecimal rounded = value.setScale(4, RoundingMode.HALF_UP);
        if ((rounded = rounded.stripTrailingZeros()).scale() < 0) {
            rounded = rounded.setScale(0);
        }
        return rounded;
    }
}

