/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import DocumentoBoleta.SiiDte.BOLETADefType;
import DocumentoBoleta.SiiDte.Detalle;
import DocumentoBoleta.SiiDte.Documento;
import DocumentoBoleta.SiiDte.DscRcgGlobal_TpoMov;
import DocumentoBoleta.SiiDte.DscRcgGlobal_TpoValor;
import DocumentoBoleta.SiiDte.Encabezado;
import DocumentoBoleta.SiiDte.IdDoc;
import DocumentoBoleta.SiiDte.IdDoc_IndServicio;
import DocumentoBoleta.SiiDte.Referencia;
import DocumentoBoleta.SiiDte.Totales;
import DocumentoDTE.SiiDte.AduanaA;
import DocumentoDTE.SiiDte.CampoStringA;
import DocumentoDTE.SiiDte.CdgItem;
import DocumentoDTE.SiiDte.CdgItemB;
import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.DetalleB;
import DocumentoDTE.SiiDte.DineroPorcentajeType;
import DocumentoDTE.SiiDte.DocPersonalizadoA;
import DocumentoDTE.SiiDte.DscRcgGlobal;
import DocumentoDTE.SiiDte.DscRcgGlobalA;
import DocumentoDTE.SiiDte.DscRcgGlobalA_TpoMov;
import DocumentoDTE.SiiDte.DscRcgGlobalA_TpoValor;
import DocumentoDTE.SiiDte.EXPType;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.EmisorB;
import DocumentoDTE.SiiDte.EncabezadoB;
import DocumentoDTE.SiiDte.Exportaciones;
import DocumentoDTE.SiiDte.IdDocB;
import DocumentoDTE.SiiDte.IdDocB_FmaPago;
import DocumentoDTE.SiiDte.IdDoc_FmaPago;
import DocumentoDTE.SiiDte.ImpresionA;
import DocumentoDTE.SiiDte.MntPagos;
import DocumentoDTE.SiiDte.MntPagosB;
import DocumentoDTE.SiiDte.OtraMonedaA;
import DocumentoDTE.SiiDte.PersonalizadosA;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.ReceptorB;
import DocumentoDTE.SiiDte.ReferenciaB;
import DocumentoDTE.SiiDte.ReferenciaB_CodRef;
import DocumentoDTE.SiiDte.Referencia_CodRef;
import DocumentoDTE.SiiDte.TipMonType;
import DocumentoDTE.SiiDte.TipoBultosA;
import DocumentoDTE.SiiDte.TipoTransVENTA;
import DocumentoDTE.SiiDte.TotalesB;
import DocumentoDTE.SiiDte.TransporteA;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import com.liquid_technologies.ltxmllib12.exceptions.LtException;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.Servicio;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCountry;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.process.DocAction;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class EKProcessGDExpressDTEInvoice
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    public String urlPdf = "";
    private String apiURL = "";
    private String apiAuth = "";
    private String ambiente;

    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        String err;
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String valConfig = MSysConfig.getValue((String)"EK_GDEXPRESS_VALIDATE_DATES", (String)"N", (int)inv.getAD_Client_ID());
        if ("Y".equalsIgnoreCase(valConfig) && (err = this.validateInvoiceDates(inv)) != null && err.trim().length() > 0) {
            inv.saveEx();
            throw new AdempiereException(err);
        }
        this.apiURL = MSysConfig.getValue((String)"DTEBoxServer", (String)"http://200.6.96.14/api/Core.svc/Core");
        this.apiAuth = MSysConfig.getValue((String)"DTEBoxPass", (String)"a497c198-a553-4ad0-8576-3cd227dc2f57");
        MOrg org = MOrg.get((Properties)inv.getCtx(), (int)inv.getAD_Org_ID());
        this.ambiente = org.get_ValueAsString("AJ_DTEBoxEnvironment");
        String msg = "";
        MDocType docTypeCab = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        msg = docTypeCab.get_ValueAsString("EK_SIICode").compareTo("39") == 0 || docTypeCab.get_ValueAsString("EK_SIICode").compareTo("41") == 0 ? this.sendDTEBoleta(inv) : (docTypeCab.get_ValueAsString("EK_SIICode").equals("110") || docTypeCab.get_ValueAsString("EK_SIICode").equals("111") || docTypeCab.get_ValueAsString("EK_SIICode").equals("112") ? this.sendDTEExport(inv) : this.sendDTE(inv));
        return msg;
    }

    public String ConverDateToString(Timestamp fecha) {
        Object dateReturn = "";
        this.log.config("month" + fecha.getMonth() + "1");
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }

    public String sendDTE(MInvoice invoice) {
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            String docRef;
            DocAction refdoc;
            MOrg org = MOrg.get((Properties)invoice.getCtx(), (int)invoice.getAD_Org_ID());
            MDocType docType = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
            DTEDefType dte = new DTEDefType();
            dte.setDTE_Choice(new DTE_Choice());
            dte.getDTE_Choice().setDocumento(new DocumentoDTE.SiiDte.Documento());
            DocumentoDTE.SiiDte.Documento doc = dte.getDTE_Choice().getDocumento();
            doc.setEncabezado(new DocumentoDTE.SiiDte.Encabezado());
            DocumentoDTE.SiiDte.IdDoc idDoc = new DocumentoDTE.SiiDte.IdDoc();
            if (docType.get_ValueAsString("EK_SIICode").compareTo("33") == 0) {
                idDoc.setTipoDTE(DTEType.n33);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("34") == 0) {
                idDoc.setTipoDTE(DTEType.n34);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("56") == 0) {
                idDoc.setTipoDTE(DTEType.n56);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("61") == 0) {
                idDoc.setTipoDTE(DTEType.n61);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("52") == 0) {
                idDoc.setTipoDTE(DTEType.n52);
            } else {
                throw new AdempiereException("Codigo SII no presente en tipo de documento");
            }
            idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(invoice.getDocumentNo())));
            idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateAcct())));
            if (invoice.getPaymentRule().compareToIgnoreCase("M") == 0) {
                idDoc.setFmaPago(IdDoc_FmaPago.n1);
            } else {
                idDoc.setFmaPago(IdDoc_FmaPago.n2);
            }
            if (docType.getName().toLowerCase().contains("activo fijo")) {
                idDoc.setTpoTranVenta(TipoTransVENTA.n2);
            }
            doc.getEncabezado().setIdDoc(idDoc);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS((String)invoice.get_TrxName(), (String)"SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", (Object[])new Object[]{invoice.get_ID()});
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID()));
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            idDoc.setFchVenc(new DateTime(DateTimeType.date, this.ConverDateToString(fchVencCal)));
            doc.getEncabezado().setIdDoc(idDoc);
            MntPagos mntPago = new MntPagos();
            mntPago.setFchPago(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateAcct())));
            mntPago.setMntPago(invoice.getGrandTotal().toBigInteger());
            String GlosaP = DB.getSQLValueString((String)invoice.get_TrxName(), (String)("SELECT MAX(rlt.name)  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID)  WHERE AD_Reference_ID=195  AND rlt.AD_Language='es_MX' AND rl.value = '" + invoice.getPaymentRule() + "'"), (Object[])new Object[0]);
            Object GlosaPFull = invoice.getC_PaymentTerm().getName();
            if (GlosaP != null && GlosaP.trim().length() > 0) {
                GlosaPFull = (String)GlosaPFull + "-" + GlosaP;
            }
            mntPago.setGlosaPagos((String)GlosaPFull);
            idDoc.setTermPagoGlosa((String)GlosaPFull);
            idDoc.getMntPagos().add(mntPago);
            doc.getEncabezado().setIdDoc(idDoc);
            Emisor emisor = new Emisor();
            emisor.setRUTEmisor((String)org.get_Value("EK_Value"));
            String nameRzn = org.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = org.getName();
            }
            emisor.setRznSoc(nameRzn);
            String giroEmisStr = (String)org.get_Value("EK_BusinessType");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            emisor.setGiroEmis(giroEmisStr);
            emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("EK_EconomicActivityCode"))));
            emisor.setDirOrigen((String)org.get_Value("EK_Address"));
            emisor.setCmnaOrigen((String)org.get_Value("EK_Commune"));
            emisor.setCiudadOrigen((String)org.get_Value("EK_City"));
            if (invoice.getSalesRep_ID() > 0) {
                emisor.setCdgVendedor(invoice.getSalesRep().getName());
            }
            doc.getEncabezado().setEmisor(emisor);
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Receptor receptor = new Receptor();
            receptor.setRUTRecep(BP.getValue());
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptor.setRznSocRecep(RznSocRecepStr);
            String dirRecepStr = bloc.get_ValueAsString("Address1");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setDirRecep(dirRecepStr);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            receptor.setCmnaRecep(CmnaRecepStr);
            String ciudadTxt = "";
            if (bloc.get_ValueAsInt("C_Region_ID") == 1000002) {
                ciudadTxt = "Santiago";
            }
            receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
            receptor.setGiroRecep((String)BP.get_Value("EK_BusinessType"));
            String strContacto = bloc.get_ValueAsString("Phone");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setContacto(strContacto);
            doc.getEncabezado().setReceptor(receptor);
            BigDecimal amountex = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.Linetotalamt)-sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.Linetotalamt)-sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            DocumentoDTE.SiiDte.Totales totales = new DocumentoDTE.SiiDte.Totales();
            totales.setMntTotal(invoice.getGrandTotal().toBigInteger());
            if (amountNeto.compareTo(Env.ZERO) > 0) {
                totales.setMntNeto(amountNeto.toBigInteger());
            }
            if (amountex.compareTo(Env.ZERO) > 0) {
                totales.setMntExe(amountex.toBigInteger());
            }
            BigDecimal ivaamt = Env.ZERO;
            ivaamt = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            if (amountNeto.signum() > 0) {
                totales.setTasaIVA(BigDecimal.valueOf(19L));
            }
            totales.setIVA(ivaamt.toBigInteger());
            doc.getEncabezado().setTotales(totales);
            MInvoiceLine[] iLines = invoice.getLines(false);
            ArrayList<MInvoiceLine> epLines = new ArrayList<MInvoiceLine>();
            ArrayList<MInvoiceLine> otherLines = new ArrayList<MInvoiceLine>();
            for (MInvoiceLine il : iLines) {
                if (il.getM_Product_ID() == 0 && il.getC_Charge_ID() == 0) continue;
                if ("EP".equals(il.get_ValueAsString("AJ_NameOverride"))) {
                    epLines.add(il);
                    continue;
                }
                otherLines.add(il);
            }
            int ID_Ship = 0;
            int lineNo = 0;
            if (!epLines.isEmpty()) {
                String epName = MRefList.getListName((Properties)this.m_ctx, (int)2000008, (String)"EP");
                if (epName == null || epName.trim().isEmpty()) {
                    epName = "Estados de Pago";
                }
                BigDecimal epNetSum = Env.ZERO;
                for (MInvoiceLine il : epLines) {
                    BigDecimal lineNet = il.getLineTotalAmt();
                    if (lineNet.signum() > 0) {
                        lineNet = lineNet.subtract(il.getTaxAmt());
                    }
                    epNetSum = epNetSum.add(lineNet);
                    if (ID_Ship != 0 || il.getM_InOutLine() == null) continue;
                    ID_Ship = il.getM_InOutLine().getM_InOut_ID();
                }
                DocumentoDTE.SiiDte.Detalle epDet = new DocumentoDTE.SiiDte.Detalle();
                epDet.setNroLinDet(BigInteger.valueOf(++lineNo));
                epDet.setNmbItem(epName);
                epDet.setQtyItem(BigDecimal.ONE);
                epDet.setUnmdItem("UN");
                epDet.setPrcItem(this.roundToFourDecimal(epNetSum));
                epDet.setMontoItem(epNetSum.setScale(0, RoundingMode.HALF_UP).toBigInteger());
                CdgItem epCdg = new CdgItem();
                epCdg.setTpoCodigo("INT");
                epCdg.setVlrCodigo("EP");
                epDet.getCdgItem().add(epCdg);
                doc.getDetalle().add(epDet);
            }
            int lineInvoice = 0;
            boolean lineDiscount = false;
            String valuecod = "";
            String namecod = "";
            String upccod = "";
            String uomcod = "";
            for (MInvoiceLine iLine : otherLines) {
                String refList;
                if (iLine.getM_Product_ID() == 0 && iLine.getC_Charge_ID() == 0) continue;
                DocumentoDTE.SiiDte.Detalle det = new DocumentoDTE.SiiDte.Detalle();
                String descr = "";
                if (iLine.getDescription() != null) {
                    descr = iLine.getDescription();
                }
                if (iLine.getM_Product_ID() > 0) {
                    String sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    String result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    this.log.config("sql = " + sql);
                    this.log.config("product " + iLine.getM_Product_ID());
                    this.log.config(" partner = " + iLine.getC_Invoice().getC_BPartner_ID());
                    valuecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getValue() : result;
                    sql = "SELECT coalesce(description,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    namecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getName() : result;
                    if (iLine.getM_Product().getC_UOM().getUOMSymbol() != null) {
                        uomcod = iLine.getM_Product().getC_UOM().getUOMSymbol();
                    }
                    if (iLine.getM_Product().getUPC() != null) {
                        upccod = "-".concat(iLine.getM_Product().getUPC());
                    }
                } else {
                    if (iLine.getC_Charge().getName().toLowerCase().contains("descuentos")) {
                        BigDecimal dctoAmt = iLine.getLineTotalAmt();
                        DscRcgGlobal dscRcgGlobal = new DscRcgGlobal();
                        dscRcgGlobal.setNroLinDR(BigInteger.valueOf(1L));
                        dscRcgGlobal.setTpoMov(DocumentoDTE.SiiDte.DscRcgGlobal_TpoMov.D);
                        dscRcgGlobal.setTpoValor(DineroPorcentajeType.Dollar);
                        dscRcgGlobal.setValorDR(dctoAmt.abs());
                        dscRcgGlobal.setGlosaDR(descr);
                        doc.getDscRcgGlobal().add(dscRcgGlobal);
                        continue;
                    }
                    valuecod = "CARGO";
                    namecod = iLine.getC_Charge().getName();
                    upccod = "- ";
                    uomcod = "UN";
                }
                if (iLine.get_ValueAsString("AJ_NameOverride").length() > 0 && (refList = MRefList.getListName((Properties)this.m_ctx, (int)2000008, (String)iLine.get_ValueAsString("AJ_NameOverride"))).length() > 0) {
                    namecod = refList;
                    valuecod = iLine.get_ValueAsString("AJ_NameOverride");
                }
                BigDecimal netAmt = Env.ZERO;
                if (iLine.getLineTotalAmt().compareTo(Env.ZERO) > 0) {
                    netAmt = iLine.getLineTotalAmt().subtract(iLine.getTaxAmt());
                }
                if (ID_Ship == 0) {
                    ID_Ship = iLine.getM_InOutLine().getM_InOut_ID();
                }
                ++lineInvoice;
                det.setNroLinDet(BigInteger.valueOf(++lineNo));
                det.setNmbItem(namecod);
                det.setQtyItem(iLine.getQtyInvoiced());
                BigDecimal prcItem = iLine.getPriceEntered();
                if (invoice.getM_PriceList().isTaxIncluded()) {
                    prcItem = netAmt.divide(iLine.getQtyInvoiced(), 4, RoundingMode.HALF_UP);
                }
                det.setPrcItem(this.roundToFourDecimal(prcItem));
                det.setMontoItem(netAmt.setScale(0, 4).toBigInteger());
                det.setDscItem(descr);
                det.setUnmdItem(uomcod);
                CdgItem cdgItem = new CdgItem();
                cdgItem.setTpoCodigo("INT");
                cdgItem.setVlrCodigo(valuecod);
                det.getCdgItem().add(cdgItem);
                doc.getDetalle().add(det);
            }
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            String codRef = "";
            if (invoice.get_ValueAsInt("AJ_RefDoc_ID") > 0) {
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("AJ_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), refdoc.getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("EK_SIICode");
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getDateInvoiced());
                codRef = invoice.get_ValueAsString("AJ_CodRef");
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0 && invoice.getC_DocType().getDocBaseType().compareTo("ARC") != 0 && invoice.getPOReference().compareTo("0") != 0) {
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered() != null ? this.ConverDateToString(invoice.getDateOrdered()) : this.ConverDateToString(invoice.getDateInvoiced());
                tipo_Ref = 2;
            }
            if (invoice.get_Value("AJ_RefInOut_ID") != null && (Integer)invoice.get_Value("AJ_RefInOut_ID") > 0) {
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("AJ_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getMovementDate());
                tipo_Ref = 3;
            }
            int indice = 0;
            if (tipo_Ref > 0) {
                ++indice;
                DocumentoDTE.SiiDte.Referencia reference = new DocumentoDTE.SiiDte.Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(indice));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    if (codRef.equals("1")) {
                        reference.setCodRef(Referencia_CodRef.n1);
                    } else if (codRef.equals("2")) {
                        reference.setCodRef(Referencia_CodRef.n2);
                    } else if (codRef.equals("3")) {
                        reference.setCodRef(Referencia_CodRef.n3);
                    } else {
                        reference.setCodRef(Referencia_CodRef.n1);
                    }
                    String razonRefTxt = invoice.get_ValueAsString("AJ_ReasonRef");
                    if (razonRefTxt != null && razonRefTxt.trim().length() > 1) {
                        reference.setRazonRef(razonRefTxt);
                    }
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    invoice.set_CustomColumn("EK_DescriptionFEL", e.getMessage());
                    invoice.saveEx();
                    throw new AdempiereException(e.getMessage());
                }
            }
            if (invoice.getC_Order_ID() > 0) {
                MOrder refdoc2 = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
                tiporeferencia = "802";
                folioreferencia = refdoc2.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc2.getDateOrdered());
                tipo_Ref = 4;
                ++indice;
                DocumentoDTE.SiiDte.Referencia reference = new DocumentoDTE.SiiDte.Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(indice));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    reference.setCodRef(Referencia_CodRef.n1);
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (ID_Ship == 0 && invoice.getC_Order_ID() > 0) {
                    ID_Ship = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT COALESCE((MAX(M_InOut_ID)),0) FROM M_InOut mi INNER JOIN C_Order co ON (mi.C_Order_ID = co.C_Order_ID) WHERE mi.docstatus IN ('CO','CL','VO') AND mi.C_Order_ID = " + invoice.getC_Order_ID()));
                }
            }
            catch (Exception e) {
                ID_Ship = 0;
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            if (ID_Ship > 0) {
                ++indice;
                docRef = "52";
                MInOut inOutref = new MInOut(invoice.getCtx(), ID_Ship, invoice.get_TrxName());
                MDocType docTShip = new MDocType(invoice.getCtx(), inOutref.getC_DocType_ID(), invoice.get_TrxName());
                docRef = docTShip.get_ValueAsBoolean("EK_CreateXML") ? docTShip.get_ValueAsString("EK_SIICode") : "52";
                DocumentoDTE.SiiDte.Referencia reference2 = new DocumentoDTE.SiiDte.Referencia();
                try {
                    reference2.setNroLinRef(BigInteger.valueOf(indice));
                    reference2.setTpoDocRef(docRef);
                    folioreferencia = this.onlyNumber(inOutref.getDocumentNo());
                    reference2.setFolioRef(folioreferencia);
                    reference2.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(inOutref.getMovementDate())));
                    doc.getReferencia().add(reference2);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if ((docRef = invoice.get_ValueAsString("AJ_ReferenceType")) != null) {
                ++indice;
                String DocNoHES = invoice.get_ValueAsString("AJ_ReferenceHES");
                if (DocNoHES == null || DocNoHES.trim().length() == 0 && DocNoHES.compareTo("0") == 0) {
                    throw new AdempiereException("Debe especificar dato v\u00e1lido en campo Folio de Referencia");
                }
                ++indice;
                DocumentoDTE.SiiDte.Referencia reference3 = new DocumentoDTE.SiiDte.Referencia();
                try {
                    reference3.setNroLinRef(BigInteger.valueOf(indice));
                    reference3.setTpoDocRef(docRef);
                    reference3.setFolioRef(DocNoHES);
                    Timestamp dateHES = invoice.getDateInvoiced();
                    if (dateHES == null) {
                        dateHES = invoice.getDateInvoiced();
                    }
                    reference3.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(dateHES)));
                    doc.getReferencia().add(reference3);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            PersonalizadosA personalizados = new PersonalizadosA();
            dte.setPersonalizados(personalizados);
            personalizados.setDocPersonalizado(new DocPersonalizadoA());
            if (invoice.getDescription() != null && invoice.getDescription().trim().length() > 0) {
                CampoStringA campoString = new CampoStringA();
                campoString.setName("Notas");
                campoString.setPrimitiveValue(invoice.getDescription());
                personalizados.getDocPersonalizado().getCampoString().add(campoString);
            }
            ImpresionA impresion = new ImpresionA();
            personalizados.getDocPersonalizado().setImpresion(impresion);
            if (invoice.getSalesRep_ID() > 0) {
                impresion.setPersonalizado_02(invoice.getSalesRep().getC_BPartner().getName() == null ? invoice.getSalesRep().getName() : invoice.getSalesRep().getC_BPartner().getName());
            }
            impresion.setPersonalizado_03(invoice.getC_PaymentTerm().getName());
            String fechaResolucion = "2014-08-22";
            int numeroResolucion = 80;
            int tipoPdf417 = 1;
            Servicio servicio = new Servicio(this.apiURL, this.apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, this.ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            dte.toXml();
            this.log.config("dte " + dte.toXml());
            this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
                error = "DTE Enviado OK";
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
            invoice.set_CustomColumn("EK_DescriptionFEL", error);
            invoice.saveEx(invoice.get_TrxName());
        }
        catch (Exception e) {
            this.log.config(e.toString());
            error = e.toString();
        }
        return "Procesado " + ted + " - " + pdf417 + " - " + error;
    }

    public String sendDTEBoleta(MInvoice invoice) {
        MDocType docType = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        MOrg org = new MOrg(invoice.getCtx(), invoice.getAD_Org_ID(), invoice.get_TrxName());
        if (docType.get_Value("EK_CreateXML") == null || !((Boolean)docType.get_Value("EK_CreateXML")).booleanValue()) {
            return "";
        }
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            MOrder order;
            String folioRefOC;
            int orderId;
            MInvoice refdoc;
            MBPartner bp;
            String bpEmail;
            MUser u;
            BOLETADefType boleta = new BOLETADefType();
            Documento doc = new Documento();
            boleta.setDocumento(doc);
            doc.setEncabezado(new Encabezado());
            IdDoc idDoc = new IdDoc();
            doc.getEncabezado().setIdDoc(idDoc);
            if (docType.get_ValueAsString("EK_SIICode").equals("39")) {
                idDoc.setTipoDTE(DocumentoBoleta.SiiDte.DTEType.n39);
            } else if (docType.get_ValueAsString("EK_SIICode").equals("41")) {
                idDoc.setTipoDTE(DocumentoBoleta.SiiDte.DTEType.n41);
            }
            idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(invoice.getDocumentNo())));
            idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateAcct())));
            idDoc.setIndServicio(IdDoc_IndServicio.n1);
            DocumentoBoleta.SiiDte.Emisor emisor = new DocumentoBoleta.SiiDte.Emisor();
            doc.getEncabezado().setEmisor(emisor);
            emisor.setRUTEmisor(org.get_ValueAsString("EK_Value"));
            String nameRzn = org.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = org.getName();
            }
            emisor.setRznSocEmisor(nameRzn);
            emisor.setGiroEmisor(org.get_ValueAsString("EK_BusinessType"));
            emisor.setDirOrigen(org.get_ValueAsString("EK_Address"));
            emisor.setCmnaOrigen(org.get_ValueAsString("EK_Commune"));
            emisor.setCiudadOrigen(org.get_ValueAsString("EK_City"));
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            DocumentoBoleta.SiiDte.Receptor receptor = new DocumentoBoleta.SiiDte.Receptor();
            doc.getEncabezado().setReceptor(receptor);
            String rut = BP.getValue();
            String bpGroupType = BP.getC_BP_Group().getValue().toLowerCase();
            if (bpGroupType.contains("extranjero")) {
                rut = "55555555-5";
            } else if (bpGroupType.contains("prospecto")) {
                rut = "66666666-6";
            }
            receptor.setRUTRecep(rut);
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptor.setRznSocRecep(RznSocRecepStr);
            String dirRecepStr = bloc.get_ValueAsString("Address1");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setDirRecep(dirRecepStr);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            receptor.setCmnaRecep(CmnaRecepStr);
            String ciudadTxt = "";
            if (bloc.get_ValueAsInt("C_Region_ID") == 1000002) {
                ciudadTxt = "Santiago";
            }
            receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
            String email = null;
            if (invoice.getAD_User_ID() > 0 && (u = MUser.get((Properties)invoice.getCtx(), (int)invoice.getAD_User_ID())) != null && u.getEMail() != null && !u.getEMail().trim().isEmpty()) {
                email = u.getEMail().trim();
            }
            if ((email == null || email.isEmpty()) && invoice.getC_BPartner_ID() > 0 && (bpEmail = (bp = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName())).get_ValueAsString("Value")) != null && !bpEmail.trim().isEmpty()) {
                email = bpEmail.trim();
            }
            if (email != null && !email.isEmpty()) {
                String emailSafe = email.replace("'", "").replace("\"", "");
                doc.getEncabezado().getReceptor().setContacto(emailSafe);
            }
            Totales totales = new Totales();
            doc.getEncabezado().setTotales(totales);
            totales.setMntTotal(invoice.getGrandTotal().toBigInteger());
            BigDecimal amountNeto = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.Linetotalamt)-sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            totales.setMntNeto(amountNeto.toBigInteger());
            BigDecimal ivaamt = Env.ZERO;
            ivaamt = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            totales.setIVA(ivaamt.toBigInteger());
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineNo = 1;
            String valuecod = "";
            String namecod = "";
            String upccod = "";
            String uomcod = "";
            int disocuntLine = 1;
            for (MInvoiceLine iLine : iLines) {
                String refList;
                if (iLine.getM_Product_ID() == 0 && iLine.getC_Charge_ID() == 0) continue;
                if (iLine.getM_Product().getProductType().equals("S") && iLine.getM_Product().getDescription().toLowerCase().contains("descuento")) {
                    DocumentoBoleta.SiiDte.DscRcgGlobal dscRcgGlobal = new DocumentoBoleta.SiiDte.DscRcgGlobal();
                    dscRcgGlobal.setNroLinDR(BigInteger.valueOf(disocuntLine++));
                    dscRcgGlobal.setTpoMov(DscRcgGlobal_TpoMov.D);
                    dscRcgGlobal.setTpoValor(DscRcgGlobal_TpoValor.Dollar);
                    dscRcgGlobal.setValorDR(iLine.getLineTotalAmt().abs());
                    dscRcgGlobal.setGlosaDR(iLine.getDescription());
                    doc.getDscRcgGlobal().add(dscRcgGlobal);
                    continue;
                }
                Detalle det = new Detalle();
                String descr = "";
                if (iLine.getDescription() != null) {
                    descr = iLine.getDescription();
                }
                if (iLine.getM_Product_ID() > 0) {
                    String sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    String result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    valuecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getValue() : result;
                    sql = "SELECT coalesce(description,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    namecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getName() : result;
                    if (iLine.getM_Product().getC_UOM().getUOMSymbol() != null) {
                        uomcod = iLine.getM_Product().getC_UOM().getUOMSymbol();
                    }
                    if (iLine.getM_Product().getUPC() != null) {
                        upccod = "-".concat(iLine.getM_Product().getUPC());
                    }
                } else {
                    valuecod = "CARGO";
                    namecod = iLine.getC_Charge().getName();
                    upccod = "- ";
                    uomcod = "UN";
                }
                if (iLine.get_ValueAsString("AJ_NameOverride").length() > 0 && (refList = MRefList.getListName((Properties)this.m_ctx, (int)2000008, (String)iLine.get_ValueAsString("AJ_NameOverride"))).length() > 0) {
                    namecod = refList;
                    valuecod = iLine.get_ValueAsString("AJ_NameOverride");
                }
                BigDecimal netAmt = Env.ZERO;
                if (iLine.getLineTotalAmt().compareTo(Env.ZERO) > 0) {
                    netAmt = iLine.getLineTotalAmt().subtract(iLine.getTaxAmt());
                }
                det.setNroLinDet(BigInteger.valueOf(lineNo));
                det.setNmbItem(namecod);
                det.setMontoItem(netAmt.setScale(iLine.getC_Invoice().getC_Currency().getStdPrecision(), RoundingMode.HALF_UP).toBigInteger());
                det.setDscItem(descr);
                det.setQtyItem(iLine.getQtyInvoiced());
                det.setUnmdItem(uomcod);
                BigDecimal prcItem = iLine.getPriceEntered();
                if (invoice.getM_PriceList().isTaxIncluded()) {
                    prcItem = netAmt.divide(iLine.getQtyInvoiced(), 4, RoundingMode.HALF_UP);
                }
                det.setPrcItem(this.roundToFourDecimal(prcItem));
                DocumentoBoleta.SiiDte.CdgItem cdgItem = new DocumentoBoleta.SiiDte.CdgItem();
                cdgItem.setTpoCodigo("INT");
                cdgItem.setVlrCodigo(valuecod);
                det.getCdgItem().add(cdgItem);
                doc.getDetalle().add(det);
                ++lineNo;
            }
            int refSeq = 0;
            int refDocID = invoice.get_ValueAsInt("AJ_RefDoc_ID");
            if (refDocID > 0 && (refdoc = new MInvoice(invoice.getCtx(), refDocID, invoice.get_TrxName())).getC_Invoice_ID() > 0) {
                MDocType refDoctype = new MDocType(invoice.getCtx(), refdoc.getC_DocType_ID(), invoice.get_TrxName());
                String tpoDocRef = (String)refDoctype.get_Value("EK_SIICode");
                String folioRef = refdoc.getDocumentNo();
                String fchRef = this.ConverDateToString(refdoc.getDateInvoiced());
                String codRef = invoice.get_ValueAsString("AJ_CodRef");
                if (tpoDocRef != null && folioRef != null && !folioRef.trim().isEmpty()) {
                    ++refSeq;
                    Referencia reference = new Referencia();
                    try {
                        reference.setNroLinRef(BigInteger.valueOf(refSeq));
                        reference.setTpoDocRef(tpoDocRef);
                        reference.setFolioRef(folioRef);
                        if (codRef != null && !codRef.trim().isEmpty()) {
                            try {
                                reference.setCodRef(codRef);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        doc.getReferencia().add(reference);
                    }
                    catch (LtException e) {
                        this.log.log(Level.SEVERE, "Error seteando Referencia DTE (AJ_RefDoc_ID)", (Throwable)e);
                    }
                }
            }
            if ((orderId = invoice.getC_Order_ID()) > 0 && (folioRefOC = (order = new MOrder(invoice.getCtx(), orderId, invoice.get_TrxName())).getDocumentNo()) != null && !folioRefOC.trim().isEmpty()) {
                ++refSeq;
                Referencia referenceOC = new Referencia();
                try {
                    referenceOC.setNroLinRef(BigInteger.valueOf(refSeq));
                    referenceOC.setTpoDocRef("802");
                    referenceOC.setFolioRef(folioRefOC);
                    doc.getReferencia().add(referenceOC);
                }
                catch (LtException e) {
                    this.log.log(Level.SEVERE, "Error seteando Referencia DTE (Orden de Compra)", (Throwable)e);
                }
            }
            String fechaResolucion = "2014-08-22";
            int numeroResolucion = 80;
            int tipoPdf417 = 1;
            Servicio servicio = new Servicio(this.apiURL, this.apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(boleta, this.ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            this.log.config("BOLETA==> " + boleta.toXml());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
                error = "DTE Enviado OK";
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
            invoice.set_CustomColumn("EK_DescriptionFEL", error);
            invoice.saveEx(invoice.get_TrxName());
        }
        catch (Exception e) {
            this.log.config(e.toString());
            error = e.toString();
        }
        return "Procesado " + error;
    }

    public String sendDTEExport(MInvoice invoice) {
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            String docRef;
            DocAction refdoc;
            MOrg org = MOrg.get((Properties)invoice.getCtx(), (int)invoice.getAD_Org_ID());
            MDocType docType = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
            DTEDefType dte = new DTEDefType();
            dte.setDTE_Choice(new DTE_Choice());
            dte.getDTE_Choice().setExportaciones(new Exportaciones());
            Exportaciones exportaciones = dte.getDTE_Choice().getExportaciones();
            exportaciones.setEncabezado(new EncabezadoB());
            IdDocB idDocB = new IdDocB();
            if (docType.get_ValueAsString("EK_SIICode").compareTo("110") == 0) {
                idDocB.setTipoDTE(EXPType.n110);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("111") == 0) {
                idDocB.setTipoDTE(EXPType.n111);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("112") == 0) {
                idDocB.setTipoDTE(EXPType.n112);
            }
            idDocB.setFolio(BigInteger.valueOf(Integer.parseInt(invoice.getDocumentNo())));
            idDocB.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateAcct())));
            if (invoice.getPaymentRule().compareToIgnoreCase("M") == 0) {
                idDocB.setFmaPago(IdDocB_FmaPago.n1);
            } else {
                idDocB.setFmaPago(IdDocB_FmaPago.n2);
            }
            exportaciones.getEncabezado().setIdDoc(idDocB);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS((String)invoice.get_TrxName(), (String)"SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", (Object[])new Object[]{invoice.get_ID()});
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID()));
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            idDocB.setFchVenc(new DateTime(DateTimeType.date, this.ConverDateToString(fchVencCal)));
            exportaciones.getEncabezado().setIdDoc(idDocB);
            MntPagosB mntPagoB = new MntPagosB();
            mntPagoB.setFchPago(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateAcct())));
            mntPagoB.setMntPago(invoice.getGrandTotal().toBigInteger());
            String GlosaP = DB.getSQLValueString((String)invoice.get_TrxName(), (String)("SELECT MAX(rlt.name)  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID)  WHERE AD_Reference_ID=195  AND rlt.AD_Language='es_MX' AND rl.value = '" + invoice.getPaymentRule() + "'"), (Object[])new Object[0]);
            Object GlosaPFull = invoice.getC_PaymentTerm().getName();
            if (GlosaP != null && GlosaP.trim().length() > 0) {
                GlosaPFull = (String)GlosaPFull + "-" + GlosaP;
            }
            mntPagoB.setGlosaPagos((String)GlosaPFull);
            idDocB.setTermPagoGlosa((String)GlosaPFull);
            idDocB.getMntPagos().add(mntPagoB);
            exportaciones.getEncabezado().setIdDoc(idDocB);
            EmisorB emisorB = new EmisorB();
            emisorB.setRUTEmisor((String)org.get_Value("EK_Value"));
            String nameRzn = org.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = org.getName();
            }
            emisorB.setRznSoc(nameRzn);
            String giroEmisStr = (String)org.get_Value("EK_BusinessType");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            emisorB.setGiroEmis(giroEmisStr);
            emisorB.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("EK_EconomicActivityCode"))));
            emisorB.setDirOrigen((String)org.get_Value("EK_Address"));
            emisorB.setCmnaOrigen((String)org.get_Value("EK_Commune"));
            emisorB.setCiudadOrigen((String)org.get_Value("EK_City"));
            if (invoice.getSalesRep_ID() > 0) {
                emisorB.setCdgVendedor(invoice.getSalesRep().getName());
            }
            exportaciones.getEncabezado().setEmisor(emisorB);
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            ReceptorB receptorB = new ReceptorB();
            receptorB.setRUTRecep("55555555-5");
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptorB.setRznSocRecep(RznSocRecepStr);
            String dirRecepStr = bloc.get_ValueAsString("Address1");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptorB.setDirRecep(dirRecepStr);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            receptorB.setCmnaRecep(CmnaRecepStr);
            String ciudadTxt = "";
            receptorB.setCiudadRecep(CmnaRecepStr);
            receptorB.setGiroRecep((String)BP.get_Value("EK_BusinessType"));
            String strContacto = bloc.get_ValueAsString("Phone");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptorB.setContacto(strContacto);
            exportaciones.getEncabezado().setReceptor(receptorB);
            TransporteA transporteA = new TransporteA();
            AduanaA aduanaA = new AduanaA();
            Integer orderId = invoice.getC_Order_ID() > 0 ? Integer.valueOf(invoice.getC_Order_ID()) : null;
            Integer vShipmentType = null;
            Integer vPackageType = null;
            BigDecimal vGrossWeight = null;
            Integer vTotalPackages = null;
            if (orderId != null) {
                String sql = "SELECT AJAH_ShipmentType, AJ_PackageType, AJ_SalesMode, AJ_GrossWeight, AJ_TotalPackages FROM AJAH_ImportTracking WHERE C_Order_ID=? AND IsActive='Y' ORDER BY Created DESC";
                try (CPreparedStatement ps = DB.prepareStatement((String)sql, (String)invoice.get_TrxName());){
                    ps.setInt(1, orderId);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            int tmpI = rs.getInt(1);
                            vShipmentType = rs.wasNull() ? null : Integer.valueOf(tmpI);
                            tmpI = rs.getInt(2);
                            vPackageType = rs.wasNull() ? null : Integer.valueOf(tmpI);
                            vGrossWeight = rs.getBigDecimal(3);
                            tmpI = rs.getInt(4);
                            vTotalPackages = rs.wasNull() ? null : Integer.valueOf(tmpI);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Error leyendo AJAH_ImportTracking: " + e.getMessage(), (Throwable)e);
                }
            }
            aduanaA.setCodModVenta(BigInteger.valueOf(1L));
            if (vShipmentType != null && vShipmentType > 0) {
                aduanaA.setCodViaTransp(BigInteger.valueOf(vShipmentType.intValue()));
            }
            if (vGrossWeight != null && vGrossWeight.compareTo(Env.ZERO) > 0) {
                BigDecimal pesoEntero = vGrossWeight;
                aduanaA.setPesoBruto(pesoEntero);
            }
            if (vTotalPackages != null && vTotalPackages > 0) {
                aduanaA.setTotBultos(BigInteger.valueOf(vTotalPackages.intValue()));
            }
            if (vPackageType != null && vPackageType > 0) {
                try {
                    TipoBultosA tipoB = new TipoBultosA();
                    tipoB.setCodTpoBultos(BigInteger.valueOf(vPackageType.intValue()));
                    aduanaA.getTipoBultos().add(tipoB);
                }
                catch (LtException e) {
                    this.log.log(Level.WARNING, "No se pudo agregar TipoBultos al XML: " + e.getMessage(), (Throwable)e);
                }
            }
            MCountry country = MCountry.get((Properties)this.m_ctx, (int)bloc.get_ValueAsInt("C_Country_ID"));
            String codPais = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT Value FROM C_Country WHERE C_Country_ID=?", (int)bloc.get_ValueAsInt("C_Country_ID"));
            if (codPais == null || codPais.length() < 1) {
                throw new AdempiereException("Pais receptor " + country.getName() + " no tiene codigo asignado.");
            }
            aduanaA.setCodPaisRecep(BigInteger.valueOf(Integer.parseInt(codPais)));
            transporteA.setAduana(aduanaA);
            exportaciones.getEncabezado().setTransporte(transporteA);
            BigDecimal amountex = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select COALESCE(SUM(il.Linetotalamt)-sum(il.taxamt),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            TotalesB totalesB = new TotalesB();
            TipMonType tpoMoneda = TipMonType.PESOSpaceCL;
            if (invoice.getC_Currency().getISO_Code().equals("USD")) {
                tpoMoneda = TipMonType.DOLARSpaceUSA;
            } else if (invoice.getC_Currency().getISO_Code().equals("EUR")) {
                tpoMoneda = TipMonType.EURO;
            } else if (invoice.getC_Currency().getISO_Code().equals("CNY")) {
                tpoMoneda = TipMonType.RENMINBI;
            }
            totalesB.setTpoMoneda(tpoMoneda);
            totalesB.setMntTotal(invoice.getGrandTotal().setScale(4, RoundingMode.HALF_UP).stripTrailingZeros());
            totalesB.setMntExe(amountex.setScale(4, RoundingMode.HALF_UP).stripTrailingZeros());
            exportaciones.getEncabezado().setTotales(totalesB);
            OtraMonedaA otraMonedaA = new OtraMonedaA();
            otraMonedaA.setTpoMoneda(TipMonType.PESOSpaceCL);
            if (invoice.getC_Currency_ID() != 228) {
                int conversionRateId = MConversionRate.getConversionRateId(invoice.getC_Currency_ID(), 228, invoice.getDateAcct(), 114, invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                MConversionRate rate = MConversionRate.get(this.m_ctx, conversionRateId);
                if (rate == null) {
                    throw new AdempiereException("Error de Conversi\u00f3n de moneda. (No se encuentra conversi\u00f3n)");
                }
                otraMonedaA.setTpoCambio(rate.getMultiplyRate());
                otraMonedaA.setMntTotOtrMnda(invoice.getGrandTotal().multiply(rate.getMultiplyRate()).setScale(0, RoundingMode.HALF_UP));
                otraMonedaA.setMntExeOtrMnda(amountex.multiply(rate.getMultiplyRate()).setScale(0, RoundingMode.HALF_UP));
                exportaciones.getEncabezado().setOtraMoneda(otraMonedaA);
            } else {
                otraMonedaA.setTpoCambio(Env.ONE);
                otraMonedaA.setMntTotOtrMnda(invoice.getGrandTotal());
                otraMonedaA.setMntExeOtrMnda(amountex);
                exportaciones.getEncabezado().setOtraMoneda(otraMonedaA);
            }
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            boolean lineDiscount = false;
            int ID_Ship = 0;
            String valuecod = "";
            String namecod = "";
            String upccod = "";
            String uomcod = "";
            for (MInvoiceLine iLine : iLines) {
                String refList;
                if (iLine.getM_Product_ID() == 0 && iLine.getC_Charge_ID() == 0) continue;
                DetalleB detB = new DetalleB();
                String descr = "";
                if (iLine.getDescription() != null) {
                    descr = iLine.getDescription();
                }
                if (iLine.getM_Product_ID() > 0) {
                    String sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    String result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    this.log.config("sql = " + sql);
                    this.log.config("product " + iLine.getM_Product_ID());
                    this.log.config(" partner = " + iLine.getC_Invoice().getC_BPartner_ID());
                    valuecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getValue() : result;
                    sql = "SELECT coalesce(description,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    namecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getName() : result;
                    if (iLine.getM_Product().getC_UOM().getUOMSymbol() != null) {
                        uomcod = iLine.getM_Product().getC_UOM().getUOMSymbol();
                    }
                    if (iLine.getM_Product().getUPC() != null) {
                        upccod = "-".concat(iLine.getM_Product().getUPC());
                    }
                } else {
                    if (iLine.getC_Charge().getName().toLowerCase().contains("descuentos")) {
                        BigDecimal dctoAmt = iLine.getLineTotalAmt();
                        DscRcgGlobalA dscRcgGlobalA = new DscRcgGlobalA();
                        dscRcgGlobalA.setNroLinDR(BigInteger.valueOf(1L));
                        dscRcgGlobalA.setTpoMov(DscRcgGlobalA_TpoMov.R);
                        dscRcgGlobalA.setTpoValor(DscRcgGlobalA_TpoValor.Dollar);
                        dscRcgGlobalA.setValorDR(dctoAmt.abs());
                        dscRcgGlobalA.setGlosaDR(descr);
                        exportaciones.getDscRcgGlobal().add(dscRcgGlobalA);
                        continue;
                    }
                    valuecod = "CARGO";
                    namecod = iLine.getC_Charge().getName();
                    upccod = "- ";
                    uomcod = "UN";
                }
                if (iLine.get_ValueAsString("AJ_NameOverride").length() > 0 && (refList = MRefList.getListName((Properties)this.m_ctx, (int)2000008, (String)iLine.get_ValueAsString("AJ_NameOverride"))).length() > 0) {
                    namecod = refList;
                    valuecod = iLine.get_ValueAsString("AJ_NameOverride");
                }
                BigDecimal netAmt = Env.ZERO;
                if (iLine.getLineTotalAmt().compareTo(Env.ZERO) > 0) {
                    netAmt = iLine.getLineTotalAmt().subtract(iLine.getTaxAmt());
                }
                if (ID_Ship == 0) {
                    ID_Ship = iLine.getM_InOutLine().getM_InOut_ID();
                }
                detB.setNroLinDet(BigInteger.valueOf(++lineInvoice));
                detB.setNmbItem(namecod);
                detB.setQtyItem(iLine.getQtyInvoiced());
                BigDecimal prcItem = iLine.getPriceEntered();
                if (invoice.getM_PriceList().isTaxIncluded()) {
                    prcItem = netAmt.divide(iLine.getQtyInvoiced(), 4, RoundingMode.HALF_UP);
                }
                detB.setPrcItem(this.roundToFourDecimal(prcItem));
                detB.setMontoItem(netAmt.setScale(iLine.getC_Invoice().getC_Currency().getStdPrecision(), RoundingMode.HALF_UP));
                detB.setDscItem(descr);
                detB.setUnmdItem(uomcod);
                CdgItemB cdgItemB = new CdgItemB();
                cdgItemB.setTpoCodigo("INT");
                cdgItemB.setVlrCodigo(valuecod);
                detB.getCdgItem().add(cdgItemB);
                exportaciones.getDetalle().add(detB);
            }
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            String codRef = "";
            if (invoice.get_ValueAsInt("AJ_RefDoc_ID") > 0) {
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("AJ_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), refdoc.getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("EK_SIICode");
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getDateInvoiced());
                codRef = invoice.get_ValueAsString("AJ_CodRef");
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0 && invoice.getC_DocType().getDocBaseType().compareTo("ARC") != 0 && invoice.getPOReference().compareTo("0") != 0) {
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered() != null ? this.ConverDateToString(invoice.getDateOrdered()) : this.ConverDateToString(invoice.getDateInvoiced());
                tipo_Ref = 2;
            }
            if (invoice.get_Value("AJ_RefInOut_ID") != null && (Integer)invoice.get_Value("AJ_RefInOut_ID") > 0) {
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("AJ_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getMovementDate());
                tipo_Ref = 3;
            }
            int indice = 0;
            if (tipo_Ref > 0) {
                ++indice;
                ReferenciaB referenceB = new ReferenciaB();
                try {
                    referenceB.setNroLinRef(BigInteger.valueOf(indice));
                    referenceB.setTpoDocRef(tiporeferencia);
                    referenceB.setFolioRef(folioreferencia);
                    referenceB.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    if (codRef.equals("1")) {
                        referenceB.setCodRef(ReferenciaB_CodRef.n1);
                    } else if (codRef.equals("2")) {
                        referenceB.setCodRef(ReferenciaB_CodRef.n2);
                    } else if (codRef.equals("3")) {
                        referenceB.setCodRef(ReferenciaB_CodRef.n3);
                    } else {
                        referenceB.setCodRef(ReferenciaB_CodRef.n1);
                    }
                    String razonRefTxt = invoice.get_ValueAsString("AJ_ReasonRef");
                    if (razonRefTxt != null && razonRefTxt.trim().length() > 1) {
                        referenceB.setRazonRef(razonRefTxt);
                    }
                    exportaciones.getReferencia().add(referenceB);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if (invoice.getC_Order_ID() > 0) {
                MOrder refdoc2 = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
                tiporeferencia = "802";
                folioreferencia = refdoc2.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc2.getDateOrdered());
                tipo_Ref = 4;
                ++indice;
                ReferenciaB referenceB = new ReferenciaB();
                try {
                    referenceB.setNroLinRef(BigInteger.valueOf(indice));
                    referenceB.setTpoDocRef(tiporeferencia);
                    referenceB.setFolioRef(folioreferencia);
                    referenceB.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    referenceB.setCodRef(ReferenciaB_CodRef.n1);
                    exportaciones.getReferencia().add(referenceB);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (ID_Ship == 0 && invoice.getC_Order_ID() > 0) {
                    ID_Ship = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT COALESCE((MAX(M_InOut_ID)),0) FROM M_InOut mi INNER JOIN C_Order co ON (mi.C_Order_ID = co.C_Order_ID) WHERE mi.docstatus IN ('CO','CL','VO') AND mi.C_Order_ID = " + invoice.getC_Order_ID()));
                }
            }
            catch (Exception e) {
                ID_Ship = 0;
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            if (ID_Ship > 0) {
                ++indice;
                docRef = "52";
                MInOut inOutref = new MInOut(invoice.getCtx(), ID_Ship, invoice.get_TrxName());
                MDocType docTShip = new MDocType(invoice.getCtx(), inOutref.getC_DocType_ID(), invoice.get_TrxName());
                docRef = docTShip.get_ValueAsBoolean("EK_CreateXML") ? docTShip.get_ValueAsString("EK_SIICode") : "52";
                ReferenciaB referenceB2 = new ReferenciaB();
                try {
                    referenceB2.setNroLinRef(BigInteger.valueOf(indice));
                    referenceB2.setTpoDocRef(docRef);
                    referenceB2.setFolioRef(this.onlyNumber(inOutref.getDocumentNo()));
                    referenceB2.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(inOutref.getMovementDate())));
                    exportaciones.getReferencia().add(referenceB2);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if ((docRef = invoice.get_ValueAsString("AJ_ReferenceType")) != null) {
                ++indice;
                String DocNoHES = invoice.get_ValueAsString("AJ_ReferenceHES");
                if (DocNoHES == null || DocNoHES.trim().length() == 0 && DocNoHES.compareTo("0") == 0) {
                    throw new AdempiereException("Debe especificar dato v\u00e1lido en campo Folio de Referencia");
                }
                ReferenciaB referenceB3 = new ReferenciaB();
                try {
                    referenceB3.setNroLinRef(BigInteger.valueOf(indice));
                    referenceB3.setTpoDocRef(docRef);
                    referenceB3.setFolioRef(DocNoHES);
                    Timestamp dateHES = invoice.getDateInvoiced();
                    if (dateHES == null) {
                        dateHES = invoice.getDateInvoiced();
                    }
                    referenceB3.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(dateHES)));
                    exportaciones.getReferencia().add(referenceB3);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            PersonalizadosA personalizados = new PersonalizadosA();
            dte.setPersonalizados(personalizados);
            personalizados.setDocPersonalizado(new DocPersonalizadoA());
            if (invoice.getDescription() != null && invoice.getDescription().trim().length() > 0) {
                CampoStringA campoString = new CampoStringA();
                campoString.setName("Notas");
                campoString.setPrimitiveValue(invoice.getDescription());
                personalizados.getDocPersonalizado().getCampoString().add(campoString);
            }
            ImpresionA impresion = new ImpresionA();
            personalizados.getDocPersonalizado().setImpresion(impresion);
            if (invoice.getSalesRep_ID() > 0) {
                impresion.setPersonalizado_02(invoice.getSalesRep().getC_BPartner().getName() == null ? invoice.getSalesRep().getName() : invoice.getSalesRep().getC_BPartner().getName());
            }
            impresion.setPersonalizado_03(invoice.getC_PaymentTerm().getName());
            String fechaResolucion = "2014-08-22";
            int numeroResolucion = 80;
            int tipoPdf417 = 1;
            Servicio servicio = new Servicio(this.apiURL, this.apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, this.ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            dte.toXml();
            this.log.config("dte " + dte.toXml());
            this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
                error = "DTE Enviado OK";
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
            invoice.set_CustomColumn("EK_DescriptionFEL", error);
            invoice.saveEx(invoice.get_TrxName());
        }
        catch (Exception e) {
            this.log.config(e.toString());
            error = e.toString();
        }
        return "Procesado " + ted + " - " + pdf417 + " - " + error;
    }

    private String onlyNumber(String documentNo) {
        Pattern patron = Pattern.compile("\\d+");
        Matcher matcher = patron.matcher(documentNo);
        if (matcher.find()) {
            return matcher.group().toString();
        }
        return null;
    }

    private BigDecimal roundToFourDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        BigDecimal rounded = value.setScale(4, RoundingMode.HALF_UP);
        if ((rounded = rounded.stripTrailingZeros()).scale() < 0) {
            rounded = rounded.setScale(0);
        }
        return rounded;
    }

    private String validateInvoiceDates(MInvoice inv) {
        boolean esFacturaVenta;
        Timestamp dateInv = TimeUtil.getDay((Timestamp)inv.getDateInvoiced());
        Timestamp dateAcct = TimeUtil.getDay((Timestamp)inv.getDateAcct());
        Timestamp today = TimeUtil.getDay((Timestamp)new Timestamp(System.currentTimeMillis()));
        MDocType dt = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        String docBaseType = dt.getDocBaseType();
        String siiCode = dt.get_ValueAsString("EK_SIICode");
        boolean bl = esFacturaVenta = inv.isSOTrx() && "ARI".equals(docBaseType) && ("33".equals(siiCode) || "34".equals(siiCode));
        if (!esFacturaVenta) {
            return null;
        }
        if (!dateInv.equals(dateAcct)) {
            return "No se puede enviar a GDExpress: la Fecha de Facturaci\u00f3n debe ser igual a la Fecha Contable.";
        }
        int diffDays = TimeUtil.getDaysBetween((Timestamp)dateInv, (Timestamp)today, (int[])new int[0]);
        int diffAbs = Math.abs(diffDays);
        if (diffAbs > 5) {
            return "No se puede enviar a GDExpress: la fecha de facturaci\u00f3n puede ser como m\u00e1ximo 5 d\u00edas anterior o posterior a la fecha actual.";
        }
        return null;
    }
}

