/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import DocumentoDTE.SiiDte.CampoStringA;
import DocumentoDTE.SiiDte.CdgItem;
import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.Detalle;
import DocumentoDTE.SiiDte.DineroPorcentajeType;
import DocumentoDTE.SiiDte.DocPersonalizadoA;
import DocumentoDTE.SiiDte.Documento;
import DocumentoDTE.SiiDte.DscRcgGlobal;
import DocumentoDTE.SiiDte.DscRcgGlobal_TpoMov;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.Encabezado;
import DocumentoDTE.SiiDte.IdDoc;
import DocumentoDTE.SiiDte.IdDoc_FmaPago;
import DocumentoDTE.SiiDte.ImpresionA;
import DocumentoDTE.SiiDte.MntPagos;
import DocumentoDTE.SiiDte.PersonalizadosA;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.Referencia;
import DocumentoDTE.SiiDte.Referencia_CodRef;
import DocumentoDTE.SiiDte.Totales;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import com.liquid_technologies.ltxmllib12.exceptions.LtException;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.Servicio;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.process.DocAction;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EKProcessGDExpressDTEInvoiceGroup
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    public String urlPdf = "";
    private String apiURL = "";
    private String apiAuth = "";
    private String ambiente;

    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        this.apiURL = MSysConfig.getValue((String)"DTEBoxServer", (String)"http://200.6.96.14/api/Core.svc/Core");
        this.apiAuth = MSysConfig.getValue((String)"DTEBoxPass", (String)"a497c198-a553-4ad0-8576-3cd227dc2f57");
        MOrg org = MOrg.get((Properties)inv.getCtx(), (int)inv.getAD_Org_ID());
        this.ambiente = org.get_ValueAsString("AJ_DTEBoxEnvironment");
        String msg = "";
        MDocType docTypeCab = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        msg = docTypeCab.get_ValueAsString("EK_SIICode").compareTo("39") == 0 || docTypeCab.get_ValueAsString("EK_SIICode").compareTo("41") == 0 ? this.CreateXMLBoleta(inv) : this.CreateXML(inv);
        return msg;
    }

    public String CreateXML(MInvoice invoice) {
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            String DocNoHES;
            DocAction refdoc;
            DTEDefType dte = new DTEDefType();
            dte.setDTE_Choice(new DTE_Choice());
            MOrg org = MOrg.get((Properties)invoice.getCtx(), (int)invoice.getAD_Org_ID());
            MDocType docType = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
            dte.getDTE_Choice().setDocumento(new Documento());
            Documento doc = dte.getDTE_Choice().getDocumento();
            doc.setEncabezado(new Encabezado());
            IdDoc idDoc = new IdDoc();
            if (docType.get_ValueAsString("EK_SIICode").compareTo("33") == 0) {
                idDoc.setTipoDTE(DTEType.n33);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("34") == 0) {
                idDoc.setTipoDTE(DTEType.n34);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("56") == 0) {
                idDoc.setTipoDTE(DTEType.n56);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("61") == 0) {
                idDoc.setTipoDTE(DTEType.n61);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("52") == 0) {
                idDoc.setTipoDTE(DTEType.n52);
            } else {
                throw new AdempiereException("Codigo SII no presente en tipo de documento");
            }
            idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(invoice.getDocumentNo())));
            idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateInvoiced())));
            if (invoice.getPaymentRule().compareToIgnoreCase("M") == 0) {
                idDoc.setFmaPago(IdDoc_FmaPago.n1);
            } else {
                idDoc.setFmaPago(IdDoc_FmaPago.n2);
            }
            doc.getEncabezado().setIdDoc(idDoc);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS((String)invoice.get_TrxName(), (String)"SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", (Object[])new Object[]{invoice.get_ID()});
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID()));
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            idDoc.setFchVenc(new DateTime(DateTimeType.date, this.ConverDateToString(fchVencCal)));
            doc.getEncabezado().setIdDoc(idDoc);
            MntPagos mntPago = new MntPagos();
            mntPago.setFchPago(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateInvoiced())));
            mntPago.setMntPago(invoice.getGrandTotal().toBigInteger());
            String GlosaP = DB.getSQLValueString((String)invoice.get_TrxName(), (String)("SELECT MAX(rlt.name)  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID)  WHERE AD_Reference_ID=195  AND rlt.AD_Language='es_MX' AND rl.value = '" + invoice.getPaymentRule() + "'"), (Object[])new Object[0]);
            Object GlosaPFull = invoice.getC_PaymentTerm().getName();
            if (GlosaP != null && GlosaP.trim().length() > 0) {
                GlosaPFull = (String)GlosaPFull + "-" + GlosaP;
            }
            mntPago.setGlosaPagos((String)GlosaPFull);
            idDoc.setTermPagoGlosa((String)GlosaPFull);
            idDoc.getMntPagos().add(mntPago);
            doc.getEncabezado().setIdDoc(idDoc);
            Emisor emisor = new Emisor();
            emisor.setRUTEmisor((String)org.get_Value("EK_Value"));
            String nameRzn = org.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = org.getName();
            }
            emisor.setRznSoc(nameRzn);
            String giroEmisStr = (String)org.get_Value("EK_BusinessType");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            emisor.setGiroEmis(giroEmisStr);
            emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("EK_EconomicActivityCode"))));
            emisor.setDirOrigen((String)org.get_Value("EK_Address"));
            emisor.setCmnaOrigen((String)org.get_Value("EK_Commune"));
            emisor.setCiudadOrigen((String)org.get_Value("EK_City"));
            if (invoice.getSalesRep_ID() > 0) {
                emisor.setCdgVendedor(invoice.getSalesRep().getName());
            }
            doc.getEncabezado().setEmisor(emisor);
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Receptor receptor = new Receptor();
            receptor.setRUTRecep(BP.getValue());
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptor.setRznSocRecep(RznSocRecepStr);
            String dirRecepStr = bloc.get_ValueAsString("Address1");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setDirRecep(dirRecepStr);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            receptor.setCmnaRecep(CmnaRecepStr);
            String ciudadTxt = "";
            if (bloc.get_ValueAsInt("C_Region_ID") == 1000002) {
                ciudadTxt = "Santiago";
            }
            receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
            receptor.setGiroRecep((String)BP.get_Value("EK_BusinessType"));
            String strContacto = bloc.get_ValueAsString("Phone");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setContacto(strContacto);
            doc.getEncabezado().setReceptor(receptor);
            BigDecimal amountex = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.Linetotalamt)-sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.Linetotalamt)-sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            Totales totales = new Totales();
            totales.setMntTotal(invoice.getGrandTotal().toBigInteger());
            if (amountNeto.compareTo(Env.ZERO) > 0) {
                totales.setMntNeto(amountNeto.toBigInteger());
            }
            if (amountex.compareTo(Env.ZERO) > 0) {
                totales.setMntExe(amountex.toBigInteger());
            }
            BigDecimal ivaamt = Env.ZERO;
            ivaamt = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(sum(il.taxamt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            if (amountNeto.signum() > 0) {
                totales.setTasaIVA(BigDecimal.valueOf(19L));
            }
            totales.setIVA(ivaamt.toBigInteger());
            doc.getEncabezado().setTotales(totales);
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            int lineDiscount = 0;
            String descr = "";
            int ID_Ship = 0;
            HashMap<String, BigDecimal> HashCodeQty = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> HashCodeAmount = new HashMap<String, BigDecimal>();
            HashMap<String, String> HashCodeName = new HashMap<String, String>();
            HashMap<String, String> HashCodeUPC = new HashMap<String, String>();
            HashMap<String, String> HashCodeUOM = new HashMap<String, String>();
            HashMap<String, BigDecimal> HashCodeRate = new HashMap<String, BigDecimal>();
            HashMap<String, String> HashCodeDesc = new HashMap<String, String>();
            for (MInvoiceLine iLine : iLines) {
                String refList;
                if (iLine.getM_Product_ID() == 0 && iLine.getC_Charge_ID() == 0) continue;
                String valuecod = "";
                String namecod = "";
                String upccod = "";
                String uomcod = "";
                if (iLine.getM_Product_ID() > 0) {
                    String sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    String result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    this.log.config("sql = " + sql);
                    this.log.config("product " + iLine.getM_Product_ID());
                    this.log.config(" partner = " + iLine.getC_Invoice().getC_BPartner_ID());
                    valuecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getValue() : result;
                    sql = "SELECT coalesce(description,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    namecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getName() : result;
                    if (iLine.getM_Product().getC_UOM().getUOMSymbol() != null) {
                        uomcod = iLine.getM_Product().getC_UOM().getUOMSymbol();
                    }
                    if (iLine.getM_Product().getUPC() != null) {
                        upccod = "-".concat(iLine.getM_Product().getUPC());
                    }
                } else {
                    if (iLine.getC_Charge().getName().toLowerCase().contains("descuentos")) {
                        BigDecimal dctoAmt = iLine.getLineTotalAmt();
                        DscRcgGlobal dscRcgGlobal = new DscRcgGlobal();
                        dscRcgGlobal.setNroLinDR(BigInteger.valueOf(1L));
                        dscRcgGlobal.setTpoMov(DscRcgGlobal_TpoMov.D);
                        dscRcgGlobal.setTpoValor(DineroPorcentajeType.Dollar);
                        dscRcgGlobal.setValorDR(dctoAmt.abs());
                        dscRcgGlobal.setGlosaDR(iLine.getDescription());
                        doc.getDscRcgGlobal().add(dscRcgGlobal);
                        continue;
                    }
                    valuecod = "CARGO";
                    namecod = iLine.getC_Charge().getName();
                    upccod = "- ";
                    uomcod = "UN";
                }
                if (iLine.get_ValueAsString("AJ_NameOverride").length() > 0 && (refList = MRefList.getListName((Properties)this.m_ctx, (int)2000008, (String)iLine.get_ValueAsString("AJ_NameOverride"))).length() > 0) {
                    namecod = refList;
                    valuecod = iLine.get_ValueAsString("AJ_NameOverride");
                }
                HashCodeName.put(valuecod, namecod);
                HashCodeUPC.put(valuecod, upccod);
                HashCodeUOM.put(valuecod, uomcod);
                if (iLine.getDescription() != null) {
                    descr = descr.concat(iLine.getDescription());
                }
                HashCodeDesc.put(valuecod, descr);
                if (iLine.getC_Tax().getRate().compareTo(Env.ZERO) != 0) {
                    HashCodeRate.put(valuecod, iLine.getC_Tax().getRate());
                } else {
                    HashCodeRate.put(valuecod, Env.ZERO);
                }
                BigDecimal netAmt = Env.ZERO;
                if (iLine.getLineTotalAmt().compareTo(Env.ZERO) > 0) {
                    netAmt = iLine.getLineTotalAmt().subtract(iLine.getTaxAmt());
                }
                if (HashCodeQty.get(valuecod) != null) {
                    HashCodeQty.put(valuecod, ((BigDecimal)HashCodeQty.get(valuecod)).add(iLine.getQtyInvoiced()));
                    HashCodeAmount.put(valuecod, ((BigDecimal)HashCodeAmount.get(valuecod)).add(netAmt));
                } else {
                    HashCodeQty.put(valuecod, iLine.getQtyInvoiced());
                    HashCodeAmount.put(valuecod, netAmt);
                }
                if (ID_Ship != 0) continue;
                ID_Ship = iLine.getM_InOutLine().getM_InOut_ID();
            }
            for (String i : HashCodeQty.keySet()) {
                if (((BigDecimal)HashCodeRate.get(i)).compareTo(Env.ZERO) >= 0) {
                    ++lineInvoice;
                    Detalle det = new Detalle();
                    CdgItem cdgItem = new CdgItem();
                    cdgItem.setTpoCodigo("INT1");
                    cdgItem.setVlrCodigo(i);
                    det.getCdgItem().add(cdgItem);
                    det.setNroLinDet(BigInteger.valueOf(lineInvoice));
                    String pname = "";
                    pname = ((String)HashCodeName.get(i)).concat((String)HashCodeUPC.get(i));
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    det.setNmbItem(pname);
                    det.setQtyItem((BigDecimal)HashCodeQty.get(i));
                    this.log.config("HashCodeAmount " + String.valueOf(HashCodeAmount.get(i)));
                    this.log.config("HashCodeQty " + String.valueOf(HashCodeQty.get(i)));
                    BigDecimal unitario = ((BigDecimal)HashCodeAmount.get(i)).divide((BigDecimal)HashCodeQty.get(i), RoundingMode.HALF_UP);
                    this.log.config("unitario " + String.valueOf(unitario));
                    det.setPrcItem(unitario.setScale(0, 4));
                    det.setMontoItem(((BigDecimal)HashCodeAmount.get(i)).setScale(0, 4).toBigInteger());
                    det.setDscItem((String)HashCodeDesc.get(i));
                    String unmdItemStr = "";
                    unmdItemStr = (String)HashCodeUOM.get(i);
                    det.setUnmdItem(unmdItemStr);
                    doc.getDetalle().add(det);
                    continue;
                }
                DscRcgGlobal dscRcgGlobal = new DscRcgGlobal();
                dscRcgGlobal.setNroLinDR(BigInteger.valueOf(++lineDiscount));
                dscRcgGlobal.setTpoMov(DscRcgGlobal_TpoMov.D);
                dscRcgGlobal.setTpoValor(DineroPorcentajeType.Dollar);
                dscRcgGlobal.setValorDR(((BigDecimal)HashCodeAmount.get(i)).abs().setScale(0, 4));
                String pname = "";
                pname = i.concat("-").concat((String)HashCodeName.get(i)).concat((String)HashCodeUPC.get(i));
                pname = pname.replace("'", "");
                pname = pname.replace("\"", "");
                dscRcgGlobal.setGlosaDR(pname);
                doc.getDscRcgGlobal().add(dscRcgGlobal);
            }
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            String codRef = "";
            if (invoice.get_ValueAsInt("AJ_RefDoc_ID") > 0) {
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("AJ_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), refdoc.getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("EK_SIICode");
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getDateInvoiced());
                codRef = invoice.get_ValueAsString("AJ_CodRef");
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0 && invoice.getC_DocType().getDocBaseType().compareTo("ARC") != 0 && invoice.getPOReference().compareTo("0") != 0) {
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered() != null ? this.ConverDateToString(invoice.getDateOrdered()) : this.ConverDateToString(invoice.getDateInvoiced());
                tipo_Ref = 2;
            }
            if (invoice.get_Value("AJ_RefInOut_ID") != null && (Integer)invoice.get_Value("AJ_RefInOut_ID") > 0) {
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("AJ_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getMovementDate());
                tipo_Ref = 3;
            }
            int indice = 0;
            if (tipo_Ref > 0) {
                ++indice;
                Referencia reference = new Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(indice));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    if (codRef.equals("1")) {
                        reference.setCodRef(Referencia_CodRef.n1);
                    } else if (codRef.equals("2")) {
                        reference.setCodRef(Referencia_CodRef.n2);
                    } else if (codRef.equals("3")) {
                        reference.setCodRef(Referencia_CodRef.n3);
                    } else {
                        reference.setCodRef(Referencia_CodRef.n1);
                    }
                    String razonRefTxt = invoice.get_ValueAsString("AJ_ReasonRef");
                    if (razonRefTxt != null && razonRefTxt.trim().length() > 1) {
                        reference.setRazonRef(razonRefTxt);
                    }
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if (invoice.getC_Order_ID() > 0) {
                MOrder refdoc2 = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
                tiporeferencia = "802";
                folioreferencia = refdoc2.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc2.getDateOrdered());
                tipo_Ref = 4;
                ++indice;
                Referencia reference = new Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(indice));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    reference.setCodRef(Referencia_CodRef.n1);
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (ID_Ship == 0 && invoice.getC_Order_ID() > 0) {
                    ID_Ship = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT COALESCE((MAX(M_InOut_ID)),0) FROM M_InOut mi INNER JOIN C_Order co ON (mi.C_Order_ID = co.C_Order_ID) WHERE mi.docstatus IN ('CO','CL','VO') AND mi.C_Order_ID = " + invoice.getC_Order_ID()));
                }
            }
            catch (Exception e) {
                ID_Ship = 0;
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            if (ID_Ship > 0) {
                ++indice;
                String docRef = "52";
                MInOut inOutref = new MInOut(invoice.getCtx(), ID_Ship, invoice.get_TrxName());
                MDocType docTShip = new MDocType(invoice.getCtx(), inOutref.getC_DocType_ID(), invoice.get_TrxName());
                docRef = docTShip.get_ValueAsBoolean("EK_CreateXML") ? docTShip.get_ValueAsString("EK_SIICode") : "52";
                Referencia reference2 = new Referencia();
                try {
                    reference2.setNroLinRef(BigInteger.valueOf(indice));
                    reference2.setTpoDocRef(docRef);
                    reference2.setFolioRef(inOutref.getDocumentNo());
                    reference2.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(inOutref.getMovementDate())));
                    doc.getReferencia().add(reference2);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if ((DocNoHES = invoice.get_ValueAsString("AJ_ReferenceHES")) != null && DocNoHES.trim().length() > 0 && DocNoHES.compareTo("0") != 0) {
                ++indice;
                String docRef = "HES";
                Referencia reference3 = new Referencia();
                try {
                    reference3.setNroLinRef(BigInteger.valueOf(indice));
                    reference3.setTpoDocRef(docRef);
                    reference3.setFolioRef(DocNoHES);
                    Timestamp dateHES = invoice.getDateInvoiced();
                    if (dateHES == null) {
                        dateHES = invoice.getDateInvoiced();
                    }
                    reference3.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(dateHES)));
                    doc.getReferencia().add(reference3);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            PersonalizadosA personalizados = new PersonalizadosA();
            dte.setPersonalizados(personalizados);
            personalizados.setDocPersonalizado(new DocPersonalizadoA());
            if (invoice.getDescription() != null && invoice.getDescription().trim().length() > 0) {
                CampoStringA campoString = new CampoStringA();
                campoString.setName("Notas");
                campoString.setPrimitiveValue(invoice.getDescription());
                personalizados.getDocPersonalizado().getCampoString().add(campoString);
            }
            ImpresionA impresion = new ImpresionA();
            personalizados.getDocPersonalizado().setImpresion(impresion);
            if (invoice.getSalesRep_ID() > 0) {
                impresion.setPersonalizado_02(invoice.getSalesRep().getC_BPartner().getName() == null ? invoice.getSalesRep().getName() : invoice.getSalesRep().getC_BPartner().getName());
            }
            impresion.setPersonalizado_03(invoice.getC_PaymentTerm().getName());
            String fechaResolucion = "2014-08-22";
            int numeroResolucion = 80;
            int tipoPdf417 = 1;
            Servicio servicio = new Servicio(this.apiURL, this.apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, this.ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            dte.toXml();
            this.log.config("dte " + dte.toXml());
            this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
                error = "DTE Enviado OK";
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
            invoice.set_CustomColumn("EK_DescriptionFEL", error);
            invoice.saveEx(invoice.get_TrxName());
        }
        catch (Exception e) {
            this.log.config(e.toString());
            error = e.toString();
        }
        return "Procesado " + ted + " - " + pdf417 + " - " + error;
    }

    public String ConverDateToString(Timestamp fecha) {
        Object dateReturn = "";
        this.log.config("month" + fecha.getMonth() + "1");
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }

    public String CreateXMLBoleta(MInvoice invoice) {
        String wsRespuesta = "";
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        MOrg org = new MOrg(invoice.getCtx(), invoice.getAD_Org_ID(), invoice.get_TrxName());
        String fechaResolucion = org.get_ValueAsString("FchResol");
        int numeroResolucion = Integer.parseInt(org.get_ValueAsString("NroResol"));
        if (doc.get_Value("CreateXML") == null || !((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("EK_SIICode"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "ID_" + invoice.getDocumentNo());
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element FechaResolEle = document.createElement("FechaResol");
            Text textFchResol = document.createTextNode(fechaResolucion);
            FechaResolEle.appendChild(textFchResol);
            Encabezado2.appendChild(FechaResolEle);
            Element NroResolEle = document.createElement("NroResol");
            Text textNroResol = document.createTextNode(Integer.toString(numeroResolucion));
            NroResolEle.appendChild(textNroResol);
            Encabezado2.appendChild(NroResolEle);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element IndServicio = document.createElement("IndServicio");
            Text IndServTxt = document.createTextNode("3");
            IndServicio.appendChild(IndServTxt);
            IdDoc2.appendChild(IndServicio);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS((String)invoice.get_TrxName(), (String)"SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", (Object[])new Object[]{invoice.get_ID()});
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID()));
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(fchVencCal.toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc2.appendChild(FchVenc);
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get((Properties)invoice.getCtx(), (int)invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("EK_Value"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            nameRzn = nameRzn.replace("'", "");
            nameRzn = nameRzn.replace("\"", "");
            Element RznSoc = document.createElement("RznSocEmisor");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            String giroEmisStr = (String)company.get_Value("EK_BusinessType");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            Element GiroEmis = document.createElement("GiroEmisor");
            Text gi = document.createTextNode(giroEmisStr);
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode("66666666-6");
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            String RznSocRecepStr = "Cliente Boletas";
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(RznSocRecepStr);
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            Object dirRecepStr = bloc.getLocation(true).getAddress1() + "-" + bloc.getPhone();
            dirRecepStr = ((String)dirRecepStr).replace("'", "");
            dirRecepStr = ((String)dirRecepStr).replace("\"", "");
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode((String)dirRecepStr);
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            if (CmnaRecepStr == null) {
                CmnaRecepStr = "Santiago";
            }
            if (CmnaRecepStr.length() > 20) {
                CmnaRecepStr = CmnaRecepStr.substring(0, 20);
            }
            this.log.config("CmnaRecep = " + CmnaRecepStr);
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(CmnaRecepStr);
            CmnaRecep.appendChild(Cmna);
            Receptor2.appendChild(CmnaRecep);
            String ciudadTxt = "";
            ciudadTxt = bloc.getLocation(true).getC_Region_ID() == 1000001 || bloc.getLocation(true).getC_City_ID() <= 0 ? "SANTIAGO" : bloc.getC_Location().getCity();
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(ciudadTxt != null ? ciudadTxt : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountex = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales2.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales2.appendChild(MntExe);
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales2.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            int lineDiscount = 0;
            HashMap<String, BigDecimal> HashCodeQty = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> HashCodeAmount = new HashMap<String, BigDecimal>();
            HashMap<String, String> HashCodeName = new HashMap<String, String>();
            HashMap<String, String> HashCodeUPC = new HashMap<String, String>();
            HashMap<String, String> HashCodeUOM = new HashMap<String, String>();
            HashMap<String, BigDecimal> HashCodeRate = new HashMap<String, BigDecimal>();
            for (MInvoiceLine iLine : iLines) {
                if (iLine.getM_Product_ID() == 0 && iLine.getC_Charge_ID() == 0) continue;
                String valuecod = "";
                String namecod = "";
                String upccod = "";
                String uomcod = "";
                if (iLine.getM_Product_ID() > 0) {
                    String sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    String result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    if (result == null || result.compareTo("-") == 0) {
                        sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                        result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), 2045812});
                        this.log.config("sql = " + sql);
                        this.log.config("product " + iLine.getM_Product_ID());
                        valuecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getValue() : result;
                    } else {
                        valuecod = result;
                    }
                    sql = "SELECT coalesce(description,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                    result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID()});
                    if (result == null || result.compareTo("-") == 0) {
                        sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                        result = DB.getSQLValueString((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{iLine.getM_Product_ID(), 2045812});
                        this.log.config("sql = " + sql);
                        this.log.config("product " + iLine.getM_Product_ID());
                        namecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getName() : result;
                    } else {
                        namecod = result;
                    }
                    if (iLine.getM_Product().getC_UOM().getUOMSymbol() != null) {
                        uomcod = iLine.getM_Product().getC_UOM().getUOMSymbol();
                    }
                    if (iLine.getM_Product().getUPC() != null) {
                        upccod = iLine.getM_Product().getUPC();
                    }
                } else {
                    valuecod = "CARGO";
                    namecod = iLine.getC_Charge().getName();
                    upccod = " ";
                    uomcod = "UN";
                }
                HashCodeName.put(valuecod, namecod);
                HashCodeUPC.put(valuecod, upccod);
                HashCodeUOM.put(valuecod, uomcod);
                if (iLine.getC_Tax().getRate().compareTo(Env.ZERO) != 0) {
                    HashCodeRate.put(valuecod, iLine.getC_Tax().getRate());
                } else {
                    HashCodeRate.put(valuecod, Env.ZERO);
                }
                if (HashCodeQty.get(valuecod) != null) {
                    HashCodeQty.put(valuecod, ((BigDecimal)HashCodeQty.get(valuecod)).add(iLine.getQtyInvoiced()));
                    HashCodeAmount.put(valuecod, ((BigDecimal)HashCodeAmount.get(valuecod)).add(iLine.getLineNetAmt()));
                    continue;
                }
                HashCodeQty.put(valuecod, iLine.getQtyInvoiced());
                HashCodeAmount.put(valuecod, iLine.getLineNetAmt());
            }
            for (String i : HashCodeQty.keySet()) {
                if (((BigDecimal)HashCodeAmount.get(i)).compareTo(Env.ZERO) >= 0) {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(++lineInvoice));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element cdgItem = document.createElement("CdgItem");
                    Detalle2.appendChild(cdgItem);
                    Element TpoCodigo = document.createElement("TpoCodigo");
                    Text descTpoCod = document.createTextNode("INT");
                    TpoCodigo.appendChild(descTpoCod);
                    cdgItem.appendChild(TpoCodigo);
                    Element VlrCodigo = document.createElement("VlrCodigo");
                    Text descVlrCod = document.createTextNode(i);
                    VlrCodigo.appendChild(descVlrCod);
                    cdgItem.appendChild(VlrCodigo);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = ((String)HashCodeName.get(i)).concat((String)HashCodeUPC.get(i));
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(((BigDecimal)HashCodeQty.get(i)).toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    String unmdItemStr = "";
                    unmdItemStr = (String)HashCodeUOM.get(i);
                    Element UnmdItem = document.createElement("UnmdItem");
                    Text UM = document.createTextNode(unmdItemStr);
                    UnmdItem.appendChild(UM);
                    Detalle2.appendChild(UnmdItem);
                    BigDecimal prcItem = null;
                    BigDecimal mntItem = null;
                    BigDecimal prcItemTax = null;
                    BigDecimal mntItemTax = null;
                    BigDecimal unitario = ((BigDecimal)HashCodeAmount.get(i)).divide((BigDecimal)HashCodeQty.get(i), RoundingMode.HALF_UP);
                    this.log.config("unitario " + String.valueOf(unitario));
                    if (invoice.getC_DocType().getDocBaseType().compareToIgnoreCase("ARI") == 0 && invoice.getC_DocType().getName().toLowerCase().contains("boleta") && ((BigDecimal)HashCodeRate.get(i)).compareTo(Env.ZERO) != 0) {
                        prcItemTax = unitario.multiply((BigDecimal)HashCodeRate.get(i));
                        prcItemTax = prcItemTax.divide(Env.ONEHUNDRED);
                        prcItem = unitario.add(prcItemTax);
                        mntItemTax = ((BigDecimal)HashCodeAmount.get(i)).multiply((BigDecimal)HashCodeRate.get(i));
                        mntItemTax = mntItemTax.divide(Env.ONEHUNDRED);
                        mntItem = ((BigDecimal)HashCodeAmount.get(i)).add(mntItemTax);
                    } else {
                        prcItem = unitario;
                        mntItem = (BigDecimal)HashCodeAmount.get(i);
                    }
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(prcItem.setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle2.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(mntItem.setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle2.appendChild(MontoItem);
                    continue;
                }
                Element Descuento = document.createElement("DscRcgGlobal");
                Documento2.appendChild(Descuento);
                Element NroLinDis = document.createElement("NroLinDR");
                Text lineDis = document.createTextNode(Integer.toString(++lineDiscount));
                NroLinDis.appendChild(lineDis);
                Descuento.appendChild(NroLinDis);
                Element Tpomov = document.createElement("TpoMov");
                Text descMov = document.createTextNode("D");
                Tpomov.appendChild(descMov);
                Descuento.appendChild(Tpomov);
                String pnameDis = "";
                pnameDis = ((String)HashCodeName.get(i)).concat((String)HashCodeUPC.get(i));
                Element GlosaDR = document.createElement("GlosaDR");
                Text descGlosaDR = document.createTextNode(pnameDis);
                GlosaDR.appendChild(descGlosaDR);
                Descuento.appendChild(GlosaDR);
                Element TpoValor = document.createElement("TpoValor");
                Text descTpoValor = document.createTextNode("$");
                TpoValor.appendChild(descTpoValor);
                Descuento.appendChild(TpoValor);
                Element TpoValorDRValor = document.createElement("ValorDR");
                Text descValorDR = document.createTextNode(((BigDecimal)HashCodeAmount.get(i)).abs().setScale(0, 4).toString());
                TpoValorDRValor.appendChild(descValorDR);
                Descuento.appendChild(TpoValorDRValor);
            }
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir2");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, invoice.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("version", "1.0");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            byte[] fileArray = new byte[(int)file.length()];
            FileInputStream inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read(fileArray);
            this.log.config("XML enviado: " + file.toString());
            byte[] encoded = Base64.encodeBase64((byte[])fileArray);
            String encodedFile = "";
            try {
                encodedFile = new String(encoded);
            }
            catch (Exception TpoValorDRValor) {
                // empty catch block
            }
            this.log.config("XML enviado base64: " + encodedFile.toString());
            boolean tipoPdf417 = true;
            String ResponseText = "";
            try {
                String invokeURI = "http://192.168.0.200/api/Core.svc/core/SendDocumentAsXML";
                try {
                    String request = "<SendDocumentAsXMLRequest xmlns=\"http://gdexpress.cl/api\"><Environment>" + this.ambiente + "</Environment>  <Content>" + encodedFile + "</Content><ResolutionDate>" + fechaResolucion + "</ResolutionDate><ResolutionNumber>" + numeroResolucion + "</ResolutionNumber><PDF417Columns></PDF417Columns><PDF417Level></PDF417Level><PDF417Type></PDF417Type><TED></TED></SendDocumentAsXMLRequest>";
                    URL url = new URL(invokeURI);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("AuthKey", this.apiAuth);
                    conn.setRequestProperty("Accept", "application/xml");
                    conn.setRequestProperty("Content-Type", "application/xml; charset=utf-8");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                    wr.write(request.getBytes("UTF-8"));
                    wr.flush();
                    wr.close();
                    InputStream is = conn.getInputStream();
                    DataInputStream dis = new DataInputStream(is);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[2028];
                    int read = 0;
                    while ((read = dis.read(buffer)) != -1) {
                        baos.write(buffer, 0, read);
                    }
                    byte[] ResponseBytes = baos.toByteArray();
                    ResponseText = new String(ResponseBytes);
                    System.out.println(ResponseText);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            invoice.set_CustomColumn("EK_DescriptionFEL", ResponseText);
            invoice.saveEx(invoice.get_TrxName());
            if (ResponseText.contains("<Result>0</Result>")) {
                wsRespuesta = "DTE Enviado OK";
                this.log.config(wsRespuesta);
            } else {
                wsRespuesta = "ERROR en DTE Enviado";
                this.log.config(wsRespuesta);
            }
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG Generated " + wsRespuesta;
    }
}

