/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoRecuperarPDF;
import dteboxcliente.ResultadoRecuperarXML;
import dteboxcliente.Servicio;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.process.SvrProcess;

public class EKProcessGDExpressDownloadPDF
extends SvrProcess {
    private int p_c_invoice_id;
    private String ambiente = "";
    private String serverHostName = "";

    protected void prepare() {
        this.p_c_invoice_id = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.getCtx(), this.p_c_invoice_id, this.get_TrxName());
        MOrg org = new MOrg(this.getCtx(), inv.getAD_Org_ID(), this.get_TrxName());
        MDocType docType = new MDocType(this.getCtx(), inv.getC_DocTypeTarget_ID(), this.get_TrxName());
        this.ambiente = org.get_ValueAsString("AJ_DTEBoxEnvironment");
        InetAddress ip = InetAddress.getLocalHost();
        this.serverHostName = ip.getHostName();
        if (this.serverHostName.contains("ad2211")) {
            this.serverHostName = "eureka.ajah.cl";
        } else if (this.serverHostName.contains("ad2217")) {
            this.serverHostName = "eurekadev.ajah.cl";
        }
        Object estado = this.getPDF(inv, org, docType);
        estado = (String)estado + " " + this.getXML(inv, org, docType);
        return estado;
    }

    private String getPDF(MInvoice inv, MOrg org, MDocType docType) {
        block7: {
            long folio;
            GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
            String rut = org.get_ValueAsString("EK_Value");
            int tipoDTE = docType.get_ValueAsInt("EK_SIICode");
            try {
                folio = Long.parseLong(inv.getDocumentNo());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("El N\u00b0" + inv.getDocumentNo() + " no se puede convertir a Numero.");
            }
            String apiURL = "http://200.6.96.14/api/Core.svc/Core";
            String apiAuth = "a497c198-a553-4ad0-8576-3cd227dc2f57";
            String path = "/opt/pdf/";
            if (org.get_ValueAsString("EK_ExportPath") != null && org.get_ValueAsString("EK_ExportPath").length() > 0) {
                path = org.get_ValueAsString("EK_ExportPath");
            }
            Servicio servicio = new Servicio(apiURL, apiAuth);
            ResultadoRecuperarPDF resultado = servicio.RecuperarPdf(this.ambiente, grupo, rut, tipoDTE, folio);
            try {
                if (resultado.getResultadoServicio().getEstado() == 0) {
                    String nameFile;
                    byte[] pdf = resultado.getDatos();
                    if (this.createPDF(pdf, path, nameFile = "T" + tipoDTE + "F" + inv.getDocumentNo() + "E" + rut)) {
                        inv.set_CustomColumn("AJ_PDFGDE", "https://" + this.serverHostName + "/pdf/" + nameFile + ".pdf");
                        inv.saveEx();
                        return "Se crea achivo " + nameFile;
                    }
                    break block7;
                }
                return resultado.getResultadoServicio().getDescripcion();
            }
            catch (Exception e) {
                throw new AdempiereException("Error al descargar PDF: " + e.toString());
            }
        }
        return null;
    }

    private boolean createPDF(byte[] pdf, String exportDir, String nameFile) throws Exception {
        try {
            String filePath = exportDir + nameFile + ".pdf";
            FileOutputStream out = new FileOutputStream(filePath);
            ((OutputStream)out).write(pdf);
            ((OutputStream)out).close();
            String os = System.getProperty("os.name").toLowerCase();
            if (!os.contains("win")) {
                Path path = Paths.get(filePath, new String[0]);
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                Files.setPosixFilePermissions(path, permissions);
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("Error:" + String.valueOf(e));
        }
    }

    private String getXML(MInvoice inv, MOrg org, MDocType docType) {
        block7: {
            long folio;
            GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
            String rutEmisor = org.get_ValueAsString("EK_Value");
            boolean esParaDistribucion = true;
            int tipoDocumento = docType.get_ValueAsInt("EK_SIICode");
            try {
                folio = Long.parseLong(inv.getDocumentNo());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("El N\u00b0" + inv.getDocumentNo() + " no se puede convertir a Numero.");
            }
            String apiURL = "http://200.6.96.14/api/Core.svc/Core";
            String apiAuth = "a497c198-a553-4ad0-8576-3cd227dc2f57";
            String path = "/opt/pdf/";
            if (org.get_ValueAsString("EK_ExportPath") != null && org.get_ValueAsString("EK_ExportPath").length() > 0) {
                path = org.get_ValueAsString("EK_ExportPath");
            }
            Servicio servicio = new Servicio(apiURL, apiAuth);
            ResultadoRecuperarXML resultado = servicio.RecuperarXml(this.ambiente, grupo, rutEmisor, tipoDocumento, folio, esParaDistribucion);
            try {
                if (resultado.getResultadoServicio().getEstado() == 0) {
                    String nameFile;
                    String xml = resultado.getDatos();
                    if (this.createXML(xml, path, nameFile = "T" + tipoDocumento + "F" + inv.getDocumentNo() + "E" + rutEmisor)) {
                        inv.set_CustomColumn("EK_URLXML", "https://" + this.serverHostName + "/pdf/" + nameFile + ".xml");
                        inv.saveEx();
                        return "Se crea achivo " + nameFile + ".xml";
                    }
                    break block7;
                }
                return resultado.getResultadoServicio().getDescripcion();
            }
            catch (Exception e) {
                throw new AdempiereException("Error al descargar XML: " + e.toString());
            }
        }
        return null;
    }

    private boolean createXML(String xmlContent, String exportDir, String nameFile) throws Exception {
        try {
            String filePath = exportDir + nameFile + ".xml";
            FileOutputStream out = new FileOutputStream(filePath);
            ((OutputStream)out).write(xmlContent.getBytes());
            ((OutputStream)out).close();
            String os = System.getProperty("os.name").toLowerCase();
            if (!os.contains("win")) {
                Path path = Paths.get(filePath, new String[0]);
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                Files.setPosixFilePermissions(path, permissions);
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("Error:" + e.getMessage(), e);
        }
    }
}

