/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoDocumentos;
import dteboxcliente.ResultadoRecuperarPDF;
import dteboxcliente.ResumenDTE;
import dteboxcliente.Servicio;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MOrg;
import org.compiere.process.SvrProcess;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EKProcessGDExpressGetPDFInOut
extends SvrProcess {
    private int p_m_inout_id;
    private String ambiente = "";

    protected void prepare() {
        this.p_m_inout_id = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInOut inout = new MInOut(this.getCtx(), this.p_m_inout_id, this.get_TrxName());
        MOrg org = new MOrg(this.getCtx(), inout.getAD_Org_ID(), this.get_TrxName());
        MDocType docType = new MDocType(this.getCtx(), inout.getC_DocType_ID(), this.get_TrxName());
        this.ambiente = org.get_ValueAsString("AJ_DTEBoxEnvironment");
        String estado = this.getPDFUrl(inout, org, docType);
        return estado;
    }

    private String getPDF(MInOut inout, MOrg org, MDocType docType) {
        block6: {
            long folio;
            GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
            String rut = org.get_ValueAsString("EK_Value");
            int tipoDTE = docType.get_ValueAsInt("EK_SIICode");
            try {
                folio = Long.parseLong(inout.getDocumentNo());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("El N\u00b0" + inout.getDocumentNo() + " no se puede convertir a Numero.");
            }
            String apiURL = "http://200.6.96.14/api/Core.svc/Core";
            String apiAuth = "a497c198-a553-4ad0-8576-3cd227dc2f57";
            Object error = null;
            Servicio servicio = new Servicio(apiURL, apiAuth);
            ResultadoRecuperarPDF resultado = servicio.RecuperarPdf(this.ambiente, grupo, rut, tipoDTE, folio);
            try {
                if (resultado.getResultadoServicio().getEstado() == 0) {
                    byte[] pdf = resultado.getDatos();
                    if (this.createPDF(pdf, "D:\\PDF\\", inout.getDocumentNo())) {
                        return "Se crea achivo D:\\PDF\\" + inout.getDocumentNo();
                    }
                    break block6;
                }
                return resultado.getResultadoServicio().getDescripcion();
            }
            catch (Exception e) {
                throw new AdempiereException("Error al descargar PDF: " + e.toString());
            }
        }
        return null;
    }

    private boolean createPDF(byte[] pdf, String ExportDir, String folio) throws Exception {
        try {
            FileOutputStream out = new FileOutputStream(ExportDir + folio + ".pdf");
            ((OutputStream)out).write(pdf);
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            throw new Exception("Error:" + String.valueOf(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getPDFUrl(MInOut inout, MOrg org, MDocType docType) {
        int pageSize;
        String folio;
        String rutEmisor;
        String apiURL = "http://200.6.96.14/api/Core.svc/Core";
        String apiAuth = "a497c198-a553-4ad0-8576-3cd227dc2f57";
        Servicio servicio = new Servicio(apiURL, apiAuth);
        GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
        String DTE = docType.get_ValueAsString("EK_SIICode");
        String consulta = "(TipoDTE:" + DTE + " AND RUTEmisor:" + (rutEmisor = org.get_ValueAsString("EK_Value")) + " AND Folio:" + (folio = inout.getDocumentNo()) + ")";
        ResultadoDocumentos resultado = servicio.BuscarDocumentos(this.ambiente, grupo, consulta, 0, pageSize = 10);
        if (resultado.getResultadoServicio().getEstado() != 0) {
            String error = resultado.getResultadoServicio().getDescripcion();
            resultado.getResultadoServicio().getExcepcionOriginal().printStackTrace();
            throw new AdempiereException(error);
        }
        if (resultado.getTotalDocumentos() <= 0) {
            inout.set_CustomColumn("AJ_PDFGDE", "No esta presente la URL del PDF.");
            inout.saveEx(this.get_TrxName());
            return "No esta presente la URL del PDF.";
        }
        int pages = resultado.getTotalPages();
        int page = 0;
        int count = 0;
        do {
            System.out.println("P\u00e1gina: " + page);
            System.out.println("-------------------------------------------------------");
            for (ResumenDTE doc : resultado.getDocumentos()) {
                folio = "";
                rutEmisor = "";
                if (doc != null) {
                    folio = String.valueOf(doc.Folio);
                    rutEmisor = doc.RUTEmisor;
                }
                System.out.println(count++ + " - " + folio + " - " + rutEmisor);
            }
            inout.set_CustomColumn("AJ_PDFGDE", this.getXMLTag(resultado.getXml(), "DownloadCustomerDocumentUrl"));
            inout.saveEx(this.get_TrxName());
            if (++page < pages) {
                resultado = servicio.BuscarDocumentos(this.ambiente, grupo, consulta, page, pageSize);
            }
            if (page >= pages) return "Se obtiene url del PDF";
        } while (resultado.getResultadoServicio().getEstado() == 0);
        return "Se obtiene url del PDF";
    }

    private String getXMLTag(String xmlString, String tagName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xmlString)));
            NodeList nodeList = document.getElementsByTagName(tagName);
            if (nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                String tagContent = element.getTextContent();
                return tagContent;
            }
            return "El tag " + tagName + " no se encontr\u00f3 en el XML.";
        }
        catch (Exception e) {
            throw new AdempiereException("Error al obtener tag " + tagName + ": " + e.toString());
        }
    }
}

