/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessSwitchProductionProductByWidth
extends SvrProcess {
    private String p_Token = "Cambiar Cono";
    private int p_WidthAttribute_ID = 1000036;
    private BigDecimal p_Tolerance = Env.ZERO;
    private boolean p_DryRun = false;
    private Properties ctx;
    private String trxName;
    private int p_M_Production_ID = 0;

    protected void prepare() {
        this.ctx = this.getCtx();
        this.trxName = this.get_TrxName();
        this.p_M_Production_ID = this.getRecord_ID();
        ProcessInfoParameter[] params = this.getParameter();
        if (params != null) {
            block12: for (ProcessInfoParameter para : params) {
                String name = para.getParameterName();
                if (name == null) continue;
                switch (name) {
                    case "TokenDocumentNote": {
                        if (para.getParameter() == null) continue block12;
                        this.p_Token = para.getParameterAsString();
                        continue block12;
                    }
                    case "WidthAttribute_ID": {
                        if (para.getParameter() == null) continue block12;
                        this.p_WidthAttribute_ID = ((BigDecimal)para.getParameter()).intValue();
                        continue block12;
                    }
                    case "ToleranceMM": {
                        if (para.getParameter() == null) continue block12;
                        this.p_Tolerance = (BigDecimal)para.getParameter();
                        continue block12;
                    }
                    case "DryRun": {
                        this.p_DryRun = "Y".equals(para.getParameterAsString());
                    }
                }
            }
        }
        if (this.p_M_Production_ID <= 0) {
            throw new AdempiereException("No hay M_Production seleccionada.");
        }
    }

    protected String doIt() throws Exception {
        String noteUpd;
        MProductionLine exLine;
        BigDecimal existQty;
        Integer existLineId;
        BigDecimal targetQty;
        MProductionLine finished;
        MProduction prod = new MProduction(this.ctx, this.p_M_Production_ID, this.trxName);
        if (prod.get_ID() <= 0) {
            throw new AdempiereException("M_Production no encontrada: " + this.p_M_Production_ID);
        }
        List<MProductionLine> linesToCheck = this.fetchProductionLinesWithToken(prod.get_ID(), this.p_Token);
        if (linesToCheck.isEmpty()) {
            this.addLog("No hay l\u00edneas para revisar (token: \"" + this.p_Token + "\").");
        }
        int total = 0;
        int replaced = 0;
        int skipped = 0;
        StringBuilder sbInfo = new StringBuilder();
        for (MProductionLine pl : linesToCheck) {
            ++total;
            try {
                int curProdID = pl.getM_Product_ID();
                MProduct curProd = MProduct.get(this.ctx, curProdID);
                BigDecimal anchoMM = this.getWidthFromOrderLineASI(prod.get_ValueAsInt("C_OrderLine_ID"), this.p_WidthAttribute_ID);
                if (anchoMM == null) {
                    ++skipped;
                    sbInfo.append(EKProcessSwitchProductionProductByWidth.msg(pl, curProd, "Sin ancho (mm) en ASI de la Nota de Venta; se omite.")).append('\n');
                    continue;
                }
                ProductCandidate candidate = this.findBestCandidateByWidth(curProd.getDocumentNote(), anchoMM, this.p_Tolerance);
                if (candidate == null) {
                    ++skipped;
                    sbInfo.append(EKProcessSwitchProductionProductByWidth.msg(pl, curProd, "Sin candidato con ancho=" + String.valueOf(anchoMM) + "\u00b1" + String.valueOf(this.p_Tolerance) + " mm.")).append('\n');
                    continue;
                }
                if (candidate.productId == curProdID) {
                    sbInfo.append(EKProcessSwitchProductionProductByWidth.msg(pl, curProd, "Ya coincide con el producto correcto (ancho=" + String.valueOf(candidate.shelfWidth) + ").")).append('\n');
                    continue;
                }
                String note = "AUTO: reemplazado por match Ancho(mm)=" + String.valueOf(anchoMM);
                if (!this.p_DryRun) {
                    this.replaceProductionLineProduct(pl, candidate.productId, note);
                }
                ++replaced;
                sbInfo.append(EKProcessSwitchProductionProductByWidth.msg(pl, curProd, "Reemplazado -> M_Product_ID=" + candidate.productId + " (ShelfWidth=" + String.valueOf(candidate.shelfWidth) + "). DryRun=" + this.p_DryRun)).append('\n');
            }
            catch (Exception ex) {
                ++skipped;
                sbInfo.append("L\u00ednea ID=").append(pl.getM_ProductionLine_ID()).append(" ERROR: ").append(ex.getMessage()).append('\n');
                this.log.warning(ex.getMessage());
            }
        }
        try {
            finished = this.findFinishedProductLine(prod);
            if (finished == null) {
                this.addLog("No se encontr\u00f3 l\u00ednea de producto terminado; se omite material de cinta/etiqueta.");
            } else {
                int finishedLineID = finished.getM_ProductionLine_ID();
                int matProdID = DB.getSQLValue((String)this.trxName, (String)"SELECT adempiere.getic_printmaterial(?)", (int)finishedLineID);
                if (matProdID > 0) {
                    BigDecimal qtyFinished = finished.getMovementQty();
                    if (qtyFinished == null) {
                        qtyFinished = Env.ZERO;
                    }
                    if (qtyFinished.signum() == 0) {
                        this.addLog("Cantidad del terminado es 0; no se inserta l\u00ednea de material de impresi\u00f3n.");
                    } else {
                        Integer existLineId2 = DB.getSQLValue((String)this.trxName, (String)"SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND M_Product_ID=? AND IsActive='Y' ORDER BY M_ProductionLine_ID ASC LIMIT 1", (int)prod.getM_Production_ID(), (int)matProdID);
                        BigDecimal m2 = DB.getSQLValueBD((String)this.trxName, (String)"SELECT adempiere.getic_printmaterial_m2(?)", (int)finishedLineID);
                        if (m2 == null) {
                            m2 = Env.ZERO;
                        }
                        BigDecimal targetQty2 = m2.negate();
                        if (existLineId2 != null && existLineId2 > 0) {
                            BigDecimal existQty2 = DB.getSQLValueBD((String)this.trxName, (String)"SELECT MovementQty FROM M_ProductionLine WHERE M_ProductionLine_ID=?", (int)existLineId2);
                            if (existQty2 == null) {
                                existQty2 = Env.ZERO;
                            }
                            if (existQty2.compareTo(targetQty2) == 0) {
                                this.addLog("Material de impresi\u00f3n ya existe con la cantidad correcta (" + String.valueOf(existQty2) + "); no se modifica.");
                            } else {
                                if (!this.p_DryRun) {
                                    MProductionLine exLine2 = new MProductionLine(this.getCtx(), existLineId2, this.trxName);
                                    exLine2.setMovementQty(targetQty2);
                                    String d = exLine2.getDescription();
                                    String noteUpd2 = "AUTO: ajustar cantidad material impresi\u00f3n a " + String.valueOf(targetQty2);
                                    exLine2.setDescription(d == null || d.isEmpty() ? noteUpd2 : d + " | " + noteUpd2);
                                    exLine2.saveEx();
                                }
                                this.addLog("Material de impresi\u00f3n ya exist\u00eda con cantidad =" + String.valueOf(existQty2) + "; actualizado a " + String.valueOf(targetQty2));
                            }
                        } else {
                            if (!this.p_DryRun) {
                                this.createNegativeLineForPrintMaterial(prod, finished, matProdID, qtyFinished);
                            }
                            this.addLog("Material de impresi\u00f3n: agregado producto " + matProdID + " con Cant=" + String.valueOf(targetQty2));
                        }
                    }
                } else {
                    this.addLog("Se devolvi\u00f3 0; no se agrega material de impresi\u00f3n.");
                }
            }
        }
        catch (Exception ex) {
            this.addLog("Error agregando material de impresi\u00f3n: " + ex.getMessage());
            this.log.warning(ex.getMessage());
        }
        try {
            finished = this.findFinishedProductLine(prod);
            if (finished == null) {
                this.addLog("No se encontr\u00f3 l\u00ednea de producto terminado; se omite tinta negra.");
            } else {
                int finishedLineID = finished.getM_ProductionLine_ID();
                BigDecimal inkQty = DB.getSQLValueBD((String)this.trxName, (String)"SELECT adempiere.getic_printerink(?)", (int)finishedLineID);
                if (inkQty == null) {
                    inkQty = Env.ZERO;
                }
                if (inkQty.signum() == 0) {
                    this.addLog("Se Devolvi\u00f3 0; no se agrega tinta negra.");
                } else {
                    int inkProductID = 1053205;
                    targetQty = inkQty.negate();
                    existLineId = DB.getSQLValue((String)this.trxName, (String)"SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND M_Product_ID=? AND IsActive='Y' ORDER BY M_ProductionLine_ID ASC LIMIT 1", (int)prod.getM_Production_ID(), (int)inkProductID);
                    if (existLineId != null && existLineId > 0) {
                        existQty = DB.getSQLValueBD((String)this.trxName, (String)"SELECT MovementQty FROM M_ProductionLine WHERE M_ProductionLine_ID=?", (int)existLineId);
                        if (existQty == null) {
                            existQty = Env.ZERO;
                        }
                        if (existQty.signum() == 0) {
                            if (!this.p_DryRun) {
                                exLine = new MProductionLine(this.getCtx(), existLineId, this.trxName);
                                exLine.setMovementQty(targetQty);
                                String d = exLine.getDescription();
                                noteUpd = "AUTO: set tinta negra a " + String.valueOf(targetQty) + " (getic_printerink)";
                                exLine.setDescription(d == null || d.isEmpty() ? noteUpd : d + " | " + noteUpd);
                                exLine.saveEx();
                            }
                            this.addLog("L\u00ednea tinta negra existente con Cantidad=0; actualizada a " + String.valueOf(targetQty));
                        } else {
                            this.addLog("L\u00ednea tinta negra ya existe con Cantidad=" + String.valueOf(existQty) + "; no se modifica.");
                        }
                    } else {
                        if (!this.p_DryRun) {
                            MProduct inkProd = MProduct.get(this.getCtx(), inkProductID);
                            MProductionLine newLine = new MProductionLine(this.getCtx(), 0, this.trxName);
                            newLine.setAD_Org_ID(prod.getAD_Org_ID());
                            newLine.setM_Production_ID(prod.getM_Production_ID());
                            newLine.setM_Product_ID(inkProductID);
                            newLine.setMovementQty(targetQty);
                            newLine.setIsEndProduct(false);
                            int locatorId = prod.getM_Locator_ID();
                            if (locatorId <= 0 && finished.getM_Locator_ID() > 0) {
                                locatorId = finished.getM_Locator_ID();
                            }
                            newLine.setM_Locator_ID(locatorId);
                            newLine.setDescription("AUTO: agregado tinta negra ");
                            newLine.saveEx();
                        }
                        this.addLog("Tinta negra agregada: producto=" + inkProductID + ", Cantidad=" + String.valueOf(targetQty));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.addLog("Error agregando l\u00ednea de tinta negra: " + ex.getMessage());
            this.log.warning(ex.getMessage());
        }
        try {
            finished = this.findFinishedProductLine(prod);
            if (finished == null) {
                this.addLog("No se encontr\u00f3 l\u00ednea de producto terminado; se omiten Caja Carton Grande Cintas 12c.");
            } else {
                int finishedLineID = finished.getM_ProductionLine_ID();
                BigDecimal boxes = DB.getSQLValueBD((String)this.trxName, (String)"SELECT adempiere.getic_cajk_boxes(?)", (int)finishedLineID);
                if (boxes == null) {
                    boxes = Env.ZERO;
                }
                if (boxes.signum() == 0) {
                    this.addLog("getic_cajk_boxes devolvi\u00f3 0; no se agrega l\u00ednea de cajas.");
                } else {
                    Integer boxProdID = 1053233;
                    if (boxProdID == null || boxProdID <= 0) {
                        this.addLog("Producto Caja Carton Grande Cintas 12c no encontrado o inactivo; no se agrega l\u00ednea de cajas.");
                    } else {
                        targetQty = boxes.negate();
                        existLineId = DB.getSQLValue((String)this.trxName, (String)"SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND M_Product_ID=? AND IsActive='Y' ORDER BY M_ProductionLine_ID ASC LIMIT 1", (int)prod.getM_Production_ID(), (int)boxProdID);
                        if (existLineId != null && existLineId > 0) {
                            existQty = DB.getSQLValueBD((String)this.trxName, (String)"SELECT MovementQty FROM M_ProductionLine WHERE M_ProductionLine_ID=?", (int)existLineId);
                            if (existQty == null) {
                                existQty = Env.ZERO;
                            }
                            if (existQty.compareTo(targetQty) == 0) {
                                this.addLog("L\u00ednea Caja Carton Grande Cintas 12c ya existe con cantidad correcta (" + String.valueOf(existQty) + "); no se modifica.");
                            } else {
                                if (!this.p_DryRun) {
                                    exLine = new MProductionLine(this.getCtx(), existLineId, this.trxName);
                                    exLine.setMovementQty(targetQty);
                                    String d = exLine.getDescription();
                                    noteUpd = "AUTO: set Caja Carton Grande Cintas 12c = " + String.valueOf(targetQty);
                                    exLine.setDescription(d == null || d.isEmpty() ? noteUpd : d + " | " + noteUpd);
                                    exLine.saveEx();
                                }
                                this.addLog("L\u00ednea Caja Carton Grande Cintas 12c actualizada a " + String.valueOf(targetQty));
                            }
                        } else {
                            if (!this.p_DryRun) {
                                MProductionLine newLine = new MProductionLine(this.getCtx(), 0, this.trxName);
                                newLine.setAD_Org_ID(prod.getAD_Org_ID());
                                newLine.setM_Production_ID(prod.getM_Production_ID());
                                newLine.setM_Product_ID(boxProdID);
                                newLine.setIsEndProduct(false);
                                newLine.setMovementQty(targetQty);
                                int locatorId = prod.getM_Locator_ID();
                                if (locatorId <= 0 && finished.getM_Locator_ID() > 0) {
                                    locatorId = finished.getM_Locator_ID();
                                }
                                newLine.setM_Locator_ID(locatorId);
                                newLine.setDescription("AUTO: Caja Carton Grande Cintas 12c = " + String.valueOf(targetQty));
                                newLine.saveEx();
                            }
                            this.addLog("Caja Carton Grande Cintas 12c agregadas: Cant=" + String.valueOf(targetQty));
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.addLog("Error agregando Caja Carton Grande Cintas 12c: " + ex.getMessage());
            this.log.warning(ex.getMessage());
        }
        String summary = "L\u00edneas revisadas=" + total + ", reemplazadas=" + replaced + ", omitidas=" + skipped + ".";
        return summary + "\n" + String.valueOf(sbInfo);
    }

    private static String msg(MProductionLine pl, MProduct curProd, String tail) {
        return "ProdLineID=" + pl.getM_ProductionLine_ID() + " [Prod " + curProd.getValue() + " - " + curProd.getName() + "] " + tail;
    }

    private List<MProductionLine> fetchProductionLinesWithToken(int M_Production_ID, String token) {
        String sql = "SELECT pl.M_ProductionLine_ID FROM M_ProductionLine pl JOIN M_Product p ON (p.M_Product_ID = pl.M_Product_ID) WHERE pl.M_Production_ID=?   AND p.DocumentNote ILIKE ?   AND pl.IsActive='Y'";
        ArrayList<MProductionLine> list = new ArrayList<MProductionLine>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, M_Production_ID);
            pstmt.setString(2, "%" + token + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProductionLine(this.getCtx(), rs.getInt(1), this.get_TrxName()));
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("Error buscando l\u00edneas: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return list;
    }

    private MProductionLine findFinishedProductLine(MProduction prod) {
        String sql1 = "SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND IsActive='Y' AND IsEndProduct='Y' ORDER BY M_ProductionLine_ID ASC";
        int lineId = DB.getSQLValue((String)this.trxName, (String)sql1, (int)prod.getM_Production_ID());
        if (lineId > 0) {
            return new MProductionLine(this.getCtx(), lineId, this.trxName);
        }
        String sql2 = "SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND IsActive='Y' AND MovementQty > 0 ORDER BY MovementQty DESC, M_ProductionLine_ID ASC LIMIT 1";
        lineId = DB.getSQLValue((String)this.trxName, (String)sql2, (int)prod.getM_Production_ID());
        if (lineId > 0) {
            return new MProductionLine(this.getCtx(), lineId, this.trxName);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal getWidthFromOrderLineASI(int C_OrderLine_ID, int widthAttrID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block11: {
            block12: {
                if (C_OrderLine_ID <= 0) {
                    return null;
                }
                int asiID = DB.getSQLValue((String)this.trxName, (String)"SELECT COALESCE(M_AttributeSetInstance_ID,0) FROM C_OrderLine WHERE C_OrderLine_ID=?", (int)C_OrderLine_ID);
                if (asiID <= 0) {
                    return null;
                }
                String sql = "SELECT COALESCE(Value, NULL) FROM M_AttributeInstance WHERE M_AttributeSetInstance_ID=? AND M_Attribute_ID=?";
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement((String)sql, (String)this.trxName);
                pstmt.setInt(1, asiID);
                pstmt.setInt(2, widthAttrID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block11;
                BigDecimal num = rs.getBigDecimal(1);
                if (num == null) break block12;
                BigDecimal bigDecimal2 = num;
                {
                    catch (Exception e) {
                        try {
                            throw new AdempiereException("Error leyendo ancho del ASI: " + e.getMessage(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, (Statement)pstmt);
                            throw throwable;
                        }
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                return bigDecimal2;
            }
            String val = rs.getString(2);
            if (val != null) {
                BigDecimal bigDecimal;
                try {
                    bigDecimal = new BigDecimal(val.trim().replace(",", "."));
                }
                catch (Exception exception) {}
                DB.close((ResultSet)rs, (Statement)pstmt);
                return bigDecimal;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return null;
    }

    private ProductCandidate findBestCandidateByWidth(String documentNoteRef, BigDecimal anchoMM, BigDecimal tol) {
        if (documentNoteRef == null || documentNoteRef.trim().isEmpty()) {
            return null;
        }
        String token = this.p_Token;
        StringBuilder where = new StringBuilder();
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        where.append("IsActive='Y'").append(" AND DocumentNote ILIKE ?").append(" AND ShelfWidth IS NOT NULL");
        params.add((CallSite)((Object)("%" + token + "%")));
        List candidates = new Query(this.ctx, "M_Product", where.toString(), this.trxName).setParameters(params).list();
        if (candidates.isEmpty()) {
            return null;
        }
        ProductCandidate best = null;
        BigDecimal bestDelta = null;
        for (MProduct p : candidates) {
            BigDecimal sw = (BigDecimal)p.get_Value("ShelfWidth");
            if (sw == null) continue;
            BigDecimal delta = sw.subtract(anchoMM).abs();
            boolean bl = tol == null || tol.signum() == 0 ? delta.compareTo(Env.ZERO) == 0 : delta.compareTo(tol) <= 0;
            boolean withinTol = bl;
            if (!withinTol || best != null && delta.compareTo(bestDelta) >= 0 && (delta.compareTo(bestDelta) != 0 || p.getM_Product_ID() >= best.productId)) continue;
            best = new ProductCandidate(p.getM_Product_ID(), sw);
            bestDelta = delta;
        }
        return best;
    }

    private void createNegativeLineForPrintMaterial(MProduction prod, MProductionLine finishedLine, int matProdID, BigDecimal qtyFinished) {
        MProduct matProd = MProduct.get(this.getCtx(), matProdID);
        MProductionLine newLine = new MProductionLine(this.getCtx(), 0, this.trxName);
        newLine.setAD_Org_ID(prod.getAD_Org_ID());
        newLine.setM_Production_ID(prod.getM_Production_ID());
        newLine.setM_Product_ID(matProdID);
        int locatorId = prod.getM_Locator_ID();
        if (locatorId <= 0) {
            locatorId = finishedLine.getM_Locator_ID();
        }
        newLine.setM_Locator_ID(locatorId);
        BigDecimal m2 = DB.getSQLValueBD((String)this.trxName, (String)"SELECT adempiere.getic_printmaterial_m2(?)", (Object[])new Object[]{finishedLine});
        if (m2 == null) {
            m2 = Env.ZERO;
        }
        BigDecimal targetQty = m2.negate();
        newLine.setMovementQty(targetQty);
        newLine.setIsEndProduct(false);
        String note = "AUTO: material para cinta/etiqueta desde getic_printmaterial(Line=" + finishedLine.getM_ProductionLine_ID() + ")";
        String old = newLine.getDescription();
        newLine.setDescription(old == null || old.isEmpty() ? note : old + " | " + note);
        newLine.saveEx();
    }

    private void replaceProductionLineProduct(MProductionLine pl, int newProductID, String note) {
        int oldProdID = pl.getM_Product_ID();
        pl.setM_Product_ID(newProductID);
        String old = pl.getDescription();
        String add = old == null || old.isEmpty() ? note : old + " | " + note;
        pl.setDescription(add);
        try {
            pl.saveEx();
        }
        catch (Exception e) {
            throw new AdempiereException("No se pudo guardar M_ProductionLine " + pl.getM_ProductionLine_ID(), (Throwable)e);
        }
        this.log.info("L\u00ednea " + pl.getM_ProductionLine_ID() + ": " + oldProdID + " -> " + newProductID);
    }

    private static class ProductCandidate {
        final int productId;
        final BigDecimal shelfWidth;

        ProductCandidate(int productId, BigDecimal shelfWidth) {
            this.productId = productId;
            this.shelfWidth = shelfWidth;
        }
    }
}

