/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MProject;
import org.compiere.model.X_AJP_ProjectPlanning;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessUpdatePriceList
extends SvrProcess {
    private int c_project_id;

    protected void prepare() {
        this.c_project_id = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MProject mp = new MProject(this.getCtx(), this.c_project_id, this.get_TrxName());
        int pricelist_id = mp.get_ValueAsInt("M_PriceList_ID");
        System.out.println("Proyecto ID: " + this.c_project_id);
        System.out.println("Lista de precios ID: " + pricelist_id);
        if (pricelist_id <= 0) {
            return "Price list not found";
        }
        String sql = "SELECT MAX(M_PriceList_Version_ID) FROM M_PriceList_Version WHERE IsActive='Y' AND M_PriceList_ID = ?";
        System.out.println("Ejecutando consulta: " + sql + " con par\u00e1metro: " + pricelist_id);
        int latestPLVId = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)pricelist_id);
        if (latestPLVId <= 0) {
            return "No price list version";
        }
        System.out.println("\u00daltima versi\u00f3n de la lista de precios ID: " + latestPLVId);
        String lines = "select m_product_id, ajp_projectplanning_id, c_project_id from adempiere.ajp_projectplanning where c_project_id = ? and m_product_id is not null";
        CPreparedStatement ps = DB.prepareStatement((String)lines, (String)this.get_TrxName());
        ps.setInt(1, this.c_project_id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            X_AJP_ProjectPlanning ajp = new X_AJP_ProjectPlanning(this.getCtx(), rs.getInt("ajp_projectplanning_id"), this.get_TrxName());
            BigDecimal price = DB.getSQLValueBD((String)this.get_TrxName(), (String)"SELECT PriceStd FROM M_ProductPrice WHERE M_Product_ID = ? is not null AND M_PriceList_Version_ID = ?", (Object[])new Object[]{ajp.getM_Product_ID(), latestPLVId});
            if (price != null) {
                BigDecimal factor = Env.ONE;
                if (ajp.getFactor().compareTo(Env.ZERO) != 0) {
                    factor = ajp.getFactor();
                }
                ajp.setAmt(price);
                ajp.setTotalAmt(price.multiply(ajp.getQty()).multiply(factor));
                System.out.println("Precio actualizado: " + String.valueOf(price));
            } else {
                ajp.setAmt(Env.ZERO);
                this.log.warning("Price product not found in the pricelist");
            }
            ajp.saveEx();
        }
        mp.set_ValueOfColumn("m_pricelist_version_id", (Object)latestPLVId);
        mp.saveEx();
        return "Proceso finalizado.";
    }
}

