/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.SvrProcess;

public class EKProcessUpdateSingleLinePrice
extends SvrProcess {
    private BigDecimal p_NewPrice;
    private Properties ctx;
    private String trxName;

    protected void prepare() {
        this.ctx = this.getCtx();
        this.trxName = this.get_TrxName();
        this.p_NewPrice = this.getParameterAsBigDecimal("NewPrice");
    }

    protected String doIt() throws Exception {
        int lineId = this.getRecord_ID();
        if (lineId <= 0) {
            throw new IllegalArgumentException("No hay l\u00ednea de orden seleccionada.");
        }
        if (this.p_NewPrice == null || this.p_NewPrice.signum() <= 0) {
            throw new IllegalArgumentException("Debe indicar un precio (> 0).");
        }
        MOrderLine line = new MOrderLine(this.ctx, lineId, this.trxName);
        if (line.get_ID() <= 0) {
            throw new IllegalArgumentException("L\u00ednea de orden no encontrada.");
        }
        MOrder order = line.getParent();
        if (order == null || order.get_ID() <= 0) {
            throw new IllegalArgumentException("Orden padre no encontrada.");
        }
        if (order.getM_PriceList_ID() != 1000469) {
            return "La orden no usa la Lista de Precios 1000469. No se realizaron cambios.";
        }
        line.set_CustomColumn("PriceList", this.p_NewPrice);
        line.setPriceActual(this.p_NewPrice);
        line.setPriceEntered(this.p_NewPrice);
        line.setDiscount(BigDecimal.ZERO);
        line.setLineNetAmt();
        line.saveEx();
        return "L\u00ednea " + line.getLine() + " actualizada con precio " + String.valueOf(this.p_NewPrice);
    }
}

