/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcess_CopyRole
extends SvrProcess {
    private int p_Role_ID;

    protected void prepare() {
        this.p_Role_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        StringBuilder resultMessage = new StringBuilder("Resumen de inserciones:\n");
        MRole rol = new MRole(this.getCtx(), this.p_Role_ID, this.get_TrxName());
        String[] tables = new String[]{"AD_Window_Access", "AD_Process_Access", "AD_Dashboard_Access", "AD_Document_Action_Access", "AD_Workflow_Access", "AD_Browse_Access", "AD_Role_Included"};
        String[] keycolumns = new String[]{"AD_Window_ID", "AD_Process_ID", "PA_DashboardContent_ID", "C_DocType_ID", "AD_Workflow_ID", "AD_Browse_ID", "Included_Role_ID"};
        ArrayList<Integer> client_ids = new ArrayList<Integer>();
        String sqlClientIds = "SELECT ad_client_id FROM ad_client WHERE ad_client_id NOT IN (11, 0, ?)";
        try (CPreparedStatement pstmt = DB.prepareStatement((String)sqlClientIds, (String)this.get_TrxName());){
            pstmt.setInt(1, rol.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                client_ids.add(rs.getInt("ad_client_id"));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error al obtener ad_client_id", (Throwable)e);
            return "Error al obtener ad_client_id: " + e.getMessage();
        }
        if (client_ids.isEmpty()) {
            return "No se encontraron ad_client_id para copiar.";
        }
        int action = 0;
        String trxName = this.get_TrxName();
        try {
            for (Integer Client_ID : client_ids) {
                int noInserted;
                boolean column_ref_list;
                int to_role_id = DB.getSQLValue((String)this.get_TrxName(), (String)"select ad_role_ID from ad_role where description= ? and ad_client_id= ?", (Object[])new Object[]{rol.getDescription(), Client_ID});
                if (to_role_id <= 0) {
                    String toclient_value = DB.getSQLValueString((String)this.get_TrxName(), (String)"select value from ad_client where ad_client_id= ?", (int)Client_ID);
                    MRole to_rol = new MRole(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)rol, (PO)to_rol);
                    to_rol.set_ValueOfColumn("AD_Client_ID", (Object)Client_ID);
                    to_rol.setName(toclient_value + " -> " + rol.getName());
                    to_rol.saveEx();
                    if (!to_rol.isManual()) {
                        resultMessage.append("Rol Cliente " + Client_ID + "Creado. ");
                        continue;
                    }
                    for (int i = 0; i < tables.length; ++i) {
                        String table = tables[i];
                        String keycolumn = keycolumns[i];
                        boolean column_IsReadWrite = !table.equals("AD_Document_Action_Access") && !table.equals("AD_Role_Included") && !table.equals("AD_Dashboard_Access");
                        boolean column_SeqNo = table.equals("AD_Role_Included");
                        column_ref_list = table.equals("AD_Document_Action_Access");
                        String sql = "INSERT INTO " + table + " (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, " + keycolumn + ", isActive";
                        if (column_SeqNo) {
                            sql = sql + ", SeqNo ";
                        }
                        if (column_IsReadWrite) {
                            sql = sql + ", isReadWrite";
                        }
                        if (column_ref_list) {
                            sql = sql + ", ad_ref_list_id";
                        }
                        sql = sql + ") ";
                        sql = sql + "SELECT " + Client_ID + ", 0, getdate(), " + Env.getAD_User_ID((Properties)Env.getCtx()) + ", getdate(), " + Env.getAD_User_ID((Properties)Env.getCtx()) + ", " + to_rol.getAD_Role_ID();
                        sql = table.equals("AD_Document_Action_Access") ? sql + ",dt2.C_DocType_ID " : sql + ", " + keycolumn;
                        sql = sql + ", t1.IsActive ";
                        if (column_SeqNo) {
                            sql = sql + ", SeqNo ";
                        }
                        if (column_IsReadWrite) {
                            sql = sql + ", isReadWrite ";
                        }
                        if (column_ref_list) {
                            sql = sql + ", ad_ref_list_id ";
                        }
                        sql = table.equals("AD_Document_Action_Access") ? sql + " from AD_Document_Action_Access t1  join C_DocType dt ON t1.C_DocType_ID=dt.C_DocType_ID  left join C_DocType dt2 ON dt.Name=dt2.Name and dt2.ad_Client_ID=" + Client_ID + " where dt2.C_DocType_ID is not null and t1.AD_Role_ID= " + this.p_Role_ID + " and t1.AD_Client_ID=" + rol.getAD_Client_ID() : sql + " FROM " + table + " t1 WHERE AD_Role_ID = " + this.p_Role_ID + " and ad_Client_ID=" + rol.getAD_Client_ID();
                        try {
                            noInserted = DB.executeUpdateEx((String)sql, (String)trxName);
                            this.addLog(action++, null, new BigDecimal(noInserted), "Registros insertados en " + table + " para AD_Client_ID = " + Client_ID);
                            resultMessage.append("Tabla: ").append(table).append(", Cliente: ").append(Client_ID).append(", Registros insertados: ").append(noInserted).append("\n");
                            continue;
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Error al insertar registros en " + table, (Throwable)e);
                            DB.rollback((boolean)true, (String)trxName);
                            return "Error al insertar registros en " + table + ": " + e.getMessage();
                        }
                    }
                    continue;
                }
                String isekcopy = DB.getSQLValueString((String)this.get_TrxName(), (String)"select isekcopy from ad_role where description= ? and ad_client_id= ?", (Object[])new Object[]{rol.getDescription(), Client_ID});
                if (!"Y".equals(isekcopy)) continue;
                for (int i = 0; i < tables.length; ++i) {
                    String table = tables[i];
                    String keycolumn = keycolumns[i];
                    String insertSql = "INSERT INTO " + table + " (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, " + keycolumn + ", IsActive";
                    boolean column_SeqNo = table.equals("AD_Role_Included");
                    boolean column_IsReadWrite = !table.equals("AD_Document_Action_Access") && !table.equals("AD_Role_Included") && !table.equals("AD_Dashboard_Access");
                    column_ref_list = table.equals("AD_Document_Action_Access");
                    if (column_SeqNo) {
                        insertSql = insertSql + ", SeqNo";
                    }
                    if (column_IsReadWrite) {
                        insertSql = insertSql + ", IsReadWrite";
                    }
                    if (column_ref_list) {
                        insertSql = insertSql + ", ad_ref_list_id ";
                    }
                    insertSql = insertSql + ") SELECT " + Client_ID + ", 0, getdate(), " + Env.getAD_User_ID((Properties)this.getCtx()) + ", getdate(), " + Env.getAD_User_ID((Properties)this.getCtx()) + ", " + to_role_id;
                    insertSql = table.equals("AD_Document_Action_Access") ? insertSql + " , dt2.C_DocType_ID " : insertSql + ", " + keycolumn;
                    insertSql = insertSql + ", t1.IsActive";
                    if (column_SeqNo) {
                        insertSql = insertSql + ", SeqNo";
                    }
                    if (column_IsReadWrite) {
                        insertSql = insertSql + ", IsReadWrite";
                    }
                    if (column_ref_list) {
                        insertSql = insertSql + ", ad_ref_list_id";
                    }
                    insertSql = table.equals("AD_Document_Action_Access") ? insertSql + " from AD_Document_Action_Access t1  join C_DocType dt ON t1.C_DocType_ID=dt.C_DocType_ID  left join C_DocType dt2 ON dt.Name=dt2.Name and dt2.ad_Client_ID=" + Client_ID + " where dt2.C_DocType_ID is not null and t1.AD_Role_ID= " + this.p_Role_ID + " and t1.AD_Client_ID=" + rol.getAD_Client_ID() + " AND NOT EXISTS (SELECT 1 FROM AD_Document_Action_Access sub \t\t\t\tWHERE sub.AD_Role_ID = " + to_role_id + " and sub.ad_Client_ID=" + Client_ID + " AND dt2.C_DocType_ID = sub.C_DocType_ID" : insertSql + " FROM " + table + " t1 WHERE AD_Role_ID = " + this.p_Role_ID + " AND NOT EXISTS (SELECT 1 FROM " + table + " sub  WHERE sub.AD_Role_ID = " + to_role_id + " AND t1." + keycolumn + " = sub." + keycolumn;
                    if (column_ref_list) {
                        insertSql = insertSql + " and t1.ad_ref_list_id=sub.ad_ref_list_id";
                    }
                    insertSql = insertSql + ")";
                    try {
                        noInserted = DB.executeUpdateEx((String)insertSql, (String)trxName);
                        this.addLog(action++, null, new BigDecimal(noInserted), "Accesos adicionales insertados en " + table + " para AD_Client_ID = " + Client_ID);
                        resultMessage.append("Tabla: ").append(table).append(", Cliente: ").append(Client_ID).append(", Registros adicionales insertados: ").append(noInserted).append("\n");
                        continue;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Error al insertar accesos adicionales en " + table, (Throwable)e);
                        DB.rollback((boolean)true, (String)trxName);
                        return "Error al insertar accesos adicionales en " + table + ": " + e.getMessage();
                    }
                }
            }
            DB.commit((boolean)true, (String)trxName);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error general durante la copia de permisos", (Throwable)e);
            DB.rollback((boolean)true, (String)trxName);
            return "Error durante la copia de permisos: " + e.getMessage();
        }
        return resultMessage.toString();
    }
}

