/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.process.InOutCreateInvoiceAbstract;
import org.compiere.process.ProcessInfoParameter;

public class InOutCreateInvoiceAJAH
extends InOutCreateInvoiceAbstract {
    private MInvoice invoice = null;
    private MOrder order = null;
    private boolean p_CompleteInvoice = false;

    protected void prepare() {
        ProcessInfoParameter[] para;
        super.prepare();
        for (ProcessInfoParameter p : para = this.getParameter()) {
            String name = p.getParameterName();
            if (name == null || !name.equalsIgnoreCase("CompleteInvoice")) continue;
            this.p_CompleteInvoice = "Y".equals(p.getParameter());
        }
    }

    protected String doIt() throws Exception {
        MInOutLine[] materialReceiptLines;
        this.log.info("M_InOut_ID=" + this.getRecord_ID() + ", M_PriceList_ID=" + this.getPriceListId() + ", InvoiceDocumentNo=" + this.getInvoiceDocumentNo());
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        Properties ctx = this.getCtx();
        String trxName = this.get_TrxName();
        MInOut io = new MInOut(ctx, this.getRecord_ID(), trxName);
        if (io.get_ID() == 0) {
            throw new IllegalArgumentException("Shipment not found");
        }
        this.ensureCompleted(io);
        for (MInOutLine materialReceiptLine : materialReceiptLines = io.getLines(false)) {
            Optional<MInvoiceLine> maybeInvoiceLine;
            if (this.order == null) {
                this.order = new MOrder(this.getCtx(), materialReceiptLine.getC_OrderLine().getC_Order_ID(), this.get_TrxName());
            }
            if ((maybeInvoiceLine = Optional.ofNullable(MInvoiceLine.getOfInOutLine((MInOutLine)materialReceiptLine))).isPresent()) continue;
            MInvoice invoice = this.getCreateHeader(io);
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setShipLine(materialReceiptLine);
            if (materialReceiptLine.sameOrderLineUOM()) {
                invoiceLine.setQtyEntered(materialReceiptLine.getQtyEntered());
            } else {
                invoiceLine.setQtyEntered(materialReceiptLine.getMovementQty());
            }
            invoiceLine.setQtyInvoiced(materialReceiptLine.getMovementQty());
            if (invoiceLine.save()) continue;
            throw new IllegalArgumentException("Cannot save Invoice Line");
        }
        if (this.invoice == null) {
            throw new AdempiereException("@InvoiceFullyMatched@");
        }
        if (this.p_CompleteInvoice) {
            this.invoice.setDocAction("CO");
            if (!this.invoice.processIt("CO")) {
                throw new AdempiereException("No se pudo completar la factura: " + this.invoice.getDocumentNo() + " - " + this.invoice.getProcessMsg());
            }
            this.invoice.saveEx();
        }
        return this.invoice.getDocumentNo();
    }

    private void ensureCompleted(MInOut io) {
        String ds = io.getDocStatus();
        if ("CO".equals(ds) || "CL".equals(ds)) {
            this.log.fine("M_InOut ya completada/cerrada: " + io.getDocumentNo());
            return;
        }
        io.setDocAction("CO");
        if (!io.processIt("CO")) {
            String msg = io.getProcessMsg();
            throw new AdempiereException("No se pudo completar la Entrega/Recepci\u00f3n " + io.getDocumentNo() + (String)(msg != null ? ": " + msg : ""));
        }
        io.saveEx();
        this.log.info("M_InOut completada: " + io.getDocumentNo());
    }

    private MInvoice getCreateHeader(MInOut shipment) {
        if (this.invoice != null) {
            return this.invoice;
        }
        this.invoice = new MInvoice(shipment, null);
        if (this.order != null) {
            this.invoice.setC_DocTypeTarget_ID(this.order.getC_DocType().getC_DocTypeInvoice_ID());
            this.invoice.setM_PriceList_ID(this.order.getM_PriceList_ID());
            if (this.order.getC_Project_ID() > 0) {
                int orderidpro = this.order.getC_Project_ID();
                int subproject = this.order.get_ValueAsInt("C_ProjectLine_ID");
                this.invoice.setC_Project_ID(orderidpro);
                this.invoice.set_ValueOfColumn("C_ProjectLine_ID", subproject);
            }
        } else {
            throw new AdempiereException("Entrega/Recepcion no tiene orden asociada");
        }
        if (this.getInvoiceDocumentNo() != null && this.getInvoiceDocumentNo().length() > 0) {
            this.invoice.setDocumentNo(this.getInvoiceDocumentNo());
        }
        if (!this.invoice.save()) {
            throw new IllegalArgumentException("Cannot save Invoice");
        }
        return this.invoice;
    }
}

