/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public final class ProductionMaterialAdjuster {
    private static final String COL_SHELF_WIDTH = "ShelfWidth";
    private static final int INK_PRODUCT_ID = 1053205;
    private static final int BOX_PRODUCT_ID = 1053233;

    private ProductionMaterialAdjuster() {
    }

    public static String apply(Properties ctx, int mProductionId, String trxName, String token, int widthAttrId, BigDecimal tol, boolean dryRun) {
        BigDecimal targetQty;
        MProductionLine finished;
        Integer orderLineId;
        if (mProductionId <= 0) {
            throw new AdempiereException("M_Production_ID inv\u00e1lido");
        }
        MProduction prod = new MProduction(ctx, mProductionId, trxName);
        if (prod.get_ID() <= 0) {
            throw new AdempiereException("Producci\u00f3n no encontrada: " + mProductionId);
        }
        StringBuilder logSb = new StringBuilder();
        int checked = 0;
        int replaced = 0;
        int skipped = 0;
        List<MProductionLine> linesToCheck = ProductionMaterialAdjuster.fetchProductionLinesWithToken(ctx, trxName, prod.get_ID(), token);
        if (linesToCheck.isEmpty()) {
            logSb.append("No hay l\u00edneas para revisar (token=\"").append(token).append("\").append(");
        }
        if ((orderLineId = (Integer)prod.get_Value("C_OrderLine_ID")) == null) {
            orderLineId = 0;
        }
        for (MProductionLine pl : linesToCheck) {
            ++checked;
            try {
                int curProdID = pl.getM_Product_ID();
                MProduct curProd = MProduct.get(ctx, curProdID);
                BigDecimal anchoMM = ProductionMaterialAdjuster.getWidthFromOrderLineASI(trxName, orderLineId, widthAttrId);
                if (anchoMM == null) {
                    ++skipped;
                    logSb.append(ProductionMaterialAdjuster.msg(pl, curProd, "Sin ancho (mm) en ASI; se omite.")).append('\n');
                    continue;
                }
                ProductCandidate candidate = ProductionMaterialAdjuster.findBestCandidateByWidth(ctx, trxName, token, anchoMM, tol);
                if (candidate == null) {
                    ++skipped;
                    logSb.append(ProductionMaterialAdjuster.msg(pl, curProd, "Sin candidato con ancho=" + String.valueOf(anchoMM) + "\u00b1" + String.valueOf(tol) + " mm.")).append('\n');
                    continue;
                }
                if (candidate.productId == curProdID) {
                    logSb.append(ProductionMaterialAdjuster.msg(pl, curProd, "Ya coincide con el producto correcto (ancho=" + String.valueOf(candidate.shelfWidth) + ").")).append('\n');
                    continue;
                }
                if (!dryRun) {
                    ProductionMaterialAdjuster.replaceProductionLineProduct(pl, candidate.productId, "AUTO: reemplazo por Ancho(mm)=" + String.valueOf(anchoMM));
                }
                ++replaced;
                logSb.append(ProductionMaterialAdjuster.msg(pl, curProd, "Reemplazado -> M_Product_ID=" + candidate.productId + " (ShelfWidth=" + String.valueOf(candidate.shelfWidth) + "). DryRun=" + dryRun)).append('\n');
            }
            catch (Exception ex) {
                ++skipped;
                logSb.append("L\u00ednea ID=").append(pl.getM_ProductionLine_ID()).append(" ERROR: ").append(ex.getMessage()).append('\n');
            }
        }
        try {
            finished = ProductionMaterialAdjuster.findFinishedProductLine(ctx, trxName, prod);
            if (finished == null) {
                logSb.append("No se encontr\u00f3 l\u00ednea de producto terminado; se omite material de impresi\u00f3n.\n");
            } else {
                int finishedLineID = finished.getM_ProductionLine_ID();
                int matProdID = DB.getSQLValue((String)trxName, (String)"SELECT adempiere.getic_printmaterial(?)", (int)finishedLineID);
                if (matProdID > 0) {
                    BigDecimal m2 = DB.getSQLValueBD((String)trxName, (String)"SELECT adempiere.getic_printmaterial_m2(?)", (int)finishedLineID);
                    if (m2 == null) {
                        m2 = Env.ZERO;
                    }
                    targetQty = m2.negate();
                    ProductionMaterialAdjuster.upsertConsumptionLine(ctx, trxName, prod, finished, matProdID, targetQty, dryRun, "AUTO: material impresi\u00f3n m2=" + String.valueOf(m2));
                } else {
                    logSb.append("getic_printmaterial devolvi\u00f3 0; no se agrega material de impresi\u00f3n.\n");
                }
            }
        }
        catch (Exception ex) {
            logSb.append("Error en material impresi\u00f3n: ").append(ex.getMessage()).append('\n');
        }
        try {
            finished = ProductionMaterialAdjuster.findFinishedProductLine(ctx, trxName, prod);
            if (finished == null) {
                logSb.append("No se encontr\u00f3 l\u00ednea de producto terminado; se omite tinta negra.\n");
            } else {
                int finishedLineID = finished.getM_ProductionLine_ID();
                BigDecimal inkQty = DB.getSQLValueBD((String)trxName, (String)"SELECT adempiere.getic_printerink(?)", (int)finishedLineID);
                if (inkQty == null) {
                    inkQty = Env.ZERO;
                }
                if (inkQty.signum() == 0) {
                    logSb.append("getic_printerink devolvi\u00f3 0; no se agrega tinta negra.\n");
                } else {
                    BigDecimal targetQty2 = inkQty.negate();
                    ProductionMaterialAdjuster.upsertConsumptionLine(ctx, trxName, prod, finished, 1053205, targetQty2, dryRun, "AUTO: tinta negra = " + String.valueOf(targetQty2));
                }
            }
        }
        catch (Exception ex) {
            logSb.append("Error en tinta negra: ").append(ex.getMessage()).append('\n');
        }
        try {
            finished = ProductionMaterialAdjuster.findFinishedProductLine(ctx, trxName, prod);
            if (finished == null) {
                logSb.append("No se encontr\u00f3 l\u00ednea de producto terminado; se omiten cajas.\n");
            } else {
                int finishedLineID = finished.getM_ProductionLine_ID();
                BigDecimal boxes = DB.getSQLValueBD((String)trxName, (String)"SELECT adempiere.getic_cajk_boxes(?)", (int)finishedLineID);
                if (boxes == null) {
                    boxes = Env.ZERO;
                }
                if (boxes.signum() == 0) {
                    logSb.append("getic_cajk_boxes devolvi\u00f3 0; no se agregan cajas.\n");
                } else {
                    Integer boxProdID = 1053233;
                    if (boxProdID == null || boxProdID <= 0) {
                        logSb.append("Producto ").append(1053233).append(" no encontrado/inactivo; no se agregan cajas.\n");
                    } else {
                        targetQty = boxes.negate();
                        ProductionMaterialAdjuster.upsertConsumptionLine(ctx, trxName, prod, finished, boxProdID, targetQty, dryRun, "AUTO: Caja Carton Grande Cintas 12c" + String.valueOf(targetQty));
                    }
                }
            }
        }
        catch (Exception ex) {
            logSb.append("Error en cajas: ").append(ex.getMessage()).append('\n');
        }
        String summary = "L\u00edneas revisadas=" + checked + ", reemplazadas=" + replaced + ", omitidas=" + skipped + ".";
        return summary + "\n" + String.valueOf(logSb);
    }

    private static String msg(MProductionLine pl, MProduct curProd, String tail) {
        return "ProdLineID=" + pl.getM_ProductionLine_ID() + " [Prod " + curProd.getValue() + " - " + curProd.getName() + "] " + tail;
    }

    private static List<MProductionLine> fetchProductionLinesWithToken(Properties ctx, String trxName, int M_Production_ID, String token) {
        String sql = "SELECT pl.M_ProductionLine_ID FROM M_ProductionLine pl JOIN M_Product p ON (p.M_Product_ID = pl.M_Product_ID) WHERE pl.M_Production_ID=? AND pl.IsActive='Y' AND p.DocumentNote ILIKE ?";
        ArrayList<MProductionLine> list = new ArrayList<MProductionLine>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Production_ID);
            pstmt.setString(2, "%" + token + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProductionLine(ctx, rs.getInt(1), trxName));
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("Error buscando l\u00edneas: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return list;
    }

    private static MProductionLine findFinishedProductLine(Properties ctx, String trxName, MProduction prod) {
        String sql1 = "SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND IsActive='Y' AND IsEndProduct='Y' ORDER BY M_ProductionLine_ID ASC";
        int lineId = DB.getSQLValue((String)trxName, (String)sql1, (int)prod.getM_Production_ID());
        if (lineId > 0) {
            return new MProductionLine(ctx, lineId, trxName);
        }
        String sql2 = "SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND IsActive='Y' AND MovementQty>0 ORDER BY MovementQty DESC, M_ProductionLine_ID ASC LIMIT 1";
        lineId = DB.getSQLValue((String)trxName, (String)sql2, (int)prod.getM_Production_ID());
        if (lineId > 0) {
            return new MProductionLine(ctx, lineId, trxName);
        }
        return null;
    }

    private static BigDecimal getWidthFromOrderLineASI(String trxName, int C_OrderLine_ID, int widthAttrID) {
        if (C_OrderLine_ID <= 0) {
            return null;
        }
        int asiID = DB.getSQLValue((String)trxName, (String)"SELECT COALESCE(M_AttributeSetInstance_ID,0) FROM C_OrderLine WHERE C_OrderLine_ID=?", (int)C_OrderLine_ID);
        if (asiID <= 0) {
            return null;
        }
        String val = DB.getSQLValueString((String)trxName, (String)"SELECT Value FROM M_AttributeInstance WHERE M_AttributeSetInstance_ID=? AND M_Attribute_ID=?", (Object[])new Object[]{asiID, widthAttrID});
        if (val == null) {
            return null;
        }
        try {
            return new BigDecimal(val.trim().replace(",", "."));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ProductCandidate findBestCandidateByWidth(Properties ctx, String trxName, String token, BigDecimal anchoMM, BigDecimal tol) {
        if (token == null || token.trim().isEmpty() || anchoMM == null) {
            return null;
        }
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        String where = "IsActive='Y' AND DocumentNote ILIKE ? AND ShelfWidth IS NOT NULL";
        params.add((CallSite)((Object)("%" + token + "%")));
        List candidates = new Query(ctx, "M_Product", where, trxName).setParameters(params).list();
        if (candidates.isEmpty()) {
            return null;
        }
        ProductCandidate best = null;
        BigDecimal bestDelta = null;
        for (MProduct p : candidates) {
            BigDecimal sw = (BigDecimal)p.get_Value(COL_SHELF_WIDTH);
            if (sw == null) continue;
            BigDecimal delta = sw.subtract(anchoMM).abs();
            boolean bl = tol == null || tol.signum() == 0 ? delta.compareTo(Env.ZERO) == 0 : delta.compareTo(tol) <= 0;
            boolean within = bl;
            if (!within || best != null && delta.compareTo(bestDelta) >= 0 && (delta.compareTo(bestDelta) != 0 || p.getM_Product_ID() >= best.productId)) continue;
            best = new ProductCandidate(p.getM_Product_ID(), sw);
            bestDelta = delta;
        }
        return best;
    }

    private static void replaceProductionLineProduct(MProductionLine pl, int newProductID, String note) {
        int oldProdID = pl.getM_Product_ID();
        pl.setM_Product_ID(newProductID);
        String old = pl.getDescription();
        pl.setDescription((String)(old == null || old.isEmpty() ? note : old + " | " + note));
        pl.saveEx();
    }

    private static void upsertConsumptionLine(Properties ctx, String trxName, MProduction prod, MProductionLine finished, int productId, BigDecimal targetQty, boolean dryRun, String descTag) {
        Integer existLineId = DB.getSQLValue((String)trxName, (String)"SELECT M_ProductionLine_ID FROM M_ProductionLine WHERE M_Production_ID=? AND M_Product_ID=? AND IsActive='Y' ORDER BY M_ProductionLine_ID ASC LIMIT 1", (int)prod.getM_Production_ID(), (int)productId);
        if (existLineId != null && existLineId > 0) {
            BigDecimal existQty = DB.getSQLValueBD((String)trxName, (String)"SELECT MovementQty FROM M_ProductionLine WHERE M_ProductionLine_ID=?", (int)existLineId);
            if (existQty == null) {
                existQty = Env.ZERO;
            }
            if (existQty.compareTo(targetQty) != 0 && !dryRun) {
                MProductionLine exLine = new MProductionLine(ctx, existLineId, trxName);
                exLine.setMovementQty(targetQty);
                exLine.setM_AttributeSetInstance_ID(finished.getM_AttributeSetInstance_ID());
                exLine.set_ValueOfColumn("ComponentType", "X");
                exLine.set_ValueOfColumn("IsAutoGenerated", false);
                int locatorId = prod.getM_Locator_ID();
                if (locatorId <= 0 && finished.getM_Locator_ID() > 0) {
                    locatorId = finished.getM_Locator_ID();
                }
                exLine.setM_Locator_ID(locatorId);
                String d = exLine.getDescription();
                exLine.setDescription((String)(d == null || d.isEmpty() ? descTag : d + " | " + descTag));
                exLine.saveEx();
            }
        } else if (!dryRun) {
            MProductionLine newLine = new MProductionLine(ctx, 0, trxName);
            newLine.setAD_Org_ID(prod.getAD_Org_ID());
            newLine.setM_Production_ID(prod.getM_Production_ID());
            newLine.setM_Product_ID(productId);
            newLine.setIsEndProduct(false);
            newLine.setMovementQty(targetQty);
            newLine.setM_AttributeSetInstance_ID(finished.getM_AttributeSetInstance_ID());
            newLine.set_ValueOfColumn("ComponentType", "X");
            newLine.set_ValueOfColumn("IsAutoGenerated", false);
            int locatorId = prod.getM_Locator_ID();
            if (locatorId <= 0 && finished.getM_Locator_ID() > 0) {
                locatorId = finished.getM_Locator_ID();
            }
            newLine.setM_Locator_ID(locatorId);
            newLine.setDescription(descTag);
            newLine.saveEx();
        }
    }

    private static class ProductCandidate {
        final int productId;
        final BigDecimal shelfWidth;

        ProductCandidate(int productId, BigDecimal shelfWidth) {
            this.productId = productId;
            this.shelfWidth = shelfWidth;
        }
    }
}

