/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.commercial;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCountry;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ImportShopifyOrdersPOS
extends SvrProcess {
    private Timestamp p_DateFrom;
    private Timestamp p_DateTo;
    private int p_C_DocTypeTarget_ID;
    private int p_M_PriceList_ID;
    private int p_M_Warehouse_ID;
    private int p_SalesRep_ID;
    private int p_DefaultCountry_ID;
    private int p_DefaultRegion_ID;
    private int p_DefaultCity_ID;
    private boolean p_AutoAddToPL = false;
    private boolean p_AutoComplete = false;
    private String shopDomain;
    private String apiVersion;
    private String accessToken;
    private int p_Shipping_Product_ID = 0;
    private int p_Discount_Product_ID = 0;
    private static final DateTimeFormatter ISO_Z = DateTimeFormatter.ISO_INSTANT;

    protected void prepare() {
        ProcessInfoParameter[] para;
        for (ProcessInfoParameter p : para = this.getParameter()) {
            String name = p.getParameterName();
            if ("Date".equals(name)) {
                this.p_DateFrom = p.getParameterAsTimestamp();
                this.p_DateTo = p.getParameterToAsTimestamp();
                continue;
            }
            if ("C_DocTypeTarget_ID".equals(name)) {
                this.p_C_DocTypeTarget_ID = p.getParameterAsInt();
                continue;
            }
            if ("M_PriceList_ID".equals(name)) {
                this.p_M_PriceList_ID = p.getParameterAsInt();
                continue;
            }
            if ("M_Warehouse_ID".equals(name)) {
                this.p_M_Warehouse_ID = p.getParameterAsInt();
                continue;
            }
            if ("SalesRep_ID".equals(name)) {
                this.p_SalesRep_ID = p.getParameterAsInt();
                continue;
            }
            if ("C_Country_ID".equals(name)) {
                this.p_DefaultCountry_ID = p.getParameterAsInt();
                continue;
            }
            if ("C_Region_ID".equals(name)) {
                this.p_DefaultRegion_ID = p.getParameterAsInt();
                continue;
            }
            if ("C_City_ID".equals(name)) {
                this.p_DefaultCity_ID = p.getParameterAsInt();
                continue;
            }
            if ("AutoAddToPriceList".equals(name)) {
                Object v = p.getParameter();
                if (v == null) continue;
                this.p_AutoAddToPL = "Y".equalsIgnoreCase(v.toString()) || Boolean.TRUE.equals(v);
                continue;
            }
            if ("IsComplete".equals(name)) {
                this.p_AutoComplete = p.getParameterAsBoolean();
                continue;
            }
            this.log.warning("Par\u00e1metro " + name + " inv\u00e1lido.");
        }
        if (!this.p_AutoAddToPL) {
            String sys = MSysConfig.getValue((String)"SHOPIFY_AUTO_ADD_TO_PL", (String)"N", (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            this.p_AutoAddToPL = "Y".equalsIgnoreCase(sys) || "true".equalsIgnoreCase(sys);
        }
        this.shopDomain = MSysConfig.getValue((String)"SHOPIFY_SHOP_DOMAIN", null, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        this.apiVersion = MSysConfig.getValue((String)"SHOPIFY_API_VERSION", (String)"2025-07", (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        this.accessToken = MSysConfig.getValue((String)"SHOPIFY_ACCESS_TOKEN", null, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        this.p_Shipping_Product_ID = MSysConfig.getIntValue((String)"SHOPIFY_SHIPPING_PRODUCT_ID", (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        this.p_Discount_Product_ID = MSysConfig.getIntValue((String)"SHOPIFY_DISCOUNT_PRODUCT_ID", (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        if (this.p_Shipping_Product_ID <= 0) {
            throw new AdempiereException("No se ha Parametrizado ID de producto Flete (SHOPIFY_SHIPPING_PRODUCT_ID).");
        }
        if (Util.isEmpty((String)this.shopDomain, (boolean)true) || Util.isEmpty((String)this.accessToken, (boolean)true)) {
            throw new AdempiereException("Config Shopify incompleta. Definir SHOPIFY_SHOP_DOMAIN y SHOPIFY_ACCESS_TOKEN");
        }
        if (this.p_DateFrom == null || this.p_DateTo == null) {
            throw new AdempiereException("Debe indicar DateFrom y DateTo");
        }
        if (this.p_C_DocTypeTarget_ID <= 0 || this.p_M_PriceList_ID <= 0 || this.p_M_Warehouse_ID <= 0) {
            throw new AdempiereException("Debe indicar C_DocTypeTarget_ID, M_PriceList_ID y M_Warehouse_ID");
        }
    }

    private int getAD_Org_ID() {
        return Env.getAD_Org_ID((Properties)this.getCtx());
    }

    protected String doIt() throws Exception {
        int created = 0;
        int skipped = 0;
        int failed = 0;
        ArrayList<String> failedDetails = new ArrayList<String>();
        HttpClient http = HttpClient.newHttpClient();
        String url = "https://" + this.shopDomain + "/admin/api/" + this.apiVersion + "/graphql.json";
        String graphQLQuery = this.buildGraphQLQuery();
        String cursor = null;
        boolean hasNext = true;
        String qDateFrom = ISO_Z.format(this.p_DateFrom.toInstant());
        String qDateTo = ISO_Z.format(this.p_DateTo.toInstant());
        String search = "created_at:>=" + qDateFrom + " created_at:<=" + qDateTo + " NOT financial_status:pending NOT financial_status:voided";
        ArrayList<ImportedOrderRow> importedOrders = new ArrayList<ImportedOrderRow>();
        while (hasNext) {
            JsonObject variables = new JsonObject();
            variables.addProperty("first", (Number)50);
            variables.addProperty("query", search);
            if (cursor != null) {
                variables.addProperty("cursor", cursor);
            }
            JsonObject body = new JsonObject();
            body.addProperty("query", graphQLQuery);
            body.add("variables", (JsonElement)variables);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").header("X-Shopify-Access-Token", this.accessToken).POST(HttpRequest.BodyPublishers.ofString(body.toString(), StandardCharsets.UTF_8)).build();
            HttpResponse<String> res = http.send(req, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) {
                throw new AdempiereException("Shopify GraphQL HTTP=" + res.statusCode() + " " + res.body());
            }
            JsonObject json = this.parseJson(res.body());
            if (json.has("errors")) {
                throw new AdempiereException("GraphQL errors: " + json.get("errors").toString());
            }
            JsonObject data = ImportShopifyOrdersPOS.optObject(json, "data");
            if (data == null || !data.has("orders")) {
                throw new AdempiereException("Respuesta inv\u00e1lida de Shopify: falta 'data.orders'");
            }
            JsonObject orders = ImportShopifyOrdersPOS.optObject(data, "orders");
            JsonArray edges = orders.getAsJsonArray("edges");
            for (JsonElement edgeElem : edges) {
                Set<String> missingPrices;
                JsonObject trxObject;
                JsonElement trx;
                JsonObject edge = edgeElem.getAsJsonObject();
                JsonObject node = ImportShopifyOrdersPOS.optObject(edge, "node");
                JsonArray transactions = node.getAsJsonArray("transactions");
                if (node == null) continue;
                String orderId = ImportShopifyOrdersPOS.optString(node, "id");
                String orderName = ImportShopifyOrdersPOS.optString(node, "name");
                String createdAt = ImportShopifyOrdersPOS.optString(node, "createdAt");
                String financialStatus = ImportShopifyOrdersPOS.optString(node, "displayFinancialStatus");
                String orderRef = orderName != null ? orderName : orderId;
                String paymentId = null;
                Iterator iterator = transactions.iterator();
                while (iterator.hasNext() && ((trx = (JsonElement)iterator.next()) == null || (paymentId = ImportShopifyOrdersPOS.optString(trxObject = trx.getAsJsonObject(), "paymentId")) == null)) {
                }
                if (!Util.isEmpty((String)orderRef, (boolean)true) && this.existsOrderByExternalRef(orderRef)) {
                    ++skipped;
                    continue;
                }
                JsonObject customer = ImportShopifyOrdersPOS.optObject(node, "customer");
                String email = ImportShopifyOrdersPOS.optString(customer, "email");
                String displayName = ImportShopifyOrdersPOS.optString(customer, "displayName");
                if (Util.isEmpty((String)orderId, (boolean)true) || Util.isEmpty((String)createdAt, (boolean)true)) {
                    ++skipped;
                    continue;
                }
                Timestamp tsCreated = Timestamp.from(Instant.parse(createdAt));
                Set<String> missingSkus = this.collectMissingSkus(node);
                if (!missingSkus.isEmpty()) {
                    ++failed;
                    StringJoiner sj = new StringJoiner(", ");
                    missingSkus.forEach(sj::add);
                    failedDetails.add((orderRef != null ? orderRef : "(sin nombre)") + " | SKU faltantes: " + sj.toString());
                    continue;
                }
                int plvId = this.getPriceListVersionId(this.p_M_PriceList_ID, tsCreated);
                if (plvId <= 0) {
                    throw new AdempiereException("No existe versi\u00f3n de lista de precios v\u00e1lida para la fecha: " + String.valueOf(tsCreated));
                }
                if (!this.p_AutoAddToPL && !(missingPrices = this.collectProductsWithoutPrice(node, plvId)).isEmpty()) {
                    ++failed;
                    StringJoiner sj = new StringJoiner(", ");
                    missingPrices.forEach(sj::add);
                    failedDetails.add((orderRef != null ? orderRef : "(sin nombre)") + " | Productos que no est\u00e1n en lista de precio: " + sj.toString());
                    continue;
                }
                MBPartner bp = this.getOrCreateBPartnerByEmail(email, displayName);
                MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                order.setAD_Org_ID(this.getAD_Org_ID());
                order.setIsSOTrx(true);
                order.setC_DocTypeTarget_ID(this.p_C_DocTypeTarget_ID);
                order.setM_Warehouse_ID(this.p_M_Warehouse_ID);
                order.setM_PriceList_ID(this.p_M_PriceList_ID);
                if (this.p_SalesRep_ID > 0) {
                    order.setSalesRep_ID(this.p_SalesRep_ID);
                }
                order.setC_BPartner_ID(bp.getC_BPartner_ID());
                int locId = this.getDefaultLocationId(bp);
                if (locId <= 0) {
                    throw new AdempiereException("BPartner sin ubicaci\u00f3n: " + bp.getValue());
                }
                order.setC_BPartner_Location_ID(locId);
                order.setDateOrdered(tsCreated);
                order.setDatePromised(tsCreated);
                order.setDateAcct(tsCreated);
                order.setDocumentNo(orderRef);
                order.setPOReference(".");
                order.setDescription("Shopify: " + orderId);
                order.set_CustomColumn("AJC_ShopifyPayment", paymentId);
                order.set_CustomColumn("AJC_ShopifyFinancialStatus", financialStatus);
                order.saveEx();
                Object docNo = order.getDocumentNo();
                if (Util.isEmpty((String)docNo, (boolean)true)) {
                    docNo = "ID:" + order.getC_Order_ID();
                }
                String bpName = bp != null ? bp.getName() : "(sin BP)";
                importedOrders.add(new ImportedOrderRow((String)docNo, orderRef, tsCreated, bpName));
                JsonObject lineItems = ImportShopifyOrdersPOS.optObject(node, "lineItems");
                JsonArray liEdges = lineItems != null ? lineItems.getAsJsonArray("edges") : null;
                int lineNo = 10;
                if (liEdges != null) {
                    for (JsonElement liEdgeElem : liEdges) {
                        MProduct product;
                        JsonObject priceSet;
                        JsonObject shopMoney;
                        BigDecimal price;
                        JsonObject liNode = liEdgeElem.getAsJsonObject().getAsJsonObject("node");
                        if (liNode == null) continue;
                        Integer qty = null;
                        if (liNode.has("quantity") && !liNode.get("quantity").isJsonNull()) {
                            qty = liNode.get("quantity").getAsInt();
                        }
                        if (qty == null || qty <= 0) continue;
                        String sku = ImportShopifyOrdersPOS.optString(liNode, "sku");
                        if (sku == null) {
                            JsonObject variant = ImportShopifyOrdersPOS.optObject(liNode, "variant");
                            sku = ImportShopifyOrdersPOS.optString(variant, "sku");
                        }
                        if ((price = ImportShopifyOrdersPOS.optDecimal(shopMoney = ImportShopifyOrdersPOS.optObject(priceSet = ImportShopifyOrdersPOS.optObject(liNode, "originalUnitPriceSet"), "shopMoney"), "amount")) == null) {
                            price = BigDecimal.ZERO;
                        }
                        if ((product = this.getProductBySKU(sku)) == null) continue;
                        if (!this.ensureProductInPriceList(plvId, product, price)) {
                            throw new AdempiereException("Producto sin precio en lista y AutoAddToPriceList=N: " + (String)(sku != null ? sku : "ID:" + product.getM_Product_ID()) + " en PLV " + plvId);
                        }
                        MOrderLine ol = new MOrderLine(order);
                        ol.setM_Product_ID(product.getM_Product_ID(), true);
                        ol.setQty(new BigDecimal(qty));
                        ol.setPrice(price);
                        ol.setPriceEntered(price);
                        ol.setPriceList(price);
                        ol.setPriceLimit(price);
                        ol.setLine(lineNo);
                        ol.saveEx();
                        lineNo += 10;
                    }
                }
                ShippingInfo ship = this.extractShippingInfo(node);
                if (ship.amount != null && ship.amount.signum() != 0) {
                    MProduct shipProd = new MProduct(this.getCtx(), this.p_Shipping_Product_ID, this.get_TrxName());
                    if (shipProd == null || shipProd.getM_Product_ID() <= 0) {
                        throw new AdempiereException("Producto de env\u00edo inexistente: ID=" + this.p_Shipping_Product_ID);
                    }
                    if (!this.ensureProductInPriceList(plvId, shipProd, ship.amount)) {
                        throw new AdempiereException("Producto de env\u00edo sin precio y AutoAddToPriceList=N en PLV " + plvId);
                    }
                    if (lineNo <= 0) {
                        lineNo = 10;
                    }
                    MOrderLine olShip = new MOrderLine(order);
                    olShip.setM_Product_ID(this.p_Shipping_Product_ID, true);
                    olShip.setQty(BigDecimal.ONE);
                    olShip.setPrice(ship.amount);
                    olShip.setPriceEntered(ship.amount);
                    olShip.setPriceList(ship.amount);
                    olShip.setPriceLimit(ship.amount);
                    olShip.setLine(lineNo);
                    Object shipDesc = "Shipping (Shopify)";
                    if (!Util.isEmpty((String)ship.title, (boolean)true)) {
                        shipDesc = (String)shipDesc + " - " + ship.title;
                    }
                    olShip.setDescription((String)shipDesc);
                    olShip.saveEx();
                    lineNo += 10;
                }
                DiscountInfo discount = this.extractDiscountInfo(node);
                if (discount.amount != null && discount.amount.signum() != 0) {
                    MProduct discountProduct = (MProduct)new Query(this.getCtx(), "M_Product", "M_Product_ID=?", this.get_TrxName()).setParameters(new Object[]{this.p_Discount_Product_ID}).first();
                    if (discountProduct == null || discountProduct.getM_Product_ID() <= 0) {
                        throw new AdempiereException("Producto de Descuento inexistente: ID=" + this.p_Discount_Product_ID);
                    }
                    if (!this.ensureProductInPriceList(plvId, discountProduct, ship.amount)) {
                        throw new AdempiereException("Producto " + discountProduct.getName() + " sin precio y AutoAddToPriceList=N en PLV " + plvId);
                    }
                    if (lineNo <= 0) {
                        lineNo = 10;
                    }
                    MOrderLine olDisc = new MOrderLine(order);
                    olDisc.setM_Product_ID(this.p_Discount_Product_ID, true);
                    olDisc.setQty(BigDecimal.ONE);
                    olDisc.setPrice(discount.amount);
                    olDisc.setPriceEntered(discount.amount);
                    olDisc.setPriceList(discount.amount);
                    olDisc.setPriceLimit(discount.amount);
                    olDisc.setLine(lineNo);
                    Object discountDesc = "Descuento";
                    if (!Util.isEmpty((String)discount.discountCode, (boolean)true)) {
                        discountDesc = (String)discountDesc + " - " + discount.discountCode;
                    }
                    olDisc.setDescription((String)discountDesc);
                    olDisc.saveEx();
                    lineNo += 10;
                }
                if (this.p_AutoComplete) {
                    boolean isCompleted;
                    order.setDocAction("CO");
                    boolean ok = order.processIt("CO");
                    boolean bl = isCompleted = ok && "CO".equals(order.getDocStatus());
                    if (!isCompleted) {
                        String msg = order.getProcessMsg();
                        try {
                            order.delete(true, this.get_TrxName());
                        }
                        catch (Exception ex) {
                            this.log.warning("No se pudo borrar la orden no completada " + order.getDocumentNo() + " - " + ex.getMessage());
                        }
                        ++failed;
                        failedDetails.add((orderRef != null ? orderRef : "(sin nombre)") + " | Fall\u00f3 completar: " + (msg != null ? msg : "sin detalle"));
                        continue;
                    }
                    order.saveEx();
                }
                ++created;
            }
            JsonObject pageInfo = ImportShopifyOrdersPOS.optObject(orders, "pageInfo");
            hasNext = pageInfo != null && pageInfo.get("hasNextPage").getAsBoolean();
            cursor = hasNext && pageInfo.has("endCursor") && !pageInfo.get("endCursor").isJsonNull() ? pageInfo.get("endCursor").getAsString() : null;
        }
        return this.buildHtmlSummary(created, skipped, failed, failedDetails, this.p_AutoAddToPL, importedOrders);
    }

    private static String optString(JsonObject obj, String prop) {
        if (obj == null || !obj.has(prop) || obj.get(prop).isJsonNull()) {
            return null;
        }
        return obj.get(prop).getAsString();
    }

    private static JsonObject optObject(JsonObject obj, String prop) {
        if (obj == null || !obj.has(prop) || obj.get(prop).isJsonNull()) {
            return null;
        }
        return obj.getAsJsonObject(prop);
    }

    private static BigDecimal optDecimal(JsonObject obj, String prop) {
        String s = ImportShopifyOrdersPOS.optString(obj, prop);
        if (s == null) {
            return null;
        }
        try {
            return new BigDecimal(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String buildGraphQLQuery() {
        return "query ListOrders($first:Int!,$cursor:String,$query:String){  orders(first: $first, after: $cursor, query: $query, sortKey: CREATED_AT, reverse: false){    edges{      cursor      node{        id name createdAt displayFinancialStatus currencyCode         totalPriceSet{ shopMoney{ amount currencyCode } }         customer{ id displayName email }         shippingLines(first: 100){          edges{            node{              title               originalPriceSet{ shopMoney{ amount currencyCode } }               discountedPriceSet{ shopMoney{ amount currencyCode } }             }          }        }        lineItems(first: 100){          edges{            node{              quantity               originalUnitPriceSet{ shopMoney{ amount currencyCode } }               sku variant{ sku } product{ id title } name             }          }        }        discountCode         totalDiscountsSet{shopMoney{amount currencyCode}}        transactions{paymentId}      }    }    pageInfo{ hasNextPage endCursor }  }}";
    }

    private boolean existsOrderByExternalRef(String shopifyOrderName) {
        String where = "IsSOTrx='Y' AND DocumentNo LIKE ?";
        return new Query(this.getCtx(), "C_Order", where, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{"%" + shopifyOrderName + "%"}).match();
    }

    private MBPartner getOrCreateBPartnerByEmail(String email, String displayName) {
        Object key = Util.isEmpty((String)email, (boolean)true) ? "sin-correo-" + System.currentTimeMillis() : email.trim().toLowerCase();
        MBPartner bp = (MBPartner)new Query(this.getCtx(), "C_BPartner", "Value=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{key}).first();
        if (bp != null) {
            return bp;
        }
        bp = new MBPartner(this.getCtx(), 0, this.get_TrxName());
        bp.setAD_Org_ID(this.getAD_Org_ID());
        bp.setValue((String)key);
        int group_id = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_BP_Group_ID) FROM C_BP_Group WHERE Value ILIKE '%Prospecto%' AND AD_Client_ID=" + this.getAD_Client_ID()));
        displayName = ImportShopifyOrdersPOS.toTitleCase(displayName);
        bp.setName((String)(Util.isEmpty((String)displayName, (boolean)true) ? key : displayName));
        bp.setIsCustomer(true);
        if (group_id > 0) {
            bp.setC_BP_Group_ID(group_id);
        } else {
            this.log.warning("No se encuentra Grupo de Socio Prospecto para crear Socio");
        }
        bp.saveEx();
        int countryId = this.p_DefaultCountry_ID > 0 ? this.p_DefaultCountry_ID : MCountry.getDefault((Properties)Env.getCtx()).getC_Country_ID();
        MBPartnerLocation bpl = new MBPartnerLocation(bp);
        bpl.setC_Country_ID(countryId);
        bpl.setC_Region_ID(this.p_DefaultRegion_ID);
        bpl.setC_City_ID(this.p_DefaultCity_ID);
        bpl.setAddress1("Shopify (sin direcci\u00f3n)");
        bpl.saveEx();
        return bp;
    }

    private int getDefaultLocationId(MBPartner bp) {
        MBPartnerLocation[] locs = bp.getLocations(false);
        return locs != null && locs.length > 0 ? locs[0].getC_BPartner_Location_ID() : 0;
    }

    private int getPriceListVersionId(int priceListId, Timestamp when) {
        String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=? AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
        return DB.getSQLValue((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{priceListId, when});
    }

    private boolean hasProductPrice(int plvId, int productId) {
        String where = "M_PriceList_Version_ID=? AND M_Product_ID=?";
        return new Query(this.getCtx(), "M_ProductPrice", where, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{plvId, productId}).match();
    }

    private void createProductPrice(int plvId, int productId, BigDecimal price) {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        MProductPrice pp = new MProductPrice(this.getCtx(), 0, this.get_TrxName());
        pp.setM_PriceList_Version_ID(plvId);
        pp.setM_Product_ID(productId);
        pp.setPriceList(price);
        pp.setPriceStd(price);
        pp.setPriceLimit(price);
        pp.saveEx();
    }

    private boolean ensureProductInPriceList(int plvId, MProduct product, BigDecimal price) {
        if (this.hasProductPrice(plvId, product.getM_Product_ID())) {
            return true;
        }
        if (this.p_AutoAddToPL) {
            this.createProductPrice(plvId, product.getM_Product_ID(), price);
            return true;
        }
        return false;
    }

    private Set<String> collectMissingSkus(JsonObject orderNode) {
        JsonArray liEdges;
        HashSet<String> missing = new HashSet<String>();
        if (orderNode == null) {
            return missing;
        }
        JsonObject lineItems = ImportShopifyOrdersPOS.optObject(orderNode, "lineItems");
        JsonArray jsonArray = liEdges = lineItems != null ? lineItems.getAsJsonArray("edges") : null;
        if (liEdges == null) {
            return missing;
        }
        for (JsonElement liEdgeElem : liEdges) {
            JsonObject liNode = liEdgeElem.getAsJsonObject().getAsJsonObject("node");
            if (liNode == null) continue;
            String sku = ImportShopifyOrdersPOS.optString(liNode, "sku");
            if (sku == null) {
                JsonObject variant = ImportShopifyOrdersPOS.optObject(liNode, "variant");
                sku = ImportShopifyOrdersPOS.optString(variant, "sku");
            }
            if (!Util.isEmpty((String)sku, (boolean)true) && this.getProductBySKU(sku) != null) continue;
            String key = Util.isEmpty((String)sku, (boolean)true) ? "(SKU vac\u00edo)" : sku.trim().toUpperCase();
            missing.add(key);
        }
        return missing;
    }

    private Set<String> collectProductsWithoutPrice(JsonObject orderNode, int plvId) {
        JsonArray liEdges;
        HashSet<String> missing = new HashSet<String>();
        if (orderNode == null) {
            return missing;
        }
        JsonObject lineItems = ImportShopifyOrdersPOS.optObject(orderNode, "lineItems");
        JsonArray jsonArray = liEdges = lineItems != null ? lineItems.getAsJsonArray("edges") : null;
        if (liEdges == null) {
            return missing;
        }
        for (JsonElement liEdgeElem : liEdges) {
            MProduct p;
            JsonObject liNode = liEdgeElem.getAsJsonObject().getAsJsonObject("node");
            if (liNode == null) continue;
            String sku = ImportShopifyOrdersPOS.optString(liNode, "sku");
            if (sku == null) {
                JsonObject variant = ImportShopifyOrdersPOS.optObject(liNode, "variant");
                sku = ImportShopifyOrdersPOS.optString(variant, "sku");
            }
            if ((p = this.getProductBySKU(sku)) == null || this.hasProductPrice(plvId, p.getM_Product_ID())) continue;
            missing.add((String)(!Util.isEmpty((String)sku, (boolean)true) ? sku.trim().toUpperCase() : "ID:" + p.getM_Product_ID()));
        }
        return missing;
    }

    private MProduct getProductBySKU(String sku) {
        if (Util.isEmpty((String)sku, (boolean)true)) {
            return null;
        }
        String key = sku.trim().toUpperCase();
        MProduct p = (MProduct)new Query(this.getCtx(), "M_Product", "UPPER(Description)=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{key}).first();
        if (p != null) {
            return p;
        }
        p = (MProduct)new Query(this.getCtx(), "M_Product", "UPPER(Value)=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{key}).first();
        if (p != null) {
            return p;
        }
        p = (MProduct)new Query(this.getCtx(), "M_Product", "UPPER(SKU)=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{key}).first();
        return p;
    }

    protected JsonObject parseJson(String jsonString) throws JsonParseException {
        return new JsonParser().parse(jsonString).getAsJsonObject();
    }

    private String buildHtmlSummary(int created, int skipped, int failed, List<String> failedDetails, boolean autoAddToPL, List<ImportedOrderRow> importedOrders) {
        int MAX_LIST = 500;
        StringBuilder html = new StringBuilder();
        html.append("<meta charset=\"UTF-8\"/>").append("<style>").append(".card{border:1px solid #e5e7eb;border-radius:10px;padding:16px;background:#fff;}").append("h1{font-size:16px;margin:0 0 12px 0;color:#111827;}").append(".kpi{display:flex;gap:12px;margin:12px 0;flex-wrap:wrap;}").append(".chip{display:inline-flex;align-items:center;gap:6px;border-radius:999px;padding:6px 10px;font-weight:600;}").append(".ok{background:#ecfdf5;color:#065f46;border:1px solid #a7f3d0;}").append(".skip{background:#fff7ed;color:#9a3412;border:1px solid #fed7aa;}").append(".err{background:#fef2f2;color:#991b1b;border:1px solid #fecaca;}").append("details{margin-top:10px;}").append("summary{cursor:pointer;font-weight:600;color:#374151;}").append("ol{margin:8px 0 0 20px;}").append(".note{margin-top:14px;padding:10px 12px;border-radius:8px;background:#f3f4f6;color:#374151;}").append(".mono{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,'Liberation Mono','Courier New',monospace;}").append(".tbl{width:100%;border-collapse:collapse;margin-top:10px;}").append(".tbl th,.tbl td{border:1px solid #e5e7eb;padding:6px 8px;text-align:left;}").append(".tbl thead th{background:#f9fafb;font-weight:700;}").append(".muted{color:#6b7280;}").append("</style>").append("</head>").append("<body>").append("<div class=\"card\">").append("<h1>Resumen ImportShopifyOrdersPOS</h1>").append("<div class=\"kpi\">").append("<span class=\"chip ok\">\u2714 \u00d3rdenes creadas: ").append(created).append("</span>").append("<span class=\"chip skip\">\u26a0 Omitidas (duplicadas): ").append(skipped).append("</span>").append("<span class=\"chip err\">\u274c No importadas: ").append(failed).append("</span>").append("</div>");
        if (failedDetails != null && !failedDetails.isEmpty()) {
            html.append("<details>").append("<summary>Detalle de \u00f3rdenes NO importadas</summary>").append("<table class=\"tbl\">").append("<thead><tr>").append("<th>#</th><th>Error</th>").append("</tr></thead><tbody>");
            int i = 1;
            for (String d : failedDetails) {
                html.append("<tr>").append("<td>").append(i++).append("</td>").append("<td class=\"mono\">").append(ImportShopifyOrdersPOS.escapeHtml(d)).append("</td>").append("</tr>");
            }
            html.append("</tbody></table>").append("</details>");
        }
        if (importedOrders != null && !importedOrders.isEmpty()) {
            html.append("<details>").append("<summary>\u00d3rdenes importadas (").append(importedOrders.size()).append(")</summary>").append("<table class=\"tbl\">").append("<thead><tr>").append("<th>#</th><th>Documento</th><th>Ref. Shopify</th><th>Fecha</th><th>Socio de Negocio</th>").append("</tr></thead><tbody>");
            int limit = Math.min(importedOrders.size(), 500);
            for (int i = 0; i < limit; ++i) {
                ImportedOrderRow r = importedOrders.get(i);
                html.append("<tr>").append("<td>").append(i + 1).append("</td>").append("<td class=\"mono\">").append(ImportShopifyOrdersPOS.escapeHtml(r.docNo)).append("</td>").append("<td class=\"mono\">").append(ImportShopifyOrdersPOS.escapeHtml(r.shopifyRef != null ? r.shopifyRef : "(sin ref)")).append("</td>").append("<td>").append(r.createdAt != null ? ImportShopifyOrdersPOS.escapeHtml(r.createdAt.toString()) : "&mdash;").append("</td>").append("<td>").append(ImportShopifyOrdersPOS.escapeHtml(r.bpartner != null ? r.bpartner : "(sin BP)")).append("</td>").append("</tr>");
            }
            html.append("</tbody></table>");
            if (importedOrders.size() > 500) {
                html.append("<div class=\"muted\">Se muestran los primeros ").append(500).append(" registros de ").append(importedOrders.size()).append(".</div>");
            }
            html.append("</details>");
        }
        html.append("<div class=\"note\">").append("<strong>Agregar producto a lista de precio:</strong> ").append(autoAddToPL ? "Activado (se agregan precios autom\u00e1ticamente)." : "Desactivado (se bloquean \u00f3rdenes con productos sin precio).").append("</div>").append("</div>");
        return html.toString();
    }

    private static String escapeHtml(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private ShippingInfo extractShippingInfo(JsonObject orderNode) {
        JsonArray slEdges;
        BigDecimal total = BigDecimal.ZERO;
        StringJoiner titles = new StringJoiner(" + ");
        JsonObject shippingLines = ImportShopifyOrdersPOS.optObject(orderNode, "shippingLines");
        JsonArray jsonArray = slEdges = shippingLines != null ? shippingLines.getAsJsonArray("edges") : null;
        if (slEdges == null) {
            return new ShippingInfo(BigDecimal.ZERO, null);
        }
        for (JsonElement slEdgeElem : slEdges) {
            JsonObject slNode = slEdgeElem.getAsJsonObject().getAsJsonObject("node");
            if (slNode == null) continue;
            String title = ImportShopifyOrdersPOS.optString(slNode, "title");
            if (!Util.isEmpty((String)title, (boolean)true)) {
                titles.add(title);
            }
            BigDecimal ship = null;
            JsonObject dps = ImportShopifyOrdersPOS.optObject(slNode, "discountedPriceSet");
            if (dps != null) {
                JsonObject sMoney = ImportShopifyOrdersPOS.optObject(dps, "shopMoney");
                ship = ImportShopifyOrdersPOS.optDecimal(sMoney, "amount");
            }
            if (ship == null) {
                JsonObject ops = ImportShopifyOrdersPOS.optObject(slNode, "originalPriceSet");
                JsonObject sMoney = ImportShopifyOrdersPOS.optObject(ops, "shopMoney");
                ship = ImportShopifyOrdersPOS.optDecimal(sMoney, "amount");
            }
            if (ship == null) continue;
            total = total.add(ship);
        }
        return new ShippingInfo(total, titles.length() > 0 ? titles.toString() : null);
    }

    private DiscountInfo extractDiscountInfo(JsonObject orderNode) {
        BigDecimal total = BigDecimal.ZERO;
        String code = null;
        code = ImportShopifyOrdersPOS.optString(orderNode, "discountCode");
        JsonObject priceSet = ImportShopifyOrdersPOS.optObject(orderNode, "totalDiscountsSet");
        JsonObject shopMoney = ImportShopifyOrdersPOS.optObject(priceSet, "shopMoney");
        BigDecimal priceDiscount = ImportShopifyOrdersPOS.optDecimal(shopMoney, "amount").negate();
        return new DiscountInfo(priceDiscount, code != null ? code.toString() : "Descuento");
    }

    public static String toTitleCase(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String[] words = text.toLowerCase().split("\\s+");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    private static final class ImportedOrderRow {
        final String docNo;
        final String shopifyRef;
        final Timestamp createdAt;
        final String bpartner;

        ImportedOrderRow(String docNo, String shopifyRef, Timestamp createdAt, String bpartner) {
            this.docNo = docNo;
            this.shopifyRef = shopifyRef;
            this.createdAt = createdAt;
            this.bpartner = bpartner;
        }
    }

    private static final class ShippingInfo {
        final BigDecimal amount;
        final String title;

        ShippingInfo(BigDecimal amount, String title) {
            this.amount = amount == null ? BigDecimal.ZERO : amount;
            this.title = title;
        }
    }

    private static final class DiscountInfo {
        final BigDecimal amount;
        final String discountCode;

        DiscountInfo(BigDecimal amount, String discountCode) {
            this.amount = amount == null ? BigDecimal.ZERO : amount;
            this.discountCode = discountCode;
        }
    }
}

