/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.financial;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class EKProcessBankStatementCorrection
extends SvrProcess {
    private int p_C_BankStatement_ID;
    private static final CLogger log = CLogger.getCLogger(EKProcessBankStatementCorrection.class);

    protected void prepare() {
        this.p_C_BankStatement_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MBankStatement bs = new MBankStatement(this.getCtx(), this.p_C_BankStatement_ID, this.get_TrxName());
        if (!"CO".equals(bs.getDocStatus())) {
            return Msg.translate((Properties)this.getCtx(), (String)"RelatedDocumentnotcompleted");
        }
        return EKProcessBankStatementCorrection.correctBankStatement(this.getCtx(), bs);
    }

    public static String correctBankStatement(Properties ctx, MBankStatement bs) {
        String sql = "SELECT bs.C_BankStatement_ID, bs.StatementDate, bs.BeginningBalance, bs.StatementDifference, bs.EndingBalance FROM C_BankStatement bs WHERE bs.C_BankAccount_ID = ? AND bs.DocStatus = 'CO' ORDER BY bs.StatementDate, bs.C_BankStatement_ID";
        try (CPreparedStatement ps = DB.prepareStatement((String)sql, (String)bs.get_TrxName());){
            ps.setInt(1, bs.getC_BankAccount_ID());
            try (ResultSet rs = ps.executeQuery();){
                EKProcessBankStatementCorrection.processBankStatements(ctx, bs, rs);
            }
        }
        catch (SQLException e) {
            log.severe("Error ejecutando consulta SQL: " + e.getMessage());
            throw new AdempiereException(Msg.translate((Properties)ctx, (String)"DBExecuteError") + ":" + String.valueOf(e));
        }
        catch (Exception e) {
            log.severe("Error inesperado: " + e.getMessage());
            throw new AdempiereException(Msg.translate((Properties)ctx, (String)"ProcessFailed") + " : " + String.valueOf(e));
        }
        return Msg.translate((Properties)ctx, (String)"ProcessOK");
    }

    private static void processBankStatements(Properties ctx, MBankStatement currentBS, ResultSet rs) throws SQLException {
        BigDecimal firstBeginningBalance = currentBS.getBeginningBalance();
        BigDecimal previousEndingBalance = null;
        boolean processingCurrent = true;
        while (rs.next()) {
            int bankStatementId = rs.getInt("C_BankStatement_ID");
            MBankStatement bs = new MBankStatement(ctx, bankStatementId, currentBS.get_TrxName());
            if (bankStatementId == currentBS.getC_BankStatement_ID()) {
                processingCurrent = false;
                if (rs.getBigDecimal("BeginningBalance").compareTo(firstBeginningBalance) != 0) {
                    currentBS.setBeginningBalance(firstBeginningBalance);
                    currentBS.saveEx();
                    log.info("Saldo inicial corregido para el estado de cuenta actual: " + currentBS.get_ID());
                }
                previousEndingBalance = currentBS.getEndingBalance();
                continue;
            }
            if (processingCurrent) {
                firstBeginningBalance = rs.getBigDecimal("EndingBalance");
                continue;
            }
            if (rs.getBigDecimal("BeginningBalance").compareTo(previousEndingBalance) != 0) {
                bs.setBeginningBalance(previousEndingBalance);
                bs.saveEx();
                log.info("Saldo inicial corregido para estado de cuenta posterior: " + bs.get_ID());
            }
            previousEndingBalance = bs.getEndingBalance();
        }
        EKProcessBankStatementCorrection.updateBankAccountBalance(ctx, currentBS, previousEndingBalance);
    }

    private static void updateBankAccountBalance(Properties ctx, MBankStatement bs, BigDecimal newBalance) {
        MBankAccount bankAccount = MBankAccount.get((Properties)ctx, (int)bs.getC_BankAccount_ID());
        bankAccount.setCurrentBalance(newBalance);
        bankAccount.saveEx();
        log.info("Saldo actual del banco actualizado: " + String.valueOf(newBalance));
    }
}

