/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.financial;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.SvrProcess;

public class EKProcessPSCreateFromCashJournal
extends SvrProcess {
    private int p_C_PaySelection_ID;
    private AtomicInteger sequence = new AtomicInteger(10);

    protected void prepare() {
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@C_PaySelection_ID@ @NotFound@");
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MPaySelection paySelection = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        this.sequence.set(paySelection.getLastLineNo() + 10);
        this.getSelectionKeys().forEach(key -> {
            for (MPaySelectionLine pLine : paySelection.getLines(true)) {
                if (pLine.get_ValueAsInt("C_Cash_ID") != key.intValue()) continue;
                throw new AdempiereException("Rendici\u00f3n ID:" + key + " ya se encuentra en las lineas.");
            }
            MCash cash = new MCash(this.getCtx(), key.intValue(), this.get_TrxName());
            MPaySelectionLine line = new MPaySelectionLine(paySelection, this.sequence.getAndAdd(10), "S");
            line.setAD_Org_ID(cash.getAD_Org_ID());
            MCashBook cashBook = MCashBook.get((Properties)this.getCtx(), (int)cash.getC_CashBook_ID());
            int bp_id = cashBook.get_ValueAsInt("C_BPartner_ID");
            line.setC_BPartner_ID(bp_id);
            line.setPayAmt(cash.getStatementDifference().abs());
            line.set_CustomColumn("C_Cash_ID", (Object)cash.getC_Cash_ID());
            line.setDescription(cash.getC_CashBook().getName().concat(" || ").concat(cash.getDescription() == null ? "" : cash.getDescription()).concat(" || ").concat(cash.getEndingBalance().toString()));
            line.saveEx();
        });
        return null;
    }
}

