/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.financial;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.compiere.model.MCharge;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;

public class EKProcessPaymentOperation
extends SvrProcess {
    private int p_C_Payment_ID;
    private String p_OperationType;
    private BigDecimal p_SplitAmount;

    protected void prepare() {
        ProcessInfoParameter[] params;
        for (ProcessInfoParameter param : params = this.getParameter()) {
            if ("AJF_OperationType".equalsIgnoreCase(param.getParameterName())) {
                this.p_OperationType = (String)param.getParameter();
                continue;
            }
            if (!"SplitAmount".equalsIgnoreCase(param.getParameterName())) continue;
            this.p_SplitAmount = (BigDecimal)param.getParameter();
        }
        this.p_C_Payment_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MPayment original = new MPayment(this.getCtx(), this.p_C_Payment_ID, this.get_TrxName());
        if (original.get_ID() <= 0) {
            throw new AdempiereUserError("No se encontr\u00f3 el pago original");
        }
        if (!original.getDocStatus().equals("CO")) {
            throw new AdempiereUserError("El pago no est\u00e1 completo.");
        }
        switch (this.p_OperationType) {
            case "PR": {
                if (!original.isReconciled()) {
                    throw new AdempiereUserError("El pago debe estar depositado para protesto");
                }
                return this.createCustomerAdjustment(original, "Protesto");
            }
            case "CD": {
                if (original.isReconciled()) {
                    throw new AdempiereUserError("El pago no debe estar depositado para cambio de documento");
                }
                return this.createCustomerAdjustment(original, "Cambio de documento");
            }
            case "DP": {
                if (original.isReconciled()) {
                    throw new AdempiereUserError("El pago no debe estar depositado para division de pagos");
                }
                return this.splitPayment(original, "Division de pago");
            }
        }
        throw new AdempiereUserError("Operaci\u00f3n no reconocida");
    }

    private String createCustomerAdjustment(MPayment original, String chargeName) throws AdempiereUserError {
        BigDecimal allocated = DB.getSQLValueBD((String)this.get_TrxName(), (String)"SELECT COALESCE(SUM(payamt), 0) FROM c_payment WHERE DocStatus not in ('VO','RE') AND ref_payment_id = ?", (int)original.getC_Payment_ID());
        BigDecimal diff = original.getPayAmt().subtract(allocated);
        if (diff.compareTo(BigDecimal.ZERO) <= 0) {
            return "No hay monto restante por generar";
        }
        MPayment newPay = new MPayment(this.getCtx(), 0, this.get_TrxName());
        newPay.setAD_Org_ID(original.getAD_Org_ID());
        newPay.setC_BPartner_ID(original.getC_BPartner_ID());
        newPay.setC_BankAccount_ID(original.getC_BankAccount_ID());
        newPay.setTenderType(original.getTenderType());
        newPay.setC_Currency_ID(original.getC_Currency_ID());
        newPay.setIsReceipt(original.isReceipt());
        newPay.setPayAmt(diff);
        newPay.setDateTrx(new Timestamp(System.currentTimeMillis()));
        newPay.setDateAcct(newPay.getDateTrx());
        newPay.setRef_Payment_ID(original.getC_Payment_ID());
        newPay.setDescription(chargeName + " generado desde pago " + original.getDocumentNo());
        MCharge charge = this.getCharge(chargeName);
        newPay.setC_Charge_ID(charge.getC_Charge_ID());
        newPay.saveEx();
        original.setIsReconciled(true);
        original.saveEx();
        return "Pago generado: " + newPay.getDocumentNo();
    }

    private String splitPayment(MPayment original, String chargeName) throws AdempiereUserError {
        BigDecimal remaining;
        if (this.p_SplitAmount == null || this.p_SplitAmount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new AdempiereUserError("Debe indicar un monto m\u00e1ximo v\u00e1lido para segmentaci\u00f3n");
        }
        BigDecimal alreadySplit = DB.getSQLValueBD((String)this.get_TrxName(), (String)"SELECT COALESCE(SUM(payamt), 0) FROM C_Payment WHERE ref_payment_id = ? AND ad_client_id = ? AND docstatus NOT IN ('VO','RE')", (Object[])new Object[]{original.getC_Payment_ID(), this.getAD_Client_ID()});
        if (alreadySplit == null) {
            alreadySplit = BigDecimal.ZERO;
        }
        if ((remaining = original.getPayAmt().subtract(alreadySplit)).compareTo(BigDecimal.ZERO) <= 0) {
            throw new AdempiereUserError("Este pago ya ha sido completamente segmentado. No se puede volver a dividir.");
        }
        int count = 0;
        ArrayList<MPayment> payments = new ArrayList<MPayment>();
        while (remaining.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal current = remaining.min(this.p_SplitAmount);
            MPayment newPay = new MPayment(this.getCtx(), 0, this.get_TrxName());
            newPay.setAD_Org_ID(original.getAD_Org_ID());
            newPay.setC_BPartner_ID(original.getC_BPartner_ID());
            newPay.setC_BankAccount_ID(original.getC_BankAccount_ID());
            newPay.setTenderType(original.getTenderType());
            newPay.setIsReceipt(original.isReceipt());
            newPay.setC_Currency_ID(original.getC_Currency_ID());
            newPay.setPayAmt(current);
            newPay.setDateTrx(new Timestamp(System.currentTimeMillis()));
            newPay.setDateAcct(newPay.getDateTrx());
            newPay.setRef_Payment_ID(original.getC_Payment_ID());
            newPay.setDescription("Segmentaci\u00f3n de pago desde " + original.getDocumentNo());
            MCharge charge = this.getCharge(chargeName);
            newPay.setC_Charge_ID(charge.getC_Charge_ID());
            newPay.saveEx();
            payments.add(newPay);
            remaining = remaining.subtract(current);
            ++count;
        }
        original.setIsReconciled(true);
        original.saveEx();
        return count + " pagos generados por segmentaci\u00f3n.";
    }

    private MCharge getCharge(String name) throws AdempiereUserError {
        List charges = new Query(this.getCtx(), "C_Charge", "name = ? AND AD_Client_ID = ?", this.get_TrxName()).setParameters(new Object[]{name, this.getAD_Client_ID()}).list();
        if (charges.isEmpty()) {
            throw new AdempiereUserError("No se encontr\u00f3 un cargo con nombre: " + name);
        }
        if (charges.size() > 1) {
            throw new AdempiereUserError("Se encontraron m\u00faltiples cargos con el nombre: " + name + ". Por favor aseg\u00farese de que sea \u00fanico para este cliente.");
        }
        return (MCharge)charges.get(0);
    }
}

