/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.financial;

import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessProtested
extends SvrProcess {
    private int p_C_Payment_ID;

    protected void prepare() {
        this.p_C_Payment_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        boolean seVaACrearNuevo;
        MPayment p = new MPayment(this.getCtx(), this.p_C_Payment_ID, this.get_TrxName());
        if (!"K".equals(p.getTenderType())) {
            throw new AdempiereUserError("Solo se pueden protestar pagos tipo cheque");
        }
        if (!p.getDocStatus().equals("CO")) {
            throw new AdempiereUserError("Pago no est\u00e1 completo");
        }
        if (p.get_ValueAsBoolean("AJF_IsProtested")) {
            throw new AdempiereUserError("Pago ya est\u00e1 protestado");
        }
        if (!p.isReconciled()) {
            throw new AdempiereUserError("Pago aun no esta conciliado");
        }
        StringBuffer sql_b = new StringBuffer("SELECT MAX(c.C_Charge_ID) FROM C_Charge c WHERE LOWER(c.Name) LIKE '%cheque%protest%'");
        sql_b = new StringBuffer(MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql_b.toString(), "c", true, false));
        String sql = sql_b.toString();
        int charge_id = DB.getSQLValue((String)this.get_TrxName(), (String)sql);
        if (charge_id <= 0) {
            throw new AdempiereUserError("Cargo Cheque Protestado no encontrado");
        }
        p.set_CustomColumn("AJF_IsProtested", true);
        p.set_CustomColumn("OpenAmt", p.getPayAmt());
        p.saveEx();
        MBankStatement bsAbierto = this.getBankStatementAbierto(p.getC_BankAccount_ID());
        boolean bl = seVaACrearNuevo = bsAbierto == null;
        if (seVaACrearNuevo) {
            MBankAccount account = MBankAccount.get((Properties)this.getCtx(), (int)p.getC_BankAccount_ID());
            bsAbierto = new MBankStatement(account);
            bsAbierto.saveEx();
        }
        bsAbierto.setDescription((String)(bsAbierto.getDescription() == null ? "" : bsAbierto.getDescription() + "-") + "Protesto del pago N\u00b0" + p.getDocumentNo());
        bsAbierto.saveEx();
        MBankStatementLine bsl = new MBankStatementLine(bsAbierto);
        Timestamp fecha_hoy = new Timestamp(System.currentTimeMillis());
        bsl.setC_Payment_ID(0);
        bsl.setChargeAmt(p.getPayAmt().negate());
        bsl.setStmtAmt(p.getPayAmt().negate());
        bsl.setDateAcct(fecha_hoy);
        bsl.setStatementLineDate(fecha_hoy);
        bsl.setC_Charge_ID(charge_id);
        bsl.setDescription("Protesto del pago N\u00b0" + p.getDocumentNo());
        bsl.saveEx();
        if (seVaACrearNuevo) {
            MBankStatement bs = new MBankStatement(this.getCtx(), bsl.getC_BankStatement_ID(), this.get_TrxName());
            bs.setStatementDate(fecha_hoy);
            if (!bs.processIt("CO")) {
                throw new AdempiereUserError("No se pudo completar el nuevo estado de cuenta: " + bs.getProcessMsg());
            }
            bs.saveEx();
            return "Se cre\u00f3 y complet\u00f3 nuevo estado de cuenta: " + bs.getDocumentNo();
        }
        return "Se agreg\u00f3 l\u00ednea de protesto en estado de cuenta existente: " + bsl.getC_BankStatement().getDocumentNo();
    }

    private MBankStatement getBankStatementAbierto(int C_BankAccount_ID) {
        String whereClause = "C_BankAccount_ID = ? AND DocStatus IN ('DR','IP') AND Processed = 'N'";
        return (MBankStatement)new Query(this.getCtx(), "C_BankStatement", whereClause, this.get_TrxName()).setParameters(new Object[]{C_BankAccount_ID}).setOrderBy("StatementDate DESC").firstOnly();
    }
}

