/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.processInvoiceAdvance;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessPercentInvoiceQty
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    private BigDecimal p_Percent;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("Percent")) {
                this.p_Percent = para[i].getParameterAsBigDecimal();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInvoiceLine[] lines;
        MInvoice invoice = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        if (invoice == null || invoice.get_ID() <= 0) {
            throw new IllegalArgumentException("Factura no encontrada con ID: " + this.p_C_Invoice_ID);
        }
        if (invoice.isProcessed()) {
            throw new IllegalArgumentException("Factura " + invoice.getDocumentNo() + " ya procesada.");
        }
        for (MInvoiceLine line : lines = invoice.getLines(true)) {
            BigDecimal plannedQty;
            if (line.getM_Product_ID() <= 0) continue;
            int projectId = invoice.getC_Project_ID();
            BigDecimal baseQty = null;
            if (projectId > 0 && (plannedQty = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)"SELECT COALESCE(SUM(PlannedQty), 0) FROM C_ProjectLine WHERE C_Project_ID=? AND M_Product_ID=?", (Object[])new Object[]{projectId, line.getM_Product_ID()})) != null && plannedQty.compareTo(BigDecimal.ZERO) > 0) {
                baseQty = plannedQty;
            }
            if (baseQty == null) {
                baseQty = line.getQtyEntered();
            }
            BigDecimal newQty = baseQty.multiply(this.p_Percent).divide(new BigDecimal(100));
            line.setQtyEntered(newQty);
            line.setQtyInvoiced(newQty);
            line.saveEx();
        }
        invoice.saveEx();
        return "Cantidades actualizadas al " + String.valueOf(this.p_Percent) + "% en la factura " + invoice.getDocumentNo() + " (usando cantidad de proyecto cuando aplica).";
    }
}

