/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.Allocation;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class VAllocationInternational
extends Allocation
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    private FormFrame frame;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel allocationPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel bpartnerLabel = new JLabel();
    private VLookup bpartnerSearch = null;
    private MiniTable invoiceTable = new MiniTable();
    private MiniTable paymentTable = new MiniTable();
    private JSplitPane infoPanel = new JSplitPane();
    private CPanel paymentPanel = new CPanel();
    private CPanel invoicePanel = new CPanel();
    private JLabel paymentLabel = new JLabel();
    private JLabel invoiceLabel = new JLabel();
    private BorderLayout paymentLayout = new BorderLayout();
    private BorderLayout invoiceLayout = new BorderLayout();
    private JLabel paymentInfo = new JLabel();
    private JLabel invoiceInfo = new JLabel();
    private JScrollPane paymentScrollPane = new JScrollPane();
    private JScrollPane invoiceScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JLabel currencyLabel = new JLabel();
    private VLookup currencyPick = null;
    private JCheckBox multiCurrency = new JCheckBox();
    private JLabel chargeLabel = new JLabel();
    private VLookup chargePick = null;
    private JLabel orgWriteLabel = new JLabel();
    private VLookup orgWritePick = null;
    private JLabel descriptionLabel = new JLabel();
    private CTextField descriptionField = new CTextField();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private JCheckBox autoWriteOff = new JCheckBox();
    private JLabel organizationLabel = new JLabel();
    private VLookup organizationPick = null;
    private JLabel aparLabel = new JLabel();
    private VLookup aparPick = null;
    private ConfirmPanel confirmPanel;

    public void init(int WindowNo, FormFrame frame) {
        this.setWindowNo(WindowNo);
        this.frame = frame;
        try {
            super.dynInit();
            this.setFromPO(frame.getProcessInfo());
            this.dynInit();
            this.jbInit();
            if (this.isFromParent()) {
                this.loadBPartner();
                this.setDefaultRecord((IMiniTable)this.paymentTable, (IMiniTable)this.invoiceTable);
            } else {
                this.calculate();
            }
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)this.panel);
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener((ActionListener)this);
        this.paymentTable.setMultiSelection(true);
        this.invoiceTable.setMultiSelection(true);
        this.invoiceTable.setSurrendersFocusOnKeystroke(true);
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.dateLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.dateLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocDate", (boolean)false));
        this.autoWriteOff.setSelected(false);
        this.autoWriteOff.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)true));
        this.autoWriteOff.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)false));
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.allocationPanel.setLayout((LayoutManager)this.allocationLayout);
        this.bpartnerLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.paymentLabel.setRequestFocusEnabled(false);
        this.paymentLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Payment_ID"));
        this.invoiceLabel.setRequestFocusEnabled(false);
        this.invoiceLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
        this.paymentPanel.setLayout((LayoutManager)this.paymentLayout);
        this.invoicePanel.setLayout((LayoutManager)this.invoiceLayout);
        this.invoiceInfo.setHorizontalAlignment(4);
        this.invoiceInfo.setHorizontalTextPosition(4);
        this.invoiceInfo.setText(".");
        this.paymentInfo.setHorizontalAlignment(4);
        this.paymentInfo.setHorizontalTextPosition(4);
        this.paymentInfo.setText(".");
        this.chargeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Charge_ID"));
        this.chargeLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ChargeDifference", (boolean)false));
        this.orgWriteLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.descriptionLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Description"));
        this.descriptionField.setColumns(20);
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.currencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.multiCurrency.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"MultiCurrency"));
        this.multiCurrency.setSelected(this.isDefaultMultiCurrency());
        this.multiCurrency.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.invoiceScrollPane.setPreferredSize(new Dimension(200, 200));
        this.paymentScrollPane.setPreferredSize(new Dimension(200, 200));
        this.mainPanel.add((Component)this.parameterPanel, (Object)"North");
        this.organizationLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.aparLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"APAR"));
        this.parameterPanel.add((Component)this.organizationLabel, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.organizationPick, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.aparLabel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.aparPick, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerSearch, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyPick, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.multiCurrency, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.autoWriteOff, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, (Object)"South");
        this.allocationPanel.add((Component)this.differenceLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.allocationPanel.add((Component)this.differenceField, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.chargeLabel, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.chargePick, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.orgWriteLabel, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.orgWritePick, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.descriptionLabel, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.descriptionField, (Object)new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocCurrencyLabel, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.confirmPanel, (Object)new GridBagConstraints(10, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.paymentPanel.add((Component)this.paymentLabel, (Object)"North");
        this.paymentPanel.add((Component)this.paymentInfo, (Object)"South");
        this.paymentPanel.add((Component)this.paymentScrollPane, (Object)"Center");
        this.paymentScrollPane.getViewport().add((Component)this.paymentTable, null);
        this.invoicePanel.add((Component)this.invoiceLabel, (Object)"North");
        this.invoicePanel.add((Component)this.invoiceInfo, (Object)"South");
        this.invoicePanel.add((Component)this.invoiceScrollPane, (Object)"Center");
        this.invoiceScrollPane.getViewport().add((Component)this.invoiceTable, null);
        this.mainPanel.add((Component)this.infoPanel, (Object)"Center");
        this.infoPanel.setOrientation(0);
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.infoPanel.setTopComponent((Component)this.paymentPanel);
        this.infoPanel.setBottomComponent((Component)this.invoicePanel);
        this.infoPanel.add((Component)this.paymentPanel, "top");
        this.infoPanel.add((Component)this.invoicePanel, "bottom");
        this.infoPanel.setContinuousLayout(true);
        this.infoPanel.setPreferredSize(new Dimension(800, 250));
        this.infoPanel.setDividerLocation(110);
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
    }

    @Override
    public void dynInit() throws Exception {
        int AD_Column_ID = 3505;
        MLookup lookupCur = MLookupFactory.get((Properties)Env.getCtx(), (int)this.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.currencyPick = new VLookup("C_Currency_ID", true, false, true, (Lookup)lookupCur);
        this.currencyPick.setValue((Object)this.currencyId);
        this.currencyPick.addVetoableChangeListener((VetoableChangeListener)this);
        AD_Column_ID = 839;
        MLookup lookupOrg = MLookupFactory.get((Properties)Env.getCtx(), (int)this.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.organizationPick = new VLookup("AD_Org_ID", true, false, true, (Lookup)lookupOrg);
        this.organizationPick.setValue((Object)this.orgId);
        this.organizationPick.addVetoableChangeListener((VetoableChangeListener)this);
        AD_Column_ID = 3499;
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.getWindowNo(), (int)0, (int)AD_Column_ID, (int)30);
        this.bpartnerSearch = new VLookup("C_BPartner_ID", true, false, true, (Lookup)lookupBP);
        this.bpartnerSearch.addVetoableChangeListener((VetoableChangeListener)this);
        if (this.bPartnerId > 0) {
            this.bpartnerSearch.setValue((Object)this.bPartnerId);
        }
        if (this.isFromParent()) {
            this.bpartnerSearch.setReadWrite(false);
        }
        this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocateStatus"));
        this.statusBar.setStatusDB("");
        this.dateField.setValue((Object)Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.dateField.addVetoableChangeListener((VetoableChangeListener)this);
        AD_Column_ID = 61804;
        MLookup lookupCharge = MLookupFactory.get((Properties)Env.getCtx(), (int)this.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.chargePick = new VLookup("C_Charge_ID", false, false, true, (Lookup)lookupCharge);
        this.chargePick.setValue((Object)this.chargeId);
        this.chargePick.addVetoableChangeListener((VetoableChangeListener)this);
        AD_Column_ID = 3863;
        MLookup lookupOrgWrite = MLookupFactory.get((Properties)Env.getCtx(), (int)this.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.orgWritePick = new VLookup("AD_OrgTrx_ID", false, false, true, (Lookup)lookupOrgWrite);
        this.orgWritePick.addVetoableChangeListener((VetoableChangeListener)this);
        AD_Column_ID = 14082;
        MLookup lookupAPAR = MLookupFactory.get((Properties)Env.getCtx(), (int)this.getWindowNo(), (int)0, (int)AD_Column_ID, (int)17);
        this.aparPick = new VLookup("APAR", true, false, true, (Lookup)lookupAPAR);
        this.aparPick.setValue((Object)"A");
        this.aparPick.addVetoableChangeListener((VetoableChangeListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.multiCurrency)) {
            this.loadBPartner();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            this.confirmPanel.getOKButton().setEnabled(false);
            this.description = this.descriptionField.getText();
            this.saveData();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isAutoWriteOff;
        boolean isInvoice;
        int col;
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        int row = e.getFirstRow();
        String msg = this.writeOff(row, col = e.getColumn(), isInvoice = e.getSource().equals(this.invoiceTable.getModel()), (IMiniTable)this.paymentTable, (IMiniTable)this.invoiceTable, isAutoWriteOff = this.autoWriteOff.isSelected());
        if (msg != null && msg.length() > 0) {
            ADialog.warn((int)this.getWindowNo(), (Container)this.panel, (String)"AllocationWriteOffWarn");
        }
        this.calculate();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(name + "=" + String.valueOf(value));
        if (value == null) {
            return;
        }
        if (name.equals("AD_Org_ID")) {
            this.setAD_Org_ID((Integer)value);
            this.loadBPartner();
        } else if (name.equals("C_Charge_ID")) {
            this.chargeId = (Integer)value;
            this.setAllocateButton();
        } else if (name.equals("AD_OrgTrx_ID")) {
            this.orgWriteId = (Integer)value;
        }
        if (name.equals("C_BPartner_ID")) {
            this.bpartnerSearch.setValue(value);
            this.bPartnerId = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("C_Currency_ID")) {
            this.currencyId = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("Date") && this.multiCurrency.isSelected()) {
            this.loadBPartner();
        } else if (name.equals("APAR")) {
            this.apar = value.toString().length() == 0 ? "A" : value.toString();
            this.loadBPartner();
        }
    }

    public void loadBPartner() {
        this.checkBPartner();
        Vector<Vector<Object>> data = this.getPaymentData(this.multiCurrency.isSelected(), this.dateField.getValue(), (IMiniTable)this.paymentTable);
        Vector<String> columnNames = this.getPaymentColumnNames(this.multiCurrency.isSelected());
        this.paymentTable.getModel().removeTableModelListener(this);
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.paymentTable.setModel((TableModel)modelP);
        this.setPaymentColumnClass((IMiniTable)this.paymentTable, this.multiCurrency.isSelected());
        data = this.getInvoiceData(this.multiCurrency.isSelected(), this.dateField.getValue(), (IMiniTable)this.invoiceTable);
        columnNames = this.getInvoiceColumnNames(this.multiCurrency.isSelected());
        this.invoiceTable.getModel().removeTableModelListener(this);
        DefaultTableModel modelI = new DefaultTableModel(data, columnNames);
        modelI.addTableModelListener(this);
        this.invoiceTable.setModel((TableModel)modelI);
        this.setInvoiceColumnClass((IMiniTable)this.invoiceTable, this.multiCurrency.isSelected());
        this.changeIndexForTables(this.multiCurrency.isSelected());
        this.calculate();
    }

    public void calculate() {
        this.allocDate = null;
        this.paymentInfo.setText(this.calculatePayment((IMiniTable)this.paymentTable, this.multiCurrency.isSelected()));
        this.invoiceInfo.setText(this.calculateInvoice((IMiniTable)this.invoiceTable, this.multiCurrency.isSelected()));
        if (this.allocDate != null) {
            this.dateField.setValue((Object)this.allocDate);
        }
        this.allocCurrencyLabel.setText(this.currencyPick.getDisplay());
        this.totalDiff = this.totalPay.subtract(this.totalInv);
        this.differenceField.setText(this.format.format(this.totalDiff));
    }

    private void setAllocateButton() {
        if (this.totalDiff.compareTo(new BigDecimal(0.0)) == 0 ^ this.chargeId > 0) {
            this.confirmPanel.getOKButton().setEnabled(true);
        } else {
            this.confirmPanel.getOKButton().setEnabled(false);
        }
        if (this.totalDiff.compareTo(new BigDecimal(0.0)) == 0) {
            this.chargePick.setValue(null);
            this.chargeId = 0;
        }
    }

    public void saveData() {
        this.setAD_Org_ID();
        try {
            Trx.run((TrxRunnable)new TrxRunnable(){

                public void run(String trxName) {
                    VAllocationInternational.this.statusBar.setStatusLine(VAllocationInternational.this.saveData(VAllocationInternational.this.getWindowNo(), VAllocationInternational.this.dateField.getValue(), (IMiniTable)VAllocationInternational.this.paymentTable, (IMiniTable)VAllocationInternational.this.invoiceTable, trxName));
                }
            });
            this.loadBPartner();
        }
        catch (Exception e) {
            ADialog.error((int)this.getWindowNo(), (Container)this.panel, (String)"Error", (String)e.getLocalizedMessage());
        }
        finally {
            this.confirmPanel.getOKButton().setEnabled(true);
        }
    }
}

