/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_A_Asset_Change;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.model.MAssetDisposed;
import org.compiere.asset.model.MAssetSplit;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;

public class MAssetChange
extends X_A_Asset_Change {
    private static final long serialVersionUID = 5906751299228645904L;
    private static CLogger s_log = CLogger.getCLogger(MAssetChange.class);

    public MAssetChange(Properties ctx, int assetChangeId, String trxName) {
        super(ctx, assetChangeId, trxName);
    }

    public MAssetChange(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        String textDetails = this.getTextDetails();
        if (textDetails == null || textDetails.length() == 0) {
            this.setTextDetails(MRefList.getListDescription((Properties)this.getCtx(), (String)"A_Update_Type", (String)this.getChangeType()));
        }
        return true;
    }

    public static MAssetChange createSplit(MAssetSplit assetSplit, MDepreciationWorkfile assetBalance) {
        MAssetChange change = new MAssetChange(assetSplit.getCtx(), 0, assetSplit.get_TrxName());
        change.setAD_Org_ID(assetSplit.getAD_Org_ID());
        change.setA_Asset_ID(assetBalance.getA_Asset_ID());
        change.setChangeType("SPL");
        String description = Msg.parseTranslation((Properties)assetSplit.getCtx(), (String)(" @A_Asset_Split_ID@ " + assetSplit.getDocumentInfo()));
        change.setTextDetails(description + " " + MRefList.getListDescription((Properties)assetSplit.getCtx(), (String)"A_Update_Type", (String)"SPL"));
        change.setPostingType(assetBalance.getPostingType());
        change.setAssetValueAmt(assetSplit.getA_Asset_Cost());
        change.setA_QTY_Current(assetSplit.getA_QTY_Split());
        change.setA_Split_Percent(assetSplit.getA_Percent_Split());
        change.setDateAcct(assetSplit.getDateAcct());
        change.setChangeDate(assetSplit.getDateDoc());
        change.saveEx();
        return change;
    }

    public static MAssetChange createAddition(MAssetSplit assetSplit, MAsset source, MAsset target, MDepreciationWorkfile assetBalance) {
        MAssetChange change = new MAssetChange(assetSplit.getCtx(), 0, assetSplit.get_TrxName());
        change.setAD_Org_ID(assetSplit.getAD_Org_ID());
        change.setA_Asset_ID(assetBalance.getA_Asset_ID());
        change.setChangeType("ADD");
        String description = Msg.parseTranslation((Properties)assetSplit.getCtx(), (String)(" @From@ @A_Asset_ID@ " + source.getValue() + " @To@  @Value@" + target.getValue() + " @A_Asset_Split_ID@ " + assetSplit.getDocumentInfo()));
        change.setTextDetails(description + " " + MRefList.getListDescription((Properties)assetSplit.getCtx(), (String)"A_Update_Type", (String)"ADD"));
        change.setPostingType(assetBalance.getPostingType());
        change.setAssetValueAmt(assetBalance.getA_Asset_Cost());
        change.setA_QTY_Current(assetBalance.getA_QTY_Current());
        change.setDateAcct(assetSplit.getDateAcct());
        change.setChangeDate(assetSplit.getDateDoc());
        change.setA_Split_Percent(assetSplit.getA_Percent_Split());
        change.setA_Parent_Asset_ID(source.getA_Asset_ID());
        change.saveEx();
        return change;
    }

    public static MAssetChange createAddition(MAssetAddition assetAdd, MDepreciationWorkfile assetwk) {
        MAssetChange change = new MAssetChange(assetAdd.getCtx(), 0, assetAdd.get_TrxName());
        change.setAD_Org_ID(assetAdd.getAD_Org_ID());
        change.setA_Asset_ID(assetAdd.getA_Asset_ID());
        change.setChangeType("ADD");
        change.setTextDetails(MRefList.getListDescription((Properties)assetAdd.getCtx(), (String)"A_Update_Type", (String)"ADD"));
        change.setPostingType(assetwk.getPostingType());
        change.setAssetValueAmt(assetAdd.getAssetValueAmt());
        change.setA_QTY_Current(assetAdd.getA_QTY_Current());
        change.saveEx();
        return change;
    }

    public static MAssetChange createDisposal(MAssetDisposed assetDisposed, MDepreciationWorkfile assetwk) {
        MAssetChange change = new MAssetChange(assetDisposed.getCtx(), 0, assetDisposed.get_TrxName());
        change.setAD_Org_ID(assetDisposed.getAD_Org_ID());
        change.setA_Asset_ID(assetDisposed.getA_Asset_ID());
        change.setChangeType("DIS");
        change.setTextDetails(MRefList.getListDescription((Properties)assetDisposed.getCtx(), (String)"A_Update_Type", (String)"DIS"));
        change.setPostingType(assetwk.getPostingType());
        change.setAssetValueAmt(assetDisposed.getA_Disposal_Amt());
        change.setA_QTY_Current(assetwk.getA_QTY_Current());
        change.saveEx();
        return change;
    }

    public static MAssetChange create(Properties ctx, String changeType, PO[] pos, String trxName) {
        return MAssetChange.create(ctx, changeType, pos, false, trxName);
    }

    public static MAssetChange createAndSave(Properties ctx, String changeType, PO[] pos, String trxName) {
        return null;
    }

    public static MAssetChange create(Properties ctx, String changeType, PO[] pos, boolean save, String trxName) {
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Entering: changeType=" + changeType);
        }
        if (pos == null || pos.length == 0) {
            s_log.fine("Entering/Leaving: POs is empty");
            return null;
        }
        MAssetChange change = new MAssetChange(ctx, 0, trxName);
        change.setChangeType(changeType);
        for (PO po : pos) {
            change.addChanges(po);
        }
        if (save) {
            change.saveEx();
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Leaving: change=" + String.valueOf((Object)change));
        }
        return change;
    }

    public void addChanges(PO po) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: po=" + String.valueOf(po));
        }
        if (po == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: po=" + String.valueOf(po));
        }
    }
}

